#include "param.h"
#include "err.h"
#include "ftn.h"
/*			Copyright 1979 by Bill Webb.	 		*/
/*			Copyright 1977 by Bill Webb.	 		*/
#include "sym.h"
#include "tree.h"
#include "ops.h"

char modenames[];	/* names of modes */
int codep;		/* current code pointer */

stmtfn(fn) char *fn;
{
/*
 * process statement function.
 */
register char *t;
register char *p;
register char *rhs;
int sfarg();

p = fn;
if (p->s_loc != NOLOC)
	SERR("stmt fn badly defined",E_STMTFN);
p->s_loc = TEXT;
p->s_flags =| F_FN;	/* mark as function */

t = treeplist(&sfarg);
expect("=");
rhs = cvt(expr(RIGHT),p->s_type);	/* get and convert rhs */
for (p=t; p; p=p->t_right)
	delsym(p->t_left);	/* delete symtab entry */
t = node(SFENTRY_OP,fn,t);
treep = node(SF_OP,t,rhs);
return(treep);
}

sfarg()
{
/*
 * get a statement function argument.
 */
register char *s;

getsym();
if (s = lookup(NO))
	{
	setflag(s,F_ARG);		/* get rid of undef msg */
	sym_type = s->s_type;
	}
fixtype();
sym_loc = PARAM;
return(enter(&symbol));
}

delsym(sp) char *sp;
{
/*
 * delete symbol sp from normal lookup chain.
 * only complication is insuring that the entry pointing
 * to this one is updated correctly.
 * it is either the hash table itself or another symbol.
 */
register int l;
register char *s, *p;

l = hash(sp->s_name,MAXHASH-1);
if ((s = hashtab[l]) == sp)
	hashtab[l] = s->s_next;
else
	{
	while ((p = s->s_next) != sp)
		s = p;
	s->s_next = p->s_next;	/* link it up */
	}
}
