#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
#include "sym.h"
#include "char.h"
/*			Copyright 1977 by Bill Webb.	 		*/

/* #define	DEBUG(x) if (qflg) printf x	/* debug */
#define	DEBUG(x) 	/* debug */

int scitem();

char *subenter();
int varsb;			/* 0 if all subscripts are constants */
int var_type;			/* variable type to enter */
int var_len;			/* size of variable */
int titem();
#define	nsubs	subs.s_numsubs	/* number of subscripts found */
struct subsc subs;			/* subscript structure */

#define	SUBSIZE	(sizeof subs.s_subsc[0])
#define	SUBSCSIZE	(sizeof subs)-MAXSUBS*SUBSIZE
gettype()
{
register struct proto *p;

for (p=types; p->p_name; ++p)
	if (teststr(p->p_name))
		return(optlen(p->p_type));
ERR("missing type specification",E_TYPE);
}

optlen(t)
{
/*
 * get and check optional length specification for type "t".
 */
register int k;
register int n;

var_len = typelens[t];
if (var_len == 0)
	var_len = 1;		/* default character length */
if (!testc(STAR))
	return(t);
var_len = n = cvtint();
if (n <= 0)
	ERR1("bad length %d",E_LENGTH,n);
if (t == CHARACTER)
	return(t);
++extend;
if (n == typelens[t])
	return(t);
k = alttypes[t];
if (n == typelens[k])
	return(k);
ERR("invalid optional length",E_OPTLEN);
}

cvtint()
{
/*
 * convert an integer value.
 * or an expression in parentheses.
 */
register int c, n;
register int sign;

if (*inptr == '(')
	return(intvalue(getconst(NO)));
n = 0;
sign = 0;
if (!testc(PLUS) && testc(MINUS))
	sign++;
while ((c = *inptr++) >= '0' && c <= '9')
	{
	n =* 10;
	if (n<0)
		ERR("integer too large",E_INTSIZE);
	n =+ c - '0';
	}
--inptr;
if (sign)
	n = -n;
return(n);
}

implicit()
{
/*
 * implicit type (letter-list)
 */
register char *s;
int impspec();

list(&impspec);
/*
 * scan symbol table and fix up any symbols affected by the 
 * new implicit specifications.
 */
for (SCANSYM(s))
	{
	if (s->s_class == SYMBOL && s->s_type < MAXTYPE && (s->s_flags & F_TYPED) == 0)
		{
		DEBUG(("fix %.6s type=%d size=%d\n",s->s_name,s->s_type,s->s_size));
		s->s_type = imptab[s->s_name[0]-'a'];
		s->s_size = implen[s->s_name[0]-'a'];
		DEBUG(("  %.6s type=%d size=%d\n",s->s_name,s->s_type,s->s_size));
		}
	}
}

impspec()
{
int impitem();
var_type = gettype();
plist(&impitem);
}

impitem()
{
/*
 * get an individual item. format is "letter" or "letter-letter".
 * and then set the implicit table.
 */
register int l1, l2;
l1 = impletter();
if(testc(MINUS))
	l2 = impletter();
else
	l2 = l1;
if (l2 < l1)
	ERR("bad implicit range",E_IMPLICIT);
DEBUG(("implicit type=%d len=%d (%c-%c)\n",var_type,var_len,l1,l2));
set(imptab+l1-'a',l2-l1+1,var_type);
set(implen+l1-'a',l2-l1+1,var_len);
}

impletter()
{
register int c;

c = *inptr++;
if (chartype(c) != ALPHA)
	ERR("letter expected",E_LETTER);
return(c);
}


typespec(t)
{
/*
 * process a type specificaton list.
 */
var_type = optlen(t);
if (teststr("function"))
	{
	function(var_type);		/* type function ... */
	return;
	}
list(&titem);				/* process type items */
}

titem()
{
getsvar(YES);			/* get a (possibly) subscripted variable */
sym_flags =| F_TYPED;		/* explicitly typed */
sym_type = var_type;
sym_size = var_len;		/* set length */
miscitem();
}

miscitem()
{
if (sym_type == STRING && *inptr == STAR)
	{
	++inptr;
	sym_size = cvtint();
	if (sym_size <= 0)
		SERR("invalid character length",E_CHLEN);
	}
entersym();
if (sym_common)
	SNOTE("has been used in common",E_CMUSED);
else if (sym_equiv)
	SNOTE("has been used in equivalence",E_EQUIV);
}

getsvar(flag)
{
/*
 * get a symbol (possibly subscripted) for a specification statment.
 * if flag is YES then enter the subscripts into the symbol
 * table. (normal type statment call to getsvar).
 * if flag is NO (for equivalence) then just return a pointer to the subscript
 * structure.
 */
struct symbol savesym;
register int i;

varsb = 0;		/* all subscripts constant */
getsym();		/* get a symbol */
if (optc(LPAR))
	{
	move(SYMSIZE,&symbol,&savesym);
	nsubs = 0;
	plist(&scitem,flag);
	move(SYMSIZE,&savesym,&symbol);
	sym_nsubs = nsubs;
	if (flag)
		symbol.s_subptr = subenter();
	else
		symbol.s_subptr = &subs;
	}
}

scitem(flag)
{
/*
 * get a subscript for a variable in a specification statment.
 * format is either "upb" or "lwb:upb" with lwb defaulting to 1.
 * flag==NO indicates call from EQUIVALENCE rather than specification
 * statment.
 */
register char *ub, *lb;

ub = sbound();
if (testc(COLON))
	{
	lb = ub;
	ub = sbound();
	}
else
	lb = one_const;
if (constant(lb) && constant(ub))
	if (flag && intvalue(lb) > intvalue(ub))
		ERR("lower bound > upper bound",E_LWB);
if (nsubs >= MAXSUBS)
	ERR1("more than %d subscripts",E_N2SUBS,MAXSUBS);
subs.s_subsc[nsubs].lwb = lb;	/* lower bound */
subs.s_subsc[nsubs].upb = ub;
++nsubs;		/* count subscript */
}

sbound()
{
/*
 * get a subscript bound.
 */
if (testc(STAR))
	{
	expectc(RPAR);
	--inptr;		/* only allowed as last element */
	++varsb;		/* of a parameter */
	return(NULL);
	}
getconst(YES);
if(sym_type != INT2 && sym_type != INT4)
	ERR("subscript not integer",E_SBMODE);
if(sym_class != CONST)
	{
	if (sym_loc != PARAM && sym_loc != COMMON)
		SERR("illegal subscript",E_BADSB);
	varsb = cur_sym;		/* remember variable sb */
	}
return(cur_sym);
}

getvar()
{
/*
 * get a variable name and lookup and enter it into the symbol table
 * with default type if need be.
 */
getsym();
if (lookup(YES) == NOSYMBOL)
	{
	fixtype();
	enter(&symbol);
	}
return(cur_sym);
}

entersym()
{
/*
 * enter the current symbol with appropriate type.
 */
fixtype();			/* default the type */
if (lookup(NO) == NOSYMBOL)
	{
	if (sym_nsubs && varsb)
		varsberr();
	enter(&symbol);
	}
else
	mergesym();		/* include new information */
return(cur_sym);
}

dimstmt()
{
int dmitem();

list(&dmitem);
}

dmitem()
{
/*
 * item in a dimension statment.
 */
getsvar(YES);
if(sym_nsubs==0)
	SWARNING("not subscripted",E_NOTSUB);
miscitem();
}

mergesym()
{
/*
 * merge attributes of symbol table entry and current symbol.
 */
register char *s;
register int i;

s = cur_sym;
if(sym_class != SYMBOL || s->s_class!=SYMBOL)
	SERR("isn't a variable",E_NOTVAR);
if (s->s_nsubs || sym_nsubs)
	{
	if (s->s_nsubs == 0)
		{
		if (s->s_loc != PARAM && varsb)
			varsberr();
		s->s_nsubs = sym_nsubs;
		s->s_subptr = symbol.s_subptr;
		}
	else
		if(sym_nsubs != 0)
			SERR("inconsistent subscripts",E_SUBSC);
	}
if (s->s_type != sym_type)
	{
	if ((s->s_flags & F_TYPED) && (sym_flags & F_TYPED))
		SERR("already typed",E_TYPED);
	if((sym_flags & F_TYPED))
		{
		s->s_type = sym_type;
		s->s_size = sym_size;
		}
	}
if (s->s_loc != sym_loc)
	{
	if (s->s_loc == NOLOC)
		s->s_loc = sym_loc;
	else if (sym_loc != NOLOC)
		SERR("allocation contradiction",E_ALLOC);
	}
s->s_flags =| sym_flags;	/* copy flags */
move(s->s_len,s,&symbol);	/* insure both now the same */
}


extstmt()
{
int extitem();

list(&extitem);
}

extitem()
{
register char *s;

getsym();
if ((s = lookup(NO)) == NULL || s->s_loc != PARAM)
	sym_loc = EXTERN;
sym_flags =| F_FN;
entersym();
}

intstmt()
{
/*
 * intrinsice fn-name.
 */
int intitem();

list(&intitem);
}

intitem()
{
getsym();
if(fnlook() == 0)
	SERR("not intrinsic",E_INTRIN);
sym_flags =| F_FN | F_INTRINSIC;
entersym();
}

paramstmt()
{
/*
 * parameter var=constant, ...
 * defines "var" as a constant with the given value.
 */
int pitem();

plist(&pitem);
}

pitem()
{
/*
 * get an item for a parameter stmt.
 */
struct symbol savesym;

getsym();
if (lookup(NO) != NOSYMBOL)
	SERR("already defined",E_DEFINED);
sym_type = PARAMETER;
move(SYMSIZE,&symbol,&savesym);
expect("=");
savesym.s_addr = getconst(YES);
enter(&savesym);
}

fixtype()
{
/*
 * if no type allocated then default the type of current symbol.
 */
register int k;

if (sym_type == NOTYPE)
	{
	sym_type = imptab[k=(sym[0]-'a')];
	sym_size = implen[k];
	}
if (sym_size == 0)
	if ((sym_size = typelens[sym_type]) == 0)
		sym_size = var_len;	/* for string fn's */
if (sym_type == NOTYPE)
	SWARNING("not declared",E_DECL);
}

varsberr()
{
SERR("has variable subscript",E_VARSUB);
}

char *subenter()
{
/*
 * enter a subscript structure into the symbol table.
 * for now don't bother checking to see if its already there.
 */
subs.s_len = SUBSCSIZE+nsubs*SUBSIZE;
subs.s_class = SUBSCRIPT;
subs.s_loc = NOLOC;
subs.s_type = NOTYPE;
enter(&subs);
return(cur_sym);
}
