#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
#include "sym.h"
#include "char.h"
#include "ops.h"
/*			Copyright 1977 by Bill Webb.	 		*/

int scitem();
int fn_stmt;

int parcnt;		/* number of parameters */
int subrtype;		/* indicates type of subr */
int retcnt;		/* number of return *'s */
int paritem();

prog()
{
fnsub(MAIN);

sym_flags =| F_TYPED;
enter(&symbol);
treep = node(MAIN_OP,cur_sym,NULL);
}

subroutine()
{
fnsub(SUBROUTINE);	/* common function/subroutine */
entersym();
fn_sym = cur_sym;
if(*inptr)
	plist(&paritem);
fnsubend();
}

function(mode)
{
/*
 * process a function definition.
 */

stmt = fn_stmt;		/* correct the statement type */
fnsub(FUNCTION);
sym_type = mode;
if (mode != NOTYPE)
	sym_flags =| F_TYPED;	/* insure we know it has been typed */
entersym();
fn_sym = cur_sym;
plist(&paritem);
fnsubend();
}

fnsub(type)
{
subrtype = type;
if (type != ENTRY && isn != 1)
	ERR("not first statement",E_FIRST);
getsym();
sym_flags =| F_ENTRY;		/* remember its an entry */
if (type != ENTRY)
	{
	copy(progname,sym);		/* remember the name */
	progtype = type;
	}
parcnt = retcnt = 0;
}

fnsubend()
{
treep = node(SUBR_OP,fn_sym,treep);	/* generate entry code */
}

paritem()
{
register int l;
register char *s;

l = 0;
if (testc(STAR))
	{
	++retcnt;
	return(NULL);
	}
if (testc(SLASH))
	++l;
getsym();
if (l)
	expect("/");
sym_addr = parcnt*2;
++parcnt;
sym_loc = PARAM;
if ((s = lookup(NO)) != NOSYMBOL)
	{
	if (subrtype != ENTRY)
		SERR("parameter multiply defined",E_PARAM);
	if (s->s_loc == LOCAL)
		{
		SWARNING("parameter used before ENTRY",E_PARUSED);
		s->s_loc = NOLOC;	/* lie for mergesym */
		}
	}
entersym();
return(cur_sym);
}

entrystmt()
{
register char *s;
register int save;

save = parcnt;
if(progtype == MAIN)
	ERR("entry in main",E_ENTRY);
fnsub(ENTRY);
s = entersym();
if(*inptr)
	treep = treeplist(&paritem);
else
	if(progtype != SUBROUTINE)
		SERR("missing parameter list",E_PARLIST);
treep = node(ENTRY_OP,s,treep);
parcnt = save;
}

block()
{
if(*inptr == 0)
	append(inptr,"data ");		/* note the blank */
fnsub(BLOCK);

}
