#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "gen.h"

int objpos;		/* position relative to start of file */
float filesize;		/* size of the whole file (with symtab) */
int flsize;		/* integer form of filesize */
int arflag;		/* if generating library */
int arflg;		/* 1 if archive is to be produced if multiple sources */
int armagic;		/* the library magic number */
#define	RLD_ABS		0
#define	RLD_TEXT	02
#define	RLD_DATA	04
#define	RLD_BSS		06
#define	RLD_GLOBAL	010
#define	RLD_PC		01	/* pc relative */
#define	RLD_SYM		16	/* multiplier for symbol number */

struct objsym
{
char o_name[8];		/* name of symbol */
int o_type;		/* type of symbol */
#define	O_UNDEFINED	0
#define	O_ABS		1
#define	O_TEXT		2
#define	O_DATA		3
#define	O_BSS		4
#define	O_GLOBAL	040
int o_addr;		/* address of symbol */
} *objbeg;

#define	OBJSIZE	(sizeof *objbeg)
#define	SCANOBJ(s)	s=objbeg; s<objlast; s =+ OBJSIZE

char *objlast;
int symtsize;			/* symbol table size */
int objcnt;		/* number of entries in obj buffers */
#define	MAXOBJ	256	/* max number of words in buffer */
int objbuff[MAXOBJ];	/* buffer for object code */
int rldbuff[MAXOBJ];	/* buffer for rld code */
char objname[8];	/* name to enter */
int objorg, objaddr;	/* address to store it */
int objdes;		/* object file descriptor */

/*
 * system dependent object code routines for UNIX.
 * these routines manipulate the symbol table and output object code.
 */

char objfile[16];	/* name of object file */

objcreate()
{
/*
 * create the object file.
 * if there are more routines in the source file, then create
 * an archive for them. otherwise output directly to the appropriate
 * file. file name is build from the source name - .f or .ftn + .o 
 */
register char *p;
register char *s;

if (objdes == 0)
	{
	if(argp)
		{
		/*
		 * create object file from last part of source file name
		 * after replacing ".f" or ".ftn" with ".o".
		 */
		p = objfile;
		for (s=argp; *p = *s++; )
			if (*p++ == '/')
				p = objfile;
		*p == 0;
		while (p > objfile && *--p != '.')
			;
		if (p <= objfile)
			ERROR("bad file name (no dot found)",E_BADFILE);
		++p; *p++ = 'o'; *p++ = 0;	/* make into name.o */
		}
	else
		copy(objfile,"a.out");		/* for testing */
	arflag = !goteof;		/* if need ar stuff */
	if ((objdes = creat(objfile,0666)) < 0)
		ERROR1("can't creat %s",E_CREATE,objfile);
	if(arflag)
		{
		armagic = testar();
		write(objdes,&armagic,2);
		}
	}
symtsize = objlast-objbeg;
filesize = 16;
filesize = filesize + symtsize + objsize + objsize;	/* size of file */
flsize = 16 + symtsize + objsize + objsize;		/* size of file */
if (filesize > 65536.0)
	ERROR1("object too big (%.0f)",E_BIGOBJ,filesize);
if(arflag)
	{
	if (armagic == OLDARMAGIC)
		oldar();
	else
		newar();
	}
objpos = 0;		/* at start of file */
objaddr = objorg = 0;
objcnt = 0;
}

initobj()
{
/*
 * initialize object code routines.
 */
objlast = objbeg = symlast;
objcnt = 0;
objaddr = objorg = 0;
}

objword(word,rld)
{
/*
 * output a relocated word to the object file.
 */
register int i;

if(pass1)
	return;		/* do nothing in pass 1 */
i = objcnt;
objbuff[i] = word;
rldbuff[i] = rld;
objcnt = ++i;
objaddr =+ 2;
if (i >= MAXOBJ)
	objdump();
}

objdump()
{
register int l;
if (pass1)
	return;
if ((l = objcnt) > 0)
	{
	l =<< 1;		/* in bytes */
	seekpos(objorg+020,0);	/* to text region */
	objwrite(objbuff,l);
	seekpos(020+objorg+objsize,0);	/* to rld location */
	objwrite(rldbuff,l);
	}
objcnt = 0;
objorg = objaddr;
}

objseek(addr)
{
objdump();
objaddr = objorg = addr;
}

objlookup(name) char name[8];
{
register char *s;
register int *p;
register int *q;

for (SCANOBJ(s))
	{
	p = name;
	q = s->o_name;
	if (*p++ == *q++ && *p++ == *q++ && *p++ == *q++ && *p++ == *q++)
		return(s);
	}
return(FAIL);
}

objenter(name,type,addr) char name[8];
{
register char *s;
register char *p;

#ifdef	debug
if (objbeg != symlast)
	ERROR("help: symlast moved",E_SYMLAST);
#endif
s = objlast;
p = s + OBJSIZE;
if (p >= symend)
	symexpand();
objlast = p;
move(8,name,s->o_name);
s->o_type = type;
s->o_addr = addr;
/*	printf("enter: %.8s %d %d\n",name,type,addr);	*/
return(s);
}

putglob(name) char *name;
{
objglob(name,0);
}

objglob(name,word) char *name;
{
register char *s;
register char *p;

p = objname;
s = name;
while (*s)
	*p++ = *s++;
while (p < objname+8)
	*p++ = 0;
if ((s = objlookup(objname)) == 0)
	s = objenter(objname,O_GLOBAL,0);
if(!pass1)
	{
	if (cflg)
		{
		printf("%s",name);
		if(word)
			printf("+%d",word);
		printf(" ");
		}
	objword(word,(s-objbeg)/OBJSIZE*RLD_SYM+RLD_GLOBAL);
	}
codep =+ 2;
}

putword(v)
{
/*
 * output a word with no relocation requirements
 */
if(!pass1)
	{
	if (cflg) printf("%d ",v);
	objword(v,RLD_ABS);		/* output the word */
	}
codep =+ 2;
}


putobj(p,l) int *p;
{
register int k;
k = (l+1)>>1;
do
	putword(*p++);
while (--k);
}

endobj()
{
/*
 * finish up object file production, including producing the
 * header.
 */
register char *p;

objdump();		/* flush the buffer */
seekpos(020+objsize,0);	/* seek to relocation */
seekpos(objsize,1);		/* seek to symbol table */
p = objlast-objbeg;
objwrite(objbeg,p);
objbuff[0] = 0407;	/* object magic word */
objbuff[1] = endtext;	/* size of text portion */
objbuff[2] = enddata-endtext;	/* size of data portion */
objbuff[3] = endbss-enddata;		/* size of bss portion */
objbuff[4] = p;
objbuff[5] = 0;		/* entry = 0 */
objbuff[6] = 0;		/* unused */
objbuff[7] = 0;		/* relocation present */
seekpos(0,0);	/* to the beginning */
objwrite(objbuff,020);		/* write the header */
if (arflag)
	seekpos(flsize,0);		/* seek to end of file */
}

putdata(word)
{
/*
 * put a word relative to variables.
 */
if(!pass1)
	{
	if (cflg)
		printf("&+%d ",word);
	objword(word,RLD_DATA);
	}
codep =+ 2;
}

putbss(word)
{
/*
 * put a word relative to variables.
 */
if (!pass1)
	{
	if (cflg)
		printf("@+%d ",word);
	objword(word,RLD_BSS);
	}
codep =+ 2;
}

puttext(word)
{
/*
 * put a word relative to text.
 */
if (!pass1)
	{
	if (cflg)
		printf("#+%d ",word);
	objword(word,RLD_TEXT);
	}
codep =+ 2;
}

defglob(name) char name[6];
{
objcvt(name);	/* convert to object name */
if (!objlookup(objname))
	objenter(objname,O_GLOBAL+O_TEXT,codep);		/* define it */
}

dataglob(name) char name[6];
{
objcvt(name);	/* convert to object name */
if (!objlookup(objname))
	objenter(objname,O_GLOBAL+O_DATA,codep);		/* define it */
}

bssglob(name) char name[6];
{
objcvt(name);	/* convert to object name */
if (!objlookup(objname))
	objenter(objname,O_GLOBAL+O_BSS,codep);		/* define it */
}

objcvt(name) char name[6];
{
/*
 * convert 6 character fortran name to object 8 character
 * name.
 */
register char *p, *s;

s = name;
p = objname;
*p++ = '_';
while ((*p++ = *s++) && s <= name+6)
	;
--p;
if (acflg)
	*p++ = '_';		/* if C interface required */
while (p < objname+8)
	*p++ = 0;
}

defcommon(name,size) char name[6];
{
/*
 * define common block "name" of given size.
 */
objcvt(name);		/* convert to object form of name */
if(!objlookup(objname))
	objenter(objname,O_GLOBAL+O_UNDEFINED,size);	/* make into common */
}

seekpos(pos,how)
{
/*
 * seek to position "pos" in the file. how is 0 for abs seek
 * (relative to start of file) or 1 for relative.
 */
if (how == 0)
	{
	if (arflag == 0)
		{
		xseek(objdes,pos,0);
		objpos = pos;
		return;
		}
	if(pos < 0)
		ERROR("objfile too large",E_OBJFILE);
	xseek(objdes,pos-objpos,1);	/* do relative seek */
	objpos = pos;
	}
else
	{
	xseek(objdes,pos,1);
	objpos =+ pos;
	}
}

objwrite(buff,length) char *buff;
{
if (write(objdes,buff,length) < 0)
	ERROR("write error on obj file",E_WRITE);
objpos =+ length;			/* remember where */
}

defvar(name,addr) char name[6];
{
/*
 * define local variable "name" in the program.
 */
objcvt(name);
if(!objlookup(objname))
	objenter(objname,(bssflag ? O_BSS : O_DATA ),addr);
}

deflab(name) char name[6];
{
/*
 * define local label "name" in the program.
 */
objcvt(name);
if(!objlookup(objname))
	objenter(objname,O_TEXT,codep);
}

defisn(n)
{
#ifdef	FDB
/*
 * define isn "n" in the program.
 */
register char *p;

p = objname;
*p++ = '_';
*p++ = '_';		/* isn's are of form "__#" */
p = objnum(p,n);
while (p < objname+8)
	*p++ = 0;
if(!objlookup(objname))
	objenter(objname,O_TEXT,codep);
#endif	/* fdb */
}

#ifdef	FDB
objnum(str,num) char *str;
{
register int k;
register char *s;

s = str;
k = num/10;
if (k > 0)
	s = objnum(s,k);
*s++ = (num%10)+'0';
return(s);
}
#endif

testar()
{
/*
 * if "--on" switch is set use new format library.
 * if libf.a is in old format generate old format library
 * if libf.a is new format generate new format.
 */
register int f;

if (armagic)
	return(armagic);
if ((f = open("/lib/libf.a",0)) < 0)
	return(ARMAGIC);		/* use the default version */
read(f,&armagic,2);
close(f);
return(armagic);
}

oldar()
{
struct oar 
{
char a__name[8];
int a__time[2];
char a__uid;
#define	a__gid	a__uid	/* overlay onto uid */
char a__mode;
int a__size;
} oar;
	clear(&oar,sizeof oar);
	move(8,progname,oar.a__name);	/* use program name */
	append(oar.a__name,".o");		/* and make it .o too */
	time(oar.a__time);
	oar.a__gid = getgid();
	oar.a__uid = getuid();
	oar.a__mode = 0666;
	oar.a__size = flsize;
	write(objdes,&oar,sizeof oar);
}

newar()
{
struct ar
{
char a_name[14];
int a_time[2];
char a_uid;
char a_gid;
int a_mode;
long a_size;
} ar;
	clear(&ar,sizeof ar);
	move(8,progname,ar.a_name);	/* use program name */
	append(ar.a_name,".o");		/* and make it .o too */
	time(ar.a_time);
	ar.a_gid = getgid();
	ar.a_uid = getuid();
	ar.a_mode = 0666;
	ar.a_size = flsize;
	write(objdes,&ar,sizeof ar);
}

dataobj(sp,len) char *sp;
{
/*
 * special version of "putobj" that is used to write odd length
 * data items directly to the file to avoid overwritting bytes in
 * the word oriented putobj routine.
 */
if ((len&1) || (objaddr&1))
	{
	objdump();
	seekpos(objaddr+020,0);		/* seek to proper place */
	objwrite(sp,len);		/* write it */
	objorg = objaddr;
	}
else
	putobj(sp,len);
}

objclose()
{
/*
 * close off object file at end of input file.
 */
int status;
if (objdes == 0)
	return;
close(objdes);
#ifdef LD
if (arflag && !arflg)		/* combine archive into single object file */
	{
	if (fork() == 0)
		{
		closeall();
		execl(LD,"ld","-r","-z",objfile,"-z",0);
		exit(1);
		}
	wait(&status);
	unlink(objfile);
	link("a.out",objfile);
	unlink("a.out");
	}
#endif	/* LD */
objdes = 0;
}

nargs()
/*
 * KLUDGE: wait calls nargs which will blow up if split I/D space is used
 * so provide an nargs which will return 1 to get around this problem.
 */
{
return(1);
}

genlab()
{
if (++labcnt >= (MAXBUFF/2-2))
	ERROR1("more than %d forward references",E_FWDREFS,labcnt);
return(labcnt);
}

setlab(l)
{
/*
 * set label "l" to current address.
 */
register int *p;

p = inbuff;
p[l] = codep;
lastisn = 0;		/* maybe jumping here */
}

putlab(l)
{
register int *p;

p = inbuff;
if(!pass1)
	{
	if(cflg) printf("%d ",p[l]);
	objword(p[l],RLD_TEXT);
	}
codep =+ 2;
}
