#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "sym.h"
#include "tree.h"
#include "ops.h"

double fetch();
double floor();
#define	ZERO(x)	hasvalue(x,0)		/* test if value is 0 */
#define	ONE(x)	hasvalue(x,1)		/* test if value is 1 */
#define	MINUSONE(x)	hasvalue(x,-1)	/* test if value is -1 */

int optflg { YES };		/* normally optimize */
char modematrix[MAXTYPE][MAXTYPE];

diadic(op,left,right) struct node *left, *right;
{
/*
 * diadic operator "op" on operands "left" and "right".
 * mode of both operands is coerced to an acceptable common mode
 * and errors produced for bad combinations.
 */
register int m, m2;
register int r;
int flag;		/* ordering flag */

m = left->t_type;
m2 = right->t_type;
flag = 0;
r = modematrix[m][m2];
if (r == NOTYPE)
	ERR2("mixed modes: %s and %s",E_MIXED2,typenames[m],typenames[m2]);
if (r == STRING && INSYM(left))
	left = mnode(STR_OP,r,left,NULL);
if (op != STORE_OP && !INSYM(left) && left->t_op == SBA_OP)
	left->t_op = SBV_OP;		/* correct for arg lists etc. */
if (right == NULL)
	{
	if (op == CHK_OP)
		return(left);
	else
		ERR("unbounded array",E_UNBND);
	}
switch(op)
	{
case GT_OP:
case GE_OP:
case LT_OP:
case LE_OP:
	++flag;
case EQ_OP:
case NE_OP:
	if (isbool[r] || (flag && !ordered[r]))
		ERR2("illegal operand(s) %s and %s",E_OPANDS,typenames[m],typenames[m2]);
	if (m != r)
		left = cvt(left,r);
	if (m2 != r)
		right = cvt(right,r);
	r = LOG2;		/* result is logical */
	if(CONSTEXPR(left) || CONSTEXPR(right))
		return(consteval(op,r,left,right));
	break;
case EXP_OP:
	if (isint[m2])
		{
		r = m;
		break;
		}
case ADD_OP:
case SUB_OP:
case MUL_OP:
case DIV_OP:
case CHK_OP:
	chkarith(r);
	if (m != r)
		left = cvt(left,r);
	if (m2 != r)
		right = cvt(right,r);
case CAT_OP:
	if(CONSTEXPR(left) || CONSTEXPR(right))
		return(consteval(op,r,left,right));
	if(optflg && (op == ADD_OP || op == MUL_OP) && dtest(left,op) && dtest(right,op))
		return(dassoc(op,left,right));
	break;
case AND_OP:
case OR_OP:
	chkbool(r);
	break;
case STORE_OP:
	if(m != m2)
		left = cvt(left,m2);
	r = m2;
	setflag(right,F_CHANGED);		/* mark as modified */
	if (r == STRING)
		return(mnode(STO_OP,r,right,left));
	break;
default:
	ERR1("bad operator %s",E_BADOP,opnames[op]);
	}
return(mnode(op,r,left,right));
}

setflag(sp,flag) char *sp;
{
/*
 * follow down chain until symbol table entry is found.
 * mark it as changed.
 * this routine relies on the fact that the symbol table entry is
 * always on the left branch of SBA, SBV, SYM and STR ops.
 */
register char *s;

for (s=sp; s; s=s->t_left)
	{
	if(INSYM(s))
		{
		s->s_flags =| flag;	/* modified */
		return;
		}
	}
ERROR("symbol expected",E_SYMEXP);
}

unary(op,tree) char *tree;
{
/*
 * check operand type for unary operators.
 */
register char *t;
register int m;
register char *s;

t = tree;
m = t->t_type;		/* pick up the type */
switch(op)
	{
case TEQ_OP:
case TNE_OP:
case TLE_OP:
case TLT_OP:
case TGT_OP:
case TGE_OP:
	m = LOG2;	/* resulting mode */
	break;		/* simplicity itself */
case NEG_OP:
	chkarith(m);
	if(INSYM(t) && constant(s=t))
		switch(m)
			{
		case INT2:
			return(iconst(-s->s_int,m));
		case INT4:
			return(qconst(-qload(s->s_qint),m));
		case REAL4:
		case REAL8:
			return(fconst(-s->s_float,m));
			}
	break;
case NOT_OP:
	chkbool(m);
	if(INSYM(t) && constant(s=t))
		return(iconst(~s->s_int,m));
	break;
default:
	ERR1("bad unary operator %d",E_BADUOP,op);
	}
return(mnode(op,m,t,NULL));
}

cvt(tree,mode) char *tree;
{
/*
 * create conversion node to mode "mode".
 * handle following constant cases:
 * integer => integer
 * real => real
 * integer => real
 * real => integer
 * where integer is INT2 or INT4 and real is REAL4 or REAL8.
 */
register int i;
register char *s;
register char *t;

t = tree;
if(t->t_type == mode)
	return(t);			/* trivial case */
if (INSYM(t) && constant(s=t))
	{
	i = s->s_type;		/* operand type */
	if (isreal[mode])
		return(fconst(fetch(s),mode));
	else if (isint[mode])
		return(fconst(floor(fetch(s)),mode));
	else if (isbool[i] && isbool[mode])
		return(iconst(s->s_int,mode));
	else if (iscmplx[mode])
		{
		if (iscmplx[i])
			return(cvtcmplx(s->s_real,s->s_imaginary,mode));
		else
			return(fconst(fetch(s),mode));
		}
	}
return(mnode(CVT_OP,mode,t,NULL));
}

mixed()
{
ERR("mixed modes",E_MIXED);
}

fpterr()
{
signal(8,&fpterr);
switch(fec())
	{
case 04:
	ERR("division by zero",E_ZDIV);
case 06:
	ERR("integer outside range",E_INTRNG);
case 08:
	ERR("real number too large",E_FOVFL);
	}
ERR("floating point error",E_FPERR);
}

chkstr(m)
{
if (m != CHARACTER)
	ERR("character mode required",E_CHAR);
}

dtest(tree,op) char *tree;
{
/*
 * test if the tree is of the form:
 * constant op expr
 */
register char *t;
register char *l, *r;

t = tree;
if (!INSYM(t) && (t->t_op == op))
	{
	l = t->t_left;
	if(CONSTEXPR(l))
		return(OK);
	}
return(FAIL);
}

distrib(op,left,right) char *left, *right;
{
/*
 * distribute "left" into "right", using operator "op".
 * normally "left" is constant and op is "*".
 */
register char *l, *r;

l = left; r = right;
return(diadic(r->t_op,
	diadic(op,l,r->t_left),
	diadic(op,l,r->t_right)));
}

assoc(op,left,right)
{
/*
 * associate "left" into right. normally op is + or minus and
 * left is constant.
 */
register char *l, *r;
register int o;

l = left;
r = right;
#ifdef	debug
if (op != r->t_op)
	error("assoc %s %s",opnames[op],opnames[r->t_op]);
#endif
if(CONSTEXPR(r->t_left))
	return(diadic(op,diadic(op,l,r->t_left),r->t_right));
else
	return(diadic(op,diadic(op,l,r->t_right),r->t_left));
}

dassoc(op,left,right)
{
/*
 * (const op expr) op (const op expr)
 * double assocation of left and right.
 */
register char *t, *l, *r;
l = left;
r = right;
t = diadic(op,l->t_left,r->t_left);
r = diadic(op,l->t_right,r->t_right);
return(diadic(op,t,r));
}

hasvalue(sp,n) char *sp;
{
/*
 * test if:
 * 1. "sp" is a in symbol table and is constant.
 * 2. it has the value "n".
 */
register char *s;

s = sp;
if (CONSTEXPR(s))
	switch(s->s_type)
		{
	case INT2:
	case LOG1:
	case LOG2:
		return(s->s_int == n);
	case REAL4:
	case REAL8:
		return(s->s_float == n+0.0);
	case INT4:
		return(qload(s->s_qint) == n+0.0);
	case CMPLX8:
	case CMPLX16:
		return(hasvalue(s->s_real,n) && hasvalue(s->s_imaginary,0));
		}
return(FAIL);
}

badsc()
{
WARNING("subscript outside bounds",E_BNDS);
}

testcvt(tree,mode) char *tree;
{
register char *t;

t = tree;
if (t->t_type == mode)
	return(t);		/* all ok */
if (modematrix[t->t_type][mode] == NOTYPE)
	ERR2("cannot convert from %s to %s",E_CVT,typenames[t->t_type],typenames[mode]);
return(cvt(t,mode));
}

cvtcmplx(f1,f2,type) char *f1, *f2;
{
/*
 * convert f1 and f2 to a complex number of type "type".
 */
register int m;

m = (type == CMPLX8) ? REAL4 : REAL8;
f1 = cvt(f1,m);
f2 = cvt(f2,m);
return(cconst(f1,f2,type));
}
