#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "sym.h"
#include "tree.h"
#include "ops.h"

char *rclist;		/* return label list */
#define	FN_OP	30
#define	INTMODE	20

/* subcodes for the fargs field */
#define	INTRINSIC	020
#define	I_1		021	/* intrinsic 1 arg */
#define	I_2		022	/* intrinsic 2 arg */
#define	I_N		020	/* intrinsic n args */
#define	CVT	040		/* conversion routine */
#define	G		010
#define	G_1	011		/* generic 1 arg */
#define	G_2	012		/* generic 2 args */
#define	G_N	010		/* generic n args */

#define	returns	+ 256 *

/* special type for the function type field */
#define	SAME	0
#define	NOTCMPLX	SPTYPE	/* anything but complex */

/* special encoded allowed argument type field */
#define	I2	1
#define	I4	2
#define	R4	4
#define	R8	010
#define	L1	020
#define	L2	040
#define	C8	0100
#define	C16	0200
#define	C	0400

#define	ARITH	(I2+I4+R4+R8+C8+C16)
#define	RC	(R4+R8+C8+C16)
#define	INT	(I2+I4)
#define	LOG	(L1+L2)
#define	REAL	(R4+R8)
#define	CMPLX	(C8+C16)
#define	INTREAL	(INT+REAL)

/* generic type letters to be prefixed onto function names */
char genletter[]
{ 0, 'I', 'Q', 'R', 'D', 'B', 'L', 'C', 'H', 'S' };	/* note case */

int typebits[]
{ 0, I2, I4, R4, R8, L1, L2, C8, C16, C };		/* bit code for type */

/*
 * look up the function in the generic and intrinsic function 
 * table. if not found assume that its an external function.
 */

struct fntab
{
char *f_name;		/* function name */
int f_args;		/* types of args acceptable */
char f_type;		/* type of function */
char f_result;		/* resulting mode */
} generic[]
{
/*
  fn	args	type		results
 */
"abs",		ARITH,		G_1 returns NOTCMPLX,
"acos",		RC,		G_1 returns SAME,
"aimag",	CMPLX,		G_1 returns REAL4,
"aint",		REAL,		G_1 returns SAME,
"alog",		REAL,		I_1 returns REAL4,
"alog10",	R4,		I_1 returns SAME,
"amax0",	INT,		I_N returns REAL4,
"amax1",	R4,		I_N returns REAL4,
"amin0",	INT,		I_N returns REAL4,
"amin1",	R4,		I_N returns REAL4,
"amod",		REAL,		I_2 returns SAME,
"asin",		RC,		G_1 returns SAME,
"atan",		REAL,		G_1 returns SAME,
"atan2",	REAL,		G_2 returns SAME,
"bool",		ARITH,		CVT+G_1 returns LOG2,
"cabs",		CMPLX,		I_1 returns NOTCMPLX,
"char",		INT,		CVT+G_1 returns CHARACTER,
"clog",		CMPLX,		I_1 returns SAME,
"cmplx",	ARITH,		G_N returns CMPLX8,
"conjg",	CMPLX,		G_1 returns SAME,
"cos",		RC,		G_1 returns SAME,
"cosh",		REAL,		G_1 returns SAME,
"csqrt",	CMPLX,		I_1 returns SAME,
"dabs",		R8,		I_1 returns SAME,
"dble",		ARITH,		CVT+G_1 returns REAL8,
"ddim",		R8,		I_1 returns SAME,
"dexp",		R8,		I_1 returns SAME,
"dfloat",	INT,		CVT+G_1 returns REAL8,
"dim",		INTREAL,	G_1 returns SAME,
"dint",		R8,		G_1 returns SAME,
"dlog",		R8,		I_1 returns REAL8,
"dlog10",	R8,		I_1 returns SAME,
"dmax0",	INT,		I_N returns REAL8,
"dmax1",	R8,		I_N returns REAL8,
"dmin0",	INT,		I_N returns REAL8,
"dmin1",	R8,		I_N returns REAL8,
"dmod",		R8,		I_2 returns SAME,
"dprod",	R4,		I_2 returns REAL8,
"dsign",	R8,		I_1 returns SAME,
"dsqrt",	R8,		I_1 returns SAME,
"exp",		RC,		G_1 returns SAME,
"float",	INT,		CVT+G_1 returns REAL4,
"iabs",		INT,		I_1 returns SAME,
"ichar",	C,		CVT+G_1 returns INT2,
"idim",		INT,		I_1 returns SAME,
"idint",	R8,		CVT+G_1 returns INT2,
"ifix",		REAL,		CVT+G_1 returns INT2,
"index",	C,		I_1 returns INT2,
"int",		ARITH+LOG,	CVT+G_1 returns INT2,
"int2",		ARITH+LOG,	CVT returns INT2,
"int4",		ARITH+LOG,	CVT+G_1 returns INT4,
"isign",	INT,		I_1 returns SAME,
"len",		C,		I_1 returns INT2,
"log",		RC,		G_1 returns SAME,
"log10",	RC,		G_1 returns SAME,
"max",		ARITH,		G_N returns SAME,
"max0",		INT,		G_N returns SAME,
"max1",		R4,		I_N returns INT2,
"min",		ARITH,		G_N returns SAME,
"min0",		INT,		G_N returns SAME,
"min1",		R4,		I_N returns INT2,
"mod",		INTREAL,	G_2 returns SAME,
"nint",		REAL,		G_1 returns SAME,
"real",		ARITH,		CVT+G_1 returns REAL4,
"sign",		INTREAL,	G_2 returns SAME,
"sin",		RC,		G_1 returns SAME,
"sinh",		REAL,		G_1 returns SAME,
"sngl",		ARITH,		CVT+G_1 returns REAL4,
"sqrt",		RC,		G_1 returns SAME,
"tan",		REAL,		G_1 returns SAME,
"tanh",		REAL,		G_1 returns SAME,
0,	0,	0 };

fnexpr(type)
{
/*
 * process arguments for the function call.
 * look up the function in a list of intrinsic functions
 * and do appropriate stuff.
 */
register char *p;
register char *t;
register int s;
int pexpr();		/* parameter expression */
int cexpr();		/* call argument */

p = cur_sym;
if (type == LEFT)
	return(stmtfn(p));		/* process stmt function */
if (p->s_flags & F_ENTRY)
	SERR("used recursively",E_RECUR);
s = reverse(treeplist(type == CALLARG ? &cexpr : &pexpr));		/* the arguments */
cur_sym = p;
move(p->s_len,p,&symbol);	/* restore symbol */
switch(p->s_loc)
	{
default:
	SERR("used as a function",E_USEFN);
case NOLOC:
	if(t = genfn(s,listcnt))
		return(t);		/* all done already */
	else
		p->s_loc = EXTERN;	/* mark as function */
case PARAM:
	p->s_flags =| F_FN;	/* mark as function */
case EXTERN:
case TEXT:		/* statement function */
	;
	}
return(mnode(FN_OP,p->s_type,p,s));
}

genfn(tree,nargs) char *tree;
{
/*
 * routine to establish the type of a function.
 * the function name is currently in "sym".
 * the arguments are in "tree".
 * nargs is their number.
 */
register struct fntab *f;
register char *s;
register int n;

s = cur_sym;
if ((f = fnlook()) == FAIL)
	return(FAIL);		/* use default info */

/*
 * We have found a intrinsic or generic function. 
 * check argument number and type.
 * if generic function then build function name from
 * the general form and a type character.
 */
if(nargs == 0)
	SERR("needs arguments",E_ARGS);
n = f->f_type&03;	/* pick up arg count */
if(n && (n != nargs))
	SERR1("requires %d arguments",E_NARGS,n);
n = tree->t_left->t_type;	/* type of 1 argument */
if((f->f_args & typebits[n]) == 0)
	SERR("argument has wrong type",E_ARGTYPE);
chkargs(tree,n);	/* insure all the same type */
if (f->f_type & G)
	{		/* build name for generic function */
	sym[0] = genletter[n];
	s->s_flags =| F_FN | F_GENERIC;		/* mark as generic */
	s->s_type = NOTYPE;			/* no type */
	move(length(f->f_name),f->f_name,sym+1);
	}
if(f->f_type & CVT)
	{
	n = f->f_result;
	if ((f->f_type&G) && n == INT2)
		n = intmode;		/* kludge */
	s = tree->t_left;
	if (!INSYM(s))
		{
		 if (s->t_op == STORE_OP)
			s = s->t_left;	/* remove temporary */
		else if (s->t_op ==SBA_OP)
			s->t_op = SBV_OP;
		}
	return(cvt(s,n));	/* let cvt do it */
	}
if ((s = lookup(YES)) == NOSYMBOL)
	s = enter(&symbol);		/* enter it if not there already */
s->s_type = f->f_result;
if(s->s_type == SAME)
	s->s_type = n;
else if (s->s_type == NOTCMPLX)
	{			/* required to get cabs to work */
	if (n == CMPLX8)
		n = REAL4;
	else if (n == CMPLX16)
		n = REAL8;
	s->s_type = n;
	}
		
s->s_flags =| F_FN | F_INTRINSIC;
s->s_loc = EXTERN;
return(mnode(FN_OP,s->s_type,s,tree));
}

chkargs(tree,type) char *tree;
{
/*
 * check that all the arguments are of type "type"
 */
register char *t;

for (t=tree; t; t=t->t_right)
	{
	if (t->t_left->t_type != type)
		SERR("arguments have mixed types",E_ARGMIXED);
	}
}

fnlook()
{
/*
 * lookup the current symbol in the function table
 * and return the appropriate entry.
 */
char name[NAMESIZE+1];
register char *p, *s;
register struct fntab *f;

s = name;
for (p=sym; p<sym+NAMESIZE;)
	*s++ = *p++;
*s++ = 0;
for (f = &generic; p = f->f_name; ++f)
	{
	s = name;		/* name to look up */
	while (*p == *s++)
		if(*p++ == 0)
			return(f);
	}
return(FAIL);
}
