#
/*			Copyright 1979 by Bill Webb.	 		*/
#include "param.h"
#include "ftn.h"
#include "sym.h"

#define	LIMIT	8	/* limit to print (listing) */
#define	LIMIT2	12	/* limit to print (no listing) */
#define WARNMAX	5

putmsg(msgp,msg,d1,d2) char *msg, *msgp;
{
register int l;
if (srcline)
	printf("%d: ",srcline);
else if(isn)
	printf("isn %d: ",isn);
if (label[0])
	printf("(#%.6s) ",label);
if(msgp)
	msgf(msgp);
msgf(msg,d1,d2);
if (inptr >= inbuff && inptr <= endstr(inbuff))
	{
	l = lflg ? LIMIT : (LIMIT2);
	printf(" in \"");
	if (inptr-l <= inbuff)
		prints(inbuff,inptr-inbuff);	/* print up to error */
	else
		{
		printf("... ");
		prints(inptr-l,l);
		}
	if(*inptr)
		{
		printf(" <=> ");
		prints(inptr,l);
		if (length(inptr) > l)
			printf(" ...");
		}
	printf("\"");
	}
printf("\n");
flush();
if(abflg)
	abort();		/* abort in compiler debug mode */
}

warn(msg,d1,d2) char *msg;
{
putmsg(0,msg,d1,d2);
++goterr; errcnt++;
if (iflg)
	rc = 1;
}

swarning(msg,d1) char *msg;
{
warning(msg,sym,d1);
}

warning(msg,d1,d2) char *msg;
{
if (wflg)
	return;		/* ignore warnings */
if (++warncnt == WARNMAX)
	putmsg(0,"additional warning(s) supressed");
if (warncnt >= WARNMAX)
	return;
putmsg("WARNING ... ",msg,d1,d2);
}

err(msg,d1,d2) char *msg;
{
putmsg(0,msg,d1,d2);
goterr++; errcnt++;
if (iflg)
	rc = 1;
if(progtype != BLOCK)
	puterr();		/* output an error */
docleanup();
reset();
}

error(msg,d1,d2) char *msg;
{
putmsg("fatal error - ",msg,d1,d2);
flush();
if (qflg > 1)
	abort();
exit(1);
}

serr(msg,d1)
{
err(msg,sym,d1);
}

swarn(msg,d1)
{
warn(msg,sym,d1);
}
