#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "sym.h"
#include "tree.h"
#include "ops.h"
#include "char.h"

#define	DATAMAX	(3*NODESIZE)
char *dataptr;		/* where we get data from */
char *constptr;		/* current constant */
char datac;		/* next delimeter */
char *datalast;
int datacnt;		/* number of pending data items */

datastmt()
{
int dataspec();

datalast = 0;
list(&dataspec);
dataflush();
}

dataspec()
{
/*
 * get a data specification. its a list of variables followed
 * by a list of data items.
 */
register char *p;
int datavar();

for (p=inptr; *p && *p != SLASH; ++p)
	;
if(*p == 0)
	ERR("/ missing",E_NOSLASH);
dataptr = p;
datacnt = 0;
datac = SLASH;	/* first delimiter */
list(&datavar);
if(datacnt != 0)
	ERR("too many data items",E_D2MNY);
expect("/");
inptr = dataptr;
expect("/");
}


datavar()
{
/*
 * pick up a data variable and then pick up the data to 
 * initialize it.
 */
register char *s;
register char *c;
register char *t;
int off;
int l;

off = eqvar();		/* use equivalence routine */
s = cur_sym;
if (s->s_loc == NOLOC)
	s->s_loc = LOCAL;
if (s->s_flags&F_FN) 
	baddata();
if (progtype == BLOCK)
	{
	if(s->s_loc != COMMON)
		baddata();
	}
else
	if(s->s_loc != LOCAL)
		baddata();
if(sym_nsubs == 0)
	l = varsize(s)/s->s_size;
else
	l = 1;
if ((s->s_flags & (F_DATA|F_DATAZ)) && s->s_nsubs == 0)
	SWARNING("multiple data assignments",E_MULTDATA);
while (--l >= 0)
	{
	c = dataconst(s->s_type,s->s_size);
	if(!ZERO(c))
		{
		s->s_flags =| F_DATA;		/* remember data assigned */
		t = node(DATA_OP,sym_node(s,off),c);
		t = node(COMMA_OP,t,NULL);
		datanode(t);		/* output data node */
		}
	else
		s->s_flags =| F_DATAZ;		/* remember data assigned */
	off =+ s->s_size;
	}
}

dataconst(type,size)
{
/*
 * get another data constant from the input line.
 */
register char *saveptr;
register char *c;
register int k;

saveptr = inptr;
inptr = dataptr;
c = constptr;
while (datacnt <= 0)
	{
	expectc(datac);
	datac = COMMA;
	c = getconst(NO);
	if(c->s_type == intmode && testc(STAR))
		{
		datacnt = intvalue(c);		/* pick up value */
		c = getconst(NO);
		}
	else
		datacnt = 1;
	}
--datacnt;
if(c->s_type != type)
	{
	if (type == alttypes[c->s_type])
		c = cvt(c,type);
	else if (c->s_type == CHARACTER)
		{
		++extend;
		c = fixstr(c,size);
		}
	else
		ERR2("%s instead of %s constant",E_DCMODE,typenames[c->s_type],typenames[type]);
	}
if (c->s_size != size)
	c = fixstr(c,size);
dataptr = inptr;
constptr = c;
inptr = saveptr;
return(c);
}

fixstr(sp,size) char *sp;
{
/*
 * produce a string constant of length "size" given string constant "sp".
 */
register char *c;

if (size > MAXSTRING)
	ERR1("string too long (%d)",E_STRLONG,size);
c = sp;
move((c->s_len&0377),c,&symbol);
if (size < sym_size)
	WARNING("constant truncated",E_DCTRUN);
while (size > sym_size)
	sym_string[sym_size++] = ' ';	/* pad with blanks */
sym_size = size;		/* correct the length */
c = senter();
return(c);
}
sym_node(sp,off) char *sp;
{
register char *s;

s = node(SYM_OP,sp,NULL);
s->t_type = sp->s_type;
s->t_offset = off;
return(s);
}

baddata()
{
SERR("can't have data",E_DCANT);
}

datanode(tree) char *tree;
{
register char *t;

t = tree;
if(datalast)
	datalast->t_right = t;
else
	treep = t;
datalast = t;
if (textlast+DATAMAX > textend)
	{
	dataflush();
	putstmt();
	}
}

dataflush()
{
if(treep)
	treep = node(DATA_OP,treep,NULL);
datalast = 0;
}
