#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "stmt.h"
#include "char.h"

compress()
{
/*
 * compress the input buffer, removing blanks and tabs and translating
 * upper to lower case.
 * strings (quoted and hollerith) are copied as is.
 * the ' in find and read statements is changed to an "@" so
 * that it isn't taken as a string.
 */
register char *p, *q;
register int c;
int notasmt;
int level;		/* parentheses level */

notasmt = 0;
level = 0;		/* start at no parens */
stmt = NO_STMT;
p = inbuff;
q = inptr;
while ((c = *q++) && c != COMCHAR)
	{
	*p++ = c;
	switch(chartype(c))
		{
	case ALPHA:
		while ((c = chartype(*q)) == ALPHA || c == DIGIT)
			*p++ = *q++;
		break;
	case UPPER:
		c =- 'A' - 'a';
		p[-1] = c;
		break;
	case INVALID:
		ERR("invalid character",E_INCHAR);
	case DIGIT:
/*
 * check for [punctuation] [number] h
 * in order to properly pass hollerith constants
 * thru to the next stage. 
 * the check for "*" is to allow "real*8 h"
 */
		c = p[-2];
		if(chartype(c) != OTHER || c == '*')
			{
			while (chartype(*q) == DIGIT)
				*p++ = *q++;
			break;
			}
		outptr = p-1;
		inptr = q-1;
		c = getint();
		p = outptr;
		q = inptr;
		if (*q == 'h' || *q == 'H')
			{
			if (c <= 0 || c > length(++q))
				ERR("invalid H field",E_BADH);
			*p++ = 'h';
			do
				*p++ = *q++;
			while (--c);
			}
		break;
	case IGNORE:			/* blank and tab */
		--p;
		break;
	case OTHER:
		switch(c)
			{
		case '(':
			++level;
			break;
		case ')':
			if (--level < 0)
				ERR("unbalanced parentheses",E_UNBAL);
			if (level == 0)
				{
				while ((c = *q) == ' ' || c==TAB)
					++q;
				if (c != '=')
					++notasmt;		/* if (a) ... = */
				}
			break;
		case ',':
			if (level == 0)
				stmt = NO_STMT;
			break;
		case '=':
			if (level == 0 && !notasmt)
				stmt = ASMT_STMT;
			break;
		case QUOTE:
			if (level == 1 && stmt == NO_STMT && chartype(p[-2]) != OTHER)
				{
				p[-1] = AT;			/* find, read etc ' */
				break;
				}
			while (c = *q++)
				{
				*p++ = c;
				if (c == QUOTE)
					{
					if (*q != QUOTE)
						break;
					else
						*p++ = *q++;	/* pass double quote */
					}
				}
			if (c == 0)
				ERR("unterminated string",E_BADSTR);
			break;
			}
		}
	}
*p++ = 0;
if (level)
	ERR("missing right parenthesis",E_NORPAR);
*p++ = 0;	/* an extra marker for safty */
}


getint()
{
/*
 * scan and convert an integer constant off the input line.
 */
register int c, n;

n = 0;
c = *inptr++;
do
	{
	*outptr++ = c;
	n = n * 10 + c - '0';
	do
		c = *inptr++;
	while (c == ' ' || c == TAB);
	}
while (c >= '0' && c <= '9');
--inptr;
return(n);
}
