#include "param.h"
#include "err.h"
#include "ftn.h"
/*			Copyright 1979 by Bill Webb.	 		*/
/*			Copyright 1977 by Bill Webb.	 		*/
#include "tree.h"
#include "sym.h"
#include "ops.h"
#include "gen.h"

#define	XFER	lastisn = -100	/* transfer of control */
#define	JSR_R4	04437	/* jsr r4,*$ ... */
int maintree [] { MAIN_OP, NULL, NULL };
char modenames[] { 0, 'i', 'q', 'f', 'd', 'b', 'l', 'c', 'h', 's', 0 };
char mainname[6] "main";	/* name of main program */
char GO_TO[] "goto_";		/* goto's name */
char intname[8] "INTEGER";	/* default integer mode type */

int codeaddr();
int putsym();
int datagen();
int genio();
int putsymt();
char procname[8];		/* name of main procedure */

code()
{

srcline = 0;		/* not in source */
goterr = 0;
mcount = 0;		/* no count word */
cmsize = 0;
setexit();
if(goterr)
	ERROR("error in code generation",E_CODE);
clear(inbuff,sizeof inbuff);
treeflush();		/* empty the buffer */
write(tmpdes,&zerovalue,2);	/* final length */
initobj();
argaddr = 0;			/* no arguments found yet */
codep = 0;
pass1 = YES;
if (progtype == BLOCK)
	{
	move(6,progname,procname+1);	/* copy the name */
	defglob(procname+1);
	putword(JSR_R4);
	putglob("blockd_");
	codesize = endtext = codep;
	alloccm(NO);			/* allocate data vars */
	enddata = codep;
	alloccm(YES);			/* allocate bss vars */
	}
else
	{
	alloccm(YES);		/* allocate common blocks */
	bssflag = NO;
	codepass();
	codesize = codep;
	allocconsts();		/* put out the constants */
	endtext = codep;
	allocdata();		/* allocate data vars */
	if (codep == endtext)
		codep =+ 2;	/* always have some data */
	enddata = codep;
	allocbss();		/* allocate bss vars */
	}
objenter(intname,041,typelens[intmode]);	/* integer */
procname[0] = '&';
if (procname[6] == ' ')
	procname[6] = '_';		/* fix up block data name */
objenter(procname,043,endtext);		/* start of data */
procname[0] = '@';
objenter(procname,044,enddata);		/* start of bss */
endbss = codep;		/* total size of program */
objsize = enddata;
codep = 0;
pass1 = NO;
objcreate();		/* create the output file */
objseek(0);
if (progtype == BLOCK)
	{
	putword(JSR_R4);
	putglob("blockd_");
	}
codepass();
allocconsts();		/* actually write the constants */
if(aflg)
	printf("%s size: code=%d+%d, variables=%d, common=%.0f bytes\n",
		progname,codesize,endtext-codesize,endbss-endtext,cmsize);
endobj();
}

codepass()
{
register int *p;
register char *tp;
register char *s;

labcnt = 0;
XFER;
xseek(tmpdes,0,0);	/* rewind the file */
nextlen = 0;
readtree(&nextlen,2);
while (nextlen > 0)
	{
	p = textbeg-(WRITEHDR-2);
	readtree(p,nextlen+WRITEHDR);
	tp = *p++;
	isn = *p;
	p = textbeg+nextlen;
	nextlen = p[0];
	if(codep == 0 && tp->t_op != MAIN_OP && tp->t_op != SUBR_OP && progtype != BLOCK)
		codegen(maintree);
	if(!pass1) if(cflg)
		{
		printf("isn %d: %d ",isn,codep);
		treeprint(tp);
		}
	if(tp->t_op == LABEL_OP)
		{
		(s = tp->t_left)->s_addr = codep;
		s->s_flags =| F_ALLOC;		/* we have allocated it */
		tp = tp->t_right;
		XFER;
		if (sflg)
			deflab(s->s_name);
		}
	if(seqflg && isn != lastisn && tp->t_op != DATA_OP && tp->t_op != SUBR_OP)
		{
		if (sflg)
			defisn(isn);
		if (isn == lastisn+1)
			putglob("isn_");
		else
			{
			putglob("lisn_");
			putword(isn);
			}
		lastisn = isn;
		}
	codegen(tp);
	if(!pass1)
		newline();
	}
}

dummy()
{ }

codegen(tree) char *tree;
{
register char *n;
register char *s;
register char *t;
char globname[10];	/* global name */

t = tree;
if (t == NULL)
	return;
if (INSYM(t))
	{
	genmove(t,'s',0);		/* move to stack */
	return;
	}
if (t->t_op == SYM_OP)
	return(genmove(t->t_sym,'s',t->t_offset));
s = opnames[t->t_op];
n = globname;
clear(n,sizeof globname);
while (*s)
	*n++ = *s++;
if (*n = modenames[t->t_type])
	++n;
*n++ = '_';
switch(t->t_op)
	{
case BIF_OP:
	codegen(t->t_left);	/* if condition */
	s = t->t_right;		/* the if block */
	putglob("lif_l");
	puttext(s->i_else);
	break;
case ELSE_OP:
	XFER;
	putglob(GO_TO);
	s = t->t_left;		/* the if block */
	puttext(s->i_end);
	s->i_else = codep;
	break;
case ENDIF_OP:
	XFER;
	s=t->t_left;
	s->i_end = codep;
	if(s->i_else == 0)
		s->i_else = codep;
	break;
case ASS_OP:
	putglob("movi_is");	/* move immediate to stack */
	putsymt(t->t_left);	/* and the label */
	break;
case FORMAT_OP:
	s = genlab();
	putglob(GO_TO);
	putlab(s);
	fmtgen(t);	/* output the format */
	setlab(s);
	break;
case DATA_OP:
	if(pass1)
		break;		/* ignore til pass 2 */
	s = codep;		/* remember where we are */
	codelist(t->t_left,&datagen);	/* output the data */
	objseek(codep = s);
	break;
case END_OP:
case ERX_OP:
case IOSTAT_OP:
	putglob(globname);
	putsymt(t->t_left);
	break;
case FILE_OP:
case ACCESS_OP:
case BLANK_OP:
case RECL_OP:
case FORM_OP:
case NUM_OP:
case SEQ_OP:
case DIR_OP:
case NAMED_OP:
case FMTED_OP:
case NEXT_OP:
case EXIST_OP:
case UNFMTED_OP:
case OPND_OP:
	codeaddr(t->t_left);
	putglob(globname);
	break;
case FMTWT_OP:
case FMTRD_OP:
case OBJWT_OP:
case OBJRD_OP:
case RFMTWT_OP:
case RFMTRD_OP:
case ROBJWT_OP:
case ROBJRD_OP:
case UNFWT_OP:
case UNFRD_OP:
case RANRD_OP:
case RANWT_OP:
case FREEWT_OP:
case FREERD_OP:
case STRRD_OP:
case STRWT_OP:
case RFRERD_OP:
case SUNFRD_OP:
case SFRERD_OP:
case SOBJRD_OP:
case RFREWT_OP:
case SUNFWT_OP:
case SFREWT_OP:
case SOBJWT_OP:
	codegen(t->t_left);	/* put logical unit on stack */
	putglob(globname);
	iocode(t->t_op,t->t_right);		/* generate i/o coding */
	putglob("endio_");	/* end of i/o list */
	break;
case OPEN_OP:
case INQ_OP:
case INQF_OP:
	codegen(t->t_left);
	putglob(globname);
	codelist(t->t_right,&codegen);
	putglob("endio_");
	break;
case CGOTO_OP:
case AGOTO_OP:
	codegen(t->t_left);	/* get integer value */
	s = t->t_right;
	putglob(globname);
	putword(codelist(s,&dummy));	/* get count of entries */
	codelist(s,&putsymt);		/* output label list */
	break;
case TEQ_OP:
case TNE_OP:
case TLE_OP:
case TLT_OP:
case TGT_OP:
case TGE_OP:
	n[-2] = modenames[(t->t_left)->t_type];
case NOT_OP:
case NEG_OP:
	codegen(t->t_left);
	*n++ = 's';
	putglob(globname);
	break;
case SF_OP:
	sfgen(t);		/* generate satement function */
	break;
case MAIN_OP:		/* procedure entry */
	defglob(mainname);
	move(6,mainname,procname+1);	/* get name of main */
	putword(JSR_R4);	/* jsr r4,*$main_ */
	putglob(globname);
	break;
case SUBR_OP:
	move(6,t->t_left->s_name,procname+1);	/* remember proc name */
case SFENTRY_OP:		/* entry to sf */
	subrgen(t,globname);
	break;
case ENTRY_OP:
	putglob(GO_TO);
	s = genlab();
	putlab(s);
	subrgen(t,globname);
	setlab(s);
	break;
case DO_OP:
	s = t->t_left;		/* point to do info */
	s->d_addr1 = genlab();
	s->d_addr2 = genlab();
	codelist(t->t_right,&codegen);
	setlab(s->d_addr1);
	*n++ = modenames[intmode];	/* correct do rtn */
	putglob(globname);
	putsym(s->d_count,0);	/* the count symbol */
	putlab(s->d_addr2);	/* where to go to */
	break;
case DOEND_OP:
	s = t->t_left;		/* pick up do header */
	codegen(t->t_right);	/* do the increment */
	putglob(GO_TO);
	putlab(s->d_addr1);
	setlab(s->d_addr2);
	break;
case RC_OP:
	codegen(t->t_left);	/* the call */
	s = t->t_right;
	putglob(globname);
	putword(codelist(s,&dummy)<<1);	/* # of labels*2 */
	codelist(s,&putsymt);		/* label list */
	break;
case FN_OP:
case CALL_OP:
	s = codelist(t->t_right,&codeaddr);	/* generate arg list */
	if(t->t_left->s_loc == PARAM)
		putglob("calli_");
	else
		putglob("call_");
	putsymt(t->t_left);	/* output the routine name */
	putword(s);		/* output argument count */
	if(t->t_op==CALL_OP)
		break;
	move(3,"mov",globname);
	*n++ = 'r';
	*n++ = 's';		/* stack it for now */
	putglob(globname);
	break;
case RET_OP:	/* return from function */
case SRET_OP:	/* return from subroutine */
	if(t->t_left)		/* function value to r0 */
		genmove(t->t_left,'r',0);
	codegen(t->t_right);		/* return i */
	putglob(globname);
	break;
case BCK_OP:
case REW_OP:
case ENF_OP:
case REC_OP:
case CLOSE_OP:
	codegen(t->t_left);
	putglob(globname);
	codelist(t->t_right,&codegen);
	break;
case STO_OP:
	codegen(t->t_left);	/* output the result field */
	codegen(t->t_right);	/* output cats */
	putglob("cats_ss");	/* and the final cat */
	putglob(globname);
	break;
case SUBSTR_OP:
	codegen(t->t_left);
	codegen(t->t_right);
	putglob(globname);
	break;
case STR_OP:
	codegen(t->t_left);
	if (t->t_right)
		codegen(t->t_right);
	else
		{
		putglob("movi_is");
		s = strlen(t);
#ifdef	debug
		if (s == 0)
			error("bad length");
#endif
		putword(s);
		}
	break;
case ERR_OP:		/* hit a source error */
case STOP_OP:
case PAUSE_OP:
case SSTOP_OP:
case SPAUSE_OP:
	putglob(globname);
	if(s = t->t_left)
		{
		putsymt(s);
		putword(s->s_slen);		/* output length */
		}
	break;
case AIF_OP:
	codegen(t->t_left);
	putglob(globname);
	while (t=t->t_right)
		putsymt(t->t_left);
	break;
case AGO_OP:
	codegen(t->t_left);
	putglob(globname);
	break;
case GOTO_OP:
	putglob(globname);
	putsymt(t->t_left);
	break;
case LIF_OP:
case RIF_OP:
	codegen(t->t_left);
	*n = modenames[(t->t_left)->t_type];
	if(t->t_right->t_op == GOTO_OP)
		{
		globname[0] = (t->t_op == LIF_OP) ? 'r' : 'l';	/* flip it */
		putglob(globname);
		putsymt(t->t_right->t_left);	/* output the label */
		}
	else
		{
		putglob(globname);
		s = genlab();
		putlab(s);
		codegen(t->t_right);
		setlab(s);
		}
	break;
case CVT_OP:
	codegen(t->t_left);
	*n = n[-2];
	*--n = modenames[(t->t_left)->t_type];
	*--n = '_';
	putglob(globname);
	break;
case SBV_OP:
case SBA_OP:
	s = t->t_left->t_sym;	/* get symbol */
	if (t->t_right)
		{
		codegen(t->t_right);
		putglob(s->s_loc == PARAM ? "addi_ms" : "addi_is");
		}
	else
		putglob(s->s_loc == PARAM ? "movi_ms" : "movi_is");
	putsym(s,t->t_left->t_offset);	/* output with offset */
	if(t->t_op == SBA_OP)
		break;		/* already got address */
	move(3,"mov",globname);
	*n++ = 'a';
	*n++ = 's';
	putglob(globname);
	break;
case EXP_OP:
	n[-2] = modenames[(t->t_left)->t_type];
	n[-1] = modenames[(t->t_right)->t_type];
	*n++ = '_';
	goto join;		/* can't avoid em sometimes */
case GT_OP:
case GE_OP:
case LT_OP:
case LE_OP:
case EQ_OP:
case NE_OP:
	n[-2] = modenames[(t->t_left)->t_type];
case ADD_OP:
case SUB_OP:
case MUL_OP:
case DIV_OP:
case AND_OP:
case OR_OP:
case EQV_OP:
case XOR_OP:
case CHK_OP:
join:
	codegen(t->t_left);
	codegen(t->t_right);
	*n++ = 's';
	*n++ = 's';
	putglob(globname);
	break;
case CAT_OP:
	codegen(t->t_left);
	putglob("cats_ss");
	codegen(t->t_right);
	break;
case STORE_OP:
	move(3,"mov",globname);
	*n++ = argloc(t->t_left);
	*n = argloc(t->t_right);
	if(*n == 's')
		*n = 'a';	/* indirect thru stack */
	putglob(globname);
	if(n[-1] != 's')
		putsymt(t->t_left);
	if(n[0] != 'a')
		putsymt(t->t_right);
	break;
default:
	if(!pass1)
		NOTE1("op %s not generated",E_NOTGEN,opnames[t->t_op]);
	}
}

argloc(tree) char *tree;
{
register char *t;

t = tree;
if (!INSYM(t))
	{
	if (t->t_op == SYM_OP)
		t = t->t_left;
	else
		{
		codegen(t);	/* evaluate it */
		return('s');	/* now on stack */
		}
	}
if (t->s_loc == PARAM)
	return('p');
return('m');		/* in memory */
}

putsym(sp,off) char *sp;
{
/*
 * output reference to symbol table "sp" to object code.
 */
register char *s;
char globname[8];

s = sp;
if(!INSYM(s))
	ERROR1("not in symtab %o",E_NINSYM,s);
s->s_flags =| F_USED;		/* remember it was used */
switch(s->s_loc)
	{
case COMMON:
	refglob(s->s_next->s_name,s->s_addr+off);
	break;
case EXTERN:
	refglob(s->s_name,0);
	break;
case CONST:
case TEXT:
	puttext(s->s_addr+off);		/* text rel word */
	break;
default:
	if(s->s_type == LABEL)
		{
		if (s->s_addr == 0)
			putword(0);		/* undefined label */
		else
			puttext(s->s_addr+off);		/* text rel word */
		}
	else if (s->s_flags & F_DATA)
		putdata(s->s_addr+off);		/* data rel word */
	else
		putbss(s->s_addr+off);
	}
}

newline()
{
if(pass1)
	return;
if (cflg) printf("\n");
}

codelist(tree,fn) char *tree; int (*fn)();
{
/*
 * output a list of expressions. results appear on the stack.
 */
register char *t;
register int n;

n = 0;
for (t=tree; t; t=t->t_right)
	{
	(*fn)(t->t_left,0);			/* do it */
	++n;
	}
return(n);
}

codeaddr(tree) char *tree;
{
/*
 * output an address for the tree requested.
 */
register char *t;
register char *s;
char globnam[8];

t = tree;
if (INSYM(t))
	{
	s = t;
gotsym:
	copy(globnam,"movi_?s");
	if (s->s_loc == PARAM)
		globnam[5] = 'm';
	else
		globnam[5] = 'i';
	putglob(globnam);
	putsymt(t);		/* output the name */
	return;
	}
else if (t->t_op == SYM_OP)
	{
	s = t->t_sym;
	goto gotsym;
	}
s = t->t_left;
switch(t->t_op)
	{
case STORE_OP:
	codegen(t);	/* generate code for it */
	codeaddr(t->t_right);	/* generate address of temp var */
	break;
case SBA_OP:
case STR_OP:
	codegen(t);	/* generate subscript address */
	break;
case STO_OP:
	codegen(t);	/* generate code */
	codegen(t->t_left->t_left);	/* addr of temp var */
	break;
default:
	ERROR1("bad argument %d",E_BADARG,t->t_op);
	}
}

putsymt(tree) char *tree;
{
register char *t;

t = tree;
if (INSYM(t))
	putsym(t,0);		/* output the symbol */
else if (t->t_op == SYM_OP)
	putsym(t->t_sym,t->t_offset);
else
	ERROR1("not in symtab %o",E_NINSYM,t);
}

genmove(tree,w1,w2) char *tree;
{
/*
 * move "t" to "w".
 * "w1" may be "s" for stack or "r" for registers.
 * "w2" is used to specify an offset for SYM_OP's
 */
char globname[8];
register char *p;
register char *t;
register int l1;

t = tree;
copy(globname,"mov");
p = globname+3;
*p++ = modenames[t->t_type];
*p++ = '_';
*p++ = l1 = argloc(t);
*p++ = w1;
*p++ = 0;
putglob(globname);
if (l1 != 's')
	putsym(t,w2);
}

genio(tree) char *tree;
{
register char *t;
register char *n;
char globname[8];

t = tree;
if (t == NULL)
	return;
n = globname;
*n++ = 't';
*n++ = 'r';
if (INSYM(t) || t->t_op == SYM_OP)
	codeaddr(t);
else
	{
	switch(t->t_op)
		{
	case DO_OP:
	case DOEND_OP:
	case END_OP:
	case ERX_OP:
	case REC_OP:
	case IOSTAT_OP:
		codegen(t);
		return;
	case COMMA_OP:
		genio(t->t_left);
		genio(t->t_right);
		return;
	case VEC_OP:
		codeaddr(t->t_left);	/* get address */
		codegen(t->t_right);	/* count */
		*n++ = 'v';		/* transfer vector */
		break;
	default:
		*n++ = 'x';		/* expression */
	case SBA_OP:
		codegen(t);
		}
	}
*n++ = '_';
*n++ = modenames[t->t_type];
*n++ = 0;
putglob(globname);
}

datagen(tree) char *tree;
{
register char *s;
register char *a;

s = tree->t_left;
a = s->t_sym->s_addr + s->t_offset;
if (codep != a)
	objseek(codep = a);
objconst(tree->t_right,YES);
}

fmtgen(tree) char *tree;
{
register char *s;
register char *t;

t = tree;
s = t+NODESIZE;
putobj(s,t->t_right->s_int);	/* output the format */
}

iocode(op,tree) char *tree;
{
register char *t;
register char *s;

t = tree;
s = t->t_left;
switch(op & (IO_FMT|IO_FREE|IO_OBJECT|IO_BINARY))
	{
case IO_FMT:
	putsym(s,(seqflg ? 8 : 4));	/* output actual format address */
	t = t->t_right;
	break;
case IO_OBJECT:
	putsym(s,0);	/* output actual format address */
	t = t->t_right;
	break;
default:		/* those not involving formats */
	break;
	}
codelist(t,&genio);
}

subrgen(sp,globname) char *sp, *globname;
{
register char *t, *s;

t = sp;
if (t->t_op != SFENTRY_OP)
	defglob(t->t_left->s_name);
putword(JSR_R4);	/* jsr r4,*$enter_ */
putglob(globname);
putobj(t->t_left->s_name,6);	/* output the name */
putword(0);			/* insure 0 termination */
if(t->t_op == SUBR_OP)
	{
	putword(parcnt);	/* count of parameters expected */
	putbss(argaddr);	/* where arguments should go */
	}
else
	{
	s = t->t_right;		/* the actual arguments */
	putword(codelist(s,&dummy));
	codelist(s,&putsymt);	/* output the addresses of params */
	}
if (prflg && t->t_op != SFENTRY_OP)
	{
	putglob("mcount_");
	putbss(mcount);
	mcount =+ 2;		/* update the pointer */
	}
}

sfgen(tree) char *tree;
{
/*
 * generate code for statement function.
 */
register char *s;
register char *t;
register char *p;

t = tree;
s = genlab();
putglob("goto_");	/* branch around the code */
putlab(s);
p = t->t_left;
p->t_left->s_addr = codep;	/* set address */
codegen(p);	/* entry sequence */
codegen(t->t_right);	/* actual code */
p = "mov?_sr";
p[3] = modenames[t->t_right->t_type];
putglob(p);
putglob("ret_");	/* return from sf */
setlab(s);
}
