#include "param.h"
#include "ftn.h"
/*			Copyright 1979 by Bill Webb.	 		*/
/*			Copyright 1977 by Bill Webb.	 		*/
#include "sym.h"
#include "gen.h"

#define	PTRSIZE	2	/* size of a pointer */
char modename[];

allocdata()
{
/*
 * allocate all data initialized variables in "data" space.
 */
register char *s;

bssflag = NO;
for (SCANSYM(s))
	{
	if((s->s_flags & F_ALLOC) || (s->s_flags & F_DATA) == 0)
		continue;
#ifdef	debug
	if (s->s_class!=SYMBOL || s->s_loc!=LOCAL)
		error("bad data-allocated symbol");
#endif
	if (s->s_equiv)
		allocequiv(s,F_DATA);	/* insure all marked */
	else
		allocvar(s,varsize(s));
	}
}

allocbss()
{
/*
 * allocate variables that are not data-initialized and parameters.
 * remember where the first parameter was allocated.
 */
register char *s;

bssflag++;
if (prflg)
	{
	s = codep;
	codep =+ mcount;
	mcount = s;
	}
for (SCANSYM(s))
	{
	if ((s->s_flags & F_ALLOC) || s->s_class!=SYMBOL)
		continue;
	if(s->s_loc == PARAM)
		{
		if(argaddr == 0)
			argaddr = codep;	/* remember where args are */
		s->s_addr = 0;		/* start at 0 */
		allocvar(s,PTRSIZE);		/* allocate space for pointer */
		continue;
		}
	else if (s->s_loc==LOCAL)
		{
		if (s->s_equiv)
			allocequiv(s,0);	/* allocate chain */
		else
			allocvar(s,varsize(s));
		}
	}
}

allocconsts()
{
register char *s;
register int l;

for (SCANSYM(s))
	{
	if (s->s_class == CONST && (s->s_flags&F_USED))
		{
		s->s_flags =| F_ALLOC;		/* remember allocated */
		if(!pass1 && cflg)
			{
			prconst(s);
			printf(" #+%d: ",codep);
			}
		s->s_addr = codep;
		objconst(s,NO);		/* output the constant */
		newline();
		}
	}
}

objconst(sp,dataflag) char *sp;
{
/*
 * output constant to object file.
 */
register char *s;
register int l;

s = sp;
switch(s->s_type)
	{
case CHARACTER:
	l = s->s_slen;
	if (dataflag)
		dataobj(s->s_string,l);
	else
		putobj(s->s_string,l);
	break;
case CMPLX8:
case CMPLX16:
	objconst(s->s_real,dataflag);
	objconst(s->s_imaginary,dataflag);
	break;
default:
	l = typelens[s->s_type];
	if (dataflag)
		dataobj(&s->s_int,l);
	else
		putobj(&s->s_int,l);		/* output the data */
	}
}

alloccm(flag)
{
/*
 * allocate common blocks and create link to common header.
 */
register char *s;
register char *p;
register char *a;
char name[8];

a = codep;
bssflag = flag;
for (SCANSYM(s))
	{
	if(s->s_class == COMMON)
		{
		for (p=s->c_chain; p->s_class!=COMMON; p=p->s_common)
			s->s_flags =| (p->s_flags&F_DATA);	/* test if data */
		flag = (s->s_flags&F_DATA) == 0;
		if (flag != bssflag)
			continue;
		cmsize = cmsize + s->c_size;		/* accumulate it */
		if(progtype == BLOCK)
			{
			if (bssflag)
				bssglob(s->s_name);
			else
				dataglob(s->s_name);
#ifdef	FDB
			if (sflg)
				{
				name[0] = '!';
				move(6,s->s_name,name+1);
				name[7] = 0;
				objenter(name,1,s->c_size);
				}
#endif	/* FDB */
			}
		else
			defcommon(s->s_name,s->c_size);		/* define it */
		for (p=s->c_chain; p->s_class!=COMMON; p=p->s_common)
			{
			p->s_next = s;		/* remember block */
			p->s_flags =| F_ALLOC;
			if (progtype == BLOCK)
				{
				p->s_addr =+ a;
				if (sflg)
					objvar(p);
				}
			}
		if(progtype == BLOCK)
			{
			a =+ s->c_size;
			codep = a;
			}
		}
	}
}

allocequiv(eq,flag) char *eq;
{
/*
 * allocate all the variables on the equivalence chain "eq".
 * or "flag" into the flag bits of each variable. (used for
 * data allocated variables).
 */
register char *p;
register int l;
register int lmax;

lmax = 0;
for (p=findequiv(eq)->e_start; p && p->s_class!=EQUIV; p=p->s_equiv)
	{
	l = p->s_addr + varsize(p);
	if(l>lmax)
		lmax = l;
	p->s_flags =| flag;		/* or in the data flag */
	allocvar(p,0);
	}
#ifdef	debug
if(p == 0)
	error("'.%6s' bad equiv chain",eq->s_name);
#endif
if (lmax&1)
	++lmax;		/* insure even length */
codep =+ lmax;
}

allocvar(sp,n) char *sp;
{
/*
 * actually allocate the variable "sp". it takes "n" bytes
 * of memory.
 * if symbol is an alternate entry name then associated it with the
 * primary name.
 */
register char *s;

if (n&1)
	n++;			/* always allocate on even bdy */
s = sp;
#ifdef	debug
if (s->s_flags & F_ALLOC)
	error("%.6s already allocated",s->s_name);
#endif
s->s_flags =| F_ALLOC;
if((s->s_flags & F_ENTRY) && s != fn_sym)
	s->s_addr = fn_sym->s_addr;
else
	{
	s->s_addr =+ codep;
	codep =+ n;
	}
if(sflg)
	objvar(s);		/* output to symbol table */
}

objvar(sp) char *sp;
{
#ifdef	FDB
register char *s;
register int i;
char name[8];

s = sp;
name[0] = '^';
name[7] = 0;
move(6,s->s_name,name+1);
defvar(s->s_name,s->s_addr);
i = (s->s_nsubs<<8)+modenames[s->s_type];
if (s->s_loc == PARAM)
	i =| 0100000;		/* mark as parameter */
objenter(name,1,i);
if (s->s_type == STRING)
	{
	name[0] = '"';
	objenter(name,1,s->s_size);
	}
for (i=0; i<s->s_nsubs; ++i)
	{
	name[0] = i+'1';	/* subscript number */
	objsc(s,s->s_subs[i].lwb,'l',name);
	objsc(s,s->s_subs[i].upb,'u',name);
	}
#endif		/* FDB */
}

#ifdef	FDB
objsc(s,p,ch,name) char *s, *p, *name;
{
register int n;
/*
 * output a subscript "p" for variable "s".
 * if subscript is a constant put it out with its value as the
 * constant.
 * if subscript is a variable, then put it out with a value of zero
 * and the name as the name of the variable that is the subscript.
 * the first character is the subscript number (1, 2, etc.)
 * the second character is 'u' for upper bound and 'l' for lower bound.
 */

name[1] = ch;
if (constant(p))
	{
	move(6,s->s_name,name+2);
	n = intvalue(p);
	}
else
	{
	move(6,p->s_name,name+2);
	n = 0;
	}
if (n != 1)
	objenter(name,1,n);
}
#endif	/* FDB */
