#
#include "user.h"
#include "svt.h"
/*			Copyright 1976 by Bill Webb.	 		*/
#include "file.h"

#define	BIT0	01
#define	BIT1	02
#define	BIT2	04
#define	BIT3	010
#define	BIT4	020
#define	BIT5	040

#define	BIT14	040000
#define	BIT15	0100000

#define b_max 256
#define t_comd 01
#define t_cil 03

char *loadpoint, *loadtra;
int loadsize;
struct comd
{
char *c_addr;
char c_type;
char c_words;
char *c_loadpt;
int c_size;
char *c_tra;
char *c_odt;
int c_ci;
int c_pgn[2];
int c_ident[2];
int c_tod[2];
int c_date;
char c_emt;
char c_ewds;
};


struct absloader
{
char *addr;
int data;
};

int cil;	/* is 0 unless from cil */ 
struct buffhdr b;

load()
{
loadpgm(BIT14);
svt.s_pla = loadpoint;
svt.s_psa = loadtra;
if (svt.s_psa&1)
	err("no transfer address");
svt.s_stk = loadpoint;
--svt.s_stk;			/* allow for 1 extra word */ 
}

loadpgm(code)
{

struct {
	char b_data[b_max];
	} buff;

trace("\"loading from:	%s\n"\",loadfile);

clear(&info,DDBLEN);
ddb = &ddbs[maxddb-1];
clear(ddb,DDBLEN);

info.d_fildes = getload();

b.b_mode = m_dump | m_fb;
b.b_maxcnt = b_max;
b.b_cnt = 0;
b.b_status = 0;
info.d_buffp = b.b_buffp = &buff;
bh = &b;

ddb->d_maxlen = maxpath;

ldread();
if(cil = (buff.c_type == t_cil))
	{
#ifndef	small
	if(tflg)
		printf("loading from a cil\n");
#endif
	ldread();
	}

if(buff.c_type!=t_comd)
	err("no comd (type=%o)",buff.c_type);

if((code & BIT3) == 0)
	loadpoint = buff.c_loadpt;
loadtra = buff.c_tra;
#ifndef	small
if (tflg)
	{
	printf("load point:	%o\n",loadpoint);
	printf("start address:	%o\n",loadtra);
	}
#endif

if(code&BIT14)
	{
	svt.s_pgn[0] = buff.c_pgn[0];
	svt.s_pgn[1] = buff.c_pgn[1];
	svt.s_odt = buff.c_odt;
	}

loadsize = buff.c_size;
setcsa(loadpoint + buff.c_size);
if(tflg)
	printf("prog size:	%o\n",loadsize);
if(svt.s_tob + 100 > loadpoint)
	err("load address (%o) < end of fakedos (0%o)",loadpoint,svt.s_tob);

if(code&BIT1)
	if((code&BIT2) == 0 || svt.s_stk > loadpoint-2)
		movestack();		/* must do before loading */

if(cil)
	{
	seek(info.d_fildes,buff.c_ci,3);
	if(read(info.d_fildes,loadpoint,loadsize) == -1)
		uerr("while loading");
	}

else
	{
	for (;;)
		{
		ldread();
		if((b.b_cnt=- 2) == 0)
			{
			loadtra = buff.addr;
			break;
			}
#ifdef	debug
		if(tflg>1)
		printf("loading %o bytes at %o\n",b.b_cnt,buff.addr);
#endif
		if(buff.addr < loadpoint)
			err("address too low (%o)",buff.addr);
		move(b.b_cnt,&buff.data,buff.addr);
		}
	}


close(info.d_fildes);
clear(ddb,DDBLEN);
if(code&BIT14)
	{
	closeall();
	clear(&ddbs,sizeof ddbs);
	}
}

move(length,from,to)
int length;
char *from, *to;
{
register int l;
register char *f,*t;
 l = length;
 f = from;
 t = to;
do 
	*t++ = *f++;
while (--l);
}

setcsa(a)
int a;
{
/*
 * increase the maximum core address to "a" (to next largest 4k boundary).
 */
register char *i;

i = ( (a-2) & ~01) | 017776;
if(svt.s_csa > i)
	return;
svt.s_csa = i;
trace("\"break addr:	%o\n"\",svt.s_csa);
if(brk(svt.s_csa)== -1)
	err("%o core required",svt.s_csa);
}

getload()
{
/*
 * get a file descriptor for the load file. try "file" then 
 * "file.lda" then "/dos/file.lda". 
 */
register int i;


if((i=open(loadfile,0))>=0)
	return(i);
#ifndef	small
copy(info.d_path,"/mnt/dos/");
append(info.d_path,loadfile);

if(!eq(endstr(loadfile)-4,".lda"))
	{
	append(info.d_path,".lda");
	if((i=open(&info.d_path[9],0))>=0)
		{
		copy(loadfile,&info.d_path[9]);
		return(i);
		}
	}
if(loadfile[0]!='/')
	{
	if((i=open(&info.d_path[4],0))>=0)
		{
		copy(loadfile,&info.d_path[4]);
		return(i);
		}
	if((i=open(info.d_path,0))>=0)
		{
		copy(loadfile,info.d_path);
		return(i);
		}
	}
#endif
uerr("file '%s'",loadfile);

}

ldread()
{

fbread();
if(b.b_status)
	err("unexpected eof");
}

#ifndef	small
runemt()
{
register int runcode;
register int *runpars;
register temp;

runpars = *u.sp++;
trace("\" pars %o"\",runpars);
runcode = *runpars++;
trace("\" code %o"\",runcode);
if(runcode & BIT15)
	{
	runcode = 0;
	rad50(*runpars++,loadfile);
	rad50(*runpars++,loadfile+3);
	}
else
	{
	temp = *runpars++;
	*--u.sp = *runpars++;
	dosinit();
	*--u.sp = temp;
	getfile();
	copy(loadfile,info.d_path);
	clear(ddb,DDBLEN);
	lb->l_ddb = 0;
	}
trace("\" file: %s\"",loadfile);
if(runcode & BIT3)
	loadpoint = *runpars++;
temp = runcode & BIT4 ? *runpars++ : 0;
trace("\"offset %o\"",temp);
if(runcode & BIT5)
	u.pc = *runpars++;
if(tflg)
	putchar('\n');
loadpgm(runcode);
loadtra =+ temp;
if(runcode & BIT0)
	{
	if ( (runcode & BIT5) == 0)
		u.pc = loadtra;
	}
else
	{
	*--u.sp = loadpoint;
	*--u.sp = loadsize;
	*--u.sp = loadtra;
	}
}

movestack()
{
/*
 * move the stack so that the new base is the program load
 * point. 
 */
register int i,j;
register int newsp;

i = svt.s_stk;
j = loadpoint-2;
i =- j;
newsp = u.sp;
newsp =- i;
i = newsp-j;
#ifdef	debug
	if(tflg)
		printf("moving sp from %o to %o (%d bytes)",u.sp,newsp,i);
#endif
smartmove(i,u.sp,newsp);
svt.s_stk = j;
u.sp = newsp;
}

smartmove(len,from,to) char *from, *to;
{
register int l;
register char *f, *t;

if( (l = len) == 0)
	return;
f = from; t = to;
if(f > t)
	{
	do
		*t++ = *f++;
	while (--l);
	}
else
	{
	f =+ l;
	t =+ l;
	do
		*--t = *--f;
	while (--l);
	}
}
#endif

#ifdef small
runemt()
{
err("not implemented");
}

movestack()
{ }
#endif
