#
/*			Copyright 1976 by Bill Webb.	 		*/

#include "user.h"
#include "file.h"
#include "svt.h"


struct tran
{
int t_block;	/* block address */
char *t_buff;	/* buffer pointer */
int t_cnt;	/* number of words to transfer */
char t_fn;	/* function code */
char t_status;	/* status returned */
int t_rem;	/* words not transfered */ 
};

#define bl_get 01
#define bl_output 02
#define bl_input 04

struct block
{
char bl_fn;
char bl_status;
int bl_block;	/* block number */
int *bl_buff;
int bl_length;
};

/*
 * dos block i/o ... only complication is that a buffer will 
 * have to be allocated above tob. currently it is never 
 * de-allocated. 
 */

#ifndef	small
dosblk()
{
register struct block *b;
register int *p;

b = *u.sp++;

if (ddb->d_state!=opened)
	err("not opened");
if (ddb->d_buff == 0)
	ddb->d_buff = getbuff();
p = b->bl_buff = ddb->d_buff;
b->bl_length = 256;
b->bl_status = 0;

#ifdef	debug
if(tflg)
	printf(" fn %o (#0%o,0%o,#0%o)",
		b->bl_fn,b->bl_block,p,b->bl_length);
#endif
switch(b->bl_fn)
{
case bl_get:
	break;	/* all done by now anyway */

case bl_output:
	seek(info.d_fildes,b->bl_block,3);
	if(write(info.d_fildes,p,512)<0)
		uerr("output");
	break;

case bl_input:
	seek(info.d_fildes,b->bl_block,3);
	if(read(info.d_fildes,p,512)<0)
		uerr("input");
	break;

default:
	err("bad function code (%o)",b->bl_fn);
}
}

int *freelist;

getbuff()
{

register int* ptr;

if( (ptr = freelist) )
	{
	freelist = *ptr;
	}
else
	{
	ptr = svt.s_tob;
	svt.s_tob =+ 512;
	}
return(ptr);
}


freebuff(p)
int *p;
{
register int *ptr;
if( (ptr = p) == 0)
	return;

if(ptr == svt.s_tob-512)
	svt.s_tob =- 512;
else
	{
	*ptr = freelist;
	freelist = ptr;
	}
}
#endif

/*
 * .tran routine ... since i/o is to actual disk image
 * (thinks dos) the actual tran address has "startblk"
 * added in so that we can take it off again. 
 */

dostran()
{
register struct tran *t;
register int b;
register int l;

t = *u.sp++;

b = t->t_block;

if(ddb->d_state==closed)
	{
	clear(&info,sizeof info);
	copylink();		/* copy link block info */
	if(ddb->d_name[0]!=0)	/* we have a file name to try */
		move(4<<1,ddb->d_name,info.d_name);
	if(b==cilblk)
		copy(info.d_path,"/dos/monlib.cil");
	else
		cvtfile(1);		/* convert to path name */
	doopen(f_opent);	/* open for traning */ 
	}

if(ddb->d_howopen!=f_opent)
	err("file open for normal i/o (%o)",ddb->d_howopen);

b =& (startblk-1);
l = t->t_cnt;
t->t_status = 0;

#ifdef	debug
if(tflg)
	printf(" fn %o (#0%o,#0%o,0%o)",
		t->t_fn,b,l,t->t_buff);
#endif

l=<< 1;		/* length in bytes needed */

if(t->t_buff + l > svt.s_csa)
	setcsa(t->t_buff+l);

	seek(info.d_fildes,b,3);
switch(t->t_fn)
{
case 2:	/* write */
	if(write(info.d_fildes,t->t_buff,l)!=l)
		uerr("write");
	break;

case 4:	/* read */ 
	if(read(info.d_fildes,t->t_buff,l)<0)
		uerr("read");
	break;

default:
	err("bad fn (%o)",t->t_fn);
}
}

struct recrd
{
char r_fn;
char r_status;
char *r_buffp;
int r_length;
int r_recno[2];
};

/* 
 * recrd input output ... maps easily into unix i/o 
 * the top word of the record index is ignored on the
 * suspition that dos does too. 
 */ 

#ifndef	small
dosrecrd()
{
register struct recrd *r;
register int addr;

r = *u.sp++;
if(ddb->d_state!=opened)
	err("file not open");

addr = r->r_recno*r->r_length;
seek(info.d_fildes,addr,0);
r->r_status = 0;
switch(r->r_fn)
{

case 2:	/* write */ 
	if(write(info.d_fildes,r->r_buffp,r->r_length)<0)
		uerr("recrd write");
	break;


case 4:	/* read */ 
	if(read(info.d_fildes,r->r_buffp,r->r_length)<0)
		uerr("recrd read");
	break;

default:
	err("bad recrd function (%o)",r->r_fn);
}
}
#endif


/*
 * copy device and dataset information from current ddb 
 * into "info". 
 */

copylink()
{
register struct ddb *d;

d = ddb;

info.d_device = d->d_device;
info.d_unit = d->d_unit;
info.d_dsn = d->d_dsn;
}


/*
 * .stat routine - just return information already collected
 * and stored in the ddb.
 */

dosstat()
{
register struct ddb *d;

d = ddb;

*--u.sp = d->d_bsize;
*--u.sp = d->d_device;
*--u.sp = d->d_fac;

#ifdef	debug
if(tflg)
	{
	rad50(d->d_device,info.d_path);
	printf(" ==> 0%o,%.3s,0%o",d->d_bsize,info.d_path,d->d_fac);
	}
#endif

}

#ifdef	small
dosrecrd()
{ err("no .recrd"); }

dosblk()
{ err("no .blk"); }
#endif
