#include "user.h"
#include "file.h"
/*			Copyright 1976 by Bill Webb.	 		*/


int status;
#define	pop	05726			/* tst (sp)+ */
#define	def_tty	0		/* default tty name */

/*	device	rad50 code */
#define	r_tmp	077430
#define	r_dd	014640
#define	r_dc	014570
#define	r_bi	06750
#define	r_si	074050
#define r_df	014760
#define r_dk	015270
#define r_dt	016040
#define r_kb	042420
#define r_opr	060122
#define	r_lpr	046622
#define r_lp	046600
#define r_mt	052140 
#define r_pp	063200
#define r_pr	063320
#define r_pt	063440
#define r_cr	012620
#define r_sy	075250
#define r_so	074430
#define	r_xy	0114750


/*
 *  wait for i/o to complete ... dummy as i/o is always completed
 *  before the user gains control.
 */
doswait()
{
u.pc[-1] = pop;		/* tst (sp)+ */
}

dosrwait()
{
/* .waitr will always show i/o as complete */ 
++u.sp;		/* pop off return address */
}




/*
 * release a link block ... free the relevent ddb entry and 
 * return to user.
 */
dosrelse()
{

if(ddb->d_state!=closed)
	dosclose();
clear(ddb,sizeof ddb[0]);
ddb->d_state=free;
lb->l_ddb=0;
}



/*
 * close a dos file. the ddb entry is not released until a 
 * .rlse is done. 
 */
dosclose()
{
register struct ddb *d;
register int i;


d = ddb;
if(d->d_state==opened)
	if(close(d->d_fildes)<0)
		uerr(" closing %s",d->d_path);
#ifndef	small
if(d->d_ps)
	{
	while ((i=wait(&status)) > 0 && i!=d->d_ps) ;
	d->d_ps = 0;
	}
freebuff(d->d_buff);
#endif
clear(d->d_name,4<<1);
d->d_state=closed;
}

/*
 * getddb is called from "run" for all i/o emts except .init and
 * sets up variable "ddb" and part of "info" from the proper
 * ddb entry. 
 */
getddb()
{

#ifdef	debug
if(tflg)
	printf(" #%6.6o",*u.sp);
#endif

lb = *u.sp++ - l_offset;
ddb = lb->l_ddb;
if (ddb < &ddbs[0] || ddb > &ddbs[maxddb])
	err("bad link block %o",lb);

if(ddb->d_state!=closed)
	info.d_fildes = ddb->d_fildes;
fb = 0;		/* make sure no file block present */
}

/*
 * process the .init emt. no actual unix i/o is done now. 
 * the information needed later is copied into an allocated 
 * ddb entry. 
 */
dosinit()
{
register struct linkblk *l;
register struct ddb *d;

#ifdef	debug
char n_device[3];
char n_dsn[3];
#endif

l = lb = *u.sp++ -l_offset;

#ifdef	debug
if(tflg)
	{
	rad50(l->l_device,n_device);
	rad50(l->l_dsn,n_dsn);
	printf(" #%6.6o (%3.3s%o:,%3.3s)",l,n_device,l->l_unit,n_dsn);
	}
#endif

d = l->l_ddb;
if (d!=0)
	{
	if (d >= &ddbs[0] && d < &ddbs[maxddb] && 
		d->d_state!=opened)
		goto gotddb;

	}

for (d= &ddbs[0]; d< &ddbs[maxddb]; ++d)
	{
	if(d->d_state==free)
		{
		gotddb:
		ddb = d;	/* tell everyone which ddb */
		d->d_dsn = l->l_dsn;
		d->d_unit = l->l_unit;
		d->d_device = l->l_device;
		d->d_state = closed;
		l->l_ddb = d;
		move(sizeof info,d,&info);
		cvtfile(0);
		d->d_bsize = info.d_bsize;
		d->d_fac = info.d_fac;
		copy(d->d_path,info.d_path);
		return;
		}
	}
err("out of ddbs");
}

dosopen()
{
register struct ddb *d;

d = ddb;
if(d->d_state!=closed)
	err("already open");

getfile();
doopen();
}

doopen()
{
register struct ddb *d;

d = ddb;
#ifdef	debug
if(tflg)
	printf(" open 0%o %s",info.d_howopen,info.d_path);
#endif

d->d_maxlen = maxpath;		/* the default buffering amount */

if(info.d_path[0]=='-')
	{
#ifdef	debug
	if(tflg)
		printf(" dup(%d)",d->d_fildes);
#endif
	if((info.d_fildes = dup(d->d_fildes))<0)
		uerr("dup failed");

	if(d->d_fildes == 0)
		d->d_maxlen = 1;	/* only buffer 1 char at a time */
#ifdef	batch
	if(xflg && d->d_device == r_lp)
		putchar(014);
#endif
	}

#ifndef	small
else
	if(info.d_path[0]=='+')
		info.d_fildes = openpipe();	/* off line print */
#endif

else
	switch(info.d_howopen)
{
case	f_opent:
	if((info.d_fildes = open(info.d_path,2)) < 0)
		if((info.d_fildes = open(info.d_path,0)) < 0)
			uerr("tran open of %s",info.d_path);
	break;

case	f_openi:

	if((info.d_fildes=open(info.d_path,0))>=0)
		break;	/* open is ok */
	openerr(2,"input file %s");
	return;

case	f_openo:
case	f_openc:

	if(( info.d_fildes=creat(info.d_path,0664))>=0)
		break;
	openerr(2,"output file %s");
	return;

case	f_opene:

	if( (info.d_fildes=open(info.d_path,1))<0)
		uerr("for extension %s",info.d_path);
	seek(info.d_fildes,0,2);		/* seek to end */
	break;

case	f_openu:

	if((info.d_fildes=open(info.d_path,2))>=0)
		break;
	openerr(2,"for update %s");
	return;

default:
	err("bad open code (0%o)",info.d_howopen);
}

	copy(d->d_path,info.d_path);
	d->d_fildes = info.d_fildes;
	d->d_state = opened;
	d->d_howopen = info.d_howopen;
#ifdef	debug
	if(tflg)
		printf(" ==> %d",info.d_fildes);
#endif
}



openerr(how,fmt)
int how;
char *fmt;
{
/* 
 * if a file block was provided and it has an error return address
 * then take that return with the error code set to "how". otherwise
 * print a unix error message via uerr. 
 */

if (fb && fb->f_return)
	{
	u.pc = fb->f_return;
	fb->f_status = how;
#ifdef	debug
	if(tflg)
		printf(" rtn to %o",u.pc);
#endif
	}
else
	uerr(fmt,info.d_path);
}

getfile()
/* get the file block and copy info into info block 
 * then call the cvtfile rtn to actually get a unix
 * path name from the info in info. 
 */
{
register struct fileblk *f;

#ifdef	debug
if(tflg)
	printf(" #%6.6o",*u.sp);
#endif
f = fb = *u.sp++ - f_offset;

info.d_name[0] = f->f_name[0];
info.d_name[1] = f->f_name[1];
info.d_name[2] = f->f_name[2];
info.d_uic = f->f_uic;
info.d_howopen = f->f_howopen;

copylink();

cvtfile(1);
}

cvtfile(flag)
int flag;
/* routine to convert dos file name to (we hope) a unix file
 * name that won't be too bad. 
 * files under [1,1] are in "/dos/*"
 * lp: is /dev/lp 
 * kb: is /dev/tty
 * cr: is /dev/cr
 * pr: is /dev/ppt
 * bi: is standard input
 * sy:
 * dk: are assumed to be under the current directory 
 */
{
register char *p;
register char *f;
register char c;

p = info.d_path;
info.d_bsize = 64;
if(f = chkasn(info.d_dsn))
	{
	copy(p,f);	/* got a path name */
	if(*p++ =='-')	/* use unix i/o unit */
		switch(c = *p++)
		{
		case 'i':
			ddb->d_fildes = 0;
			break;
		case 'o':
			ddb->d_fildes = 1;
			break;
		default:
			if(c>='0' && c<='9')
				ddb->d_fildes = c - '0';
			else
				err("bad - option");
		}
	return;
	}


f = "";		/* just in case */

switch(info.d_device)
	{
	case r_rdv:	/* run device */ 
		f=loadfile;
		info.d_bsize = 256;
		info.d_fac = 0112037;
		break;
	
#ifndef	small
	case r_bi:		/* batch input ==> si */
	case r_si:
		f="-i";
		info.d_fac = 0624;
		ddb->d_fildes = 0;
		break;
	
	case r_kb:
		f="/dev/tty8";
		f[8] = (c = ttyn(2)) == 'x' ? def_tty : c;
		info.d_fac = 0727;
		break;
	
	case r_dd:
		f="/dev/null";
		info.d_fac = 037;
		break;
	
	case r_pr:
		f="/dev/ppt";
		info.d_fac = 0234;
		break;
	
	case r_lp:
		if(!xflg)
			{
			f="/dev/lp";
			info.d_fac = 0323;
			break;
			}
	
	case r_so:
		f="-o";
		info.d_fac = 0323;
		ddb->d_fildes = 1;
		break;
	
	case r_opr:
		f="+/bin/opr";
		info.d_fac = 0323;
		break;
	
	case r_lpr:
		f = "+/bin/lpr";
		info.d_fac = 0323;
		break;
	
	case r_cr:
		f="/dev/cr";
		info.d_fac = 0264;
		break;
	
	case r_dt:
		info.d_bsize = 256;
		info.d_fac = 0140037;
		if(info.d_name[0])
			{
			f = "+@0";
			f[2] = info.d_unit + '0';
			goto cvt;
			}
		f="/dev/tap0";
		f[8] = info.d_unit + '0';
		break;
	
	
	case r_mt:
		f="/dev/rmt0";
		f[8] = info.d_unit + '0';
		info.d_bsize = 256;
		info.d_fac = 0120037;
		break;
	
	case	r_xy:
		f = "+/bin/xy";
		info.d_fac = 033;
		break;
	
#endif
	
#ifdef	small
	case r_lp:
		f = "/dev/lp";
		info.d_fac = 0323;
		break;
#endif
	
	case r_sy:
	case r_dk:
	case 0:				/* no name */
		info.d_fac = 0112037;
		info.d_bsize = 256;
		if(info.d_uic==sysuic)
			f="/dos/";
		if(info.d_name[2]==r_tmp)
#ifdef	batch
			if(xflg)
				f = "/dos/tmp/";
			else
#endif
				f = "/tmp/";
	cvt:
		while (*f) 
			*p++ = *f++;
		cvtname(info.d_name,p,flag);
		return;
	
	default:
		rad50(info.d_device,info.d_path);
		err("invalid device '%.3s'",info.d_path);
	}
while (*p++ = *f++);
}

#ifndef	small
openpipe()
{
/* 
 * open a pipe to read/write to the given routine 
 *
 */
int pipdes[2];	/* read/ write descriptors for the pipes */ 
register int i;
register char *p;
register char *q;
char file[32];

p = &info.d_path[1];
i = info.d_howopen == f_openi;		/* 1 for input */
if(pipe(pipdes)<0)
	uerr("no pipes");

if((ddb->d_ps=fork())==0)
	{	/* child process */
	close(i);	/* get another standard input/output */
	dup(pipdes[i]);	/* get new standard input/output */
	closeall();
	if(*p=='@')
		{	/* must go through dosdt */
		/*
		 * pathname is of form: 
		 * +@nname where "n" is unit number
		 */
		q = i ? "-ro0" : "-si0";
		++p;
		q[3] = *p++;
		execl("/usr/bin/dosdt","dosdt",q,p,0);
		err("no dosdt");
		}
	copy(file,"/usr/bin/");
	copy(file+9,p);
	execl(file+9,p,0);		/* file itself */
	execl(file+4,p,0);		/* /bin/file */
	execl(file,p,0);		/* /usr/bin/file */
	uerr("bad pipe to %s",p);
	exit(1);
	}

else
	{
	/* for input i==1; output i==0;
	 * we must return the read fildes for input and close
	 * the output one. 
	 */
	close(pipdes[i]);
	return(pipdes[1-i]);
	}
}
#endif



closeall()
{
register int i;

/*
 * close all but normal files 
 */

for (i=3; i<15; ++i)
	close(i);

}
