#
/*			Copyright 1976 by Bill Webb.	 		*/
#include "user.h"
#include "file.h"

#define	maxsws	100
#define oit (*p>='0' && *p<='7')
#define	alpha (*p>='A' && *p<='Z')
#define alphanum ((*p>='A' && *p<='Z') || (*p>='0' && *p<='9'))

#define r_sysdv 075250
#define r_star 052
#define cr 015
#define lf 012
#define vt 013
#define cntrl_c 03
#define ff 014


/* csi - command string interpreter */ 


struct
{
int *integer;
};

struct
{
char *ch;
};


struct csicmd
{
int c_code;	/* command code (0==input 2==output) */
char *c_inptr;	/* input device pointer */
char *c_outptr;	/* output device pointer */
int c_indev;	/* default input device */
int c_outdev;	/* default output device */
int c_inunit;	/* default input unit */
int c_outunit;	/* default output unit */
struct buffhdr c_buff;	/* buffer header */
};

struct csiblk
{
struct csicmd *c_csi;
struct linkblk *c_link;
struct fileblk *c_file;
};




struct 
{
char * ptr;	/* csi input pointer */ 
char *pptr;	/* put pointer */
char unit;		/* unit number */
char bf[6];		/* buffer for radpk cvt */
int r_device;
int r_file[2];
int r_ext;
int uic;
int flag;
int *swptr;
int swmax;
int swcnt;
int rc;
int dflt;
} csi;

doscsx()
{
register struct csicmd *c;
register char *p, *q;


c = *u.sp++;	/* get command block address */ 

clear(&csi,sizeof csi);
csi.ptr = &(c->c_buff.b_buffp);

c->c_outptr = p = q = csi.ptr;
c->c_inptr = 0;


while (*p!=lf && *p!=vt && *p!=ff && *p!=cr)
	{
	if(*p!=' ' && *p!='\0' && *p!=0377 && *p!='\t')
		{
		if( *p>='a' && *p<='z')
			*q++ = *p++ - ('a' - 'A');
		else
			*q++ = *p++;
		}
	else
		++p;
	}
*q++ = *p++;		/* copy delimeter */

#ifdef	debug
if(tflg)
	{
	*p++ = 0;
	printf(" ==>%.20s",csi.ptr);
	}
#endif


for (;;)
{

#ifdef	debug
	if(tflg>1)
		printf(" scan==>%.20s (%o)",csi.ptr,csi.ptr);
#endif

	csidev();
	csifile();
	csiuic();
	csisws();

	p = csi.ptr;
	switch(*csi.ptr++)
{

case vt:
case lf:
case cr:
case ff:

	--csi.ptr;	/* don't go past delimeter */
	*--u.sp = 0;	/* all ok */
	c->c_indev = r_sysdv;
	c->c_outdev = r_sysdv;
	
	c->c_inunit = 0;
	c->c_outunit = 0;
	return;

case cntrl_c:

	dosexit();

case '<':

	if(c->c_inptr)
		goto badsyn;
	c->c_inptr = csi.ptr;
	break;

case ',':

	break;

default:
badsyn:
#ifdef	debug
	if(tflg)
		printf("syntax ==>%.6s",p);
#endif
	*--u.sp = p;	/* where the error happened */
	return;
}	/* of switch */
}	/* of for */ 

}

put(c)
{

/* 
 * put a charaacter into the output temorary buffer
 */ 

if(csi.pptr < &csi.bf[6])
	*csi.pptr++ = c;
}

csifill()
{

while (csi.pptr < &csi.bf[6])
	*csi.pptr++ = ' ';

}

csidev()
{
register char *p;
register int n;

csi.pptr = csi.bf;
p = csi.ptr;

if(alpha)
	{
	do
		put(*p++);
	while (alpha);

	csifill();

	n = (oit) ? *p++ - '0' : 0;

	if(*p++==':')
		{
		csi.ptr = p;
		csi.r_device = radpk(csi.bf);
		csi.unit = n;
		++csi.flag;
		csi.dflt = 0;
		}
	}
}

csifile()
{
register char *p;

p = csi.ptr;

#ifndef	small
if(*p=='*')
	{
	csi.r_file[0] = r_star;
	csi.r_file[1] = 0;
	++p;
	}

else
#endif
	{
	if (alpha)
		{
		csi.pptr = csi.bf;
		do
			put(*p++);
		while (alphanum);
	
		csifill();
		csi.r_file[0] = radpk(&csi.bf[0]);
		csi.r_file[1] = radpk(&csi.bf[3]);
		}
	else
		return;	/* no file name present */
	}
csi.ptr = p;
csi.flag++;
if(*p++!='.')
	return;

#ifndef	small
if(*p=='*')
	{
	csi.r_ext = r_star;
	++p;
	}
else
#endif
	{
	csi.pptr = csi.bf;
	if(alphanum)
		{
		do
			put(*p++);
		while (alphanum);

		csifill();
		csi.r_ext = radpk(csi.bf);
		}
	}
csi.ptr = p;
}

csioct()
{
register char *p;
register int num;

p = csi.ptr;

if(*p=='*')
	{
	num=0377;
	++p;
	}
else
	{
	num = 0;
	
	while (oit)
		num = (num << 3) + *p++ -'0';
	
	}
csi.ptr = p;
return(num);

}

#ifndef	small
csiuic()
{

if(*csi.ptr!='[')
	return;

++csi.ptr;
csi.uic.hi = csioct();
if(*csi.ptr++!=',')
	goto syntax;

csi.uic.lo = csioct();
if(*csi.ptr++!=']')
	goto syntax;
++csi.flag;
return;

syntax:
	*--csi.ptr = 0;		/* insure an error */
}
#endif

doscsm()
{
/*
 * do semantics for csi ... get information into link and file 
 * blocks provided. 
 *
 * no errors should occur since csx already has done it once. 
 */

register struct csicmd *c;
register int *p;
register struct linkblk *l;
struct fileblk *f;
int code;

p = *u.sp++;	/* csi block pointer */

c = *p++;	/* csi command block */
l = *p++ - l_offset;
f = *p++ - f_offset;

clear(&csi,sizeof csi);

code = c->c_code;

if(code)
	c.integer++;

csi.ptr = c->c_inptr;
csi.r_device = c->c_indev;
csi.unit = c->c_inunit;

#ifdef	debug

if(tflg)
	{
	if(tflg>1)
		printf(" csm(%o,%o,%o)",c,l,f);
	printf(" fn=%s ==>%.6s", code==0 ? "in" : "out",csi.ptr);
	}
#endif

csi.flag = 0;
csi.rc = 0;
csi.dflt = 04;
csi.swptr = &l->l_sws;
csi.swmax = l->l_cnt-1;

if(csi.ptr==0)
	goto done;


csidev();
csifile();
csiuic();
csisws();

if(*csi.ptr==',')
	{
	++csi.ptr;
	}
else
done:
	csi.rc =| 1;

c->c_inptr = csi.ptr;
c->c_indev = csi.r_device;
c->c_inunit = csi.unit;

if(csi.flag)
	{	/* got a dataset */
	l->l_device = csi.r_device;
	l->l_unit = csi.unit;
	csi.rc =| csi.dflt;		/* mark if got default */
	}
else
	{
	l->l_device = 0;
	l->l_unit = 0;
	}


*csi.swptr = 0;		/* no more sws to follow */
move(4<<1,csi.r_file,f->f_name);

#ifdef	debug
if(tflg)
	{
	cvtname(f->f_name,info.d_path,0);
	rad50(l->l_device,csi.bf);
	printf(" ==>%.3s%o:%s[%o,%o]",csi.bf,l->l_unit,
		info.d_path,csi.uic.lo,csi.uic.hi);
	printf(" rc=%o",csi.rc);
	}
#endif


*--u.sp = csi.rc;

}

#ifndef	small
csisws()
{

int swbuff[maxsws];
register char* p;
int n;
register int *t;
register int *s;

p = csi.ptr;
t = csi.swptr;

while (*p++ == '/')
	{
	csi.flag++;
#ifdef	debug
	if(tflg>1)
		printf(" ==>%.20s",p-1);
#endif
	s = swbuff;
	*s.ch++ = alpha ? *p++ : 0;
	*s.ch++ = alpha ? *p++ : 0;
	n = 1;		/* number of sw words used */
	for(;;)
		{
		while (alphanum || *p=='$')
			++p;
		if(*p!=':')
			break;
		*s++ = ++p;
		++n;
		}
	if((csi.swcnt=+ n) < csi.swmax)
		{
		*t++ = n;
#ifdef	debug
		if(tflg>1)
			printf(" %o",n);
#endif
		do
			{
			*t++ = *--s;
#ifdef	debug
			if(tflg>1)
				printf(" %o",*s);
#endif
			}
		while (--n);
		}
	else
		csi.rc =| 02;		/* too many sws */
	}

csi.ptr = --p;
csi.swptr = t;
}
#endif

#ifdef	small
csiuic()
{ }

csisws()
{ }
#endif
