#include "batch.h"


struct buf
{
int fildes;
int nleft;
char *nextp;
char buffer[512];
} input;

#define alpha (*p>='a' && *p<='z')
#define digit	(*p>='0' && *p<='9')
#define oit	(*p>='0' && *p<='7')
#define	delim	(*p==' ' || *p==',' || *p==';')

pack()
{

/*
 * pack the input buffer into the command buffer. 
 * the initial $ sign and following command word are 
 * ignored. 
 */

register char *p, *q;

p = buff;
ptr = q = cmdbuff;

if(*p == '$')
	++p;
cmd = 0;
if(*p && !delim)
	cmd.lo = *p++;
if(*p && !delim)
	cmd.hi = *p++;
while (*p && !delim)
	++p;
while (*p==',' || *p==' ')
	++p;
while (*p && *p!=';')
	if(*p!=' ')
		*q++ = *p++;
	else
		++p;
*q++ = 0;
}




getfile()
{
/*
 * get the file name and store into the "file" structure
 * the pieces found. 
 */

register char *p;
register char *q;

p = ptr; 

q = device.d_device;
clear(&device,sizeof device);
while (alpha)
	if(q < &device.d_device[3])
		*q++ = *p++;
	else
		++p;
device.d_unit[0] = digit ? *p++ : '0';

if(*p==':')
	++p;
else
	{
	clear(&device, sizeof device);
	p = ptr;
	}
clear(&file,sizeof file);
q = file.f_name;
while (alpha || digit)
	if(q < &file.f_name[6])
		*q++ = *p++;
	else
		++p;
if(*p=='.')
	{
	++p;
	q = file.f_ext;
	while (alpha || digit)
		if(q < &file.f_ext[3])
			*q++ = *p++;
		else
			++p;
	}
if(*p=='[')
	{
	ptr = ++p;
	file.f_uic.lo = octal();
	if(*ptr++!=',')
		err("bad uic syntax");
	file.f_uic.hi = octal();
	p = ptr;
	if(*p++!=']')
		err("bad uic syntax");
	}
if(*p && *p!=',' && *p!='/')
	err("bad file syntax near ==> %s",p);
ptr = p;
}




octal()
{
register char *p;
register int num;

p = ptr;

num = 0;

while (oit)
	num = num * 8 + *p++ - '0';
ptr = p;
return(num);
}

#define	maxdev	(sizeof devices)/2
char *devices[]
{
"","dk","sy","lp","cr","dt","mt","kb","xy","bi","pr","pp"
};

char *unixnames[]
{
"","","","-o","/dev/cr","/dev/tap","/dev/rmt","/dev/tty","/dev/xy",
"-i","/dev/ppt","/dev/ppt"
};




cvtfile(name)
char *name;
{
/*
 * convert contents of file and device into a unix path name
 * pointed to by "name". 
 */

register char *p,*q;
register int i;

name[0] = 0;		/* reset the name */
for (i=0; i<maxdev; ++i)
	if(equal(device.d_device,devices[i]))
		goto gotdev;
err("invalid device %s",device.d_device);

gotdev:
rest[0] = 0;
switch(i)
{
case 5:		/* dt */
	copy(name,"+@");
	append(name,device.d_unit);
	goto	normal;

case	0:		/* no device present */
case	1:		/* dk: */
case	2:		/* sy */
	if(file.f_uic==sysuic)
		append(name,"/dos/");
	else
		if(equal("tmp",file.f_ext))
			append(name,temp_dir);
normal:
	append(name,file.f_name);
	if(file.f_ext[0])
		{
		append(name,".");
		append(name,file.f_ext);
		}
	break;

case 6:		/* mt */
	rest[0] = device.d_unit[0];
	goto deflt;

case 7:		/* kb */
	rest[0] = ttyn(2);
	if(rest[0]=='x')
		rest[0] = 0;		/* use /dev/tty instead */
	goto deflt;


default:	/* other devices */
deflt:
	append(name,unixnames[i]);
	append(name,rest);
	break;
	}
}





echo()
{
if(!echoflag)
	printf("%s\n",buff);
++echoflag;
}





error(s,d1,d2,d3)
char *s;
{
initflg = 0;
err(s,d1,d2,d3);
}



err(s,d1,d2,d3)
char *s;
{

putchar('\n');
putchar(statflag);		/* flag character for statistics etc */
printf(s,d1,d2,d3);
putchar('\n');
buff[0] = 0;		/* ignore any pending command */

if(!initflg)
	batchexit(1);	/* error during initialization */
finish();
}





readline()
{

register char *p;
register char c;

echoflag = 0;
if(inflag)
	{
	inflag = 0;
	return(1);
	}
p = buff;

while (c=getchar())
	{
	switch(c)
		{
	case '\r':
		break;
	case '\n':
		*p++ = 0;
		return(1);

	case	'!':
		c = ']';

	default:
		if(c >= 'A' && c <= 'Z')
			c =- 'A' - 'a';
		*p++ = c;
		if( p >= &buff[maxbuff])
			err("line too long");
		}
	}
buff[0] = 0;
return(0);
}

getsws()
{
register char *p;

p = ptr;

while (*p=='/')
	{
	++p;
	while(alpha || digit)
		++p;
	while (*p==':')
		{
		++p;
		while (alpha || digit || *p=='$')
			++p;
		}
	}
ptr = p;
}




collect(name,cnt)
char *name;
{
register int i;
register char *p;
register char *n;

p = ptr; 
n = name;
for (i=0; i<cnt; ++i)
	if(alpha || digit)
		*n++ = *p++;
for (; i<=cnt; ++i)
	*n++ = 0;
ptr = p;
}



acopy(name)
char *name;
{
char *p, *q, *s;

s = p = freeptr;
q = name;

do
	{
	*p++ = *q;
	if(p >= &freechars[maxfree])
		err("out of dynamic space");
	}
while (*q++);
freeptr = p;
return(s);
}





int eof;

getchar()
{
char c;
register char ch;
register int l;

if(eof)
	return(0);

if(chgdes > 0 )
	{
	if(read(chgdes,&c,1)<=0)
		{
		close(chgdes);
		chgdes = 0;
		}
	else
		return(c);
	}
if((c = getch(&input)) <= 0)
	{
	if(c == 0)
		++eof;
	return(0);
	}
else
	return(c);
}

writef(des,s,d1,d2,d3,d4)
char *s;
{

register int old;
extern fout;

old = fout;
flush();

fout = des;
printf(s,d1,d2,d3,d4);
flush();
fout = old;
flush();
flush();
}



getch(buf)
struct buf *buf;
{
register struct buf *b;

b = buf;

if(b->nleft <= 0)
	{
	b->nleft = read(b->fildes,b->buffer,512);
	if(b->nleft < 0)
		return(-1);
	if(b->nleft == 0)
		return(0);
	b->nextp = b->buffer;
	}
--b->nleft;
return(* b->nextp ++);
}

