#include "acc.h"

int pr();
int clr();
int pgs();
int dlt();
int prg();
#define	ff	014
#define	digit	(*ptr >='0' && *ptr<='7')
#define	alpha	(*ptr>='a' && *ptr<='z')
#define	delim	(*ptr ==' ' || *ptr==',')
#define	ignsp	while (delim) ++ptr;


#define	maxcmds	(sizeof cmds)/2
#define	maxcmd	12


int prcnt;
int uic;
char buff[256];
char cmd[maxcmd];

char *ptr;

char *cmds[]
{
"initialize","create","stop","print","statistics","clear","delete","pages",
"purge"
};


main(argc,argv)
char *argv[];
{
int reset();
extern fout;

fout = dup(1);
setexit();
signal(2,&reset);
maint();
}


maint()
{
register int i;
int n;


for (;;)
	{
	flush();
	write(2,"*",1);
	if(readline(buff)<= 0)
		exit();
	ptr = buff;
	if(!getwrd(cmd,maxcmd))
		continue;
	for (i=0; i<maxcmds; ++i)
		{
		if(eq(cmds[i],cmd))
			goto gotcmd;
		}
	warn("invalid cmd");
gotcmd:
	ignsp;
	switch(i)
		{
	case 0:		/* initialize */
		if(*ptr)
			warn("syntax");
		accclose();
		if((i=creat(accfile,0644))<0)
			err("can't creat %s",accfile);
		if(close(i)<0)
			err("can't close %s",accfile);
		break;

	case	1:	/* create */
		create();
		break;

	case	2:	/* stop */
		exit();
		break;

	case	3:	/* print */
		process(&pr);
		break;

	case	4:	/* statistics */

		uic = *ptr ? getuic() : 0;
		prstats(uic);
		break;

	case	5:	/* clear */
		process(&clr);
		break;
	case 6:		/* delete */
		process(&dlt);
		break;
	case 7:		/* pages */
		process(&pgs);
		break;
	case 8:
		process(&prg);
		break;

		}
	}
}


create()
{
/*
 * create a new account entry 
 */

clear(&acc,sizeof acc);

acc.a_uic = getuic();

getstr(acc.a_name,maxname);
if(*ptr)
	getstr(acc.a_dir,maxname);
if (*ptr)
	acc.a_pglimit = decimal();

store(acc.a_uic);

printf("account [%o,%o] created for '%.20s'.\n",
	acc.a_uic.lo &0377, acc.a_uic.hi & 0377,acc.a_name);


}

getuic()
{
int n;

n.lo = octal();
while (delim)
	++ptr;
n.hi = octal();
return(n);
}


number(base)
{

register int num;
register int c;

num = 0;

ignsp;

while (digit)
	{
	c = *ptr++;
	c =- '0';
	if (c >= base)
		err("bad digit");
	num = num * base + c;
	}
return(num);
}

octal()
{
register int num;

num = number(010);

if(num <= 0 || num >= 0377)
	warn("invalid octal number");

return(num);
}

decimal()
{
return(number(10));
}

getstr(name,cnt)
char *name;
{
/* 
 * get a string enclosed in quotes
 */

register char *p;


ignsp;
if(*ptr++ != '\'')
	warn("invalid string");

p = name;
clear(p,cnt);

while (*ptr!='\'')
	{
	if(*ptr==0)
		warn("unclosed string");
	if(--cnt >= 0)
		*p++ = *ptr++;
	else
		warn("string too long");
	}
++ptr;
ignsp;
}


pr()
{
float elt, cpu;
float flt();

if(prcnt++ == 0)
	{
	printf(
"  uic	name			pages	elt	cpu	pglim	directory\n");
	printf(
"					(hr)	(min)\n\n");
	}
elt = flt(acc.a_elt)/3600.0;
cpu = flt(acc.a_cpu)/3600.0;
printf("%o,%o	%-20.18s %6d  %7.2f  %7.2f	%5d	%.18s",
	acc.a_uic.lo&0377, acc.a_uic.hi&0377,acc.a_name,acc.a_pages,
	elt,cpu,acc.a_pglimit,acc.a_dir);

putchar('\n');
}


pgs()
{
acc.a_pglimit = decimal();
store(acc.a_uic);
}

getwrd(name,cnt)
char *name;
{
register char *p;

p = name;

ignsp;
if(*ptr==0)
	return(0);
clear(p,cnt);

while (*ptr && !delim)
	if(--cnt >= 0)
		*p++ = *ptr++;
	else
		err("word too long");

return(1);
}



process(fn) int (*fn) ();
{

int n;
register int i;

prcnt = 0;
if(*ptr)
	{
	n = getuic();
	if(fetch(n))
		(*fn)();
	else
		warn("no such uic");
	}
else
	{
	accopen();
	for (i = 0; i < accindex.a_cnt; ++i)
		{
		n = accindex.a_uics[i];
		if (n == 0)
			continue;
		if(fetch(n))
			(*fn)();
		else
			err("can't fetch %o,%o",
				n.lo&0377,n.hi&0377);
		}
	}
}

prstats(num)
{
float min, cpu;
register char *p;
float flt();
float elt_sum, cpu_sum;
float pag_sum;
extern ldivr;

statdes = open(statfile,0);
if(statdes < 0)
	warn("no %s",statfile);

putchar(ff);
printf(" uic	jobname	time		pages	elt	cpu\n");
printf("					(min)	(min)\n\n");
elt_sum = 0.0;
cpu_sum = 0.0;
pag_sum = 0.0;
while (read(statdes,&stats,sizeof stats)>0)
	{
	if(num!=stats.s_uic && num)
		continue;
	min = flt(stats.s_elt)/60.0;
	cpu = flt(stats.s_cpu)/3600.;
	elt_sum =+ min;
	cpu_sum =+ cpu;
	pag_sum =+ stats.s_pages;
	p = ctime(stats.s_ton);
	printf("%o,%o	%s	%.12s  %5d %7.2f	%7.2f",
		stats.s_uic.lo&0377,stats.s_uic.hi&0377,
		stats.s_jobname,p+4,stats.s_pages,min,cpu);
	putchar('\n');
	}
printf("\n\n totals: elapsed time = %.2f hours.  cpu = %.2f hours.",
	elt_sum/60.0, cpu_sum/60.0);
printf(" pages = %.0f.",pag_sum);
putchar('\n');
close(statdes);
}


clr()
{
acc.a_pages = 0;
acc.a_cpu[0] = 0;
acc.a_cpu[1] = 0;
acc.a_elt[0] = 0;
acc.a_elt[1] = 0;
store(acc.a_uic);
}

dlt()
{
register int n;

n = acc.a_uic;
clear(&acc,sizeof acc);
store(n);
}

prg()
{
/*
 * purge any entries that have not been used lately.
 */

if (acc.a_pages == 0 && acc.a_cpu[0] == 0 && acc.a_cpu[1] == 0)
	dlt();
}

err(fmt,d1,d2) char *fmt;
{
flush();
printf(" error: ");
printf(fmt,d1,d2);
printf("\n");
flush();
exit(1);
}
