#include "batch.h"
#include "acc.h"

int pagecnt;		/* # of pages printed */
int setpages;		/* he set limit */
int pages;		/* page limit */
int pagedes 0;		/* file des for /dos/page.info */
char sleepmsg[]
	"\377\377\377timeout";

#define	hz	60		/* power line freq */
#define	motd	"/dos/motd"
#define	sigkill	9
#define	def_time	10
#define	def_pages	20
#define	alpha	(*ptr>='a' && *ptr<='z')
#define	digit	(*ptr>='0' && *ptr<='9')


struct times

{
int p_user;
int p_system;
int c_user[2];
int c_system[2];
} before, after;


jobscan()

{
do
	{
	if(eq(buff,"$jo"))
		return(1);
	}
while (readline());

batchexit(0);
}




job()
{
register int min;
initout();
asninit();
echoflag = 0;
echo();
pack();
times(&before);

getfile();
pages = def_pages;
setpages = 0;		/* assume default was used */
min = def_time;
while (*ptr == '/')
	{
	if (eq(ptr,"/ti"))
		min = gettime();
	else if (eq(ptr,"/pa"))
		pages = getpages();
	else err("bad switch");
	}
copy(jobname,file.f_name);

if(file.f_uic.lo==0 || file.f_uic.hi==0)
	err("invalid uic");
if(!fetch(file.f_uic))
	err("No such uic, job ignored");


copy(userdir, acc.a_dir[0] ? acc.a_dir : def_dir);
if (!setpages && acc.a_pglimit)
	pages = acc.a_pglimit;
uic = file.f_uic;
passuic();
openout();
time(tvec);
putchar('\n');
pruser();
prtd("logged on",tvec);
if(acc.a_ton[0])
	prtd("last   on",acc.a_ton);

putchar('\n');
pr_motd();
acc.a_ton[0] = tvec[0];
acc.a_ton[1] = tvec[1];
store(uic);
accclose();
settime(min);
flush();
}




finish()
{
extern ldivr;
register int min, secs;

signal(sigtime,1);		/* ignore signals now */
if(uic==0)
	{
	openout();
	closeout();
	reset();
	}

if(timeps != 0)
	{
	kill(timeps,sigkill);
	timeps = 0;
	}
if(runps != 0)
	{
	kill(runps,sigkill);
	runps = 0;
	}
if(acc.a_dir[0]==0)
	purge(def_dir);

purge(temp_dir);

if(inpipe)
	{
	close(inpipe);
	inpipe = 0;
	}
if(outpipe)
	{
	close(outpipe);
	outpipe = 0;
	}
if(chgdes > 0)
	{
	close(chgdes);
	chgdes = 0;
	}
putchar(statflag);		/* flag start of statistics */
time(tvec);
if(!fetch(uic))
	err("fetch failed");
pruser();
prtd("logged off",tvec);

dpsub2(tvec,acc.a_ton);
min = ldiv(tvec[0],tvec[1],60);
secs = ldivr;
printf("elapsed time %d minutes %d seconds.\n",min,secs);
pr_cpu();
closeout();
do_stat();
dpadd2(acc.a_elt,tvec);		/* cummulative elapsed time */
dpadd2(acc.a_cpu,after.c_user);	/* cummulative cpu time */
acc.a_pages =+ pagecnt;		/* accumulate page count */
store(uic);
accclose();
uic = 0;
reset();
}



getpages()
{
ignsw();
++setpages;
return(decimal());
}

gettime()
{

register int min, sec;
/* 
 * pick up and convert the time switch 
 */

ignsw();
min = decimal();
if(*ptr==':')
	{
	++ptr;
	min =* 60;
	min =+ decimal();
	}
if(min==0)
	err("no time specified");
return(min);
}

ignsw()
{
++ptr;
while (alpha)
	++ptr;
if(*ptr++!=':')
	err("bad switch specification");
}

decimal()
{
register int num;
num = 0;
while (digit)
	num = num * 10 + *ptr++ - '0';

return(num);
}



settime(min)
{
/*
 * set up a time out of given minutes 
 */ 

register int secs;
register int mainps;
int timeout();

secs = min * 60;
if(secs < min )
	return;

mainps = getpid();

if((timeps = fork()) == 0)
	{		/* child */
	move(sizeof sleepmsg,&sleepmsg,- sizeof sleepmsg);
	sleep(secs);
	if(kill(mainps,sigtime) < 0)
		error("timeout: no process %d",mainps);
	exit();
	}

signal(sigtime,&timeout);
}


timeout()
{
/* 
 * invoked via a signal from the tsettime routine in 
 * task doing the sleep. 
 */

if(runps)
	{
	kill(runps,sigtime);
	timeps = 0;
	}

else
	err("job time limit exceeded");

}

prtd(s,tm)
int tm[2];
char *s;
{
printf("%s at ",s);
prtime(tm);
printf(" on ");
prdate(tm);
printf(".\n");
}

pruser()
{

printf("user [%o,%o] \"%.20s\":\n",
	acc.a_uic.lo&0377, acc.a_uic.hi&0377,
	acc.a_name);
}

char file_name[64];
struct rec
{
int r_inode;
char r_name[14];
} rec;

purge(dir)
char *dir;
{
/*
 * purge all files in directory "dir". 
 */

register int des;
register char *p;
register int i;

#define	imask	060000
#define	ifile	0

copy(file_name,dir);
p = file_name;
while (*p)
	++p;
*p++ = '/';
des = open(dir,0);
if(des < 0 )
	{
	uic = 0;
	err("can't open dir file %s",dir);
	}
while (read(des,&rec,sizeof rec)>0)
	{
	for (i=0; i<14; ++i)
		p[i] = rec.r_name[i];
	p[14] = 0;
	if(rec.r_inode!=0 &&
		stat(file_name,&statb) >= 0 &&
		(statb.s_flags&imask) == ifile)
		unlink(file_name);
	}
close(des);
}

do_stat()
{
clear(&stats, sizeof stats);
stats.s_pages = pagecnt;
stats.s_uic = uic;
stats.s_ton[0] = acc.a_ton[0];
stats.s_ton[1] = acc.a_ton[1];
stats.s_cpu[0] = after.c_user[0];
stats.s_cpu[1] = after.c_user[1];
stats.s_elt[0] = tvec[0];
stats.s_elt[1] = tvec[1];
copy(stats.s_jobname,jobname);
statdes = open(statfile,1);
if(statdes > 0)
	{
	seek(statdes,0,2);
	write(statdes,&stats,sizeof stats);
	close(statdes);
	}
statdes = 0;
}


passuic()
{
register char *p;

p = option;
*p++ = '-';
*p++ = 'c';			/* allow cr on output */
*p++ = 'x';
*p++ = uic.hi;
*p++ = uic.lo;
*p++ = 0;
}

pr_motd()
{
register int f, l;
register int i;
char msg[64];

f = open(motd,0);

if(f > 0)
	{
	while ((l = read(f,msg,64)) > 0)
		for (i=0; i<l; ++i)
			putchar(msg[i]);
	close(f);
	}
}


pr_cpu()
{
register int min, secs;
register int sys;
extern ldivr;
int total;

times(&after);
after.p_user =- before.p_user;
after.p_system =- before.p_system;
after.p_user =+ after.p_system;

dpsub2(after.c_user,before.c_user);
dpsub2(after.c_system,before.c_system);

dpadd2(after.c_user,after.c_system);
dpadd(after.c_user,after.p_user);
dpadd(after.c_system,after.p_system);

min = ldiv(after.c_user[0],after.c_user[1],hz * 60);
secs = ldivr/60;
printf("cpu time %d minutes %d seconds.\n",min,secs);
secs =+ min * 60;
total = secs/100;
sys = ldiv(after.c_system[0],after.c_system[1],hz);
if(total<5)
	sys = (sys*100)/secs;
else
	sys = sys / total;
if(sys && sys <= 100)
	printf("approximately %d%% system cpu time.\n",sys);
}

initout()
{
extern fout[];

flush();
fout[0] = 1;
fout[1] = 512;
}

openout()
{
/*
 * create a pipe to the output routine "/dos/lpr" which is used
 * for page limit counting.
 */
extern fout;
if (pagedes == 0)
	pagedes = open("/dos/page.info",2);
seek(pagedes,0,0);
write(pagedes,&pages,2);
fout = debug ? dup(1) : pipeout("/dos/blpr","blpr",0);
flush();
}

closeout()
{
extern fout;
flush();
if (fout > 2)
	close(fout);
fout = 1;
while (wait(&status) != -1)
	;
seek(pagedes,2,0);
pagecnt = 0;
read(pagedes,&pagecnt,2);
}
