#include "batch.h"

#define	DOSID	22

char lockfile[] "/tmp/batch.lock";
int debug 0;
#define	root	0		/* uid of super user */

main(argc,argv)
int argc;
char *argv[];
{


close(2);		/* make error output same as standard output */
dup(1);
if (fork() == 0)
	interlock();
else
	wait(&status);
old_int = signal(sigint,1);
old_quit = signal(sigquit,1);
old_hup = signal(sighup,1);
tty = argc > 1 ? argv[1] : "/dev/tty8";
if (debug)
	signal(sigint,0);
else
	if(setuid(root))
		err("not super-user");

if(stat(def_dir,&statb) < 0)
	err("no %s",def_dir);
uid = statb.s_uid;
gid = statb.s_gid;

++initflg;		/* now we are initialized */
setexit();

for (;;)
	{
	if(!jobscan())
		exit();
	
	job();
	
	while (readline())
		execute();
	finish();
	}
	
batchexit(0);
}



execute()
{

if(buff[0]!='$')
	return;
putchar('\n');
pack();
echo();

switch(cmd)
	{

case	'jo':
	finish();
	return;

case	'fi':
	finish();
	return;

case	'r':
	run(1);
	break;

case	'ru':
	run(0);
	break;

case	'eo':
	break;

case	'ki':
	break;

case	'as':
	assign();
	break;

case	'ch':
	change();
	break;

case	'ft':
	ftn();
	break;

case	'ex':
	exec();
	break;
case	'da':
	time(tvec);
	prdate(tvec);
	putchar('\n');
	break;

case	'ti':
	time(tvec);
	prtime(tvec);
	putchar('\n');
	break;

case	'me':
	msgcmd();
	break;

case	'wa':
	waitcmd();
	break;

case	0:
	break;

case	'un':		/* allow unix command to execute */
	unix();
	break;

default:
	err("invalid command");
	break;

	}
}

batchexit(n)
{
unlink(lockfile);		/* remove interlock */
exit(n);
}

interlock()
{
register int i;
setuid(DOSID);		/* temporarily make non-super user */
if ((i=creat(lockfile,0)) < 0)
	{
	printf("batch: batch job already in progress\n\r");
	do
		sleep(15);
	while ((i=creat(lockfile,0)) < 0);
	}
close(i);
exit(0);
}
