#include "acc.h"


fetch(n)
{
/*
 * fetch accounting record corresponding to uic "n". 
 */

register int i;


accopen();


for (i=0; i<accindex.a_cnt; ++i)
	{
	if(n == accindex.a_uics[i])
		{
		seek(accdes,sizeof accindex + i*sizeof acc,0);
		if(read(accdes,&acc,sizeof acc) <= 0 || acc.a_uic != n)
			err("error reading acc record for %o,%o",n.lo,n.hi);
		return(1);
		}
	}
return(0);
}

accopen()
{
if(accdes>0)
	return;

accdes = open(accfile,2);
if(accdes < 0)
	err("can't open account file %s",accfile);

clear(&accindex,sizeof accindex);
read(accdes,&accindex,sizeof accindex);

}

accclose()
{
if(accdes > 0)
	close(accdes);
accdes = 0;
}






store(n)
{
/*
 * update accounting record corresponding to uic "n". 
 */

register int i;
register int pos;

pos = -1;

accopen();


for (i=0; i<accindex.a_cnt; ++i)
	{
	if(n == accindex.a_uics[i])
		goto oldentry;
	if (accindex.a_uics[i] == 0)
		pos = i;
	}

if (pos >= 0)
	i = pos;
else
	if(++accindex.a_cnt > maxuic) 
		err("can't add more users to accounting file");
oldentry:
if (accindex.a_uics[i] != n || n != acc.a_uic)	/* if index not valid */
	{
	accindex.a_uics[i] = acc.a_uic;
	seek(accdes,0,0);
	write(accdes,&accindex,sizeof accindex);
	}

accindex.a_uics[i] = acc.a_uic;
seek(accdes,sizeof accindex + i*sizeof acc,0);
if(write(accdes,&acc,sizeof acc)<=0)
	err("writing account record for %o,%o",n.lo&0377,n.hi&0377);
}
