#define	MAXSUBS	2	/* for now */

#define	SYMHDR	struct symhdr *v_next; char v_name[2]; short v_nsubs
#define	SUBHDR	struct symhdr *v_next; char v_name[2]; short v_nsubs, v_subsc[MAXSUBS]

struct symhdr
{
struct symhdr *v_next;	/* the next symbol table entry */
char v_name[2];		/* the name of the symbol */
short v_nsubs;		/* the number of subscripts */
};

struct subhdr
{
SUBHDR;				/* subscript header is everything */
};

/*
 * the following declare the symble table entries for simple variables
 * of the appropriate types.
 */

struct floatsym
{
SYMHDR;
float v_float;
};

struct doublesym
{
SYMHDR;
double v_double;
};


struct intsym
{
SYMHDR;
short v_int;
};


struct strsym
{
SYMHDR;
struct string v_str;
};

/*
 * the following declare the appropriate array variables
 */

struct fltvec
{
SUBHDR;
float v_fltvec[DUMMYVEC];
};

struct dblvec
{
SUBHDR;
double v_dblvec[DUMMYVEC];
};

struct intvec
{
SUBHDR;
short v_intvec[DUMMYVEC];
};

struct strvec
{
SUBHDR;
struct string v_strvec[DUMMYVEC];
};

/*
 * function symbol table entry.
 */
struct fn
{
SYMHDR;
char *v_inptr;			/* where it starts */
struct textline  *v_curline;	/* the line it starts at */
};

struct
{
SYMHDR;
char *v_ptr;
short v_len;
};

union values
{
int *vv_int;
double *vv_double;
float *vv_float;
struct string *vv_str;
} ;

typedef struct string *VALPTR;

typedef union sym_union
{
char *vp_char;
struct floatsym *vp_float;
struct doublesym *vp_double;
struct intsym *vp_int;
struct strsym *vp_str;
struct fltvec *vp_vfloat;
struct dblvec *vp_vdouble;
struct intvec *vp_vint;
struct strvec *vp_vstr;
struct fn *vp_fn;
} SYM_UNION;

typedef union stk_union
{
char *vp_char;
struct floatsym *vp_float;
struct doublesym *vp_double;
struct intsym *vp_int;
struct strsym *vp_str;
struct string *vp_string; 
struct floatvec *vp_vfloat;
struct dblvec *vp_vdouble;
struct intvec *vp_vint;
struct strvec *vp_vstr;
struct fn *sp_fn;
struct gosub *sp_gosub;
struct forstack *sp_forstack;
/* struct fnstack *sp_fnstack; 		/* dummy */
} STK_UNION;

int nsubs;			/* number of subscripts found */
int subsc[MAXSUBS];		/* subscripts found */
typedef struct symhdr *SYMPTR;	/* symbol table header */

SYMPTR getvar();
VALPTR getsvar();

struct var		/* a variable on the stack */
{
char k_type, k_len;	/* stack header */
SYMPTR k_ptr;		/* pointer to variable */
};

#define	v_string v_str
#define intSym(s) (((struct intsym *) (s)) -> v_int)
#define floatSym(s) (((struct floatsym *) (s)) -> v_float)
#define doubleSym(s) (((struct doublesym *) (s)) -> v_double)
#define Sptr(s) (((struct strsym *) (s)) -> v_str.ptr)
#define Slen(s) (((struct strsym *) (s)) -> v_str.len)

SYMPTR chains[MAXTYPE*3] INITZERO;	/* points to symbol table entries */
