#
/*			Copyright 1980 by Bill Webb.	 		*/
#include "basic.h"
#include "stack.h"
#include "tokens.h"

#define	DEFSIZE	10		/* size of default elements */

char *types[] IS
{ "", "%", "", "$" };

int typelens[] IS {0, sizeof (short), sizeof (double), STRINGSIZE };

clrsym()
{
clrstr();		/* clear string area */
symlast = symspace;
clear((char *) chains,sizeof chains);
}

SYMPTR getvar(type,flag) int *type;
{
/*
 * get a variable and return its pointer.
 * enter it if not already in the symbol table.
 * if flag=ON then this is a dim statement entry
 * and allocation is exact, otherwise allocate a default sized
 * array (currently 10).
 */
char name[3];
register char *p;
SYMPTR *chain;
register SYMPTR q;
register int len;
int i;
int size;		/* size of scalar or array */
int subslen;
int fnflag;
int _nsubs;		/* local nsubs */
int _subsc[MAXSUBS];	/* local subsc */

p = inptr;
fnflag = 0;
if (*p == FN)
	{
	++p;
	fnflag = DIMOFF;
	}
if (!alpha(*p))
	err("name required");
name[0] = *p++;
name[1] = 0;
while (alphanum(*p))
	{
	if (!name[1])
		name[1] = *p;
	else if (nflg)
		err("variable name more than 2 characters");
	++p;
	}
if (nflg && name[1] && !isdigit(name[1]))
	err("second character in name not numeric");
if (*p == '%')
	{ ++p; *type = INT; }
else if (*p == '$')
	{ ++p; *type = STRING; }
else
	*type = FLOAT;

chain = &chains[*type];
_nsubs = 0;			/* assume no subscripts for now */
inptr = p;
if (*p == LPAR)
	{
	chain += DIMOFF + fnflag;
	if (!fnflag)
		{
		++inptr;
		for ( ; ; )
			{
			_subsc[_nsubs++] = fexpr();
			if (*inptr == RPAR)
				{ ++inptr; break; }
			expectc(COMMA);
			if (_nsubs >= MAXSUBS)
				err("more than %d subscripts",MAXSUBS);
			}
		}
	}
else
	if (flag)
		err("expected (");
/*
 * scan through the appropriate chain looking for the symbol.
 */
for (q = *chain; q != NULL; q = q->v_next)
	if (q->v_name[0] == name[0] && q->v_name[1] == name[1])
		{
		if (flag)
			err("attempt to re-dimension");
		TTRACEF(("getvar: found %.2s @%o type=%s\n",q->v_name,q,typenames[*type]));
		goto done;
		}
/*
 * symbol was not found ... enter it.
 */
q = (SYMPTR) symlast;
size = 1;
/*
 * if subscripted variable then calculate the array size
 * if dimensioned and in a DIM stmt then use the dimensions provided,
 * otherwise use the default values.
 */
if (_nsubs)			/* get the proper header size */
	{
	len = SYMSUBSIZE;
	for (i=0; i<_nsubs; ++i)
		{
		size *= (flag ? _subsc[i] : DEFSIZE) + 1;
		if (size <= 0)
			err("negative array size");
		}
	}
else
	len = SYMSIZE;
subslen = typelens[*type]*size;
len += subslen;
if (symlast + len >= symend)
	if (!moresym(symlast+len))
		err("no room");
symlast += len;
/*
 * clear and copy information into symbol table entry.
 */
clear((char *) q,len);
q->v_name[0] = name[0];
q->v_name[1] = name[1];
if (_nsubs)
	{
	for (i=0; i<_nsubs; ++i)
		((struct subhdr *)q) ->v_subsc[i] = (flag ? _subsc[i] : DEFSIZE);
	q->v_nsubs = _nsubs;
	}
TTRACEF(("getvar: create %.2s @%o type=%s\n",q->v_name,q,typenames[*type]));
q->v_next = *chain;
*chain = q;

done:
/*
 * make global copy of subscript information
 */
if (nsubs = _nsubs)
	for (i=0; i<nsubs; ++i)
		subsc[i] = _subsc[i];
return(q);
}

dim()
{
/*
 * allocate space for a dimensioned variable.
 * if a dimensioned variable is used before the dim statement
 * than a 10 element array is allocated.
 * since subscripts start at zero, dim a(n) allocates
 * elements 0...n
 * all the work is now done in getvar.
 */
int type;

do
	getvar(&type,YES);
while (*inptr == COMMA && ++inptr);
}


dumpsym()
{
register int i;

puts("\t\tSymbol Table Dump\n");
for (i=1; i<MAXTYPE; ++i)
	{
	dumpchain(chains[i],i);
	dumpchain(chains[i+DIMOFF],i);
	}
dumpstk();				/* dump the stack too */
}

dumpchain(chain,type) SYMPTR chain;
{
register SYMPTR s;
register int i, n;
int k;
int nsubs;		/* for future printout of array values */

for (s = chain; s; s=s->v_next)
	{
	TRACEF(("%6o ",s));	/* for debug print address */
	printf("%.2s%s",s->v_name,types[type]);
	nsubs = 1;
	if (n = s->v_nsubs)
		{
		printf("(");
		for (i=0; i<n; )
			{
			k = ((struct subhdr *)s)->v_subsc[i];
			printf("%d",k);
			nsubs *= k;
			if (++i != n)
				printf(",");
			}
		printf(")");
		}
	printf(" =");
	switch(type)
		{
	case INT:
		printf(" %d",intSym(s));
		break;
	case FLOAT:
		printf(" %.5f",floatSym(s));
		break;
	case STRING:
		printf(" %d chars '%.*s'",Slen(s),Slen(s),Sptr(s));
		break;
	default:
		badtype();
		}
	printf("\n");
	}
}
