#
/*			Copyright 1980 by Bill Webb.	 		*/
#include "basic.h"
#include "stack.h"

/*
 * String manipulation:
 *
 * basic princple:
 * when a string is allocated in the string area, allocate enough
 * extra space to allow us to garbage collect later.
 * during normal operation this extra space is used to hold the
 * length of the string.
 * during garbage collect, this space is used to hold a pointer
 * the "string" structure that pointed to it initially.
 * it is assumed that the address can be distinguished from the pointer
 * because the string area has an address much higher than MAXSTRING.
 * the string structure pointer that used to point to the string area
 * is null for the first such string structure.
 * after the first it will point to a chain of such structures.
 * after all the strings are marked, those that are used are moved
 * to the start of the string area and the pointers fixed up again.
 * it is arranged so that the extra information is "hidden" before
 * the string by being GCHDRSIZE bytes before it.
 */

#define	WORDSIZE (sizeof (int))
#define	FIXLENGTH(l) if (l&1) ++l			/* make it even */
#define	MARKED(q) (q->X_len > MAXSTRING)
#define	ISMARKED(q) ((unsigned) q > MAXSTRING)
#define	ALIGNED(q) (((int) (q)) & (WORDSIZE-1)) == 0
#define	NEXTSTR(q,l) (STR_APTR) (((char *) q) + l)

#define	isstring(s)	(s >= strspace && s < endstring)
/*	#define MAXSTRSPACE	512		/* for testing only */
char strspace[MAXSTRSPACE] INITZERO;
char *strptr = strspace;			/* current end of string area */
#define	endstring (strspace+MAXSTRSPACE)	/* end of string area */

struct strarea
{
union gc_union {
	struct string *x_next;			/* pointer to string */
	unsigned int x_len;			/* length field */
	} x_union;
char x_data[2];
};

typedef struct strarea * STR_APTR;
int gc_count;					/* safety check */

/* some defines to make life easier with unions */
#define	X_next	x_union.x_next
#define	X_len	x_union.x_len

#define	GCHDRSIZE	(sizeof (union gc_union))

clrstr()
{
/*
 * clear the string area.
 */

strptr = strspace;
}

char *allocstring(ptr,len,mlen) char *ptr;
{
/*
 * allocate and copy a string into the variable string area.
 * mlen is the length to actually move.
 */
register STR_APTR s;
register int l;

l = len + GCHDRSIZE;
if (len >= MAXSTRING)
	err("bad string length");
FIXLENGTH(l);
if (strptr+l >= endstring)
	collect();
s = (STR_APTR ) strptr;
strptr += l;
s->X_len = len;		/* store the length */
if (mlen)
	move(mlen,ptr,s->x_data);
return(s->x_data);
}

collect()
{
/*
 * scan thru the string area collecting all unused strings.
 *
 * first mark the flag bytes to 1 for all strings actually referenced.
 */

markstr();		/* mark simple string vars */
markvstr();		/* mark string arrays */
markstk();		/* mark the stack */
colstr();		/* collect the string area */
}

colstr()
{
/*
 * collect the string area.
 * Scan thru the string area.
 * We use two pointers:
 *	"p" scans thru the area one string at a time
 *	"q" marked strings are copied into q 
 */
register struct string *s;
register STR_APTR p;
register STR_APTR q;
STR_APTR t;
int l;

for (q = p = (STR_APTR) strspace; p < (STR_APTR) strptr; p = NEXTSTR(p,l))
	{
	TTRACEF(("p=%o q=%o next=%o, len=%d\n",p,q,p->X_next,p->X_len));
	s = p->X_next;
	if (!MARKED(p))
		{			/* junk space */
		l = p->X_len + GCHDRSIZE;
		FIXLENGTH(l);
		}
	else
		{			/* used space */
		l = s->len+GCHDRSIZE;
		FIXLENGTH(l);
		if (p != q)
			{		/* move to start of area */
			TRACEF(("move %l %o %o\n",l,p,q));
			move(l,(char *)p,(char *)q);
			}
		q->X_len = s->len;	/* copy the length */
		/*
		 * scan thru the variable chain resetting the
		 * pointers.
		 */
		TRACEF(("reset pointers to '%.*s'\n",s->len,q->x_data));
		/* NOSTRICT */
		for (; ISMARKED(s) ; s = (struct string *) t)
			{
			--gc_count;	/* decrement link count */
			/* NOSTRICT */
			t = (STR_APTR) s->ptr;	/* point to next in the chain */
			s->ptr = q->x_data;
			TRACEF(("reset %o => %o %d\n",s,s->ptr,s->len));
			}
		q = NEXTSTR(q,l);
		}
	}
l = endstring - (char *)q;		/* amount now free */
TRACEF(("%d bytes free\n",l));
strptr = (char *) q;
if (l < MAXSTRSPACE/10)
	err("not enough free space");
if (gc_count != 0)
	err("garbage collection error (%d)",gc_count);

}

markstr()
{
/*
 * mark all the normal string variables.
 */
register SYMPTR s;

for (s=chains[STRING]; s; s=s->v_next)
	{
	TRACEF(("mark var %.2s ",s->v_name));
	mark(&((struct strsym *)s)->v_str,1);
	}
}

markvstr()
{
/*
 * mark string vectors
 */
register SYMPTR s;

for (s= chains[STRING+DIMOFF]; s; s=s->v_next)
	{
	TRACEF(("mark vec %.2s ",s->v_name));
	mark(((struct strvec *) s)->v_strvec,count(s));
	}
}

count(s) register struct subhdr *s;
/*
 * return the number of array elements for given vector.
 */
{
register int i;
register int n = 1;

for (i=0; i<MAXSUBS; ++i)
	n *= s->v_subsc[i];
return(n);
}

markstk()
{
/*
 * mark all the strings on the stack.
 */
register STKPTR s;

for (SCANSTK(s))
	{
	if (s->k_type == STRINGEXPR)
		{
		TRACEF(("mark stk %o ",s));
		mark(&((struct stringexpr *) s)->k_str,1);	/* mark stack frame */
		}
	}
}

mark(ptr,n) struct string *ptr;
{
/*
 * if the string structure "ptr" points to a string in the string
 * area, change the string area to point to it. this marks the
 * string as being used.
 * Assumption: that the flag "gc" will be set in an address, and not
 * when just the length is changed.
 */
register struct string *s;
register char *p;
register STR_APTR q;

for (s = ptr; --n >= 0; ++s)
	{
	p = s->ptr;
	if (isstring(p))	/* if inside string area mark it */
		{
		q = (STR_APTR ) (p - GCHDRSIZE);
		TRACEF(("mark %o '%.*s' %d\n",q,s->len,p,s->len));
		if (!MARKED(q))
			{
			if (s->len != q->X_len)
				err("bad string list");
			}
		s->ptr = (char *) q->X_next;
		q->X_next = s;		/* link into the chain */
		++gc_count;		/* count number of links */
		}
	}
}

storestring(v) struct string *v;
{
/*
 * store string on top of stack into string pointer "v"
 * the old value of the variable is changed last, so that in the
 * case of an error, it is still available, allowing re-execution
 * of the line with the error.
 * if storing a pointer will suffice (a$ = b$)
 * then only store the pointer, otherwise allocate more space
 * and copy the string.
 */
char *ptr;
register int len;
register struct stringexpr *s = (struct stringexpr *) stkptr;
register STR_APTR q;

len = s->k_slen;
ptr = s->k_sptr;
if (! (isstring(ptr) && ( (q = (STR_APTR) (ptr - GCHDRSIZE)) , (ALIGNED(q) && q->X_len == len))))
	{
	ptr = allocstring((char *) NULL,len,0);	/* allocate space */
	move(len,s->k_sptr,ptr);
	}
v->ptr = ptr;
v->len = len;
pop(STRINGEXPR);	/* remove from the stack */
}
