#define	NULLSTK	0			/* type 0, length 0 */

#define	STK_END		0
#define	STK_GOSUB	7		/* line # entry on stack */
#define	STK_FOR		6		/* for loop on stack */
#define	STK_DEF		5		/* def fn stack */

#define	ANYTYPE	0

#define	EXPR	010
#define	FLOATEXPR	(FLOAT+EXPR)
#define	INTEXPR		(INT+EXPR)
#define	STRINGEXPR	(STRING+EXPR)
#define	INT	1
#define	FLOAT	2
#define	STRING	3
#define	DIMOFF 3

#define	STREXPR	(STRING+EXPR)
#define	SYMSUBSIZE	(sizeof (struct subhdr))
#define	SYMSIZE	(sizeof (struct symhdr))
#define	RHS	EXPR
#define	LHS	0

#define	pushint(i)	pushfloat((double) i)
#define	popint()	((int) popfloat())

#define	fexpr()	(expr(),popfloat())
#define	sexpr()	(expr(),strpop())
#define	stkbase	stkspace
#define	stktop	(stkspace+MAXSTACK)

#define	STACK_HDR	char k_type, k_len;	/* stack frame hdr */
struct stack
{
char k_type;		/* type of frame */
char k_len;		/* length of frame */
};

/*
 * string type 
 */
struct string
{
char *ptr;
short len;
};

struct {int *intptr;};
char stkspace[MAXSTACK] INITZERO;
char *stkptr INITZERO;			/* pointer to current stack item */

struct floatexpr
{
char k_type, k_len;	/* stack header */
double k_float;
};

struct stringexpr
{
char k_type, k_len;	/* stack header */
struct string k_str;	/* the string */
};

#define k_sptr k_str.ptr	/* string pointer */
#define k_slen k_str.len	/* string pointer */

char *symspace INITZERO;		/* pointer to start of symtab */
char *symend INITZERO;			/* pointer to end of symtab */
char *symlast INITZERO;			/* next free byte in table */

/*
 * stack entries for special statments.
 */

struct gosub				/* stack entry for GOSUB return */
{
char g_type;
char g_len;
struct textline *g_curline;
char *g_inptr;
} gosub INITZERO,
data INITZERO;				/* data scan pointer */

struct forstack				/* stack entry for FOR statment */
{
char k_type, k_len;	/* stack header */
struct textline *k_curline;
char *k_inptr;
struct symhdr *k_var;				/* the for variable */
double k_incr;				/* the increment */
double k_last;				/* the last value */
struct textline *k_ncurline;		/* point to line containing next */
char *k_ninptr;				/* the actual spot */
};

#define	INFOR()	(((struct forstack *) stkptr) -> k_type == STK_FOR)

struct fnstk
{
char k_type, k_len;		/* stack header */
struct textline *k_curline;
char *k_inptr;
char *k_fnline;			/* line in the function */
char *k_fnptr;			/* function text pointer */
char *k_fn;			/* the function pointer */
short k_fntype;			/* the type of the function */
short k_argcnt;			/* number of args */
};

double popfloat();
double cvtnumber();
struct stringexpr *pushstring();
#define	SINGLE	(typelens[FLOAT] == 4)

typedef char *POINTER;		/* generic pointer type */

#include "sym.h"		/* include symbol table def's */
typedef struct stack *STKPTR;

/* defines to access thru arb pointer */
#define	intValue(s) (*(short *) (s))
#define	floatValue(s) (*(float *) (s))
#define	doubleValue(s) (*(double *) (s))

#define	ptrValue(s) ((struct string *) s) ->ptr
#define	lenValue(s) ((struct string *) s) ->len

#define	floatStk(s) (((struct floatexpr *) (s)) -> k_float)
#define	intStk(s) (((struct intexpr *) (s)) -> k_int)
#define	Kptr(s) (((struct stringexpr *) (s)) -> k_sptr)
#define	Klen(s) (((struct stringexpr *) (s)) -> k_slen)

#define SCANSTK(s) s = (STKPTR) stkptr; s->k_type != STK_END; s = NEXTSTK(s)
#define	NEXTSTK(s) (STKPTR) (((char *) s) + s->k_len)	/* next element on stack */
#define	POPSTK(s) (((char *) s) + s->k_len)	/* move along stack */

