#
#include <stdio.h>
/*			Copyright 1980 by Bill Webb.	 		*/
/*  EVAX    jnl821124  add program timing                               */
#include "basic.h"
#include "stack.h"
#include "tokens.h"

run()
{
register LNR line1;
long now;

srand(1);			/* ADDED RK 5/10/83 */
line1 = cvtlnr();
endchk();
dorun(line1);
if (timerflg) {		/* EVAX - timer code */
	time(&now);
	printf("\n\nTime: %ld secs.\n", now - clock_time) ;
	}
}

dorun(line1) LNR line1;
{
clrsym();
clrstk();
clrio();
curline = findline(line1,NEXTLNR);
inptr = NULL;
execute(curline);
}


execute(linep)
LINEPTR linep;
{
/*
 * execute the line pointed to by "linep".
 * unless its "immed" continue executing until we run out
 * of lines or have an error.
 */
register int c;
register LNR line1;
register struct gosub *g;
int randtime;			/* rand number seek -- ADDED RK 5/10/83 */

for (curline = linep; curline == &immed || isline(curline) ;)
	{
	inptr = curline->l_line;
	if (trace && curline != &immed)
		{
		printf("#%d ",curline->l_lnr);
		flush();
		}
	do
		{
		TESTATTN();
	next:
		c = *inptr;
		if (istoken(c))
			{
			++inptr;
			switch(c)
				{
			case END:
				return;
			case TRACE:
				trace = YES;
				break;
			case NOTRACE:
				trace = NO;
				break;
			case PRINT:
				prtstmt();
				break;
			case INPUT:
			case ASK:
				ask();
				break;
			case READ:
				readdata();
				break;
			case RESTORE:
				restore();
				break;
			case RANDOM:    /* RANDOMIZE added 5/10/83 RK */
				time(&randtime);
				srand(randtime);
				break;
			case DIM:
				dim();
				break;
			case FOR:
				forstmt();
				break;
			case NEXT:
				nextstmt();
				break;
			case REM:
			case QUOTE:
			case PRIME:
			case DATA:
				while (*inptr)
					++inptr;
				break;
			case RETURN:
				endchk();
				if (INFOR())
					exitfor((LNR) NULL);
				g = (struct gosub *) pop(STK_GOSUB);
				curline = g->g_curline;
				inptr = g->g_inptr;
				break;
			case GOSUB:
				line1 = cvtlnr();
				endchk();
				gosub.g_curline = curline;
				gosub.g_inptr = inptr;
				gosub.g_type = STK_GOSUB;
				gosub.g_len = sizeof gosub;
				push(&gosub);
				curline = findline(line1,EXACTLNR);
				inptr = NULL;
				break;
			case GOTO:
				line1 = cvtlnr();
				endchk();
				if (INFOR())
					exitfor(line1);
				curline = findline(line1,EXACTLNR);
				inptr = NULL;
				break;
			case DEF:
				def();
				break;
			case LET:
				let();
				break;
			case IF:
				ifstmt();
				goto nochk;
			case STOP:
				endchk();
				if (curline != &immed)
					err("stop");
				else
					IMMED_STOP();
				break;
			case COLON:
				goto next;
			case ON:
				ongoto();
				break;
			case CHAIN:
				chain();
				break;
#ifdef PLOT
			case HPLOT:
				hplot();
				break;
			case HGR:
				hgr();
				break;
#endif
			case OPEN:
				openstmt();
				break;
			case CLOSE:
				clsstmt();
				break;
			case FLUSH:
				flsstmt();
				break;
			default:
				badsyn();
				}
			}
		else
			let();
		if (inptr)
			endchk();
	nochk:	;
		}
	while (inptr && *inptr);
	/*
	 * fall thru if
	 * (1) inptr == NULL, in which case curline has been reset
	 * (2) *inptr == NULL, we have finished executing the line
	 */
	if (curline == &immed || curline == NULL)
		return;
	if (inptr != NULL)
		curline = NEXTLINE(curline);	/* step to next line */
	else	;				/* curline already set */
	}
}

int getline()
{
/*
 * advance to the next input line if there is one.
 * return NO if we couldn't get another line.
 * 	YES if we could.
 * update curline and inptr appropriately.
 */

if (curline == &immed)
	return(NO);

curline = NEXTLINE(curline);
if (!isline(curline))
	return(NO);
inptr = curline->l_line;
return(YES);
}
