#
/*			Copyright 1980 by Bill Webb.	 		*/
#include "basic.h"
#include "stack.h"
#include "tokens.h"

int rencnt INITZERO;
LNR renbase INITZERO;
LNR renincr INITZERO;
char *outlnr();
LNR curlnr INITZERO;		/* current line being processed */

renumber(line1,incr)
LNR line1;
LNR incr;
{
/*
 * renumber the program. the following tokens may be followed
 * by line numbers.
 * goto, gosub, then
 */
register LINEPTR s;
register LNR *p;
LNR lnr;

renbase = line1; renincr = incr;
p = (LNR *) stkbase; rencnt = 0; lnr = line1;
for (SCANLINES(s))
	{
	*p++ = s->l_lnr;	/* remember the line number */
	if (p >= (LNR *) stktop)
		err("too many lines");
	++rencnt;
	lnr += incr;
	if (lnr <= line1 || lnr > MAXLNR)
		err("invalid renumber parameters");
	}

lnr = line1;
for (SCANLINES(s))
	{			/* actually re-number the lines */
	s->l_lnr = lnr;
	lnr += incr;
	}
for (SCANLINES(s))
	{
	immed.l_lnr = s->l_lnr;
	if (renumline(s))
		{
		storeline(&immed);
		}
	}
}

renumline(s) register LINEPTR s;
{
/*
 * renumber the given line.
 * line numbers are always preceeded by:
 * then, goto, gosub
 * in a "on expr goto" or "on expr gosub" there is a list of line
 * numbers following the "goto" or "gosub"
 */
register char *p;
register char *q;
int l;
int changed;
int onflag;

changed = 0;
onflag = 0;
p = s->l_line;
curlnr = s->l_lnr;
for (q=line, p = s->l_line; *p; )
	{
	switch(*q++ = *p++)
		{
	case ON:
		++onflag;
		break;
	case COMMA:
		if (!onflag)
			break;
		/* fall thru if inside a ON ... GO ... */

	case THEN:
	case GOTO:
	case GOSUB:
		if (isdigit(*p))
			{
			inptr = p;
			l = cvtlnr();
			p = inptr;
			l = newlnr(l);
			q = outlnr(q,l);
			++changed;
			}
		break;
	case COLON:
	case REM:
		onflag = 0;	/* reset onflag at end of statement */
		break;
		}
	}
*q++ = 0;
*q = 0;
immed.l_len = q-line+LINESIZE;
if (immed.l_len&1)
	++immed.l_len;
return(changed);
}

char *outlnr(buffp,lnr) LNR lnr; char *buffp;
{
register char *p;

p = buffp;
sprintf(p,"%u",lnr);
while (*p++)
	;
return(--p);
}

newlnr(lnr) LNR lnr;
{
register int i;
register LNR *p;

for (p = (LNR *) stkbase, i = 0; i < rencnt; ++i)
	if (*p++ == lnr)
		return(renbase+i*renincr);
printf("line %d: %d not found\n",curlnr,lnr);
return(lnr);
}
