/*
 * configuration of Basic.
 * the following #defines are used:
 *
 *	UBC		for UBC options
 *	PLOT		for the UBC plot system
 *	FPU		for FP11C floating point unit exceptions
 *	VAX		for VAX stuff
 *	LINT		for lint
 *	SIGNEDCHARS	for machines with signed (char)
 *	UNIX		for UNIX systems
 *	UCB		for sites with UCB stuff
 *	NOTRCE		removes debug printouts
 *	PRINTHEADER	if headers desired for run & list
 *	EVAX		for University of Wisconsin EE VAX stuff I didn't
 *			make part of the standard Basic
 *	BYEMSG		what to print on exit from basic
 *	ATTNMSG		what to print on SIGINT
 *	IMMED_STOP	what to do if immediate mode stop
 *	NOTRCE		disable debugging trace code
 *	HELP_CMD()	command to give help to user
 *	NOTIFY		who to call if in trouble
 *
 */
#define UBC 1		/* for UBC only stuff */
#define	PRINTHEADER 1	/* for printing headers */
/* #define VAX	1	/* for Vax */
/* #define	EVAX		/*  for EVAX stuff  */

#ifndef LINT
#define UNIX	1	/* If not using LINT assume UNIX (PDP) */
#endif

#define	SIGNEDCHARS	1	

#ifdef VAX
#else
#endif

#ifdef UBC
#define	UNIXV6	1		/* running (modified) UNIX Version6 */
#define	FMOD	1		/* if we have fmod() */
#define	FPU	1		/* got floating point processor */
#define	PLOT	1
#define	ISTTY(n) ttyn(n) != 'x'
#define	EDIT	"/bin/edit"
#define	VI	"/bin/vi"
#define	HELP_CMD()	system("help basic");	/* use system help command */
#else
#define	flush() fflush(stdout)
#ifdef UCB
#define	EDIT	"/usr/ucb/edit"
#define	VI	"/usr/ucb/vi"
#define	HELP_CMD()	system("more /usr/lib/basic.help");	/* print help */
#else
#define	HELP_CMD()	system("cat /usr/lib/basic.help");	/* print help */
#define	EDIT	"/bin/ed"
#define	VI	"/usr/ucb/vi"
#endif	/* UCB */
#define	ISTTY(n) isatty(n)
#endif

#define	DUMMYVEC	1	/* must be at least 1 */

#ifndef INITZERO
#define	INITZERO	/* for C compilers requiring all vars be init'ed */
#endif

#ifdef SIGNEDCHARS
#define	istoken(c)	(c < 0)
#define	UNTOKEN(c)	(-1-(c))	/* convert to subscript */
#else
#define	istoken(c)	(c & 0200)
#define	UNTOKEN(c)	(c & 0177)
#endif

#define	INTEGER(x)	((int) x)
#define	IS	=		/* for V7 compiles make it = */
#define	MAXFILENAME	32
#define	MAXLINELEN	255
#define	MAXLINES	4096	/* maximum # of characters for lines */
#define	EXPANDLINES	2048	/* expansion size */
#define	MAXLNR	32767
#define	MAXINT	32767
#define	LEN_FUZZ	6	/* close enough to not move */

/* space allocations */
#define	MAXSTACK	512
#define	MAXSTRING	255	/* maximum string length max 255 */
#define	MAXSUBS	2	/* for now */
#define	MAXSYMSPACE	2048
#define	EXPANDSYM	2048
#define MAXSTRSPACE	2048
#define	MAXTYPE	4

#ifdef EVAX
#define	ATTNMSG	"\ninterrupt!"
#define	OLDMSG	"you must specify a program name with the OLD command"
#define	BYEMSG "goodbye!\n"
#define IMMED_STOP()	err("use bye to exit basic.") ;  /*EVAX*/
#define	TABBLANKS	1	/* expand tabs to blanks */
#define	SIGNON "UBC/EVAX-basic Ver 1.4. Please report problems to %s.",NOTIFY /* EVAX */
#define	NOTIFY	"your TA"
#define	TIMER	1
#else
#define	ATTNMSG	"\nattn!"
#define	OLDMSG	"file name expected"
#define	BYEMSG	""
#define IMMED_STOP()	exit(0);	/* if from keyboard then stop basic */
/* #define	TABBLANKS	1	/* don't expand tabs to blanks */
#define	SIGNON	""			/* no signon msg */
#define	NOTIFY	"a staff member"
#define	TIMER	0
#endif
#define	CALL_SYS	1
#define	NOTRCE	1			/* disable trace */
