#include "basic.h"
/*			Copyright 1980 by Bill Webb.	 		*/
#include "stack.h"
#include "tokens.h"

ifstmt()
{
LNR line1;

if (fexpr() != 0)
	{			/* if statment is true */
	if (*inptr == THEN)
		++inptr;
	if (isdigit(*inptr))
		{
		line1 = cvtlnr();
		endchk();
		if (INFOR())
			exitfor(line1);
		curline = findline(line1,EXACTLNR);
		inptr = NULL;
		}
	}
else
	{			/* its false */
	curline = NEXTLINE(curline);		/* step to next line */
	inptr = NULL;			/* start a new line */
	}
}

forstmt()
{
/*
 * for var=expr to expr step expr
 */
struct forstack f;
register SYMPTR v;
int type;
double fval;

f.k_len = sizeof (struct forstack);
f.k_type = STK_FOR;
f.k_var = v = getvar(&type,NO);
if (type != FLOAT)
	typeerr();
expectc(EQ);
fval = fexpr();
if (SINGLE)
	floatSym(v) = fval;
else
	doubleSym(v) = fval;
expectc(TO);
f.k_last = fexpr();
if (*inptr == STEP)
	{
	++inptr;
	f.k_incr = fexpr();
	}
else
	f.k_incr = 1.0;
endchk();
f.k_inptr = inptr;
f.k_curline = curline;

findnext();

f.k_ninptr = inptr;
f.k_ncurline = curline;		/* remember the location of NEXT statement */

inptr = f.k_inptr;
curline = f.k_curline;		/* restore to current position */
push(&f);
if ((f.k_incr >= 0.0) ? fval > f.k_last : fval < f.k_last)
	popfor(YES);		/* immediately exit the for ... next loop */
}

findnext()
{
/*
 * scan thru the input looking for the matching "next" statment to
 * the currently active "for" statement.
 * only real complication in insuring that we find the for and next
 * statements.
 */
register int level = 1;
register int c, lastc;

do
	{
	TTRACEF(("findnext - scan line %d\n",curline->l_lnr));
	lastc = COLON;
	for  ( ;c = *inptr++; lastc = c)
		{
		if (lastc == COLON)
			if (c == FOR)
				++level;
			else if (c == NEXT && --level == 0)
				{
				TTRACEF(("found NEXT @ line %d\n",curline->l_lnr));
				return;
				}
		}
	}
while (getline());
err("No NEXT statement found for FOR statement");
}

popfor(flag)
{
/*
 * exit the current FOR ... NEXT group.
 * flag == YES	set inptr and curline from the stack
 *	   NO	leave as is (exit is via return/goto)
 */
register struct forstack *s = (struct forstack *) stkptr;
register SYMPTR v;
int type;

TTRACEF(("popfor - pop out of for loop\n"));
if (s->k_type != STK_FOR)
	err("for missing");
if (flag)
	{
	inptr = s->k_ninptr;
	curline = s->k_ncurline;
	v = s->k_var;
	if (!endtest())
		{
		if (getvar(&type,NO) != v)
			err("bad for nesting");
		}
	endchk();
	}
pop(STK_FOR);		/* for loop terminated */
}

exitfor(lnr) LNR lnr;
{
/*
 * test for exit from the currently running FOR ... NEXT statement.
 * if "line" is outside the line number limits of the current for
 * statement then we should use popfor() to pop off the for stack.
 * keep testing for further for loops to pop out of.
 */
register struct forstack *s;

while ((s = (struct forstack *) stkptr) -> k_type == STK_FOR)
	{
	TTRACEF(("exitfor: test if %d < %d < %d\n",s->k_curline->l_lnr,lnr,s->k_ncurline->l_lnr));
	if (lnr < s->k_curline->l_lnr || lnr > s->k_ncurline->l_lnr)
		popfor(NO);
	else
		break;
	}
}

nextstmt()
{
register struct forstack *s = (struct forstack *) stkptr;
register SYMPTR v;
int type;
double f;

if (s->k_type != STK_FOR)
	err("NEXT: for missing");
v = s->k_var;
if (!endtest())
	{
	if (getvar(&type,NO) != v)
		err("bad for nesting");
	}
endchk();
if (SINGLE)
	f = floatSym(v) += s->k_incr;
else
	f = doubleSym(v) += s->k_incr;
if ((s->k_incr >= 0.0) ? f > s->k_last : f < s->k_last)
	pop(STK_FOR);		/* for loop terminated */
else
	{
	inptr = s->k_inptr;
	curline = s->k_curline;
	}
}


typeerr()
{
err("invalid type");
}

readdata()
{
register VALPTR v;
int type;

while (!endtest())
	{
	v = getsvar(&type);
	optional(askdelims);
	if (data.g_inptr == NULL)
		getdata();
	while (*data.g_inptr == ' ')
		++data.g_inptr;
	if (*data.g_inptr == 0)
		getdata();
	cvtdata(v,type,&data.g_inptr);
	}
}

getdata()
{
register char *p;
register LINEPTR s;

for (s = data.g_curline; isline(s); s = NEXTLINE(s))
	{
	p = s->l_line;
	if (*p++ == DATA)
		{
		data.g_inptr = p;
		data.g_curline = NEXTLINE(s);	/* point to next one */
		return;
		}
	}
err("out of data");
}

cvtdata(v,type,ptr) char **ptr; VALPTR v;
{
/*
 * convert string pointed to by "ptr" of type "type" and
 * store it thru "vp".
 */
char *p = *ptr;

while (*p == ' ')
	++p;
switch(type)
	{
case INT:
	intValue(v) = cvtnumber(&p,MAXINT);
	break;
case FLOAT:
	if (SINGLE)
		floatValue(v) = cvtnumber(&p,MAXINT);
	else
		doubleValue(v) = cvtnumber(&p,MAXINT);
	break;
case STRING:
	cvtstring(&p);
	storestring((struct string *) v);
	break;
default:
	badtype();
	}
while (*p == ' ')
	++p;
if (*p)
	if (*p == ',')
		++p;
	else
		err("bad input");
*ptr = p;
}

cvtstring(cvtptr) char **cvtptr;
{
register int c;
register char *p;
register char *ptr;
int len;

p = *cvtptr;
if (*p == '"' || *p == '\'')
	c = *p++;
else
	c = ',';
ptr = p;
while (*p && *p != c)
	++p;
len = p - ptr;
if (*p && *p != ',')
	++p;
*cvtptr = p;
pushstring(ptr,len);
}

ongoto()
{
/*
 * on expr goto s1,s2, ... sn
 * on expr gosub s1, s2, ... sn
 */
register int l;
register LNR lnr;
register int s;

l = fexpr();
s = *inptr++;
if (s != GOTO && s != GOSUB)
	badsyn();
if (l <= 0)
	err("on index less than one");
while (!endtest())
	{
	lnr = cvtlnr();
	if (--l == 0)
		{
		if (s == GOSUB)
			{
			while (!endtest())
				++inptr;
			gosub.g_curline = curline;
			gosub.g_inptr = inptr;
			gosub.g_type = STK_GOSUB;
			gosub.g_len = sizeof gosub;
			push(&gosub);
			}
		else
			if (INFOR())
				exitfor(lnr);
		curline = findline(lnr,EXACTLNR);
		inptr = NULL;
		return;
		}
	if (*inptr == COMMA)
		++inptr;
	else
		break;
	}
err("on index too big");
}

#ifdef PLOT
hgr()
{
pltcls();
pltini(0);
}

hplot()
{
register int x,y;

do
	{
	x = fexpr();
	expectc(COMMA);
	y = fexpr();
	plot(x,y);
	pendn();
	}
while (*inptr == TO && ++inptr);
penup();
}
#endif
