#
#include <stdio.h>
/*			Copyright 1980 by Bill Webb.	 		*/
/*   EVAX  modified by Jerry Lieberthal 821118                          */
/*   EVAX  lines 229-230 changed for tab(const)                         */
/*   EVAX  added the sys functions jnl821203                            */
/*   EVAX  fix ? symbol on input # stmt                                 */
/*   EVAX  allow the maximum number of files to be used                 */
/*                                                                      */

#include "basic.h"
#include "stack.h"
#include "tokens.h"
#include <sgtty.h>

/*
 * IMPORTANT NOTE:
 * because basic manages its own space, via "sbrk", and it assumes that
 * there is no other space management going on (e.g. CALLOC) that calls
 * "sbrk" after startup, it would get fowled up by the buffer allocation
 * done by the standard I/O package. Therefore, it does its own STDIO
 * buffer allocation from its own pool of buffers. 
 * ... modify at your own risk.
 */

#ifdef	EVAX
#define	MAXUNIT	_NFILE  /* EVAX - change max size  */
#define	MAXBUF	_NFILE	/* on Vax there's lots of room */
#else
#define	MAXUNIT 5       /* EVAX - default as it came.. */
#define	MAXBUF	7	/* allow load/save commands to have unit */
#endif
#define	MAXSTR 255	/* maximum string for temp file */

#ifdef UBC
#define ON_CBREAK RAW	/* CBREAK_ON ==> ON_CBREAK to keep cpp happy */
#else
#define ON_CBREAK CBREAK
#endif

#define	INUNIT	0
#define	OUTUNIT	1
#define KEYBOARD  0     /*  filedes for stdio  */
#define HIGHBITS  0177777
#define CBREAK_OFF (HIGHBITS - ON_CBREAK)
#define ON_ECHO   ECHO
#define ECHO_OFF  (HIGHBITS - ON_ECHO)

struct iotab
{
int io_flag;		/* if currently open etc. */
int io_col;		/* current column */
FILE *io_ptr;		/* input/output stdio table entry */
} units[MAXUNIT] INITZERO;	/* Basic unit table */

char buffers[MAXBUF][BUFSIZ];
char bufflg[MAXBUF];
char pflgs[_NFILE];
FILE *popen();

FILE *xopen(file,how) char *file, *how;
{
register FILE *f;

if (*file == '!')		/* output via pipe */
	{
	if (f = popen(file+1,how))
		pflgs[fileno(f)]++;
	}
else
	f = fopen(file,how);
if (f != NULL)
	assbuf(f);
return(f);
}

xclose(file) register FILE *file;
{
register char *b = file->_base;
register int i;

i = fileno(file);
if (pflgs[i])
	pclose(file);
else
	fclose(file);
pflgs[i] = 0;
for (i=0; i<MAXBUF; ++i)
	if (b == buffers[i])
		bufflg[i] = 0;
}

assbuf(f) register FILE *f;
{
register int i;

for (i=0; i<MAXBUF; ++i)
	if (bufflg[i] == 0)
		{
		setbuf(f,buffers[i]);
		++bufflg[i];
		return;
		}
err("no buffers available");
}

initio()
{
assbuf(stdin);
if (!xflg)
	setout();
clrio();
}

clrio()
{
register struct iotab *i;

for (i = units; i < units+MAXUNIT; ++i)
	{
	if (i->io_flag)
		iocls(i);
	}
units[INUNIT].io_flag = INPUT; units[INUNIT].io_ptr = stdin;
units[INUNIT].io_col = 1;
units[OUTUNIT].io_flag = OUTPUT; units[OUTUNIT].io_ptr = stdout;
units[OUTUNIT].io_col = 1;
}

iocls(i) register struct iotab *i;
{
if (i->io_flag)
	{
	if (i->io_ptr != stdin && i->io_ptr != stdout)
		xclose(i->io_ptr);
	i->io_flag = 0;
	i->io_ptr = NULL;
	i->io_col = 1;
	}
}

struct iotab *getunit(flag,defunit)
{
register int n;
register struct iotab *i;

if (*inptr != SHARP)
	n = defunit;
else
	{
	++inptr;
	n = fexpr();
	if (!endtest())
		expectc(COMMA);
	}
if (n < 0 || n >= MAXUNIT)
	err("invalid unit %d",n);
i = &units[n];
if (flag && flag != i->io_flag)
	err("unit not opened for %s",(flag == INPUT ? "input":"output"));
return(i);
}

openstmt()
{
/*
 * open "file" for input/output #n
 */
register struct iotab *i;
char *code;
char *file;
int how;

expr();
file = strpop();
expectc(FOR);
how = *inptr;
switch(how)
	{
case INPUT:
	code = "r";
	break;
case OUTPUT:
	code = "w";
	break;
case APPEND:
	code = "a";
	how = OUTPUT;		/* same as OUTPUT mostly */
	break;
default:
	badsyn();
	}
++inptr;
i = getunit(NULL, (how == INPUT ? INUNIT : OUTUNIT)); /* open for either */
i->io_ptr = xopen(file,code);
if (i->io_ptr == NULL)
	err("cannot open %s",file);
i->io_flag = how;
i->io_col = 1;
}

prtstmt()
{
/*
 * process the print and print using statments.
 */
register struct iotab *i = getunit(OUTPUT,OUTUNIT);

col = i->io_col;
if (*inptr == USING)
	{
	++inptr;
	printusing(i->io_ptr);
	}
else
	print(i->io_ptr);
i->io_col = col;
}

clsstmt()
{
register struct iotab *i;

i = getunit(NULL,NULL);
iocls(i);
}

flsstmt()
{
/*
 * flush output unit to file.
 */
register struct iotab *i;

i = getunit(OUTPUT,OUTUNIT);
if (i->io_flag == OUTPUT)
	fflush(i->io_ptr);
}

print(file) FILE *file;
{
/*
 * output via "print" statment.
 * "file" has already been provied, now do the actual printing.
 */
register STKPTR s;
register int l;
int	flag = NO,
	lastdelim = 0,
	type;
double f;

while (!endtest())
	{
	flag = NO;
	if (*inptr == TAB)		/* tab(expr) */
		{
		++inptr;
		l = fexpr();
		if (l < 0 || l > 80)
			l = 1;
		expectc(RPAR);
		/*
		if (!flag) {
		    col = 1 ;
                }
		*/
#ifdef TABBLANKS
		while (col < l)
		       printstr(" ", 1, file) ;  /*  EVAX  */
#else
		while (col <= l-8)
			printstr("\t",1,file);	/* use tab to get close */
		TTRACEF(("tab(%d) @%d ==> %d blanks\n",l,col,l-col));
		if (col < l)
			printstr("        ",l-col,file);   /* blank the rest */
#endif
		type = STRINGEXPR;	/* fix tab problems before ; */
		}
	else				/* not tab(expr) */
		{
		expr();
		s = (STKPTR) stkptr;
		switch(type = s->k_type)
			{
		case FLOATEXPR:
			f = popfloat();
			if (f > 0 && lastdelim == SEMICOLON)
				printstr(" ",1,file);		/* kludge */
			printstr(fprint(f),MAXSTR,file);
			break;
		case STREXPR:
			pop(ANYTYPE);
			printstr(Kptr(s),Klen(s),file);
			break;
		default:
			badtype();
			}
		}
	switch(lastdelim = *inptr)
		{
	case COMMA:
		++inptr;
		printstr("\t",1,file);
		if ((col%16) == 9)
			printstr("\t",1,file);
		flag = YES;		/* suppress the NL */
		break;
	case SEMICOLON:
		++inptr;
		if (type == FLOATEXPR)
			printstr(" ",1,file);	/* put in trailing blank */
		flag = YES;
		break;
	case NULL:
	case COLON:
		break;
	default:
		badsyn();
		}
	}
if (!flag)
	printstr("\n",1,file);
if (file == stdout)
	fflush(file);
}

printstr(ptr,len,file) char *ptr; FILE *file;
{
/*
 * output the string pointed to be "ptr" of up the "len" characters
 * to the file specified. update "col" appropriately.
 */
register int c;
register int l;
register char *p;

l = len; 
if ((p = ptr) == NULL && l)
	err("invalid string pointer");
while (--l >= 0 && (c = *p++))
	{
	switch(c)
		{
	case '\n':
	case '\r':
		col = 1;
		break;
	case '\t':
		col = ((col+8)&~07)+1;
		break;
	default:
		col++;
		break;
		}
	putc(c,file);
	}
}

char askdelims[] IS { COMMA, SEMICOLON, 0 };
ask()
{
int len;
char *ptr;
register VALPTR v;
int type;
FILE *f;

f = getunit(INPUT,INUNIT)->io_ptr;
askptr = askline;
askline[0] = 0;
while (!endtest())
	{
	if (*inptr == QUOTE || *inptr == PRIME)
		{
		strconst(*inptr++);
		popstring(&ptr,&len);
		printstr(ptr,len,stdout);
		optional(askdelims);
		}
	v = getsvar(&type);
	optional(askdelims);
	while (*askptr == ' ')
		++askptr;
	if (*askptr == 0)
		{
		if (f == stdin)
		printf("?");
		flush();
		if (readline(askline,f) < 0)
			{
			TESTATTN();
			err("EOF on input");
			}
		askptr = askline;
		}
	cvtdata(v,type,&askptr);
	}
}

char strtemp[MAXSTR];
char *strpop()
{
char *str;
int len;

popstring(&str,&len);
if (len >= MAXSTR-1)
	err("string too long");
move(len,str,strtemp);
strtemp[len] = NULL;
return(strtemp);
}

#ifdef	CALL_SYS
call_sys (sysval)

register	int	*sysval ;

#define	SYSOK	0
#define	SYSERR	1

{
	switch (*sysval) {

	case 1:	/*	disable echo	*/
		set_tty (ECHO_OFF) ;
		break ;

	case 2:	/*	enable echo	*/
		set_tty (ON_ECHO) ;
		break ;

	case 3:	/*	get one char from keyboard	*/
		set_tty (ON_CBREAK) ;
		*sysval = getchar() ;
		set_tty (CBREAK_OFF) ;
		return ;

	case 4:	/*	dump symbol table */
		dumpsym() ;
		break ;
	case 5:
	case 6:
		err ("not yet implemented sys ( %d )", *sysval) ;
		break ;

	case 7:			/*	exit basic from basic	*/
		printf(BYEMSG);
		exit(0);

	default:
		err ("sys ( %d ) is illegal.", *sysval) ;

	}

	*sysval = SYSOK ;
	return ;

}


/*	set tty routine.	EVAX	*/

set_tty (way)

int	way ;
{

	struct	sgttyb	tty	;

	if (gtty (KEYBOARD, &tty) >= 0)
	{
		tty.sg_flags = (way == ON_ECHO || way == ON_CBREAK)
			? tty.sg_flags | way : tty.sg_flags & way ;
		stty (KEYBOARD, &tty) ;
	}
	return ;
}

#endif

