#include "basic.h"
/*			Copyright 1980 by Bill Webb.	 		*/
/*  EVAX jnl821203  evaluate sys functions                              */
/*  EVAX jnl821212  add sleep/dat$ functions                            */
/*  EVAX jnl821208  add mod function                                    */

#include "stack.h"
#include "tokens.h"

#define MAX_SLEEP	160		/*  max value for sleep(x) */


double sqrt(), exp(), log(), atan(), sin(), cos(), fabs(), fmod();
double floor();

function()
{
switch(*inptr)
	{
case LEFT:
	fnarg("si");
	break;
case RIGHT:
	fnarg("si");
	break;
case MID:
	fnarg("sii");
	break;
case SYSTEM:
case LEN:
case VAL:
case ASCII:
	fnarg("s");
	break;
case DATE:
case TIME:
	fnarg("");
	break;
case ARG:
case SYS:
case CHR:
case SLEEP:
	fnarg("i");
	break;
case SIN:
case COS:
case TAN:
case ATN:
case SQR:
case EXPFN:
case LOG:
case INTFN:
case ABS:
case STR:
	fnarg("f");
	break;
case MOD:
	fnarg("ff");
	break;
default:
	return(0);
	}
return(1);
}

fnarg(args) char *args;
{
int op;
register char *s;
register int i;
char *p;
double x, f;
int n;
char ch;
int len;
register struct stringexpr *stk;

op = *inptr++;
for (s=args; *s; )
	{
	expr();
	switch(*s++)
		{
	case 's':
		if (((STKPTR) stkptr)->k_type != STRINGEXPR)
			err("string argument required");
		break;
	case 'i':
	case 'f':
		if (((STKPTR) stkptr)->k_type != FLOATEXPR)
			err("numeric argument required");
		break;
	default:
		badtype();
		}
	if (*s)
		expectc(COMMA);
	}
expectc(RPAR);
switch(op)
	{
case SYSTEM:
	s = strpop();		/* got a string in UNIX format */
	i = exec("/bin/sh","sh","-c",s,0);
	pushint(i);
	break;
case LEFT:
	i = popint();
	stk = (struct stringexpr *) stkptr;
	if (i > stk->k_slen)
		err("string too short");
	stk->k_slen = i;
	break;
case RIGHT:
	i = popint();
	stk = (struct stringexpr *) stkptr;
	n = stk->k_slen-i;	/* amount to adjust */
	if (n < 0)
		err("string too short");
	stk->k_sptr += n;
	stk->k_slen = i;
	break;
case MID:
	i = popint();
	n = popint()-1;
	stk = (struct stringexpr *) stkptr;
	if (n+i > stk->k_slen)
		err("string too short");
	stk->k_sptr += n;
	stk->k_slen = i;
	break;
case LEN:
	stk = (struct stringexpr *) stkptr;
	pop(STRINGEXPR);
	pushint(stk->k_slen);
	break;
case CHR:
	ch = popint();
	stk = pushstring(&ch,1);
	stk->k_sptr = allocstring(&ch,1,1);
	break;
case STR:
	p = fprint(popfloat());
	len = length(p);
	stk = pushstring(p,len);
	stk->k_sptr = allocstring(p,len,len);
	break;
case ARG:
	len = popint();
	p = len >= argcnt ? "" : argvec[len];
	len = length(p);
	stk = pushstring(p,len);
	stk->k_sptr = allocstring(p,len,len);
	break;
case ASCII:
	stk = (struct stringexpr *) stkptr;
	pop(STRINGEXPR);
	pushint(*stk->k_sptr);
	break;
case VAL:
	stk = (struct stringexpr *) stkptr;
	pop(STRINGEXPR);
	p = stk->k_sptr;
	len = stk->k_slen;
	while (len > 0 && *p == ' ')
		{--len; ++p; }
	pushfloat(cvtnumber(&p,len));
	break;
case SIN:
	pushfloat(sin(popfloat()));
	break;
case COS:
	pushfloat(cos(popfloat()));
	break;
case TAN:
	x = popfloat();
	pushfloat(sin(x)/cos(x));
	break;
case SQR:
	pushfloat(sqrt(popfloat()));
	break;
case LOG:
	pushfloat(log(popfloat()));
	break;
case EXPFN:
	pushfloat(exp(popfloat()));
	break;
case ATN:
	pushfloat(atan(popfloat()));
	break;
case ABS:
	pushfloat(fabs(popfloat()));
	break;
case INTFN:
	pushfloat(floor(popfloat()));
	break;
case MOD:
	f=popfloat();
	x=popfloat();              /* EVAX */
	pushfloat(fmod(f,x));
	break; 
#ifdef CALL_SYS
case SYS:
        len = popint() ;  /*  EVAX get the sys value  */
	call_sys(&len) ;  /*  EVAX do the function requested  */
	pushint(len)  ;  /*  EVAX return a result  */
	break ;         /*  EVAX end sys eval  */
#endif
case SLEEP:
	i = popint() ;  /*  EVAX get the sleep value  */
	if (i <= 0 || i > MAX_SLEEP)  err("sleep value of %d is illegal", i);
	sleep ((unsigned) i) ;
	pushint(0);    /*  EVAX must put some value back  */
	break ;        /*  EVAX end function  */
case TIME:	/* return time in form hh:mm:ss	*/
	timefn();
	break;
case DATE:	/* return date in form yy/mm/dd	*/
	datefn();
	break;
default:
	err("function not implemented yet");
	}
}

#ifndef FMOD
#ifdef EVAX
double fmod(f,x) double f,x;
{
/*
 * funny fake fmod for EVAX 
 */
long i, l;

i = (long) floor(f) ;     /* EVAX */
l = (long) floor(x);      /* EVAX */
l = l % i ;            /* EVAX */
return((double) l);
}
#else
double fmod(f,x) double f,x;
/*
 * fmod for non-UBC systems
 */
{
return(f - floor(f/x) * x);
}
#endif
#endif

datefn()
{
/*
 * stack the current date in format yy/mm/dd
 */
#include <time.h>
long now;
char datestr[10];
struct tm *localtime();
register struct tm *tm;
register int len;

time(&now);
tm = localtime(&now);
sprintf(datestr,"%02d/%02d/%02d",tm->tm_year,tm->tm_mon+1,tm->tm_mday);
len = strlen(datestr);
pushstring(allocstring(datestr,len,len),len);
}

timefn()
{
/*
 * stack the current time in format hh:mm:ss
 */
#include <time.h>
long now;
char timestr[10];
struct tm *localtime();
register struct tm *tm;
register int len;

time(&now);
tm = localtime(&now);
sprintf(timestr,"%02d:%02d:%02d",tm->tm_hour,tm->tm_min,tm->tm_sec);
len = strlen(timestr);
pushstring(allocstring(timestr,len,len),len);
}
