#include <stdio.h>
#include <ctype.h>
/*			Copyright 1980 by Bill Webb.	 		*/
/*  EVAX  jnl821124  add goodbye after exit                             */
/*  EVAX  jnl821124  add vars command to dump symbol table              */
/*  EVAX  jnl821124  add unsave command (std basic)                     */
/*  EVAX  jnl821124  add catalog command (std basic)                    */
/*  EVAX  jnl821124  add timeon, timeoff commands for profiling         */
/*  EVAX  jnl821201  add standard header line (pgm name, etc.)          */

#include "basic.h"
#include "tokens.h"
#include "stack.h"

#define	RENBASE	10
#define RENINCR	10

char *prompt;
char tempfile[32];

/* the following basic commands exist: */
char *cmds[] IS
{
"old", "save", "bye", "dump", "edit", "vi", "!", "mode", "delete", "load",
"renumber", "list", "del", "scr", "run", "clear", "auto",
"vars", "catalog", "timeon", "timeoff", "unsave", "help",
"merge", 
0 };

int mode = 0;		/* current mode of operation */
char *modes[] = { "int", "fp", "unix", "ibm", 0 };
char *prompts[] = { "> ",  "] ",  "^ ",   "READY\n" };

moncmd()
{
/*
 * look for commands that can only be executed from the keyboard.
 */
register int i;
char *file;
LNR line1; LNR line2;
extern char lnrdelims[];
#define	MAXWORD	16		/* max length for a command verb */
char word[MAXWORD];

inptr = line;
while (isspace(*inptr))
	++inptr;
getword(word,MAXWORD);
if ((i = lookup(word,cmds)) >= 0)
	{
	switch(i)
		{
	case 0:			/* old */
	case 9:			/* load */
		old(inptr,YES);
		printf("%s loaded, %d lines\n",curfile,linecnt);
		break;
	case 1:
		file = *inptr == 0 ? curfile : inptr;
		save(file);
		printf("%s saved, %d lines\n",file,linecnt);
		break;
	case 2:
		printf(BYEMSG);
		exit(0);
	case 3:
		dumpsym();
		break;
	case 4:
		edit(EDIT);
		break;
	case 5:
		edit(VI);
		break;
#ifdef UNIX
	case 6:
		system(inptr);
		break;
#endif
	case 7:		/* mode */
		getword(word,MAXWORD);
		i = lookup(word,modes);
		if (i >= 0)
			{
			prompt = prompts[mode = i];
			printf("%s mode\n",modes[i]);
			}
		else
			err("invalid mode");
		break;
	case 10:		/* renumber */
		line1 = RENBASE;
		line2 = RENINCR;
		getlnrs(&line1,&line2,DEFAULTLNRS);
		renumber(line1,line2);
		break;
	case 11:		/* list */
#ifdef PRINTHEADER
		printheader() ; /* EVAX */
#endif
		getlnrs(&line1,&line2,LISTLNRS);
		list(line1,line2,stdout);
		break;
	case 12:		/* del */
	case 8:		/* delete */
		getlnrs(&line1,&line2,LISTLNRS);
		delete(line1,line2);
		break;
	case 13:		/* scr atch */
		delete(MINLNR,MAXLNR);
		clrstk();
		clrsym();
		break;
	case 14:		/* run */
		if (timerflg == YES) time (&clock_time);
#ifdef PRINTHEADER
		printheader() ;
#endif
		run();
		break;
	case 15:		/* clear */
		getword(word,MAXWORD);
		if (!equal(word,"stack"))
			clrsym();
		if (!equal(word,"vars"))
			clrstk();
		break;
	case 16:		/* auto */
		line1 = RENBASE;
		line2 = RENINCR;
		getlnrs(&line1,&line2,DEFAULTLNRS);
		autonumber(line1,line2);
		break;
/* #ifdef EVAX */
	case 17:	/* vars */
		notimpl();
		break ;

	case 18:
		system("ls") ;
		break ;

	case 19:
		timerflg = YES ;
		break ;
	case 20:
		timerflg = NO ;
		break ;
	case 21:
		deletef (inptr) ;
		break ;
/* #endif */
	case 22:
		HELP_CMD();
		break;
	case 23:		/* merge file */
		copy(tempfile,inptr);
		old(inptr,NO);
		printf("%s merged, now %d lines\n",tempfile,linecnt);
		break;
	default:
		return(NO);
		}
	return(YES);
	}
return(NO);
}

int lookup(word,cmds) char *word, *cmds[];
{
register int i;
register char *s;

for (i=0; s = cmds[i]; ++i)
	{
	if (word[0]==s[0] && equal(word,s))
		{
		inptr += length(s);
		while (isspace(*inptr))
			++inptr;
		return(i);
		}
	}
return(-1);
}

getword(word,len) char *word;
{
/*
 * collect the next word off of the input line.
 * convert upper to lower case. stop on non-alphabetic
 * character.
 */
register char *p;
register char *w;
register int c;


p = inptr; w = word;
if (*p == '!')
	*w++ = *p;
else
	do
		{
		c = *p++;
		if ('A' <= c && c <= 'Z')
			c -= 'A'-'a';
		if ('a' <= c && c <= 'z')
			*w++ = c;
		else
			break;
		}
	while (--len > 0);
*w = 0;
}
		

/* ARGSUSED */
edit(file) char *file;
{
#ifdef UNIX
long now;
long modtime();

sprintf(tempfile,"/tmp/Ba%05d",getpid());
save(tempfile);
time(&now);
exec(file,file,tempfile,0);
if (modtime(tempfile) > now)
	{
	old(tempfile,YES);
	printf("%d lines\n",linecnt);
	}
else
	printf("No changes made while in editor\n");
unlink(tempfile);
#endif
#ifndef UNIX
notimpl();
#endif
}

/* ARGSUSED */
/* VARARGS 1 */
exec(file,args) char *file, **args;
{
static int status;
#ifdef UNIX
register int pid;
register int oldattn;
register int i;

if ((pid = fork()) == 0)
	{
	closeall();
	execv(file,&args);
	printf("no %s\n",file);
	exit(1);
	}
oldattn = signal(SIG_ATTN,1);
while ((i = wait(&status)) != -1 && i!=pid)
	;
signal(SIG_ATTN,oldattn);
#endif
#ifndef UNIX
notimpl();
#endif
return(status);
}

chain()
{
LNR lnr;
char *file;

file = sexpr();
if (*inptr == COMMA)
	{
	++inptr;
	lnr = cvtlnr();
	}
else
	lnr = 0;
endchk();
old(file,YES);
curline = findline(lnr,NEXTLNR);
inptr = NULL;
}

notimpl()
{
	err("not implemented");
}

deletef (file)                       /* EVAX */
register	char	*file ;      /* EVAX */
{
	if (*file == NULL) 
		err("you must specify a program name to delete.");
	if (unlink(file) != 0)
		err("program %s could not be found.", file) ;
	printf("file %s deleted\n",file);
}

#ifdef PRINTHEADER
printheader() /*  EVAX  print a header as standard basic  */
{
long	timval ;
char	*ctime() ;
char	*getlogin() ;

    time(&timval) ;  /*  get current time  */
    if (curfile[0] == 0)
	printf("[noname]") ;
    else
	printf("%s", curfile) ;
    printf("\t%s\t%s\n\n", username, ctime (&timval));
    flush();
}
#endif
