#
#include "/usr/sys/stat.h"

#define	cpu_rate	100.0/hour
#define	fork_rate	0.05
#define	hour		3600.0

#define	MAXUID	256
#define	STAT_SIZE	(sizeof stats)
#define	PSTAT_SIZE	(sizeof pstats)
#define	ID_MASK	017	/* ID mask for ID byte */
#define	ID_TIME		(ST_TIME>>8)
#define	ID_ELAPSED	(ST_ELAPSED>>8)
#define	ID_UID		(ST_UID>>8)
#define	ID_PID		(ST_PID>>8)
#define	ID	0161
#define	ID_CPU	((ST_CPU+ST_ACC)>>8)
#define	ID_LP	((ST_LP+ST_ACC)>>8)
char users[MAXUID][8];
char buf[518];
int id,uid,pid;
int pages, lines, plot;
float elt,utime,stime;
float cpu,cost;
float tcpu,tcost;
float size;
extern int fin;

struct stats
{
char s_name[8];
int s_count;	/* number of processes */
float s_utime;
float s_stime;
float s_size;
} stats;

struct pgstats
{
int p_count;		/* number of jobs */
float p_pages;
float p_lines;
float p_plot;
} pstats;

int count;
float eltime;
float elt;
int vflg;
int lflg;		/* if returning long cpu times */

char *filep "/usr/adm/cpu-stats";
char pfilep[64];	/* the page info file */
int file;
int pfile;
double lword();

main(argc,argv) char **argv;
{
register struct stats *s;
register int i;
register char *argp;

rdusers(&users,MAXUID,&buf);
--argc; ++argv;
while (argc>0)
	{
	--argc;
	if ( *(argp = *argv++) == '-')
		{
		while (*argp)
			switch(*argp++)
				{
			case 'l':
				++lflg;
				break;
			case 'f':
				filep = *argv++;
				--argc;
				break;
			case 'v':
				++vflg;
				break;
				}
		}
	else 
		file = argp;
	}
copy(pfilep,filep);
append(pfilep,".p");
if ((file = open(filep,2)) < 0)
	err("can't open %s",filep);
if ((pfile = open(pfilep,2)) < 0)
	err("can't open %s",pfilep);
if (vflg)
	printf("elt	uid	pid	utime	stime	size\n");
for (;;)
	{
	id = byte();
	if (id < 0)
		exit();
	if (id != ID_CPU && id != ID_LP)
		continue;
	if (id & ID_ELAPSED)
		{
		elt = word()/60.0;
		eltime =+ elt;
		}
	if (id & ID_UID)
		if ((uid = byte()) < 0)
			break;
	if (id & ID_PID)
		pid = word();
	switch(id)
		{
	case ID_CPU:
		if (lflg)
			{
			utime = lword()/60.0;
			stime = lword()/60.0;
			}
		else
			{
			utime = word()/60.0;
			stime = word()/60.0;
			}
		cpu = utime+stime;
		cost = cpu*cpu_rate;
		size = word()*64.0/2048.;
		s = &stats;
		rdstat(uid);
		s->s_utime =+ utime;
		s->s_stime =+ stime;
		s->s_size =+ size;
		s->s_count++;
		wtstat(uid);
		if (vflg) printf("%7.2f	%-8.8s %7d	%7.2f	%7.2f	%7.2f\n",elt,users[uid],pid,utime,stime,size);
		break;
	case ID_LP:
		rdstat(uid);
		rdpstat(uid);
		++pstats.p_count;
		pages = word();
		lines = word();
		plot = word();
		pstats.p_pages =+ pages;
		pstats.p_lines =+ lines;
		pstats.p_plot =+ plot;
		wtpstat(uid);
		if (vflg) printf("%-8.8s %6l %6l %6l\n",
			users[uid],pages,lines,plot);
		break;
		}
	}
}

byte()
{
register int i;

i = getc(&fin);
return(i);
}

word()
{
return(getw(&fin));
}

double lword()
{
long itol();
register int i1, i2;
i1 = word();
i2 = word();
return(itol(i1,i2)+0.0);
}


rdstat(i)
{
seek(file,i*STAT_SIZE,0);
if (read(file,&stats,STAT_SIZE) != STAT_SIZE)
	clear(&stats,STAT_SIZE);
move(8,users[uid],stats.s_name);
}

wtstat(i)
{
seek(file,i*STAT_SIZE,0);
write(file,&stats,STAT_SIZE);
}

rdpstat(i)
{
seek(pfile,i*PSTAT_SIZE,0);
if (read(pfile,&pstats,PSTAT_SIZE) != PSTAT_SIZE)
	clear(&pstats,PSTAT_SIZE);
}

wtpstat(i)
{
seek(pfile,i*PSTAT_SIZE,0);
write(pfile,&pstats,PSTAT_SIZE);
}

