#
#include <stdio.h>
#include <pwd.h>

#define	MIN_CHARGE	0.03
#define	CPU_RATE	100.0/HOUR
#define	FORK_RATE	0.001
#define	PAGE_RATE	0.05
#define	LINE_RATE	(0.40/thousand)
#define	ELT_RATE		1.00
#define	DISK_RATE	0.01/MONTH	/* $0.01 per block-month */
#define	thousand	1000.0
#define	HOUR		3600.0
#define	DAY		(HOUR*24.0)
#define	MONTH		(DAY*30.0)
#define	MAXUID	256
#define	STAT_SIZE	(sizeof stats)
#define	PSTAT_SIZE	(sizeof pstats)
char *outfmt	"%-8.8s %7.0f	%7.2f	%7.0f	%7.1f	%7.2f	%7.2f	%7.0f\n";
char *br_fmt "%-8.8s %7.2f\n";

float min_charge = MIN_CHARGE;
char users[MAXUID][8];
int id,uid,pid;
float elt,utime,stime;
float cpu,cost;
double disk, tdisk;
float tcpu,tcost;
float tlines, tpages;
float telt;
float size;
char *itoa();
FILE *mtsfile;
char *mtsname;		/* pointer to mts file name */
double diskuse[MAXUID];

struct stats
{
char s_name[8];
unsigned s_count;	/* number of processes */
float s_utime;
float s_stime;
float s_size;
} stats;

struct pgstats
{
int p_count;		/* number of jobs */
float p_pages;
float p_lines;
float p_plot;
} pstats;

struct ubuf
{
char t_name[8];
float t_time;
} ubuf[MAXUID];

char uname[9];
char pfilep[64];	/* the page info file */
int tfile;
int pfile;
int sfile;
float count;
float eltime;
float elt;
int vflg;
int lflg;
int aflg;
int bflg;		/* brief */
int tflg;		/* no title */
int dolflg;		/* just cost in $ */

char *filep "/usr/adm/cpu-stats";
int file;

main(argc,argv) char **argv;
{
register struct stats *s;
register int i;
char *argp;
char *p;

if (*argv[0] == '-')
	{
	if ((i = dup(1)) != 2)
		close(i);
	++lflg;
	}
setout();
uid = getuid()&0377;
rdtab(&users,MAXUID,"/etc/passwd");
--argc; ++argv;
while (argc>0)
	{
	--argc;
	if ( *(argp = *argv++) == '-')
		{
		while (*argp)
			switch(*argp++)
				{
			case 'm':
				mtsname = *argv++;
				--argc;
				if ((mtsfile = fopen(mtsname,"w")) == NULL)
					err("can't open %s",mtsname);
				break;
			case 'z':		/* new minimum charge */
				pscanf(&argp,"%f",&min_charge);
				break;
			case 'a':
				++aflg;
				break;
			case 't':
				++tflg;
				break;
			case 'f':
				filep = *argv++;
				--argc;
				break;
			case 'u':
				--argc;
				p = *argv++;
				for (i=0; i<MAXUID; ++i)
					if (eqtest(users[i],p))
						break;
				if (i >= MAXUID)
					err("user %.8s not found",p);
				uid = i;
				break;
			case 'v':		/* verbose */
				++vflg;
				break;
			case 'l':		/* limit access */
				++lflg;
				break;
			case '$':		/* brief */
				++bflg;
				++dolflg;
				break;
			case 'b':		/* brief */
				++bflg;
				break;
				}
		}
	else 
		err("bad usage");
	}
if ((file = open(filep,0)) < 0)
	err("can't open %s",filep);

sprintf(pfilep,"%s.p",filep);
if ((pfile = open(pfilep,0)) < 0)
	printf("can't open %s\n",pfilep);

readfile("t",ubuf,sizeof ubuf);

readfile("s",diskuse,sizeof diskuse);

s = &stats;
if (lflg)
	chklimit();
if (!tflg)
	{
	if (bflg)
		{
		if (!dolflg)
			printf("User	$\n");
		}
	else
		{
		printf(
		"User	   cmds	            cpu	  pages	  lines	   term	   cost	  disk\n");
		printf(
		"Name	  (forks)	    hr.           (thous)   hr.    $cc    blk-day\n");
		}
	}
utime = 0;
stime = 0;
count = 0;
if (!aflg)
	{
	rdstat(uid);
	rdpstat(uid);
	costcalc();
	prstat();
	}
else
	{
	for (i = 0; i<MAXUID; ++i)
		{
		uid = i;
		rdstat(i);
		rdpstat(i);
		costcalc();
		if (cost >= min_charge)
			prstat();
		}
	printf(outfmt,
		"Total",
		count,tcpu/3600.0,
		tpages,tlines/1000.0,
		telt,
		tcost,
		tdisk/DAY
		);
	}
flush();
exit(0);
}

rdstat(i)
{
seek(file,i*STAT_SIZE,0);
if (read(file,&stats,STAT_SIZE) != STAT_SIZE)
	clear(&stats,STAT_SIZE);
if (users[i][0] == 0)
	copy(stats.s_name,itoa(i));
else
	move(8,users[i],stats.s_name);
move(8,users[i],uname);
}

float tfind(name) char *name;
{
/*
 * return the amount of time used in HOURs.
 */
register struct ubuf *p;

for (p = ubuf; p < ubuf+MAXUID; ++p)
	if (eqcmp(8,p->t_name,name))
		return(p->t_time/60.0);
return(0.0);
}

eqcmp(len,s1,s2) char *s1, *s2;
{
register char *p1, *p2;
register int l;

for (p1 = s1, p2 = s2, l = len; --l ; )
	if (*p1++ != *p2++ && (p1[-1] ^ p2[-1]) != 040)
		return(0);
return(1);
}

float lines;
float etime;

prstat()
{
register struct passwd *p;
if (bflg)
	{
	if (dolflg)
		printf("%.2f\n",cost);
	else
		printf(br_fmt,stats.s_name,cost);
	}
else
	printf(outfmt,
		stats.s_name,
		stats.s_count+0.0,
		cpu/3600.0,
		pstats.p_pages,
		lines/1000.0,
		etime,
		cost,
		disk/DAY
		);
if (mtsfile && (p = getpwnam(uname)) && p->pw_mtsid[0])
	fprintf(mtsfile,"C %-4.4s %7.2f UNIX CHARGES\n",p->pw_mtsid,cost);
}

costcalc()
{
etime = tfind(stats.s_name);
utime =+ stats.s_utime;
stime =+ stats.s_stime;
count =+ stats.s_count;
cpu = stats.s_utime+stats.s_stime;
cost = cpu*CPU_RATE + stats.s_count*FORK_RATE + etime*ELT_RATE;
lines = pstats.p_lines+pstats.p_plot;
disk = diskuse[uid];
cost =+ lines*LINE_RATE + pstats.p_pages*PAGE_RATE;
cost =+ disk * DISK_RATE;
tlines =+ lines;
tpages =+ pstats.p_pages;
tcpu =+ cpu;
tcost =+ cost;
telt =+ etime;
tdisk =+ disk;
}

char *itoa(n)
{
register int k;
static bf[10];
register char *p;

for (p=bf+9; n; )
	{
	k = n%10;
	n = n/10;
	*--p = k+'0';
	}
return(p);
}

eqtest(s1,s2)
{
register char *p1, *p2;

p1 = s1; p2 = s2;
while (*p1++ == *p2++)
	if (p1[-1] == 0)
		return(1);
if ((*--p1 == ' ' || p1 >= s1+8) && *--p2 == 0)
	return(1);
return(0);
}

rdpstat(i)
{
seek(pfile,i*PSTAT_SIZE,0);
if (read(pfile,&pstats,PSTAT_SIZE) != PSTAT_SIZE)
	clear(&pstats,PSTAT_SIZE);
}

wtpstat(i)
{
seek(pfile,i*PSTAT_SIZE,0);
write(pfile,&pstats,PSTAT_SIZE);
}

rdlimit(i)
{
static int f;
char xfile[64];
int limit;			/* the limit in dollars */

if (f == 0)
	{
	copy(xfile,filep);
	append(xfile,".l");
	f = open(xfile,0);
	}
if (f < 0)
	return(0);
seek(f,i*(sizeof limit),0);
if (read(f,&limit,sizeof limit) != sizeof limit)
	limit = 0;
return(limit);
}

chklimit()
{
float f;

rdstat(uid);
rdpstat(uid);
costcalc();
f = rdlimit(uid);
if (f < 0.0)
	err("Your account has expired; see staff member");
if (f != 0.0 && cost >= f)
	err("You have overspent your limit (%.2f) by $%.2f",f,cost-f);
if (vflg)
	{
	printf("spent=%.2f; limit=",cost);
	if (f != 0.0)
		printf("%.2f\n",f);
	else
		printf("none\n");
	}
exit(0);
}

readfile(name,buf,length) char *name, *buf;
{
register int f;
char temp[64];

sprintf(temp,"%s.%s",filep,name);
if ((f = open(temp,0)) < 0)
	{
	fprintf(stderr,"cannot open %s\n",temp);
	return(0);
	}
read(f,buf,length);
close(f);
return(1);
}
