#

#include <stdio.h>

#include <signal.h>

#define	MOTD	"/etc/motd"
#

#define	IALLOC	0100000
#define	IFMT	060000
#define		IFDIR	040000
#define	IFCHR	020000
#define	IFBLK	060000

struct stat
{
char s_minor;
char s_major;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
int s_actime[2];
int s_modtime[2];
} ;

struct {
int s_dev;
int s_inumber;
int s_flags;
char s_nlinks;
char s_uid, s_gid;
char s_size0;
int s_size1;
int s_addr[8];
long s_atime;
long s_mtime;
};
/*
 * install in /bin/bye
 * invoked from the yale shell when it exits from the top level
 * (e.g. when its argument was "-" and fildes 2 was not allocated)
 * a better alternaltive would be to do it when the shell's parent
 * was process 1, but this requires a system change to get one's parent's
 * id.
 * Functions:
 * 1. if file .bye exists in the current directory (== home directory
 *	since the shell did a "cd" implicitly) then start up a shell
 *	on it. (logical complement to .profile).
 * 2. scan thru /etc/utmp for the entry for this tty (attatched to 2)
 * 	and print a log off message.
 */
struct stat sbuff;

struct utmp
{
char uname[8];
int ttyname;
long intime;
int junk;
} utmp;
int tty;		/* the terminal number */
int min, hr;
int nokill;

main(argc,argv) char **argv;
{
long tvec;
extern int ldivr;
int i, status, pid;
register int p;
register char *argp;

tty = ttyn(2);
setout();
if (argc > 1 && *(argp = argv[1]) == '-')
	if (argp[1] == 'n')
		++nokill;
if (write(2,"\n",1) < 0)
	exit(1);			/* must be line drop */
if (stat(".bye",&sbuff) >= 0)
	{
	if ((pid = fork()) == 0)
		{
		signal(SIGINT,0);		/* allow interrupts */
		execl("/bin/sh","sh",".bye",0);
		printf("cannot execute /bin/sh\n");
		exit(1);
		}
	while ((i = wait(&status)) != pid && i != -1)
		;
	}
if (p = scantty())
	{
	prmotd();
	printf("User '%.8s' ",utmp.uname);
	}
time(&tvec);
printf("logged off tty%c %.16s ",tty,ctime(&tvec));
if (p)
	{
	printf("[");
	min = ldiv(tvec-utmp.intime,60);
	if (ldiv)
		++min;
	hr = min/60;
	min = min % 60;
	if (hr)
		printf("%d Hr ",hr);
	printf("%d Min]",min);
	}
printf("\n");
flush();
if (!nokill)
	killem();
exit(0);
}

int dummy() { }

killem()
{
int status;
register int pid;
register int i;
struct { char lo, hi; };

if (kill(0,SIGHUP) != -1)		/* hangup all other processes */
	{
	signal(SIGALRM,&dummy);
	alarm(5);
	for (i=0; ((pid = wait(&status)) != -1); ++i)
		{
		if (status.lo == SIGHUP)
			printf("process %d killed\n",pid);
		}
	if (i == 0)
		printf("Note: 'kill -1 0' done.\n");
	flush();
	}
}

scantty()
{
register FILE *f;
register char *p = NULL;

f = fopen("/etc/utmp","r");
if (f == NULL)
	return(0);
while (fread(&utmp, sizeof utmp, 1, f))
	{
	if (tty == utmp.ttyname)
		{
		for (p=utmp.uname+8; *--p == ' '; )
			*p = 0;
		break;
		}
	}
fclose(f);
return(p != 0);
}

prmotd()
{
register FILE *motd;
char buff[64];
register int l;

if (stat(MOTD,&sbuff) >= 0 && sbuff.s_size1 && sbuff.s_mtime > utmp.intime &&
		(motd = fopen(MOTD,"r")))
	{
	while ((l = read(fileno(motd),buff,sizeof buff)) > 0)
		write(1,buff,l);
	printf("\n");
	fclose(motd);
	}
}
