/* $Id: vmeio-reg.h,v 1.5 1991/04/02 18:06:34 sharakan Exp $ */

/*****************************************************************************
*       (c) Copyright 1989, 1990 Thinking Machines Corporation, Inc.
*	      of Cambridge, Mass. All rights reserved.
*
*  This notice is intended as a precaution against inadvertent publication
*  and does not constitute an admission or acknowledgement that publication
*  has occurred or constitute a waiver of confidentiality.
*
*  Connection Machine software is the proprietary and confidential property
*  of Thinking Machines Corporation.
*****************************************************************************/

/*
 * VMEIO board register defs
 * REV 3; 12/12/89 
 */
struct vmeio_regs {
    u_long	vmeio_status;			/* 0 */  /* Writing clears ints */
    u_long	vmeio_command;			/* 4 */
    u_long	vmeio_setup; 			/* 8 */
    u_long	vmeio_vme_addr;			/* 12 */
    u_long	vmeio_vme_count;		/* 16 */
    u_long	vmeio_read_pointer;		/* 20 */
    u_long	vmeio_write_pointer;		/* 24 */
    u_long	vmeio_word_count;		/* 28 */
    u_long	vmeio_test_vme_addr;		/* 32 */
    u_long	vmeio_test_pointers;		/* 36 */ 
    u_long	vmeio_reset;			/* 40 */
    u_long	vmeio_fifo_ram;			/* 44 */
    u_long	vmeio_data_low;			/* 48 */
    u_long	vmeio_data_high;		/* 52 */
    u_long	vmeio_cmio_status;		/* 56 */
    u_long	vmeio_cmio_setup;		/* 60 */
    u_long 	vmeio_master_enable;		/* 64 */ /* VME master!!! */	
};


/*
 * CMIO constants
 */

#define CMIO_NTARGETS	16	/* number of targets on the CMIO bus */

/*  */
/*
 * VMEIO status register 
 */
#define 	IC_VME_TIMEOUT                 	0x00000001
#define 	IC_VME_MASTER_DONE             	0x00000002
#define 	IC_RAM_PAR_ERR                 	0x00000004
#define 	VME_MASTER_ENABLE              	0x00000008
#define         FIELD_RAM_FIFO_EMPTY           	0x00000010
#define         FIELD_RAM_FIFO_FULL            	0x00000020

#define 	IC_CMIO_DONE            	0x00000040
#define 	IC_CMIO_SLAVE_DONE             	0x00000080
#define         IC_CMIO_INTERRUPT              	0x00000100
#define		VMEIO_REV_MASK			0x00007000
#define		VMEIO_REV_SHIFT			12
#define		VMEIO_DRAM_32MB			0x00008000
#define		VMEIO_DRAM_SHIFT		15
#define		VMEIO_RAM_PAR_MASK		0x7F800000
#define		VMEIO_RAM_PAR_SHIFT		23
#define 	VMEIO_ERROR                     0x80000000

#define VMEIO_STATUS_BITS "\20\
\1IC_VME_TO\2IC_VME_MDONE\3IC_RAM_PERR\4VME_M_ENA\5RAM_FIFO_MT\6RAM_FIFO_FULL\
\7IC_CMIO_MDONE\10IC_CMIO_SDONE\11IC_CMIO_STATUS\20DRAM_32MB\40VMEIO_ERROR"

#define VMEIO_ERROR_STATUS_BITS "\20\
\1IC_VME_TO\3IC_RAM_PERR\5RAM_FIFO_MT\6RAM_FIFO_FULL\
\11IC_CMIO_STATUS\40VMEIO_ERROR"

/* 
 * VMEIO Command Register 
 */
#define 	IMASK_VME_TIMEOUT             	0x00000001
#define 	IMASK_VME_MASTER_DONE  	      	0x00000002
#define 	IMASK_RAM_PARERR               	0x00000004
#define         IMASK_CMIO_TIMER_ERROR         	0x00000008
#define         IMASK_CMIO_EXCEPTION           	0x00000010
#define         IMASK_CMIO_DONE         	0x00000020
#define         IMASK_CMIO_SLAVE_DONE          	0x00000040
#define         IMASK_CMIO_PARERR              	0x00000080
#define         IMASK_CMIO_ARBITER_TIMEOUT     	0x00000100
#define 	ENABLE_VME_TIMEOUT             	0x00000200
/* VME master direction */
#define		VME_TO_IOP_DIRECTION		0
#define		IOP_TO_VME_DIRECTION	      	0x00000400
#define CMIO_MASTER_HOLD			0x00000800
#define VMEIO_SINGLE_STEP               	0x00001000
#define VMEIO_HOLD_ADDRESS               	0x00002000
#define VMEIO_RAM_BYPASS                 	0x00004000
#define VMEIO_RAM_FIFO_MODE               	0x00008000
#define VMEIO_RAM_INVERT_PARITY          	0x00010000
#define VMEIO_RAM_PARITY_ENA			0x00020000
#define VMEIO_BLOCK_SIZE_MASK			0x000c0000
#define VMEIO_BLOCK_SIZE_SHIFT			18
# define VMEIO_BS_1MB 3
# define VMEIO_BS_2MB 2
# define VMEIO_BS_4MB 1
# define VMEIO_BS_8MB 0

#define VMEIO_AUTO_MASTER_ENA			0x00100000

#define VMEIO_BANK_MASK				0x00c00000
#define VMEIO_BANK_SHIFT			22

#define VMEIO_COMMAND_BITS "\20\
\1IM_VME_TO\2IM_VME_MDONE\3IM_RAM_PERR\4IM_CMIO_TIMER_ERR\5IM_CMIO_EXCPT\
\6IM_CMIO_MDONE\7IM_CMIO_SDONE\10IM_CMIO_PERR\11IM_CMIO_ARB_TO\12ENA_VME_TO\
\13DIR_CMIO_VME\14DIR_VME_IOP\15VMEIO_SS\16VMEIO_HA\17VMEIO_RAM_BP\
\20VMEIO_RAM_FIFO\21VMEIO_RAM_IPAR\22VMEIO_RAM_PAR_ENA\25VMEIO_AUTO_M\
\27DRAM_BANK0\30DRAM_BANK1"

/*
 * VME setup register 
 */
#define	VMEIO_VEC_MASK			0x000000ff
#define VMEIO_VEC_SHIFT			0
#define	VMEIO_ADDR_MOD_MASK		0x00003f00
#define VMEIO_ADDR_MOD_SHIFT		8
#define	VMEIO_VME_REQ_MASK		0x00030000
#define VMEIO_VME_REQ_SHIFT		16
#define	VMEIO_INTR_LEVEL_MASK		0x001c0000
#define VMEIO_INTR_LEVEL_SHIFT		18


/*
 * CMIO status register 
 */
#define CMIO_INTERLOCK_FLAG    			0x00000001
#define CMIO_SLAVE_ACTIVE                      	0x00000002
#define CMIO_MASTER_ACTIVE                     	0x00000004
#define	CMIO_ARBITER_ACTIVE	       		0x00000008
#define CMIO_NAK_IN                         	0x00000010

#define CMIO_FIFO_NOT_FULL			0x00000020
#define CMIO_FIFO_NOT_MT			0x00000040
#define CMIO_FIFO_NHF				0x00000080

#define CMIO_BUS_CONTROL_MASK                 	0x00000700
#define CMIO_BUS_CONTROL_SHIFT			8

#define         BUS_IDLE_PHASE                 0
#define         BUS_ARB_PHASE                  2
#define         BUS_GRANT_PHASE                6
#define         BUS_TARGET_SEL_PHASE           3
#define         BUS_XFR_PHASE                  1

#define CMIO_STICKY_READY                	0x00000800
#define CMIO_STICKY_ACK                  	0x00001000
#define CMIO_STICKY_NAK                  	0x00002000
#define CMIO_STICKY_SLAVE                	0x00004000
#define CMIO_STICKY_MASTER               	0x00008000
#define CMIO_STICKY_ARB                  	0x00010000
#define CMIO_MY_STICKY_EXCEPTION         	0x00020000
#define CMIO_STICKY_TIMER_ERR            	0x00040000
#define CMIO_PARITY_MASK                      	0x07f80000
#define	CMIO_PARITY_SHIFT			23

#define VMEIO_CMIO_STATUS_BITS "\20\
\1CMIO_IL\2CMIO_SLAVE\3CMIO_MASTER\4CMIO_ARBITER\5CMIO_NAK\6CMIO_FIFO_NOT_FULL\
\7CMIO_FIFO_NOT_MT\10CMIO_IFIFO_NOT_HF\14CMIO_S_RDY\15CMIO_S_ACK\16CMIO_S_NAK\
\17CMIO_S_SLA\20CMIO_S_MAS\21CMIO_S_ARB\22CMIO_MY_S_EXCPT\23CMIO_S_TIM_ERR"

#define VMEIO_CMIO_ERROR_STATUS_BITS "\20\
\14CMIO_S_RDY\15CMIO_S_ACK\16CMIO_S_NAK\
\17CMIO_S_SLA\20CMIO_S_MAS\21CMIO_S_ARB\22CMIO_MY_S_EXCPT\23CMIO_S_TIM_ERR"

/*
 * CMIO setup register 
 */
#define CMIO_REQ_EXCEPTION               	0x00000001
#define CMIO_SLAVE_BUSY                  	0x00000002
#define CMIO_MASTER_ENABLE               	0x00000004
#define IC_CMIO_EXCEPTION                      	0x00000008
#define IC_CMIO_TIMER_ERROR                    	0x00000010
#define IC_CMIO_PARITY_ERROR                   	0x00000020
#define IC_CMIO_NO_ARBITER                   	0x00000040

#define CMIO_INVERT_PARITY                	0x00000800
#define CMIO_ENABLE_PARITY               	0x00001000
#define CMIO_ENABLE_TIMER                	0x00002000
#define CMIO_ENABLE_SLAVE                	0x00004000
#define CMIO_ENABLE_ARBITER              	0x00008000
#define CMIO_SPEED_MASK                       	0x00070000
#define	CMIO_SPEED_SHIFT			16
#define CMIO_FIFO_ENABLE                  	0x00080000
#define CMIO_SENDER_ID_MASK                   	0x00f00000
#define CMIO_SENDER_ID_SHIFT			20
#define CMIO_TARGET_ID_MASK                   	0x0f000000
#define	CMIO_TARGET_ID_SHIFT			24
#define CMIO_STATION_ID_MASK                  	0xf0000000
#define CMIO_STATION_ID_SHIFT			28

#define VMEIO_CMIO_SETUP_BITS "\20\
\1CMIO_REQ_EXCPT\2CMIO_SLA_BUSY\3CMIO_M_ENA\4CMIO_EXCPT\5CMIO_TERR\
\6CMIO_PERR\7CMIO_ARB_ERR\14CMIO_INV_PAR\15CMIO_ENA_PAR\16CMIO_ENA_TIMER\
\17CMIO_ENA_SLA\20CMIO_ENA_ARB"

#define VMEIO_CMIO_ERROR_SETUP_BITS "\20\
\2CMIO_SLA_BUSY\3CMIO_M_ENA\4CMIO_EXCPT\5CMIO_TERR\
\6CMIO_PERR\7CMIO_ARB_ERR\17CMIO_ENA_SLA\20CMIO_ENA_ARB"


/*
 * FIFO/RAM/BUFFER sizes
 */

#define	VMEIO_FIFO_SIZE				8192	  /* 8k bytes */
#define VMEIO_BANK_SIZE				0x00800000 /* 8MB */
#define MASK_8MB				0xff800000
#define DRAM_MASK_8MB				0x007fffff
#define DRAM_MASK_32MB				0x01ffffff

/*
 * VME Address modifier definitions
 */
#define VME_SS_DATA	0x3D
#define VME_SNP_DATA	0x39
#define VME_ES_DATA	0x0D
#define VME_ENP_DATA	0x09

#define VMEIO_BR_LEVEL 3


#define MAX_VMEIO_BSIZE (63*1024)


/*  CMIO specific errors -- from cm_errno.h */
#define FIRST_DVC_ERROR 0x80 

#define NOEROR	(FIRST_DVC_ERROR + 0x00) /* No Error at all */
#define DIAGFL	(FIRST_DVC_ERROR + 0x01) /* diagnostic failure */
#define BPHASE	(FIRST_DVC_ERROR + 0x02) /* bad phase from file server */
#define SWCHEK	(FIRST_DVC_ERROR + 0x03) /* Software consistency check #1 */
#define HDWFAL	(FIRST_DVC_ERROR + 0x04) /* hardware failure */
#define MEDIAF	(FIRST_DVC_ERROR + 0x05) /* disk media failure */
#define MLTECC	(FIRST_DVC_ERROR + 0x06) /* Double or Multi-bit ECC error detected */
#define CONFUS	(FIRST_DVC_ERROR + 0x07) /* Data Vault software got confused, but is now resetting */
#define CBSPRO	(FIRST_DVC_ERROR + 0x08) /* CMIO-bus protocol error */
#define ILPARM	(FIRST_DVC_ERROR + 0x09) /* Illegal/Invalid parameter in command */
#define PSTEOM	(FIRST_DVC_ERROR + 0x0A) /* request goes past physical end-of-media */
#define GARBLD	(FIRST_DVC_ERROR + 0x0B) /* unknown command block -- command garbled */
#define RSVDNZ	(FIRST_DVC_ERROR + 0x0C) /* Reserved field(s) not set to zero */
#define BPCKSM	(FIRST_DVC_ERROR + 0x0D) /* Bad prom checksum */
#define BRCKSM	(FIRST_DVC_ERROR + 0x0E) /* Bad ram checksum */
#define FNSREV	(FIRST_DVC_ERROR + 0x0F) /* function not supported in this revision */
#define BADPAR	(FIRST_DVC_ERROR + 0x10) /* bad parity on data */
#define DRVFMT	(FIRST_DVC_ERROR + 0x11) /* inconsistent drive format */
#define DRVERR	(FIRST_DVC_ERROR + 0x12) /* drive error */
#define NODRVA	(FIRST_DVC_ERROR + 0x13) /* no drives active (cannot initialize drive-related tables) */
#define NOTLOD	(FIRST_DVC_ERROR + 0x14) /* RAM not loaded with viable image */
#define DINAVL	(FIRST_DVC_ERROR + 0x15) /* Diagnostic not available in current configuration */
#define PIPSFT	(FIRST_DVC_ERROR + 0x16) /* Data Pipeline corrected single bit error(s) */
#define BDSPAR	(FIRST_DVC_ERROR + 0x17) /* Configuration error:  incorrect/illegal sparing selection */
#define SCTIME	(FIRST_DVC_ERROR + 0x18) /* scsi-related timeout */
#define DATIME	(FIRST_DVC_ERROR + 0x19) /* data-transfer timeout */
#define COTIME	(FIRST_DVC_ERROR + 0x1A) /* control-transfer timeout */
#define DRVSFT	(FIRST_DVC_ERROR + 0x1B) /* Disk Drive recovered from soft error */
#define DRVHRD	(FIRST_DVC_ERROR + 0x1C) /* Disk Drive could not recover from error */
#define NAKRNL	(FIRST_DVC_ERROR + 0x1D) /* Command not available from Kernel */
#define LOGFUL	(FIRST_DVC_ERROR + 0x1E) /* Log almost full */
#define BUSBSY	(FIRST_DVC_ERROR + 0x1F) /* Bus busy timeout */
#define NAKRCV	(FIRST_DVC_ERROR + 0x20) /* Target busy timeout */
#define NOARBT	(FIRST_DVC_ERROR + 0x21) /* No arbitor on bus */
#define TSELTO	(FIRST_DVC_ERROR + 0x22) /* No response from target select */
#define XCPRCV	(FIRST_DVC_ERROR + 0x23) /* Bus exception received */
#define NOTSEL	(FIRST_DVC_ERROR + 0x24) /* No target select received */
#define PCERR	(FIRST_DVC_ERROR + 0x25) /* DV pipe counter mismatch */

