#!/bin/csh -f
# $Id: cmacct.csh,v 1.3 1992/03/05 18:15:05 nesheim Exp $
#############################################################################
# 	  Copyright (c) 1991 Thinking Machines Corporation, Inc.,	     
#		of Cambridge, Mass.   All rights reserved.		     
#									     
#  This notice is intended as a precaution against inadvertent publication   
#  and does not constitute an admission or acknowledgement that publication  
#  has occurred or constitute a waiver of confidentiality.		     
#									     
#  Connection Machine software is the proprietary and confidential property  
#  of Thinking Machines Corporation.					     
#############################################################################
#
# Usage: cmacct [-i] [file] [file] [...]
#
set cmsa_args=(\
    %id.pid %id.euid %id.egid %cm.interface %cm.uccs %cm.flags \
    %cm.connected %cm.ucc_busy_ticks \
    %io.p_kb_read %io.p_kb_written %io.s_kb_read %io.s_kb_written \
    %ts.memory_integral  %cm.cm_name %cm.memory_size %cm.processors \
    %cm.rusage.ru_utime %cm.rusage.ru_stime)

set AwkArgs=()

if (-f /etc/cm-base-system-config) then
   set CM_ETC_DIR=`/etc/cm-base-system-config ETC-DIR`
else if (-f /usr/local/etc/cm-base-system-config) then
   set CM_ETC_DIR=`/usr/local/etc/cm-base-system-config ETC-DIR`
else
   echo "Cannot find the CM base system config file"
   exit 1
endif
endif

if (-f ./cmsa.awk) then
   set CMSA_AWK_SCRIPT=${cwd}/cmsa.awk
else
   set CMSA_AWK_SCRIPT=${CM_ETC_DIR}/cmsa.awk
endif

if (-f ./cmsa) then
   set CMSA=${cwd}/cmsa
else
   set CMSA=${CM_ETC_DIR}/cmsa
endif


if ($#argv > 0) then
   if ($argv[1] == "-i") then
      set AwkArgs=($AwkArgs SummaryByInterface=1)
      shift argv
   endif
endif

if ($#argv == 0) then
   set argv="/usr/spool/cm/cmacct"
endif

rm -f /tmp/cmacct.$$
touch /tmp/cmacct.$$
foreach file ($argv)
 echo "Extracting ASCII accounting information from $file ..."
 $CMSA -f $file $cmsa_args >>/tmp/cmacct.$$
end

echo "Generating accounting summary ..."

awk -f $CMSA_AWK_SCRIPT $AwkArgs  </tmp/cmacct.$$
rm -f /tmp/cmacct.$$














