;;; -*- Mode: Lisp; Package: CMSR ; Base: 10.; Syntax: Common-lisp; Patch-File: Yes -*-

(in-package 'cmsr)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 
;;; Patch to /cm/viz/cmsr/f2004/math.lisp
;;; 
;;; This file patches a bug in the f2004 graphics fileset.
;;; I had forgotten to give the floating-point sizes to
;;; cmsr:v-ref so it assumed that everything was single
;;; precision. This is fixed in the f2005 fileset.

;;; If the vector in the current processor is zero, the
;;; corresponding bit in bit-field is set to 1.
;;; If the vector is not zero, the bit is set to 0.
;;; matt 26 Sep 90
(defun v-is-zero-2d (bit-field vector-field &optional (slen 23) (elen 8))
  (cmi::with-all-flags-saved
    (cm:u-move-zero-1l bit-field 1)
    (dotimes (i 2)
      (cm:f-eq-zero-1l (v-ref vector-field i slen elen) slen elen)
      (cm:logand-context-with-test))
    (cm:u-move-constant-1l bit-field 1 1)
    )
  (values)
  )

;;; If the vector in the current processor is zero, the
;;; corresponding bit in bit-field is set to 1.
;;; If the vector is not zero, the bit is set to 0.
;;; matt 26 Sep 90
(defun v-is-zero-3d (bit-field vector-field &optional (slen 23) (elen 8))
  (cmi::with-all-flags-saved
    (cm:u-move-zero-1l bit-field 1)
    (dotimes (i 3)
      (cm:f-eq-zero-1l (v-ref vector-field i slen elen) slen elen)
      (cm:logand-context-with-test))
    (cm:u-move-constant-1l bit-field 1 1)
    )
  (values)
  )

(*lisp-i::increment-patch-level 5)
