
(in-package '*lisp-i)

;;; The call to *set which zeroes out the count value of the 
;;; destination pvar will generate a type check that will not
;;; allow a structure pvar to be passed in.  The fix is to
;;; wrap the call to *set with a compiler-let which binds
;;; safety to 0, so it will generate the naked paris.
;;;
;;; This allows the user to pass in a structure pvar with a 32-bit
;;; field and a vector of 32-bit elements as the slots as the
;;; destination pvar.

;;; AJW 7/4/92

;;; Added a condition for doing the slicewise-to-processorwise
;;; transposition.  If there are no processors active, then
;;; don't do the transposition.

;;; Also: when no processors are active, zero out the count
;;; in all processors.

;;; AJW 22/4/92

(defun *pset-queue ()

  (when (or (< (pvar-length **pset-dest*) 64)
	    (not (zerop (mod (pvar-length **pset-dest*) 32)))
	    )
    (error "Implementation limitation. ~@
            The destination pvar for *PSET :QUEUE must be~@
            at least 64 bits long and a multiple of 32 bits"
	   ))

  (when (eq :array (pvar-type **pset-dest*))
    (when (not (eql 32 (pvar-array-element-type-length **pset-dest*)))
      (error "The destination array pvar for *PSET :QUEUE must have 32 bit long elements")
      ))

  (*let ()

    (let ((source-to-send
	    (*nocompile
	      (case (pvar-type **pset-source*)
		(:field
		  (*let ((temp-source **pset-source*))
		    (declare (type (field-pvar 32) temp-source))
		    temp-source
		    ))
		(:signed
		  (*let ((temp-source **pset-source*))
		    (declare (type (signed-pvar 32) temp-source))
		    temp-source
		    ))
		(:float
		  (*let ((temp-source **pset-source*))
		    (declare (type single-float-pvar temp-source))
		    temp-source
		    ))
		(otherwise
		  (if (eql (pvar-length **pset-source*) 32)
		      **pset-source*
		      (error "Implementation limitation.  Cannot send pvars of type ~S, length ~D~@
                            using :QUEUE combiner.  You will need to represent your data in 32~@
                            bit form."
			     (pvar-type **pset-source*)
			     (pvar-length **pset-source*)
			     )))))))

      ;; Zero out the count.

      (*with-vp-set (pvar-vp-set **pset-dest*)
	(compiler-let ((*safety* 0))  ;; this is the patched line
	  (*all
	    (*set (the (field-pvar 32) **pset-dest*) (!! 0)))
	  ))

      ;; Do the send with Queue.

      (let ((array-length (/ (pvar-length **pset-dest*) 32)))

	(cm:send-to-queue32-1l
	  (pvar-location **pset-dest*)
	  (pvar-location **pset-address*)
	  (pvar-location source-to-send)
	  32
	  (1- array-length)
	  )

	;; Transpose the results processorwise

	
	(*with-vp-set (pvar-vp-set **pset-dest*)
	  (when (*or t!!) ;; if any processors are active
	    (let ((location (pvar-location **pset-dest*)))
	      (dotimes (j array-length)
		#+SMART-ITERATION
		(declare (ignore j))
		(cm:transpose32-2-1l location location 32)
		(incf location 32)
		)))
	  (when **pset-notify*
	    (*when (not!! (zerop!! (the (field-pvar 32) **pset-dest*)))
	      (*nocompile (*set **pset-notify* t!!))
	      )))

	))))

(*lisp-i::increment-patch-level 13)





