;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CMI; Base: 10; Patch-File: Yes -*-

(in-package "CMI")

;;;
;;; this function used to *not* print SBE's if
;;; double bit error reporting was enabled, even if SBE
;;; reporting was enabled as well!
;;;
(defun get-sprint-error-mask (configuration)
  (let ((mask 0))
    ;; Single-Bit error.
    (if (ldb-test (byte 1 2) configuration)
	(setq mask (logior mask #x0003)))
    ;; Double-Bit error.
    (if (ldb-test (byte 1 3) configuration)
	(setq mask (logior mask #x000C)))
    ;; Indirect Addressing error.
    (if (ldb-test (byte 1 4) configuration)
	(setq mask (logior mask #x0020)))
    ;; Floating Point Exception
    (if (and (ldb-test (byte 1 5) configuration)
	     (ldb-test (byte 1 6) configuration))
	(setq mask (logior mask #x0010)))
    mask))

(cmi::increment-patch-level 18)
