/*****************************************************************************
* 	  (c) Copyright 1990 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#ifndef TIMESHARE_H
# define TIMESHARE_H yes

#if !defined(lint) && !defined(__SABER__) && !defined(LC)
static char ts_h_rcsid[] = "$Id: timeshare.h,v 1.34 1992/05/21 18:45:30 nesheim Exp $";
#endif

/*
 * timeshare.h -- common defines for the CM TS daemon and CM processes.
 */ 

#define CMTS_CONF_FORMAT \
	TK_str_to_upper_case(CMI_attached_cm_name), CMI_attached_sequencers

#define CMTS_PORT_DIRECTORY_FORMAT_STRING "/tmp/cmts-%s-%X"
#define CMTS_PORT_DIRECTORY_FORMAT \
  	CMTS_PORT_DIRECTORY_FORMAT_STRING, CMTS_CONF_FORMAT

#define CMTS_KERNEL_PORT_FORMAT_STRING "/tmp/cmts-%s-%X/daemon-port"
#define CMTS_KERNEL_PORT_FORMAT        \
  	CMTS_KERNEL_PORT_FORMAT_STRING, CMTS_CONF_FORMAT

#define CMTS_PROCESS_PORT_FORMAT_STRING	"/tmp/cmts-%s-%X/pid-%d-port"
#define CMTS_PROCESS_PORT_FORMAT       \
	CMTS_PROCESS_PORT_FORMAT_STRING, CMTS_CONF_FORMAT

#define CMTS_PROCESS_PORT_NEW_FORMAT_STRING "/tmp/cmts-%s-%X/pid-%d-%X-port"
#define CMTS_PROCESS_PORT_NEW_FORMAT       \
	CMTS_PROCESS_PORT_NEW_FORMAT_STRING, CMTS_CONF_FORMAT


#define CMTS_KERNEL_INFO_FILE_FORMAT_STRING "/tmp/cmts-%s-%X/ts-daemon-info"
#define CMTS_KERNEL_INFO_FILE_FORMAT   \
  	CMTS_KERNEL_INFO_FILE_FORMAT_STRING, CMTS_CONF_FORMAT

#define CMTS_PROCESS_ERROR_FILE_FORMAT_STRING "/tmp/cmts-%s-%X/errtext-pid-%d"
#define CMTS_PROCESS_ERROR_FILE_FORMAT \
	CMTS_PROCESS_ERROR_FILE_FORMAT_STRING, CMTS_CONF_FORMAT

#define CMTS_REGISTER_TIMEOUT 10 /* in seconds */

#define CMTS_MAX_MESSAGE_SIZE 1024 /* Have to set a max for recv_from */
#define CMTS_PAGE_SIZE    1024 /* For memory manager */

#define CMTS_TTY_NAMELEN  20

/*
 * This business with the seed magic number is a way of (one hopes)
 * providing back-compatibility with pre-seeded binaries.  If the seed
 * comes out of the message with the wrong magic number, then it's
 * probably an older binary...
 *
 * Incidentally, the magic number can be used as a protocol version
 * number, as well.  Protocol version numbers are ``named'' just so it's
 * easy to keep track of *why* the protocol changed.
 */
#define PROCS_MAY_BE_NON_ZERO_BASED 0x00000010
#define PROTOCOL_VERSION	PROCS_MAY_BE_NON_ZERO_BASED
#define SEED_MAGIC_NUMBER_BITS	0x10000000
#define SEED_MAGIC_NUMBER	SEED_MAGIC_NUMBER_BITS + PROTOCOL_VERSION
#define SEED_MAGIC_NUMBER_MASK	0xfffffff0

/*
 * A seed-magic-number has a protocol version embedded in it, and
 * the ts-daemon can handle a (narrow) range of protocols versions.
 */
#define PROBABLE_SEED(x) \
  ((((x) & SEED_MAGIC_NUMBER_MASK) >= SEED_MAGIC_NUMBER - PROTOCOL_VERSION) \
   && (((x) & SEED_MAGIC_NUMBER_MASK) <= SEED_MAGIC_NUMBER) \
   && (((x) & ~SEED_MAGIC_NUMBER_MASK) != 0))

/* Process request structures.  This is a little ugly right now. */

enum MEM_OPERATION
{
    ALLOCATE_PAGE,
    SHOW_MEMORY_MAP,
    PIDTEST_ENABLE,
    DUMP_STATISTICS,
};

typedef struct
{
    enum MEM_OPERATION oper;
    int increment;
} MM_REQUEST;

/* Only have to keep track of framebuffer operations right now */

enum IOMGR_OPERATION
{
    BEGIN_IO,
    END_IO,
    ALLOCATE,
    DEALLOCATE,
    LIST_DISPLAYS
};

typedef struct
{
    enum IOMGR_OPERATION oper;
    char data[80]; /* Name of the frambuffer */
} IOMGR_REQUEST;

#define CM_MAX_DISPLAYS 16 /* Should be defined someplace else */
#define CM_MAX_DISPLAY_NAME_LENGTH 40

typedef struct 
{
    int count;
    char id[CM_MAX_DISPLAYS][CM_MAX_DISPLAY_NAME_LENGTH];
} DISPLAY_LIST;

enum PROCMGR_OPERATION
{
    REGISTER,
    DEREGISTER,
    GET_ERROR_REPORT,
    LIST_PROCESSES,
    SHOW_STATUS,
    GET_CM_SPEED,
    NULL_OPERATION,		/* For timing */
    SET_PRIORITY,
    GET_PRIORITY,
    REGISTER_WITH_WAIT,
    DUMP_PROCESS_TABLE,
    GET_TS_STATS,
    REGISTER_AT_PHYSADDR,	/* checkpointing requires repeated physaddr */
    SET_PROC_PRIORITY,		/* renice */
    GET_PROC_PRIORITY,		/* renice */
};

typedef struct
{
    enum PROCMGR_OPERATION oper;
    char data[80]; /* Fix this later */
} PROCMGR_REQUEST;



/*
 * The extent of a process's memory --- what is returned in reply to a
 * grow or shrink memory request.
 */
typedef struct {
    int lower_bound;		/* lower bound --- included in address space*/
    int upper_bound;		/* upper bound --- NOT included in address */
				/* space*/
} MM_LIMITS;

/*
 * CM configuration data as returned from a register process request.
 */
typedef struct {
    MM_LIMITS memdata;
    double cm_speed;
} REGISTER_REPLY;

/*
 * administrative requests for changing the behavior of the ts-daemon
 * while it is running.
 */
typedef enum 
{
    LATENCY,
    LOGLEVEL,
    MAXPROCS,
    MINQUANTUM,
    OVERHEAD,
    PROCSIZE,
    SHUTDOWN,
    LOGLEVEL_MM,
    LOGLEVEL_PM,
    LOGLEVEL_SM,
    LOGLEVEL_SCHED,
    SUSPENDTIME,
    SUSPEND_TIMESHARING,
    RESUME_TIMESHARING,
    CURRENT_SETTINGS,
    FRONT_END_NICE,
    CLIENT_NICE,
    CHECKSUM_LEVEL,
    QUANTUM,
    IDLE_LIMIT,
} ADMIN_OPERATION;

#define CHECKSUM_LOW	0
#define CHECKSUM_NONE	CHECKSUM_LOW
#define CHECKSUM_BOTH	1
#define CHECKSUM_HIGH	2
#define CHECKSUM_ALL	CHECKSUM_HIGH

typedef struct {
    ADMIN_OPERATION op;
    int uid;
    union {
	int ivalue;
	float fvalue;
    } ad_u;
    char data[80];
} ADMIN_REQUEST;

typedef enum {
    SOCKET_NOOP,		/* a non-operation (for internal use by */
				/* the ts-daemon to indicate that no */
				/* operation is pending) */
    SOCKET_CREATE,
    SOCKET_ACCEPT,
    SOCKET_BIND,
    SOCKET_CLOSE,
    SOCKET_CONNECT,
    SOCKET_LISTEN,
    SOCKET_RECV,
    SOCKET_RECVFROM,
    SOCKET_SEND,
    SOCKET_SENDTO,
    SOCKET_STATUS,
} SOMGR_OPERATION;

typedef enum { CMTS_DATAGRAM, CMTS_STREAM } CMTS_socket_type;

#define CMTS_MAX_SOCKNAME_LEN	128

typedef struct {
    int buflen_or_nsent;	/* buflen in, nsent out */
    int address;		/* address of buffer */
    char peername[CMTS_MAX_SOCKNAME_LEN];
} SOMGR_MSG;


/*
 * for those routines that accept or return a socket descriptor:
 */
typedef int CMTS_descriptor;

typedef struct {
    CMTS_descriptor desc;
    char peername[CMTS_MAX_SOCKNAME_LEN];
} SOMGR_CONNECTION;

typedef struct {
    SOMGR_OPERATION oper;
    int uid;
    CMTS_descriptor descriptor;
    union {
	int socket_type;	/* for socket create */
	char name[CMTS_MAX_SOCKNAME_LEN]; /* for bind */
	int max_number_of_peers; /* for listen */
	SOMGR_MSG datagram;	/* for send, sendto, recv, recvfrom */
    } u;
} SOMGR_REQUEST;

typedef union {
    CMTS_descriptor	desc;	/* for socket, accept */
    SOMGR_CONNECTION 	connection; /* for accept */
    SOMGR_MSG 		datagram; /* for recv, recvfrom, send, sendto */
} SOMGR_REPLY;

/*
 * for those routines that return success or failure:
 */
typedef enum { CMTS_SOCKET_FAIL = -1, CMTS_SOCKET_SUCCESS = 0 }
	CMTS_socket_status;

typedef enum {
    MEM_MANAGER,
    IO_MANAGER,
    PROC_MANAGER,
    ADMIN,
    SOCK_MANAGER
  } REQUEST_DESTINATION;

typedef struct
{
    int length;  /* Actual length of message */
    REQUEST_DESTINATION dest;	/* manager the request is destined for */
    int source;			/* Source's CM PID */
    int seed;			/* a number that makes an attach-session's */
				/* socketname unique */
    union 
    {
	PROCMGR_REQUEST pm_req;
	MM_REQUEST mm_req;
	IOMGR_REQUEST io_req;
	ADMIN_REQUEST ad_req;
	SOMGR_REQUEST so_req;
    } req;
} PROCESS_MESSAGE;

typedef struct
{
    int	loc;	
    int tag1;
    int tag2;
} ERROR_IF_LOCATION_MESSAGE;

typedef struct
{
    int cm_errno;
    int message_length;
    char data[1];
} CM_ERROR_MESSAGE;

/*
 * discriminators for the kernel message union: 
 */
typedef enum {
    KMSG_VOID,
    KMSG_REGISTER_REPLY,
    KMSG_MM_LIMITS, 
    KMSG_PRIORITY,
    KMSG_ERROR_IF_LOCATION,
    KMSG_CM_ERROR_MESSAGE,
    KMSG_DISPLAY_LIST,
    KMSG_SOCKET_REPLY
  } KMSG_DISCRIMINATOR;

typedef struct
{
    int length; 			/* Total length of message */
    enum { REPLY, WAKEUP } type;	/* Historical */
    int status;
    KMSG_DISCRIMINATOR format_type;
    union {
	char data[80]; /* Fix this later */
	REGISTER_REPLY cmdata;
	MM_LIMITS memdata;
	int priority;
	ERROR_IF_LOCATION_MESSAGE error_if_location;
	CM_ERROR_MESSAGE error_message;
	DISPLAY_LIST display_list;
	SOMGR_REPLY socket_reply;
    } u;
} KERNEL_MESSAGE;


#define CMTS_E_NO_MORE_PROCESSES  	1
#define CMTS_E_BAD_FORMAT		2
#define CMTS_E_NOT_REGISTERED		3
#define CMTS_E_USED_TOO_MUCH_TIME	4
#define CMTS_E_TS_SHUTDOWN		5
#define CMTS_E_NO_PERMISSION		6
#define CMTS_E_TIMEOUT			7
#define CMTS_E_NO_MORE_MEMORY		8
#define CMTS_E_BAD_PAGE			9
#define CMTS_E_MM_NO_FREE_PAGES		10
#define CMTS_E_NOT_SCHEDULED		11
#define CMTS_E_NO_SUCH_DEVICE		12
#define CMTS_E_DEVICE_NOT_ALLOCATED	13
#define CMTS_E_NO_SUCH_PROCESS		14
#define CMTS_E_PROTOCOL_VIOLATION	15
#define CMTS_E_INVALID_ARGUMENT		16
#define CMTS_E_ERROR_IF_LOCATION	17
#define CMTS_E_DEVICE_BUSY		18
#define CMTS_E_SWAP_SIZE_TOO_LOW_TO_SUSPEND	19
#define CMTS_E_SUSPEND_FAILED		20
#define CMTS_E_RESUME_FAILED		21
#define CMTS_E_NOT_TIMESHARING		22

/*
 * socket-related errors:
 */
#define CMTS_E_TOO_MANY_SOCKETS		23
#define CMTS_E_SOCKET_NAME_IN_USE	24
#define CMTS_E_INVALID_SOCKET_DESCRIPTOR 25
#define CMTS_E_CONNECTION_REFUSED	26
#define CMTS_E_SOCKET_HAS_BEEN_CLOSED	27
#define CMTS_E_SOCKET_IS_CONNECTED	28
#define CMTS_E_SOCKET_NOT_CONNECTED	29
#define CMTS_E_SOCKET_IS_LISTENING	30
#define CMTS_E_SOCKET_IS_NOT_LISTENING  31


#define CMTS_E_UNKNOWN			100

#define CMTS_E_FRONT_END_ERROR		1000

/* Globals for user processes */

extern int CMTS_ProcessPort;
extern char * progname;
extern int CMTS_HoldingCM;

extern char *CMI_attached_cm_name;
extern int CMI_attached_sequencers;

#ifndef errormsg
extern int errno;
extern char *sys_errlist[];
extern int sys_nerr;
#define errormsg \
	(errno<0 || errno>sys_nerr)? "(errno out of range)": sys_errlist[errno]
#endif /* errormsg */

#endif /* TIMESHARE_H */

