/* -*- Package: cmfs-i; Mode: C; Base: 10; -*- */
/*****************************************************************************
* 	  Copyright (c) 1988 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#ifndef _CM_ERRNO
#define _CM_ERRNO

/* This file has the errno numbers for the CM file system.  Thes were derived
 * from the ULTRIX 2.0 errors - These are independent of host system.
 * The file system will return these to the front end
 */

#if !defined(lint) && !defined(__SABER__)
static char rcsid_cm_errno[] = "$Id: cm_errno.h,v 1.42 1992/06/09 21:24:41 taylor Exp $";
#endif

#define	CMFS_EPERM		1	/* Not owner */
#define	CMFS_ENOENT		2	/* No such file or directory */
#define	CMFS_ESRCH		3	/* No such process */
#define	CMFS_EINTR		4	/* Interrupted system call */
#define	CMFS_EIO		5	/* I/O error */
#define	CMFS_ENXIO		6	/* No such device or address */
#define	CMFS_E2BIG		7	/* Arg list too long */
#define	CMFS_ENOEXEC		8	/* Exec format error */
#define	CMFS_EBADF		9	/* Bad file number */
#define	CMFS_ECHILD		10	/* No children */
#define	CMFS_EAGAIN		11	/* No more processes */
#define	CMFS_ENOMEM		12	/* Not enough core */
#define	CMFS_EACCES		13	/* Permission denied */
#define	CMFS_EFAULT		14	/* Bad address */
#define	CMFS_ENOTBLK		15	/* Block device required */
#define	CMFS_EBUSY		16	/* Mount device busy */
#define	CMFS_EEXIST		17	/* File exists */
#define	CMFS_EXDEV		18	/* Cross-device link */
#define	CMFS_ENODEV		19	/* No such device */
#define	CMFS_ENOTDIR		20	/* Not a directory*/
#define	CMFS_EISDIR		21	/* Is a directory */
#define	CMFS_EINVAL		22	/* Invalid argument */
#define	CMFS_ENFILE		23	/* File table overflow */
#define	CMFS_EMFILE		24	/* Too many open files */
#define	CMFS_ENOTTY		25	/* Not a typewriter */
#define	CMFS_ETXTBSY		26	/* Text file busy */
#define	CMFS_EFBIG		27	/* File too large */
#define	CMFS_ENOSPC		28	/* No space left on device */
#define	CMFS_ESPIPE		29	/* Illegal seek */
#define	CMFS_EROFS		30	/* Restricted operation on file system (Read-only) */
#define	CMFS_EMLINK		31	/* Too many links */
#define	CMFS_EPIPE		32	/* Broken pipe */

/* math software */
#define	CMFS_EDOM		33	/* Argument too large */
#define	CMFS_ERANGE		34	/* Result too large */

/* non-blocking and interrupt i/o */
#define	CMFS_EWOULDBLOCK	35	/* Operation would block */
#define	CMFS_EINPROGRESS	36	/* Operation now in progress */
#define	CMFS_EALREADY		37	/* Operation already in progress */
/* ipc/network software */

	/* argument errors */
#define	CMFS_ENOTSOCK		38	/* Socket operation on non-socket */
#define	CMFS_EDESTADDRREQ	39	/* Destination address required */
#define	CMFS_EMSGSIZE		40	/* Message too long */
#define	CMFS_EPROTOTYPE		41	/* Protocol wrong type for socket */
#define	CMFS_ENOPROTOOPT	42	/* Protocol not available */
#define	CMFS_EPROTONOSUPPORT	43	/* Protocol not supported */
#define	CMFS_ESOCKTNOSUPPORT	44	/* Socket type not supported */
#define	CMFS_EOPNOTSUPP		45	/* Operation not supported (on socket) */
#define	CMFS_EPFNOSUPPORT	46	/* Protocol family not supported */
#define	CMFS_EAFNOSUPPORT	47	/* Address family not supported by protocol family */
#define	CMFS_EADDRINUSE		48	/* Address already in use */
#define	CMFS_EADDRNOTAVAIL	49	/* Can't assign requested address */

	/* operational errors */
#define	CMFS_ENETDOWN		50	/* Network is down */
#define	CMFS_ENETUNREACH	51	/* Network is unreachable */
#define	CMFS_ENETRESET		52	/* Network dropped connection on reset */
#define	CMFS_ECONNABORTED	53	/* Software caused connection abort */
#define	CMFS_ECONNRESET		54	/* Connection reset by peer */
#define	CMFS_ENOBUFS		55	/* No buffer space available */
#define	CMFS_EISCONN		56	/* Socket is already connected */
#define	CMFS_ENOTCONN		57	/* Socket is not connected */
#define	CMFS_ESHUTDOWN		58	/* Can't send after socket shutdown */
#define	CMFS_ETOOMANYREFS	59	/* Too many references: can't splice */
#define	CMFS_ETIMEDOUT		60	/* Connection timed out */
#define	CMFS_ECONNREFUSED	61	/* Connection refused */

	/* */
#define	CMFS_ELOOP		62	/* Too many levels of symbolic links */
#define	CMFS_ENAMETOOLONG	63	/* File name too long */

/* should be rearranged */
#define	CMFS_EHOSTDOWN		64	/* Host is down */
#define	CMFS_EHOSTUNREACH	65	/* No route to host */
#define	CMFS_ENOTEMPTY		66	/* Directory not empty */

/* quotas & mush */
#define	CMFS_EPROCLIM		67	/* Too many processes */
#define	CMFS_EUSERS		68	/* Too many users */
#define	CMFS_EDQUOT		69	/* Disc quota exceeded */

/* NFS error codes */
#define CMFS_ESTALE		70
#define CMFS_EREMOTE		71

/* IPC errors
 */
#define CMFS_ENOMSG		72	/* No message of desired type */
#define CMFS_EIDRM		73	/* Identifier removed */

/* Alignment error of some type (i.e., cluster, page, block ...) */
#define CMFS_EALIGN		74	/* alignment error */

/* System V mappings from BRL package
 */
#define CMFS_EDEADLK	CMFS_EWOULDBLOCK	/* resource deadlock would occur */

extern int CMFS_errno;



/*  Data Vault specific errors */
#define FIRST_DVC_ERROR 0x80 

#define NOEROR	(FIRST_DVC_ERROR + 0x00) /* No Error at all */
#define DIAGFL	(FIRST_DVC_ERROR + 0x01) /* diagnostic failure */
#define BPHASE	(FIRST_DVC_ERROR + 0x02) /* bad phase from file server */
#define SWCHEK	(FIRST_DVC_ERROR + 0x03) /* Software consistency check #1 */
#define HDWFAL	(FIRST_DVC_ERROR + 0x04) /* hardware failure */
#define MEDIAF	(FIRST_DVC_ERROR + 0x05) /* disk media failure */
#define MLTECC	(FIRST_DVC_ERROR + 0x06) /* Double or Multi-bit ECC error detected */
#define CONFUS	(FIRST_DVC_ERROR + 0x07) /* Data Vault software got confused, but is now resetting */
#define CBSPRO	(FIRST_DVC_ERROR + 0x08) /* CMIO-bus protocol error */
#define ILPARM	(FIRST_DVC_ERROR + 0x09) /* Illegal/Invalid parameter in command */
#define PSTEOM	(FIRST_DVC_ERROR + 0x0A) /* request goes past physical end-of-media */
#define GARBLD	(FIRST_DVC_ERROR + 0x0B) /* unknown command block -- command garbled */
#define RSVDNZ	(FIRST_DVC_ERROR + 0x0C) /* Reserved field(s) not set to zero */
#define BPCKSM	(FIRST_DVC_ERROR + 0x0D) /* Bad prom checksum */
#define BRCKSM	(FIRST_DVC_ERROR + 0x0E) /* Bad ram checksum */
#define FNSREV	(FIRST_DVC_ERROR + 0x0F) /* function not supported in this revision */
#define BADPAR	(FIRST_DVC_ERROR + 0x10) /* bad parity on data */
#define DRVFMT	(FIRST_DVC_ERROR + 0x11) /* inconsistent drive format */
#define DRVERR	(FIRST_DVC_ERROR + 0x12) /* drive error */
#define NODRVA	(FIRST_DVC_ERROR + 0x13) /* no drives active (cannot initialize drive-related tables) */
#define NOTLOD	(FIRST_DVC_ERROR + 0x14) /* RAM not loaded with viable image */
#define DINAVL	(FIRST_DVC_ERROR + 0x15) /* Diagnostic not available in current configuration */
#define PIPSFT	(FIRST_DVC_ERROR + 0x16) /* Data Pipeline corrected single bit error(s) */
#define BDSPAR	(FIRST_DVC_ERROR + 0x17) /* Configuration error:  incorrect/illegal sparing selection */
#define SCTIME	(FIRST_DVC_ERROR + 0x18) /* scsi-related timeout */
#define DATIME	(FIRST_DVC_ERROR + 0x19) /* data-transfer timeout */
#define COTIME	(FIRST_DVC_ERROR + 0x1A) /* control-transfer timeout */
#define DRVSFT	(FIRST_DVC_ERROR + 0x1B) /* Disk Drive recovered from soft error */
#define DRVHRD	(FIRST_DVC_ERROR + 0x1C) /* Disk Drive could not recover from error */
#define NAKRNL	(FIRST_DVC_ERROR + 0x1D) /* Command not available from Kernel */
#define LOGFUL	(FIRST_DVC_ERROR + 0x1E) /* Log almost full */
#define BUSBSY	(FIRST_DVC_ERROR + 0x1F) /* Bus busy timeout */
#define NAKRCV	(FIRST_DVC_ERROR + 0x20) /* Target busy timeout */
#define NOARBT	(FIRST_DVC_ERROR + 0x21) /* No arbitor on bus */
#define TSELTO	(FIRST_DVC_ERROR + 0x22) /* No response from target select */
#define XCPRCV	(FIRST_DVC_ERROR + 0x23) /* Bus exception received */
#define NOTSEL	(FIRST_DVC_ERROR + 0x24) /* No target select received */
#define PCERR	(FIRST_DVC_ERROR + 0x25) /* DV pipe counter mismatch */

/*	The following error codes are set by the file system software */
#define FIRST_CM_FILE_SYSTEM_ERROR	(FIRST_DVC_ERROR + 0x30)

/* CMIOC board detected a parity error */
#define CMFS_ECMIOC_PARITY 		(FIRST_CM_FILE_SYSTEM_ERROR + 0x00)
/* I/O was not on a legal processor boundary */
#define CMFS_EILLEGAL_PROCESSOR 	(FIRST_CM_FILE_SYSTEM_ERROR + 0x01)
/* The file has a different width than the current configuration */
#define CMFS_EDIFFERENT_VIRTUAL_SIZE	(FIRST_CM_FILE_SYSTEM_ERROR + 0x02)
/* File server return count was an invalid value */
#define CMFS_EINVALID_RETURN_COUNT	(FIRST_CM_FILE_SYSTEM_ERROR + 0x03)
/* No CMIOC board available for this I/O */
#define CMFS_ENO_CMIOC 		 	(FIRST_CM_FILE_SYSTEM_ERROR + 0x04)
/* Stripe not available */
#define CMFS_ESTRIPE_NOTAVAIL		(FIRST_CM_FILE_SYSTEM_ERROR + 0x05)
/* CM I/O Bus unreachable */
#define CMFS_ECMIOBUS_UNREACH		(FIRST_CM_FILE_SYSTEM_ERROR + 0x06)
/* 
 * CMFS protocol mismatch -- file server using old protocol version
 * or loss of synchronization on the tcp/ip connection
 */
#define CMFS_EPROTOCOL_MISMATCH		(FIRST_CM_FILE_SYSTEM_ERROR + 0x07)
/* Synchronization lost */
#define CMFS_ESYNC_LOST			(FIRST_CM_FILE_SYSTEM_ERROR + 0x08)
/* file server not running */
#define CMFS_ENO_FILE_SERVER		(FIRST_CM_FILE_SYSTEM_ERROR + 0x09)
/* Raw HIPPI attempted on Ultranet */
#define CMFS_ERAW_ULTRA			(FIRST_CM_FILE_SYSTEM_ERROR + 0x0A)

/* Grrrr!  Hardware errors belong above, not here!!! */
/* CMHIPPI Source board detected a parity error */
#define CMFS_EHIPPI_SRC_PARITY		(FIRST_CM_FILE_SYSTEM_ERROR + 0x0B)
/* CMHIPPI Destination board detected a parity error */
#define CMFS_EHIPPI_DST_PARITY		(FIRST_CM_FILE_SYSTEM_ERROR + 0x0C)
/* CMHIPPI IOP board detected a parity error */
#define CMFS_EHIPPI_IOP_PARITY		(FIRST_CM_FILE_SYSTEM_ERROR + 0x0D)

#ifndef NO_BACK_COMPATIBILITY
/*
 * The following defines are provided for backwards compatibility
 * with 4.3; new programs should use the CMFS_ defines listed above;
 * these defines will eventually disappear -- so convert your programs!!
 */
#define	CM_EPERM		CMFS_EPERM
#define	CM_ENOENT		CMFS_ENOENT
#define	CM_ESRCH		CMFS_ESRCH
#define	CM_EINTR		CMFS_EINTR
#define	CM_EIO			CMFS_EIO
#define	CM_ENXIO		CMFS_ENXIO
#define	CM_E2BIG		CMFS_E2BIG
#define	CM_ENOEXEC		CMFS_ENOEXEC
#define	CM_EBADF		CMFS_EBADF
#define	CM_ECHILD		CMFS_ECHILD
#define	CM_EAGAIN		CMFS_EAGAIN
#define	CM_ENOMEM		CMFS_ENOMEM
#define	CM_EACCES		CMFS_EACCES
#define	CM_EFAULT		CMFS_EFAULT
#define	CM_ENOTBLK		CMFS_ENOTBLK
#define	CM_EBUSY		CMFS_EBUSY
#define	CM_EEXIST		CMFS_EEXIST
#define	CM_EXDEV		CMFS_EXDEV
#define	CM_ENODEV		CMFS_ENODEV
#define	CM_ENOTDIR		CMFS_ENOTDIR
#define	CM_EISDIR		CMFS_EISDIR
#define	CM_EINVAL		CMFS_EINVAL
#define	CM_ENFILE		CMFS_ENFILE
#define	CM_EMFILE		CMFS_EMFILE
#define	CM_ENOTTY		CMFS_ENOTTY
#define	CM_ETXTBSY		CMFS_ETXTBSY
#define	CM_EFBIG		CMFS_EFBIG
#define	CM_ENOSPC		CMFS_ENOSPC
#define	CM_ESPIPE		CMFS_ESPIPE
#define	CM_EROFS		CMFS_EROFS
#define	CM_EMLINK		CMFS_EMLINK
#define	CM_EPIPE		CMFS_EPIPE

/* math software */
#define	CM_EDOM			CMFS_EDOM
#define	CM_ERANGE		CMFS_ERANGE

/* non-blocking and interrupt i/o */
#define	CM_EWOULDBLOCK		CMFS_EWOULDBLOCK
#define	CM_EINPROGRESS		CMFS_EINPROGRESS
#define	CM_EALREADY		CMFS_EALREADY
/* ipc/network software */

	/* argument errors */
#define	CM_ENOTSOCK		CMFS_ENOTSOCK
#define	CM_EDESTADDRREQ		CMFS_EDESTADDRREQ
#define	CM_EMSGSIZE		CMFS_EMSGSIZE
#define	CM_EPROTOTYPE		CMFS_EPROTOTYPE
#define	CM_ENOPROTOOPT		CMFS_ENOPROTOOPT
#define	CM_EPROTONOSUPPORT	CMFS_EPROTONOSUPPORT
#define	CM_ESOCKTNOSUPPORT	CMFS_ESOCKTNOSUPPORT
#define	CM_EOPNOTSUPP		CMFS_EOPNOTSUPP
#define	CM_EPFNOSUPPORT		CMFS_EPFNOSUPPORT
#define	CM_EAFNOSUPPORT		CMFS_EAFNOSUPPORT
#define	CM_EADDRINUSE		CMFS_EADDRINUSE
#define	CM_EADDRNOTAVAIL	CMFS_EADDRNOTAVAIL

	/* operational errors */
#define	CM_ENETDOWN		CMFS_ENETDOWN
#define	CM_ENETUNREACH		CMFS_ENETUNREACH
#define	CM_ENETRESET		CMFS_ENETRESET
#define	CM_ECONNABORTED		CMFS_ECONNABORTED
#define	CM_ECONNRESET		CMFS_ECONNRESET
#define	CM_ENOBUFS		CMFS_ENOBUFS
#define	CM_EISCONN		CMFS_EISCONN
#define	CM_ENOTCONN		CMFS_ENOTCONN
#define	CM_ESHUTDOWN		CMFS_ESHUTDOWN
#define	CM_ETOOMANYREFS		CMFS_ETOOMANYREFS
#define	CM_ETIMEDOUT		CMFS_ETIMEDOUT
#define	CM_ECONNREFUSED		CMFS_ECONNREFUSED

	/* */
#define	CM_ELOOP		CMFS_ELOOP
#define	CM_ENAMETOOLONG		CMFS_ENAMETOOLONG

/* should be rearranged */
#define	CM_EHOSTDOWN		CMFS_EHOSTDOWN
#define	CM_EHOSTUNREACH		CMFS_EHOSTUNREACH
#define	CM_ENOTEMPTY		CMFS_ENOTEMPTY

/* quotas & mush */
#define	CM_EPROCLIM		CMFS_EPROCLIM
#define	CM_EUSERS		CMFS_EUSERS
#define	CM_EDQUOT		CMFS_EDQUOT

/* NFS error codes */
#define CM_ESTALE		CMFS_ESTALE
#define CM_EREMOTE		CMFS_EREMOTE

/* IPC errors
 */
#define CM_ENOMSG		CMFS_ENOMSG
#define CM_EIDRM		CMFS_EIDRM

/* Alignment error of some type (i.e., cluster, page, block ...) */
#define CM_EALIGN		CMFS_EALIGN

/* System V mappings from BRL package
 */
#define CM_EDEADLK	CMFS_EDEADLK

/* External definition of errno from System V
 */
#ifndef KERNEL
#define CM_errno	CMFS_errno
#endif


/*  Data Vault specific errors */
#define FIRST_DVC_ERROR 0x80 

/*	The following error codes are set by the file system software */
#define FIRST_CM_FILE_SYSTEM_ERROR	(FIRST_DVC_ERROR + 0x30)

#define CM_ECMIOC_PARITY 		CMFS_ECMIOC_PARITY
#define CM_EILLEGAL_PROCESSOR 	CMFS_EILLEGAL_PROCESSOR
#define CM_EDIFFERENT_VIRTUAL_SIZE	CMFS_EDIFFERENT_VIRTUAL_SIZE
#define CM_EINVALID_RETURN_COUNT	CMFS_EINVALID_RETURN_COUNT
#define CM_ENO_CMIOC 		 	CMFS_ENO_CMIOC
#endif

#endif /* _CM_ERRNO */
