/* -*- Package: CMFS-I; Base: 10; Mode: C; -*- */
/*
 * Copyright (c) 1987 Regents of the University of California.
 * This file may be freely redistributed provided that this
 * notice remains attached.
 */

#if !defined(__CM_DIR_H__)
#if !defined(lint) && !defined(__SABER__)
static char* rcsid_cm_dir_h = "$Id: cm_dir.h,v 1.27 1992/06/11 21:27:47 taylor Exp $";
#endif

/*
 * This file, <cm/cm_dir.h> is similar to the system <sys/dir.h> file
 *
 * There may be conflicts if both <sys/dir.h> and this file
 * are included in the same file.  This will be addressed at
 * a future time.  Portions of this file are derived from ndir.h
 * distributed as part of patch 17 by Berkeley.
 */

#define CMMAXNAMLEN	255

struct	cm_direct {
	u_long	cmd_ino;		/* inode number of entry */
	u_short	cmd_reclen;		/* length of this record */
	u_short	cmd_namlen;		/* length of string in d_name */
	char	cmd_name[CMMAXNAMLEN + 1];/* name must be no longer than this */
};

#define cmd_fileno	cmd_ino	/* sun compatibility */
/*
 * The DIRSIZ macro gives the minimum record length which will hold
 * the directory entry.  This requires the amount of space in struct direct
 * without the d_name field, plus enough space for the name with a terminating
 * null byte (dp->d_namlen+1), rounded up to a 4 byte boundary.
 */
#undef CMDIRSIZ
#define CMDIRSIZ(dp) \
    ((sizeof (struct cm_direct) - (CMMAXNAMLEN+1)) + (((dp)->cmd_namlen+1 + 3) &~ 3))

/*
 * Definitions for library routines operating on directories.
 */
typedef struct _cmdirdesc {
	int	dd_fd;
	long	dd_loc;
	long	dd_size;
	long	dd_bbase;
	long	dd_entno;
	long	dd_bsize;
	char	*dd_buf;
} CMDIR;

#ifndef NULL
#define NULL 0
#endif
extern	CMDIR *CMFS_opendir();
extern	struct cm_direct *CMFS_readdir();
extern	long CMFS_telldir();
extern	void CMFS_seekdir();
#define CMFS_rewinddir(dirp)	CMFS_seekdir((dirp), (long)0)
extern int CMFS_closedir();
#endif	/* __CM_DIR_H__ */
