;;; -*- Mode: LISP; Syntax: Common-lisp; Package: *lisp-i; Base: 10; Patch-File: T  -*-

(in-package '*lisp-i)

;;; For some unknown reason the 
;;; (slc::transform-expect-pvar-argument vector-pvar)
;;; forms were all commented out.  Jeff claims this
;;; can't possibly result in a bug, so we are uncommenting
;;; them back in.

;;; Also, the obsolte sf-v$-constant function ftype processors were not
;;; checking that their arguments were pvars (and thus promoting
;;; them to pvars if they are scalars)

;;; JP Massar.  10/30/91


(slc::define-transform v+scalar!! (vector-pvar scalar-pvar)
  (slc::transform-expect-pvar-argument vector-pvar)
  (slc::transform-expect-pvar-argument scalar-pvar)
  (if (and (slc::array-pvar-node-p vector-pvar) 
	   (*lisp-i::dimensions-ok-p (slc::node-pvar-array-dimensions vector-pvar)))
      `(v+!! ,vector-pvar
             (make-array!! (the fixnum ,(car (slc::node-pvar-array-dimensions vector-pvar)))
			   :element-type ',(slc::node-pvar-array-element-type vector-pvar)
			   :initial-element ,scalar-pvar))
      (slc::transform-pass)))



(slc::define-transform v-scalar!! (vector-pvar scalar-pvar)
  (slc::transform-expect-pvar-argument vector-pvar)
  (slc::transform-expect-pvar-argument scalar-pvar)
  (if (and (slc::array-pvar-node-p vector-pvar) 
	   (*lisp-i::dimensions-ok-p (slc::node-pvar-array-dimensions vector-pvar)))
      `(v-!! ,vector-pvar
             (make-array!! (the fixnum ,(car (slc::node-pvar-array-dimensions vector-pvar)))
			   :element-type ',(slc::node-pvar-array-element-type vector-pvar)
			   :initial-element ,scalar-pvar))
      (slc::transform-pass)))


(slc::define-transform v*scalar!! (vector-pvar scalar-pvar)
  (slc::transform-expect-pvar-argument vector-pvar)
  (slc::transform-expect-pvar-argument scalar-pvar)
  (if (and (slc::array-pvar-node-p vector-pvar) 
	   (*lisp-i::dimensions-ok-p (slc::node-pvar-array-dimensions vector-pvar)))
      `(v*!! ,vector-pvar
             (make-array!! (the fixnum ,(car (slc::node-pvar-array-dimensions vector-pvar)))
			   :element-type ',(slc::node-pvar-array-element-type vector-pvar)
			   :initial-element ,scalar-pvar))
      (slc::transform-pass)))


(slc::define-transform v/scalar!! (vector-pvar scalar-pvar)
  (slc::transform-expect-pvar-argument vector-pvar)
  (slc::transform-expect-pvar-argument scalar-pvar)
  (if (and (slc::array-pvar-node-p vector-pvar) 
	   (*lisp-i::dimensions-ok-p (slc::node-pvar-array-dimensions vector-pvar)))
      `(v/!! ,vector-pvar
             (make-array!! (the fixnum ,(car (slc::node-pvar-array-dimensions vector-pvar)))
			   :element-type ',(slc::node-pvar-array-element-type vector-pvar)
			   :initial-element ,scalar-pvar))
      (slc::transform-pass)))


(slc::define-ftype sf-v*-constant!! (vector-pvar scalar-pvar)
  (slc::ftype-expect-pvar-argument vector-pvar 'sf-v*-constant!!)
  (slc::ftype-expect-pvar-argument scalar-pvar 'sf-v*-constant!!)
  (slc::ftype-pass))

(slc::define-ftype sf-v+-constant!! (vector-pvar scalar-pvar)
  (slc::ftype-expect-pvar-argument vector-pvar 'sf-v+-constant!!)
  (slc::ftype-expect-pvar-argument scalar-pvar 'sf-v+-constant!!)
  (slc::ftype-pass))

(slc::define-ftype sf-v--constant!! (vector-pvar scalar-pvar)
  (slc::ftype-expect-pvar-argument vector-pvar 'sf-v--constant!!)
  (slc::ftype-expect-pvar-argument scalar-pvar 'sf-v--constant!!)
  (slc::ftype-pass))


(*lisp-i::increment-patch-level 6)
