
(in-package 'slc)

;;; This tells the compiler that CHAR-UPCASE will return the type of 
;;; character passed to it, so that the call to MAKE-CHAR which is in
;;; the macroexpansion of CHAR-EQUAL!! would work for string-char pvars.

;;; Andy Wilson 6/3/92 (Patch by Jeff Mincy)

(define-special-ftype make-char (character &optional (bits 0) (font 0))
  (declare (ignore character))
  (if (and (eql 0 bits) (eql 0 font)) 'string-char '(or null character)))

(define-special-ftype (char-upcase char-downcase) (character)
  (let ((type (descriptor-type (node-descriptor character))))
    (if (eq type 'string-char)
	'string-char
	'character)))

(*lisp-i::increment-patch-level 16)
