;;; -*- Base: 10; Syntax: Common-Lisp; Package: cmi; Patch-File: Yes; -*- 

;;; Patch for broken flag save.
;;; 6104 ucode didn't save the physical context flag correctly..
;;; Thanks to Bromley for finding this!
;;; 10/28/91 19:43:29 nesheim
;;;

(in-package 'cmi)

(def-min-mic write-beta-chip-state-to-memory-slicewise (maddr)
  "First, save the flipper rugs, so we can strighten them out for the remaining saves"

  "Load the condition latch with 0 (all context off) and
   Read flip0 rug into the C latch, then store it by doing STORE with context off (stores unflipped)"
  (ui (alu-simp (+ maddr 1) (Y maddr) (maddr $EXP)) (ld-maddr maddr)
      (mop::rug-r-c :address :flip0))
  (ui (mop::loadb nil :condition-flag :zero-flag :condition-invert nil))
  (ui (mop::store :write-flag :sink-flag))
  "Do the same with flip1"
  (ui (alu-simp (+ maddr 1) (Y maddr) (maddr $EXP)) (ld-maddr maddr)
      (mop::rug-r-c :address :flip1))
  (ui (mop::loadb nil :condition-flag :zero-flag :condition-invert nil))
  (ui (mop::store :write-flag :sink-flag))

  ;; reset the flipper for remaining stores
  (ui (mop::loadi :data 0))
  (ui (mop::rug-w-a :address :flip0))
  (ui (mop::rug-w-a :address :flip1))

  "Load the condition latch with 1's"
  (ui (mop::loadb :f :condition-flag :zero-flag :condition-invert t))

  ;; write context flag to memory
  (ui (alu-simp (+ maddr 1) (Y maddr) (maddr $EXP)) (ld-maddr maddr)
      (mop::loada :f :read-flag :context-flag :pmode :ecc :bsel :normal))
  (ui (mop::store :write-flag :zero-flag :pmode :ecc))

  ;; write carry flag to memory
  (ui (alu-simp (+ maddr 1) (Y maddr) (maddr $EXP)) (ld-maddr maddr)
      (mop::loada :f :read-flag :carry-flag :pmode :ecc :bsel :normal))
  (ui (mop::store :write-flag :zero-flag :pmode :ecc))

  ;; write test flag to memory
  (ui (alu-simp (+ maddr 1) (Y maddr) (maddr $EXP)) (ld-maddr maddr)
      (mop::loada :f :read-flag :test-flag :pmode :ecc :bsel :normal))
  (ui (mop::store :write-flag :zero-flag :pmode :ecc))

  ;; write overflow flag to memory
  (ui (alu-simp (+ maddr 1) (Y maddr) (maddr $EXP)) (ld-maddr maddr)
      (mop::loada :f :read-flag :overflow-flag :pmode :ecc :bsel :normal))
  (ui (mop::store :write-flag :zero-flag :pmode :ecc))

  ;; Save all cube-control rug saved (flipper saved above)

  (ui (alu-simp (+ maddr 1) (Y maddr) (maddr $EXP)) (ld-maddr maddr)
      (mop::rug-r-c :address :cube-control))
  (ui (mop::rug-r-a :address :sink))
  )


(eval-when (load eval)
  ;(warn "You must do a (cmi::link-paris) to apply the timesharing context switch patch") 
  (cmi::increment-patch-level 2))
