;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CMI; Base: 10; Patch-File: Yes -*-

(in-package 'cmi)

(defun cm:get-1l (dest send-address source length)
  (let (source-dest-the-same)
    (with-any-vp-fields ((dest :location dloc)
			 (source :location sloc))
      (setq source-dest-the-same (= dloc sloc))
      )
    (when source-dest-the-same
      ;; Handle identical source and dest by getting to a temp and then copying to the dest.
      (let ((dest-temp (cm:allocate-stack-field length)))
	(cm:get-1l dest-temp send-address source length)
	(cm:u-move-1l dest dest-temp length)
	(cm:deallocate-stack-through dest-temp)
	(return-from cm:get-1l (values)))))
  ;; note: the current vp set is the dest and send-address vp set, not the source vp set 
  (let* ((transpose-length (* (ceiling (min length cm:*maximum-message-length*) 32) 32))
	 (source-vp-set (cm:field-vp-set source))
	 (source-geometry (cm:vp-set-geometry source-vp-set))
	 (source-vp-ratio (cm:geometry-total-vp-ratio source-geometry))
	 (dest-vp-ratio *current-vp-ratio*))

    ;; The delivery code OR's the incoming data with the dest.  We have
    ;; to clear the active dest elements for this to work.
    (cm:u-move-zero-1l dest length)

    (with-stack-fields-vp-set source-vp-set ((slice-source transpose-length))

      (let* ((available-unsafe   (cm:available-memory))
	     (safety-per-bank    (ceiling *router-safe-allocation-buffer* dest-vp-ratio))
	     (available-per-bank (- available-unsafe safety-per-bank))
	     (available-total    (* available-per-bank dest-vp-ratio))
	     (K64-1 (1- (ash 1 16)))
	     (K16   (ash 1 14))
	     ;; the following are all slices per bank
	     (max-16K-total    (truncate (router-at-most K16   available-total) dest-vp-ratio))
	     (max-64K-total    (truncate (router-at-most K64-1 available-total) dest-vp-ratio))
	     (max-64K-per-bank           (router-at-most K64-1 available-per-bank))
	     )
	(when *router-divided-get-debugging*
	  (format t "~%available total: ~d   available/bank: ~d" available-total available-per-bank)
	  (format t "~%max-16K-total: ~d   max-64K-total: ~d   max-64K-per-bank: ~d"
		  max-16K-total max-64K-total max-64K-per-bank)
	  (format t "~%*router-divided-get-p*:~d  *timesharing*: ~d"
		  *router-divided-get-p* *timesharing*))
	(cond ((not *timesharing*)
	       ;; not timesharing: 64k per bank
	       (when *router-divided-get-debugging*
		 (format t "~%Max 64K/bank, slices/bank: ~d;  available: ~d"
			 max-64K-per-bank available-total))
	       (get-allocate-trace max-64K-per-bank
				   send-address dest slice-source source
				   source-geometry source-vp-ratio dest-vp-ratio length))
	      (*router-divided-get-p*
		;; divided timesharing: 16K total, 1 iteration, then 64K total, then 64K per bank
		(when *router-divided-get-timesharing-try-16K-total*
		  (when *router-divided-get-debugging*
		    (format t "~%Max 16K total, slices/bank: ~d;  available: ~d"
			    max-16K-total available-total))
		  (let ((iterations-save *router-divided-iterations*))
		    (router-divided-iterations-set *router-divided-get-timesharing-16K-iterations*)
		    (get-allocate-trace max-16K-total
					send-address dest slice-source source
					source-geometry source-vp-ratio dest-vp-ratio length)
		    (router-divided-iterations-set iterations-save)))
		(when (and *router-get-ran-out-of-space* (> available-total K16))
		  (when *router-divided-get-timesharing-try-64K-total*
		    (when *router-divided-get-debugging*
		      (format t "~%Max 64K total, slices/bank: ~d;  available: ~d"
			      max-64K-total available-total))
		    (get-allocate-trace max-64K-total
					send-address dest slice-source source
					source-geometry source-vp-ratio dest-vp-ratio length))
		  (when (and *router-get-ran-out-of-space*
			     (> available-total K64-1))
		    (when *router-divided-get-debugging*
		      (format t "~%Max 64K/bank, slices/bank: ~d;  available: ~d"
			      max-64K-per-bank available-total))
		    (get-allocate-trace max-64K-per-bank
					send-address dest slice-source source
					source-geometry source-vp-ratio dest-vp-ratio length)
		    )))
	      (t
		;; undivided timesharing; 64K total (old style), then 64k per bank
		(when *router-divided-get-debugging*
		  (format t "~%Max 64K total, slices/bank: ~d;  available: ~d"
			  max-64K-total available-total))
		(get-allocate-trace max-64K-total
				    send-address dest slice-source source
				    source-geometry source-vp-ratio dest-vp-ratio length)
		(when (and *router-get-ran-out-of-space*
			   (> available-total K64-1))
		  (when *router-divided-get-debugging*
		    (format t "~%Max 64K/bank, slices/bank: ~d;  available: ~d"
			    max-64K-per-bank available-total))
		  (get-allocate-trace max-64K-per-bank
				      send-address dest slice-source source
				      source-geometry source-vp-ratio dest-vp-ratio length)
		  ))
	      ))))
  (when *router-get-ran-out-of-space*
    (when cm:*error-on-failed-get*
      (error "cm:get-1l failed because it did not have enough stack space."))
    (funcall cm:*alternative-get-function* dest send-address source length))
  (values))

(cmi::increment-patch-level 21)
