#ifndef _CMREG_
#define _CMREG_

#if !defined(lint) && !defined(LC) && !defined(__SABER__)
static char rcsid_cmreg[] = "$Id: cmreg.h,v 1.11 1991/10/01 04:30:46 sean Rel $";
#endif

/*****************************************************************************
* 	  (c) Copyright  1990 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#ifdef sun

/* 
** These are the registers on the vmefebi device Rev 2 5/30/88
*/

typedef struct {
    long	cm_csr_a[256];		/* Control/Status register (R/W) */
    long	cm_vec_a[256];		/* Interrupt vector (R/W) */
    long	cm_data_a[256];		/* last hbus data (R/W) */
    long	cm_hstat_a[256];	/* HBUS status (RO) */
    long	cm_nsr_a[256];		/* NEXUS status (R/W) */
    long	cm_nshad_a[256];	/* NEXUS shadow (R/W) */
    long	cm_ucsr0_a[256];	/* UCC status reg 0 (R/W) */
    long	cm_ucsr1_a[256];	/* UCC status reg 1 (RO) */
    long	cm_ucsr2_a[256];	/* UCC status reg 2 (cm1, RO) */
    long	cm_uccsa_a[256];	/* UCC control store address (R/W) */
    long	cm_uccsd_a[256];	/* UCC control store data (R/W) */
    long	cm_hnoop_a[256];	/* HBUS Noop (force timeout errors */
    long	cm_rsvd1_a[256 * 4];	/* offset 3000 - 3fff reserved */
    
    long	cm_ucfifo_a[256];	/* UCC input/output fifo */
    long	cm_rsvd2_a[256 * 15];	/* offset 4400 - 7fff reserved */
    long	cm_eeprom[8192];	/* EEPROM */
} CM_REGS;

#define	cm_csr		cm_csr_a[0]
#define	cm_vec		cm_vec_a[0]
#define	cm_data		cm_data_a[0]
#define	cm_hstat	cm_hstat_a[0]
#define	cm_nsrl		cm_nsr_a[0]
#define	cm_nsrh		cm_nshad_a[0]
#define	cm_ucsr0	cm_ucsr0_a[0]
#define cm_ucsr1	cm_ucsr1_a[0]
#define	cm_ucsr2	cm_ucsr2_a[0]
#define	cm_uccsa	cm_uccsa_a[0]
#define	cm_uccsd	cm_uccsd_a[0]
#define cm_hnoop	cm_hnoop_a[0]
#define	cm_ucfifo	cm_ucfifo_a[0]

/* CSR bits */

#define CM_CSR_BITS	"\20\10IE\11IE_IFMT\12IE_IFIR\13IE_OFOR\14FORCEPARERR\15IE_ACCERR\16IE_TIMEOUT\17IE_PARERR\20IE_CMEX\21DO_BERR\22CHECK_PAR\23HERR_DISABLE\24HASYNC\25HENABLE\26EEPROMNBSY\27EEPROMWEN\30SRESET\31IC_IFMT\32IC_IFIR\33IC_OFOR\34HDIRTY\35IC_ACCERR\36IC_TIMEOUT\37IC_PARERR\40IC_CMEX"

#define CM_INTLEV		3

#define CM_TIMEOUT		0x2		/* timeout value */
#define CM_CSR_INTLEV		0x30		/* interrupt level */

#define	CM_IE			0x80		/* master int. enable */
#define	CM_IE_IFMT		0x100		/* int on ififo empty */
#define	CM_IE_IFIR		0x200		/* int on ififo input ready */
#define CM_IE_OFOR		0x400		/* int on something in ofifo */
#define CM_FORCE_PARERR		0x800		/* force hbus parity error */
#define	CM_IE_ACCERR		0x1000		/* int on access error */
#define	CM_IE_TIMEOUT		0x2000		/* int on HBUS timeout */
#define	CM_IE_PARERR		0x4000		/* int on HBUS parity error */
#define	CM_IE_CMEX		0x8000		/* int on CM Exception */

#define	CM_DO_BERR		0x10000		/* do buserr on HBUS timeout */
#define	CM_CHECK_PAR		0x20000		/* Check HBUS parity */
#define	CM_HERR_DISABLE		0x40000		/* disable HBUS on error */
#define	CM_HASYNC		0x80000		/* allow async HBUS ops */

#define	CM_HENABLE		0x100000	/* enable hbus signals */
#define CM_EENOTBUSY		0x200000	/* EEprom not busy  (R/O)*/
#define CM_EEWEN		0x400000	/* EEprom write enable */
#define	CM_BRESET		0x800000	/* Soft reset */

/*
** Some useful combinations of above CSR bits
** Note interrupts on errors arn't enabled by default, as the user code
** checks for them, *not* the interrupt handler
*/

#define CM_CSR_INIT (CM_HENABLE    | CM_CHECK_PAR  | CM_HASYNC |\
		     CM_IE         | CM_TIMEOUT    | CM_CSR_INTLEV)


/* Interrupt Condition bits */
/* "soft" interrupts */
#define	CM_IC_IFMT		0x1000000	/* ififo became empty */
#define	CM_IC_IFIR		0x2000000	/* ififo input ready */
#define	CM_IC_OFOR		0x4000000	/* ofifo became ready */

#define CM_HDIRTY		0x8000000	/* hbus dirty */

/* "hard" errors */
#define	CM_IC_ACCERR		0x10000000	/* Access Error */
#define	CM_IC_TIMEOUT		0x20000000	/* HBUS Timeout */
#define	CM_IC_PARERR		0x40000000	/* HBUS Parity err */
#define	CM_IC_CMEX		0x80000000	/* CM Exception */

/* useful composite bit constants */
#define CM_IC_BITS (CM_IC_ACCERR|CM_IC_TIMEOUT|CM_IC_PARERR|CM_IC_CMEX|CM_IC_IFMT|CM_IC_IFIR|CM_IC_OFOR)
#define CM_HARD_ERR (CM_IC_ACCERR|CM_IC_TIMEOUT|CM_IC_PARERR|CM_IC_CMEX)
#define CM_HARD_INT_ENABLE (CM_IE_ACCERR|CM_IE_TIMEOUT|CM_IE_PARERR|CM_IE_CMEX)
#define CM_SOFT_ERR (CM_IC_IFMT|CM_IC_IFIR|CM_IC_OFOR)
#define CM_SOFT_INT_ENABLE (CM_IE_IFMT|CM_IE_IFIR|CM_IE_OFOR)

/* Bits in HSTAT */

#define	HS_IFIR		0x01	/* Input fifo ready */
#define	HS_IFMT		0x02	/* Input fifo empty */
#define HS_HERROR	0x04	/* hbus error has occurred */
#define	HS_OFOR		0x08	/* Output fifo ready */

#define HS_HDERROR	0x10	/* HBUS error due to HBUS disabled */
#define	HS_CMEX		0x20	/* CM Exception */
#define	HS_IF_RDY	0x80	/* IFIR and no pending error */

#define HS_RSEL_MASK	0xf00
#define HS_RSEL_SHIFT	8

#define	HS_PAR		0x1000	/* hbus odd parity bit on last transaction */
#define	HS_PARVAL	0x2000	/* parity valid bit on last transaction */
#define	HS_OF_RDY	0x8000	/* OFOR and no pending error */

#define CM_HSTAT_BITS	"\20\1IFIR\2IFMT\3HERROR\4OFOR\5HDBERR\6CMEX\10IF_RDY\15OPAR\16PARVAL\20OF_RDY"

#define CM_EEPROMSIZE	2048	/* size of EEPROM, bytes (but accessed  at longword locs */

#define CM_SHMEM_OFFSET	(sizeof (CM_REGS))	/* offset to use to mmap the soft-regs */

#endif 

#ifdef vax

/*
 * Connection Machine Front End Interface register definitions for the VAX.
 */

#ifndef LC
#ifndef KERNEL
/* #include <vaxbi/bireg.h> */
#include "/sys/io/bi/bireg.h"
#endif


/*
 * BIBI registers
 * This is a node in the BI address space (8 KB).
 * Some of these are arrays because any address in the range will access
 * the associated BIBI register. See below for standard name #defines.
 *
 * 1/30/90 11:36:53 nesheim: Updated for BIBI rev 5
 */

#define CM_NUMBER_OF_REG_PAGES 16


typedef struct cm_regs {
	struct biic_regs cm_biic;	/* 0000 - BIIC specific registers */
	long  cm_slave_sreg;		/* 0100 - slave only status register */
	long  cm_reserved1[64 - 1];
	long  cm_recv_con_dreg;		/* 0200 - receive console data reg. */
	long  cm_reserved2[128 - 1];
	long  cm_discard_regA[128];	/* 0400 - BIBI discard register */
	long  cm_csrA[128];		/* 0600 - control and status reg. */
	long  cm_io_fifoA[128];		/* 0800 - input/output fifo register */
	long  cm_uc_sreg0A[128];	/* 0A00 - u-controller status reg. 0 */
	long  cm_uc_sreg1A[128];	/* 0C00 - u-controller status reg. 1 */
	long  cm_uc_sreg2A[128];	/* 0E00 - u-controller status reg. 2 */
	long  cm_uc_sreg3A[128];	/* 1000 - u-controller status reg. 3 */
	long  cm_nexus_reg0A[128];	/* 1200 - nexus register 0 (status) */
	long  cm_nexus_reg123A[128];	/* 1400 - nexus registers 1, 2, 3 */
	long  cm_uc_addr_regA[128];	/* 1600 - beta micro address reg */
	long  cm_uc_data_regA[128];	/* 1800 - beta micro data reg */
	long  cm_reserved3[128];	/* 1A00 */
	/*
	** For compatibility with previous versions of the device driver, we need
	** to define the software registers variables. Nothing is actually mapped
	** here.
	*/
	long  cm_soft_regs[128];
	char  cm_error_report[128*4];
} CM_REGS;


/*
** The names below are the ones that will be used by most programs.
** E.g., given an address:  ((struct cm_regs *) address)->cm_csr gives the
** current value of the command and status register.
**
** These names have been chosen to conform to those used by the Sun version
** of the device driver.
*/

#define cm_csr		cm_csrA[0]
#define cm_ucfifo	cm_io_fifoA[0]
#define cm_ucsr0	cm_uc_sreg0A[0]
#define cm_ucsr1	cm_uc_sreg1A[0]
#define cm_ucsr2	cm_uc_sreg2A[0]
#define cm_ucsr3	cm_uc_sreg3A[0]
#define cm_nsrl		cm_nexus_reg0A[0]
#define cm_uccsa	cm_uc_addr_regA[0]
#define cm_uccsd	cm_uc_data_regA[0]

/*
** Fields not present in Sun VME version
*/

#define cm_discard_reg	cm_discard_regA[0]
#define cm_nexus_reg123	cm_nexus_reg123A[0]

/*
** Backward compatibility with old code.
*/

#define cm_nexus_reg0	    cm_nexus_reg0A[0]
#define cm_nexus_lo_sreg    cm_nexus_reg0A[0]
#define cm_nexus_hi_sreg    cm_nexus_reg123A[0]
#endif LC

/*
 * CSR bit definitions
 */

/* Straight from the HBUS: */

#define CM_HBUS_ACK		0x80000000	/* HBUS acknowledge */
#define CM_HBUS_CM_EXCPT	0x40000000	/* HBUS CM exception */
#define CM_HBUS_IFIFO_NHF	0x20000000	/* UCC input FIFO not half full */
#define CM_HBUS_OFIFO_READY	0x10000000	/* UCC output FIFO ready */
#define CM_HBUS_PARITY_VALID	0x08000000	/* HBUS parity valid */
#define CM_HBUS_IFIFO_MT	0x00000400	/* UCC input FIFO empty */

/* Interrupt latches: */

#define CM_HARD_INT_L		0x04000000	/* BIBI hard interrupt */
#define CM_BI_ERR_LATCH_L	0x02000000	/* BI error */
#define CM_CM_PAR_ERR_LATCH_L	0x01000000	/* CM parity error */
#define CM_CM_EXCPT_LATCH_L	0x00800000	/* CM exception */
#define CM_ACC_TIMEOUT_LATCH_L	0x00400000	/* access timeout */
#define CM_SOFT_INT_L		0x00200000	/* BIBI soft interrupt */
#define CM_OFIFO_NMT_LATCH	0x00100000	/* OFIFO not empty */
#define CM_FIFO_NHF_LATCH_L	0x00080000	/* HBUS FIFO not half full */
#define CM_FIFO_HF_LATCH_L	0x00040000	/*  "   "    half full */
#define CM_BIBI_MT_L		0x00020000	/* BIBI FIFO empty (NOT latched)*/
#define CM_BIT_16		0x00010000	/* reads as 0, used internally */
#define CM_BIT_15		0x00008000	/* reads as 0, used internally */
#define CM_BIT_14		0x00004000	/* reads as 0, used internally */


/* Diagnostic stuff and just junk: */

#define CM_BI_STOP_MODE		0x00002000	/* Junk */
#define CM_BI_BROKE		0x00001000	/* Always 0 */
#define CM_RESERVED		0x00000E00
#define CM_HBUS_PARITY_BIT	0x00000100	/* HBUS last parity bit latch */

/* Interrupt enabling / clearing: */

#define CM_CM_ERR_IE		0x00000080	/* On CM exception */
#define CM_FIFO_MT_IE		0x00000040	/* On UCC IFIFO going empty */
#define CM_BIT_5		0x00000020	/* Unused */
#define CM_FIFO_NHF_IE		0x00000010	/* On UCC IFIFO going half empty */
#define CM_DATA_AVAIL_IE	0x00000008	/* On UCC OFIFO going not empty */
#define CM_HARD_INT_CLEAR	0x00000004	/* hard interrupt clear */
#define CM_SOFT_INT_CLEAR	0x00000002	/* soft interrupt clear */

/* Loopback diagnostic mode control: */

#define CM_TEST_MODE_ENABLE	0x00000001	/* test mode enable */


/*
 * Most of the interesting bits for printf %b.
 */
#define  CM_CSR_BITS \
"\40HBUS-ACK\37HBUS-CM-EXCPT\36HBUS-IFIFO-NHF\35HBUS-OFIFO-RDY\
\34HBUS-PAR-VALID\33HARD-INT\32BI-ERR\31CM-PAR-ERR-LATCH\
\30CM-EXCPT-LATCH\27ACCESS-TIMEOUT\
\26SOFT-INT\25OFIFO-NMT-LATCH\24IFIFO-NHF-LATCH\23IFIFO-HF-LATCH\22BIBI-MT\
\13HBUS-IFIFO-MT\11HBUS-PAR\10CM-EXCP-IE\7IFIFO-MT-IE\
\5IFIFO-NHF-IE\4OFIFO-NMT-IE\3HARD-CLR\2SOFT-CLR\1TEST"

/*
 * The CSR should be ^ed with this before printf %b for aesthetic reasons.
 * (These are the "active low" signals.)
 */
#define CM_CSR_INVERTED \
	(CM_HARD_INT_L | CM_BI_ERR_LATCH_L | CM_CM_PAR_ERR_LATCH_L \
	| CM_CM_EXCPT_LATCH_L | CM_ACC_TIMEOUT_LATCH_L | CM_SOFT_INT_L \
	| CM_FIFO_NHF_LATCH_L | CM_FIFO_HF_LATCH_L | CM_BIBI_MT_L)

/*
 * These are the "hard error" bits that mean something is gravely
 * wrong (they are inverted so an error is detected when
 * (status & CM_HARD_ERRORS) != CM_HARD_ERRORS )
 */
#define CM_HARD_ERRORS \
	(CM_BI_ERR_LATCH_L | CM_CM_PAR_ERR_LATCH_L \
	| CM_CM_EXCPT_LATCH_L | CM_ACC_TIMEOUT_LATCH_L)

#endif

#define CM_VFIFO_READ_TIMEOUT	30
#define CM_VFIFO_WRITE_TIMEOUT	30

#endif
