#ifndef CKPT_H
#define CKPT_H yes

#if !defined(lint) && !defined(c_star) && !defined(__SABER__) && !defined(LC)
static char rcsid_ckpt_h[] = "$Id: ckpt.h,v 1.3 1991/11/21 03:36:36 dm Exp $";
#endif

/*
 * The environment variables used to communicate between resume and the
 * checkpointing package within the user's program.
 *
 * CKPT_ENV_FEPREFIX having a non-null value will trigger the resumption of a
 * checkpoint with data files with names that begin with the value of this
 * envariable.
 *
 * CKPT_ENV_CMPREFIX being non-null will mean that the CM state is stored on
 * a datavault, with a file-name beginning with the value of this envariable.
 */ 
#define CKPT_ENV_FEPREFIX   "CKPT_ENV_FEPREFIX"

#define CKPT_ERRMSG_LEN	256

/*
 * A selector which chooses whether the function is called as part of the
 * checkpoint saving process.
 */
typedef enum { CKPT_SAVE_HOOK, CKPT_RESTART_HOOK } ckpt_hook_id; 

typedef enum { ON_FE, ON_CM } filestate_place;
/*
 * A descriptor which contains that information about open files that the
 * checkpoint package preserves:
 *
 * - how it was opened.
 * - the current file pointer.
 * - the name of the file (or NULL, for those files which were passed as
 *   open file descriptors to the running program).
 * - what fd it is mapped to.
 */
typedef struct {
    char *name;
    filestate_place place;
    unsigned long offset;
    int access;
    int fd;
    struct termios *termios;
} filestate;
    
typedef struct {
    int priority;
    int (*func)();
    char *arg;
} hook;

/*
 * void ckpt_periodic(char *feprefix, char *cmprefix)
 *
 * The user should call this periodically (e.g., in the outer layers
 * of a time-consuming loop).  It is implemented as a macro which
 * tests the bit indicating it is time to do a checkpoint.  If the bit
 * is set, the checkpoint routine is called and the bit is cleared,
 * otherwise nothing happens.
 *
 * Except for the first call after a SIGALRM arrives, this macro
 * consists only of a test of a bit, and thus it is cheap enough to
 * use within loops.
 *
 * ckpt() must set ckpt_periodic_request_bit to 0
 */
extern int ckpt_periodic_request_bit;
#define ckpt_periodic(a,b) \
    if(ckpt_periodic_request_bit) ckpt(a,b);

/*
 * ckpt_periodic_with_return_value(char *feprefix, char *cmprefix)
 *
 * This macro is provided for those users concerned enough with the
 * value returned by ckpt() to pay the price of an extra instruction
 * or two in their loop.
 *
 * The return values are the same as the return values of ckpt(), with
 * the addition of:
 *
 *	-2	No call to ckpt() was made.
 *
 * ckpt() must set ckpt_periodic_request_bit to 0
 */
#define ckpt_periodic_with_return_value(a,b) \
    (ckpt_periodic_request_bit? ckpt(a,b): -2)
 
/*
 * The user wants to use checkpointing on a front-end-only program, and
 * therefore does not want to link with libparis...
 *
 * We do this by having two versions of the checkpoint routines --- an
 * FE-only version, and a version that checkpoints both the CM and the FE,
 * the two versions exist in separate files.  The FE-only file declares
 * ckpt_fe_only, the other one declares ckpt_fe_and_cm_both.  These are the
 * unresolved references that cause the linker to choose between the two
 * files. 
 * 
 */
#ifdef CKPT_SKIP_CM_CODE
extern int ckpt_fe_only;
#else
extern int ckpt_fe_and_cm_both;
#endif /* CKPT_SKIP_CM_CODE */

/*
 * Checkpointing can take so long it is reassuring to get progress reports
 * periodically.
 */
extern int ckpt_verbose;

int ckpt_init();
int ckpt();
void ckpt_restart();
int ckpt_hook_set();
int ckpt_hook_delete();
void ckpt_periodic_start();
void ckpt_periodic_end();
void ckpt_periodic_request();

#ifndef CKPT_INTERNAL
extern char ckpt_errormsg[];
#endif /* CKPT_INTERNAL */

#endif /* CKPT_H */
