;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CMI; Base: 10; Patch-File: Yes -*-

(in-package 'cmi)

;;;
;;; PATCH 11/7/91 13:58:50 bromley
;;; This function lives in /cm/paris/hardware/news-scan/fnnnn/global-count-enum.lisp
;;;

(defun normalize-round-and-adjust-exponent (destination significant exponent signif-len total-signif-len dims expt-len)
  (with-stack-fields ((saved-context-flag 1)
		      (saved-overflow-flag 1)
		      (saved-carry-flag 1)
		      (saved-test-flag 1)
		      (clear-exponent 1)
		      (clear-significand 1)
		      (infinitize-exponent 1)
		      (count (+ expt-len 2))
		      (temp-exp (+ expt-len 2)))
			     
    (let ((unsigned-signif-len (- total-signif-len 1))
	  (hidden-bit (+ significant total-signif-len -2))
	  (sign-bit (+ significant total-signif-len -1))
	  (new-significant (- (+ significant total-signif-len) signif-len 2) ))
      
      ;; save away the flags
      (cm:move-always saved-context-flag  cm:context-flag  1)
      (cm:move-always saved-carry-flag    cm:carry-flag    1)
      (cm:move-always saved-overflow-flag cm:overflow-flag 1)
      (cm:move-always saved-test-flag     cm:test-flag     1)


      ;; negate field if negative
      (cm:move-always cm:context-flag sign-bit 1)
      (cm:negate significant significant unsigned-signif-len)
      (cm:move-always cm:context-flag saved-context-flag 1)

      ;; normalize and adjust exponent
      (unsigned-normalize-always significant count unsigned-signif-len expt-len)
      ;(ocm:add new-significant new-significant (- new-significant 1) signif-len signif-len 1)
      ;;(cm:u- exponent count expt-len)
      ;;(cm:u+constant exponent dims expt-len)
      (cm:move-constant-always (+ count expt-len) 0 2)
      (cm:unsigned-new-size temp-exp exponent (+ expt-len 2) expt-len)
      (cm:u- temp-exp count (+ expt-len 2))
      (cm:u+constant temp-exp dims (+ expt-len 2))

      (cm:clear-bit-always clear-exponent)
      (cm:clear-bit-always clear-significand)
      (cm:clear-bit-always infinitize-exponent)

      ;; If the high bit of temp-exp is on, the result underflowed, so we have to create a
      ;; zero.
      (cm:logior-2-1l clear-exponent (+ temp-exp expt-len 1) 1)
      (cm:logior-2-1l clear-significand (+ temp-exp expt-len 1) 1)

      ;; Turn off the underflowing processors.
      (cm:lognot cm:context-flag (+ temp-exp expt-len 1) 1)

      (cm:u-ge-constant-1l temp-exp (lognot (ash -1 expt-len)) (+ expt-len 1))
      (cm:store-test infinitize-exponent)
      (cm:store-test clear-significand)

      ;; If the significand is zero (ie the hidden bit is zero) we also have to clear the
      ;; exponent.
      (cm:lognot hidden-bit hidden-bit 1)
      (cm:logior-2-1l clear-exponent hidden-bit 1)

      ;; Clear the exponent if needed.
      (cm:load-context clear-exponent)
      (cm:u-move-zero-1l temp-exp expt-len)

      ;; Clear the significand if needed.
      (cm:load-context clear-significand)
      (cm:u-move-zero-1l new-significant signif-len)

      ;; Put all 1's in the exponent if needed.
      (cm:load-context infinitize-exponent)
      (cm:u-move-constant-1l temp-exp (lognot (ash -1 expt-len)) expt-len)

      ;; Move the pieces back into the destination.
      (cm:load-context saved-context-flag)
      (cm:move destination new-significant signif-len)
      (cm:move (+ destination signif-len) temp-exp expt-len)
      (cm:move (+ destination signif-len expt-len) sign-bit 1)

      ;; restore the flags
      (cm:move-always cm:context-flag  saved-context-flag 1)
      (cm:move-always cm:carry-flag    saved-carry-flag 1)
      (cm:move-always cm:overflow-flag saved-overflow-flag 1)
      (cm:move-always cm:test-flag     saved-test-flag 1)
      )
    ))
(cmi::increment-patch-level 8)
