#if !defined(lint) && !defined(__SABER__)
static char rcsid[] = "$Id: cm.c,v 61.33 1992/02/28 19:36:26 nesheim Exp $";
#endif

/*****************************************************************************
* 	  (c) Copyright  1990 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#define IDLEDETACH yes

/*
 * ACL_ANY_GROUPS means that a process with *any* of its groups listed in
 * the group access control list may open the CM for writing.
 *
 * If ACL_ANY_GROUPS is not defined, then ONLY THE EFFECTIVE GROUP of the
 * process is examined for access-list membership (this allows sites to
 * charge specific groups for the CM by requiring users to newgrp to the
 * group that represents their funding source).
 */
/* #define ACL_ANY_GROUP yes */


#ifndef LOADABLE_DRIVER
#include "cm.h"
#endif

#if NCM > 0 || defined (BINARY)

#ifdef sun
#define SUNOS4
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/dir.h>
#include <sys/buf.h>
#include <sys/systm.h>
#include <sys/conf.h>
#include <sys/map.h>
#include <sys/vmmac.h>
#include <sys/mman.h>
#include <vm/seg.h>
#include <sys/ioctl.h>
#include <sys/uio.h>
#include <sys/kernel.h>
#include <sys/proc.h>
#include <sys/user.h>
#include <sys/fcntl.h>
#include <sys/session.h>

#include <machine/pte.h>
#include <machine/psl.h>
#include <machine/mmu.h>
#include <machine/cpu.h>
#include <machine/scb.h>
#include <machine/vm_hat.h>
#include <vm/as.h>
#include <sun/vddrv.h>
#include <sundev/mbvar.h>

#define private static

#endif /* sun */

#ifdef vax
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/map.h"
#include "../h/buf.h"
#include "../h/vm.h"
#include "../h/bk.h"
#include "../h/file.h"
#include "../h/uio.h"
#include "../h/kernel.h"
#include "../h/cpuconf.h"
#include "../h/signal.h"
#include "../h/cpudata.h"
#include "../h/cmap.h"
#include "../h/kmalloc.h"

#include "../machine/vax/cpu.h"
#include "../machine/vax/mtpr.h"
#include "../machine/vax/nexus.h"
#include "../machine/vax/psl.h"
#include "../machine/vax/scb.h"
#include "../machine/vax/pte.h"

#include "../io/uba/ubareg.h"
#include "../io/uba/ubavar.h"

#define private 

#endif vax


#include "cmreg.h"
#include "cmioctl.h"
#include "cmacct.h"
#include "cmsoft.h"
#include "nexus-code.h"

/*
 * these are the ``reset register access bit'' and the diagnostic-mode
 * bit.  Generally, you don't want to write these bits, except when trying
 * to override the register access.
 */
#define NEXUS_R0_DONT_TOUCH	(0xf<<28)

int	cm_debug = 0;		/* General Debugging */
int	cm_verbose = 0;		/* Be verbose about timesharing errors */
int	cm_debug_timeouts = 0;
int	cm_debug_events = 0;

#ifdef CM_DEBUG
#define trace(X) 	if(cm_debug) printf(X)
#define trace2(X, Y) 	if(cm_debug) printf(X, Y)
#define traceN(X)	if(cm_debug) printf X
#else CM_DEBUG
#define trace(X)
#define trace2(X, Y)
#define traceN(X)
#endif CM_DEBUG

/*
 * SMP locks, for Ultrix 4.X
 */
#ifdef ultrix
#define ASSERT_PROCESS_LOCK_HELD()    0
#define ASSERT_NO_PROCESS_LOCK() 0
struct lock_t CMProcessLock;
struct lock_t CMFifoLock;
struct lock_t CMAcctLock;

#define AcquireProcessLock(s) smp_lock(&CMProcessLock, LK_RETRY)
#define AcquireFifoLock(s) smp_lock(&CMFifoLock, LK_RETRY)
#define AcquireAcctLock(s) smp_lock(&CMAcctLock, LK_RETRY)

#define ReleaseProcessLock(s) smp_unlock(&CMProcessLock)
#define ReleaseFifoLock(s) smp_unlock(&CMFifoLock)
#define ReleaseAcctLock(s) smp_unlock(&CMAcctLock)

#else
/*
 * SMP lock debugging on SunOS.
 */
char *ProcessLockStr = NULL;
char *FifoLockStr = NULL;
char *AcctLockStr = NULL;

#define ASSERT_PROCESS_LOCK_HELD() (ProcessLockStr ? 0 : \
				     printf("ProcessLock lock NOT held at line %d!\n", \
					    __LINE__))
#define ASSERT_NO_PROCESS_LOCK() (ProcessLockStr ? \
				  printf("ProcessLock held in error at line %d\n", \
					 __LINE__) : 0)

#define AcquireProcessLock(str)\
    (ProcessLockStr ? \
     (printf("Acquire ProcessLock(%s): already held by (%s)\n", \
	     (str), ProcessLockStr), 0):\
     ((ProcessLockStr = (str)), 1))
#define AcquireFifoLock(str)\
    (FifoLockStr ? \
     (printf("Acquire FifoLock(%s): already held by (%s)\n", \
	     (str), FifoLockStr), 0):\
     ((FifoLockStr = (str)), 1))
#define AcquireAcctLock(str)\
    (AcctLockStr ? \
     (printf("Acquire Acctlock(%s): already held by (%s)\n", \
	     (str), AcctLockStr), 0):\
     ((AcctLockStr = (str)), 1))

#define ReleaseProcessLock(str)\
    ( ProcessLockStr ? ((ProcessLockStr = NULL), 0) : \
     printf("ReleaseProcessLock (%s): no lock held!\n", (str)))
#define ReleaseFifoLock(str)\
    ( FifoLockStr ? ((FifoLockStr = NULL), 0) : \
     printf("ReleaseFifoLock (%s): no lock held!\n", (str)))
#define ReleaseAcctLock(str)\
    ( AcctLockStr ? ((AcctLockStr = NULL), 0) : \
     printf("ReleaseAcctLock (%s): no lock held!\n", (str)))

#define LK_WON			1
#define LK_LOST			0
#endif ultrix

#define TRUE 1
#define FALSE 0

#if NCM > CM_INTERFACE_MAXIMUM

NCM must be <= CM_INTERFACE_MAXIMUM.  If NCM > CM_INTERFACE_MAXIMUM, then
iterating over NCM things will march off the end of user-defined
structures in cmioctl code;

#endif /* NCM > CM_INTERFACE_MAXIMUM */

int	nCM = NCM;

void (*AuxAcctFunc)();
static int UsingAcctFunc = 0;
/*
 * How long may a user remain idle before being automatically detached?
 * If this is set to 0, automatic detaching is disabled.
 */
static int cm_idletime = 0;

/*
 * Access control lists for controlling access to /dev/cm
 */
uid_t *acl_uids = NULL;
uid_t *acl_gids = NULL;

int acl_uids_size = 0;
int acl_gids_size = 0;

uid_t *acl_denied_uids = NULL;
uid_t *acl_denied_gids = NULL;

int acl_denied_uids_size = 0;
int acl_denied_gids_size = 0;

/*
 * How long may a user have an interface with no UCCs allocated?
 * (Primarily to detect those times when we are detached by another
 * front-end.) 
 */
static int cm_no_uccs_time = 15;

/*
 * Since IdleTimer deletes processes and process-groups at interrupt
 * level, we need to protect CM code from having its operands deleted out
 * from under it.
 *
 * One way to do that is to do splcm() for all that code, another way is
 * to just flag that we're within the code, and have IdleTimer wait 'til
 * we're not within the code.
 */
int in_cm_code = 0;

/*
 * For marking time
 */

extern struct timeval time;
#define TIME_STAMP ((long)time.tv_sec)

#define CMPRI	(PZERO+1)

/*
 * A set of macros useful in for-loops.  These macros ONLY work on the
 * active processes, not on the suspended ones.
 */

#define ALL_PROCESSES_ON_INTERFACE(cms, cmp) \
  (ASSERT_NO_PROCESS_LOCK(), cmp = FirstProcess(cms); cmp != NULL; cmp = NextProcess(cmp, cms))

#define ALL_PROCESSES_IN_PROCESS_GROUP(icmp, owner) \
  (ASSERT_PROCESS_LOCK_HELD(), icmp = owner; icmp; icmp = icmp->cmp_next)

#define ALL_BUT_LAST_PROCESS_IN_PROCESS_GROUP(icmp, owner) \
  (ASSERT_PROCESS_LOCK_HELD(), icmp = owner; icmp->cmp_next; icmp = icmp->cmp_next)

#define ALL_PROCESS_GROUPS(cm_procs, cmp) \
  (ASSERT_PROCESS_LOCK_HELD(), cmp = cm_procs; cmp != NULL; cmp = cmp->cmp_sibling)

/*
 * given a pointer to a CM_PROC structure, and a stored pid, does the
 * given process still exist?
 */
#define PROC_STILL_EXISTS(cmp) \
	(cmp->cmp_procp != NULL && cmp->cmp_procp->p_pid == cmp->cmp_pid)

#define CURRENT_PROCESS(CMP) \
    (((CMP)->cmp_procp == u.u_procp) && ((CMP)->cmp_pid == u.u_procp->p_pid))

/*
 * Can't read nexus, must not be physically attached!
 */
#define NEXUS_R0_CANT_READ(n) (((n) == -1) || ((n) == -2))

#ifdef sun

#define lock_buffer(bp)		bp_mapin(bp)
#define unlock_buffer(bp)	bp_mapout(bp)

#define kmalloc(size)		kmem_alloc(size)
#define kmfree(ptr,size)	kmem_free(ptr,size)
/*
#define splcm(cms)		((cms) ? splr(pritospl((cms)->cms_intpri)) : spl5())
 */
#define splcm(cms)		splr(pritospl(3))

#define cm_regs_dirty(cms)	((cms)->cms_regs->cm_csr & CM_HDIRTY)
#define cm_reset_dirty(cms)	((cms)->cms_regs->cm_csr = \
				 (((cms)->cms_regs->cm_csr & ~CM_IC_BITS) | CM_HDIRTY))


/*
 * Protect from bus timeouts by saving the state of CM_DO_BERR,
 * clearing it for the duration of the Nexus access, and restoring
 * it after the access has completed. Be carefull to use these macros
 * within the same block, and do not return until RestoreNexus is called.
 *
 * NOTE: you must splcm() any code that calls ProtectNexus (because the
 * Idletimer might sneak in and turn the CM_DO_BERR bit back on on you).
 */

#define ProtectNexus(cms) \
{\
   int do_berr = (cms->cms_regs->cm_csr & (CM_DO_BERR));\
   if (do_berr) cms->cms_regs->cm_csr &= ~(CM_DO_BERR);

#define RestoreNexus(cms) \
   if (do_berr) cms->cms_regs->cm_csr |= do_berr;\
}

/*
 * If you're doing something potentially dangerous, and want to ignore
 * FEBI errors, bracket the dangerous things with WithFEBIErrorsIgnored
 * and EndFEBIErrorsIgnored.  
 *
 * XXX - ProtectNexus is somewhat weaker, and, when I have time, I'll
 * eliminate ProtectNexus, replacing it with this, mostly because I can't
 * characterize when one should be used and not the other -- dm.
 *
 * Requires splcm()
 */
#define WithFEBIErrorsIgnored(cms) \
{ \
    register int *csr = &(cms)->cms_regs->cm_csr; \
    int old_csr = *csr; \
    *csr = CM_CSR_INIT | CM_IC_BITS;

#define EndFEBIErrorsIgnored \
    *csr = old_csr; \
}

/*
 * For use in those situations where the nexus protection may get reset
 * when timesharing is suspended.
 */
#define ReprotectNexus(cms)	cms->cms_regs->cm_csr &= ~(CM_DO_BERR);

#define P_Session(p)	((p)->p_sessp? (p)->p_sessp->s_sid: 0)

#endif /* sun */

#ifdef vax

#define lock_buffer(bp)
#define unlock_buffer(bp)

/*
 * Lots of places we kmalloc things while holding a SMP lock, or
 * are at interrupt level.  It's easiest to just always request
 * that we don't sleep waiting for memory.
 */
private caddr_t
my_kmalloc(size, line)
int size;
{
    caddr_t p;

    KM_ALLOC(p, caddr_t, size, KM_TEMP, KM_CLEAR|KM_NOWAIT);

    if (cm_debug & 0x10) {
	char *sp = NULL;

	if (size == sizeof (CM_KACCT))
	    sp = "CM_KACCT";
	else if (size ==  sizeof (CM_ACCT))
	    sp = "CM_ACCT";
	else if (size == CM_INFO_SIZE)
	    sp = "CM_INFO";
	else if (size ==  sizeof (Q_FOR_CM))
	    sp = "Q_FOR_CM";

	if (sp)
	    printf("[%d] kmalloc(%s) --> 0x%x\n", line, sp, p);
	else
	    printf("[%d] kmalloc(%d) --> 0x%x\n", line, size, p);
    }
    return p;
}

private void
my_kmfree(ptr, size, line)
caddr_t ptr;
int size;
{
    if (cm_debug & 0x10) {
	char *sp = NULL;

	if (size == sizeof (CM_KACCT))
	    sp = "CM_KACCT";
	else if (size ==  sizeof (CM_ACCT))
	    sp = "CM_ACCT";
	else if (size == CM_INFO_SIZE)
	    sp = "CM_INFO";
	else if (size ==  sizeof (Q_FOR_CM))
	    sp = "Q_FOR_CM";

	if (sp)
	    printf("[%d] kmfree(0x%x, %s)\n", line, ptr, sp);
	else
	    printf("[%d] kmfree(0x%x, %d)\n", line, ptr, size);
	    
    }

    KM_FREE(ptr, KM_TEMP);
}

#define kmalloc(size) my_kmalloc(size, __LINE__)
#define kmfree(ptr,size) my_kmfree(ptr, size, __LINE__)


#define splcm(cms) spl5()

#define cm_regs_dirty(cms)	((cms)->cms_ptep[4].pg_m)
#define cm_reset_dirty(cms)	((cms)->cms_ptep[4].pg_m = 0)

#define ProtectNexus(cms)
#define ReprotectNexus(cms)
#define RestoreNexus(cms)

#define WithFEBIErrorsIgnored(cms)
#define EndFEBIErrorsIgnored

#define P_Session(p)	(p)->p_sid
static struct timeval cmlast;

/*
 * Ultrix doesn't have uniqtime()
 */
private void
uniqtime(tvp) 
struct timeval *tvp;
{
    *tvp = time;    
    if ((tvp->tv_sec == cmlast.tv_sec) && 
	(tvp->tv_usec == cmlast.tv_usec)) {
	bumptime(&cmlast, 1);
	*tvp = cmlast;
    } else {
	cmlast = *tvp;
    }
}
#endif /* vax */

/*
 * Following definition taken from /cm/cparis/h/ucc-code.h
 */


#define CM_UCC0_RUN			0x1		/* rw */
#define CM_UCC0_RESET			0x2		/* rw */
#define CM_UCC0_DIAGNOSTIC_MODE 	0x8		/* rw */
#define CM_UCC0_RESET_ERROR 		0x4		/* rw */
#define CM_UCC0_WCS_REG_CNTL		0x200		/* rw */
#define CM_UCC0_MASK_ERRORS		0x1c0


#define CM_UCC0_TS_HOST_TO_UCC_MASK	0x60000000
#define CM_UCC0_TS_HOST_TO_UCC_SHIFT	29

#define CM_UCC0_TS_UC_TO_HOST_MASK	0x18000000	/* ro */
#define CM_UCC0_TS_UC_TO_HOST_SHIFT 	27
#define CM_UCC0_TS_SUSPEND 		(1 << CM_UCC0_TS_HOST_TO_UCC_SHIFT)
#define CM_UCC0_TS_FIFO_LOOP 		(2 << CM_UCC0_TS_HOST_TO_UCC_SHIFT)

#define CM_UCC0_TS_IDLE 		(1 << CM_UCC0_TS_UC_TO_HOST_SHIFT)
#define CM_UCC0_TS_SUSPENDING		(2 << CM_UCC0_TS_UC_TO_HOST_SHIFT)
#define CM_UCC0_TS_LOOPING		(3 << CM_UCC0_TS_UC_TO_HOST_SHIFT)

#define CM_UCC0_OFIFO_MT		0x200000	/* ro */
#define CM_UCC0_IFIFO_MT		0x40000		/* ro */

#define UC_REG0_BITS_WITH_FLAGS "\
\20\1RUN\2RESET\3RESET_ERROR\4DIAG\5BREAK\6CONT\7MASK_UC_ERR\10MASK_CM_ERR\
\11MASK_IO_ERR\12WCS_REG_CTL\20NEXUS_IO_RDY\21IFIFO_FULL\22IFIFO_HF\23IFIFO_MT\
\24OFIFO_FULL\25OFIFO_HF\26OFIFO_MT\27NX_IF_MT\30NX_OF_MT\31NX_OFHF\32SV_GLBL\
\33NX_RCV_GLBL\40NX_IFHF"


#define CM_IN_DISPATCH(cms) \
    (((cms)->cms_regs->cm_ucsr0 & CM_UCC0_TS_UC_TO_HOST_MASK) == CM_UCC0_TS_IDLE)

#define CM_UCC0_IFIFO_MPTY(cms) \
    (((cms)->cms_regs->cm_ucsr0 & CM_UCC0_IFIFO_MT))

#define CM_UCC0_OFIFO_MPTY(cms) \
    (((cms)->cms_regs->cm_ucsr0 & CM_UCC0_OFIFO_MT))
    

#define IF_TO_OF_SINGLE(cms, fifo, data) \
    *fifo = (cms)->cms_tsinfo.if_to_of_single; *fifo = (data)


#ifdef sun

#define CM_OFIFO_EMPTY(cms) \
    (((cms)->cms_regs->cm_hstat & HS_OFOR) == 0)

#define CM_OFIFO_READY(cms) \
    ((cms)->cms_regs->cm_hstat & HS_OF_RDY)

#define CM_READ_OFIFO(cms, dest) \
    (dest) = ((cms)->cms_regs->cm_ucfifo)

#define CM_IFIFO_MPTY(cms) \
    (((cms)->cms_regs->cm_hstat & (HS_IF_RDY|HS_IFMT)) == (HS_IF_RDY|HS_IFMT))

#define CM_IFIFO_RDY(cms) \
    ((cms)->cms_regs->cm_hstat & HS_IF_RDY)

#define CM_ERROR(cms) \
    ((cms)->cms_regs->cm_csr & CM_HARD_ERR) 

#define FEBI_ERROR(cms) \
    ((cms)->cms_regs->cm_csr & (CM_IC_TIMEOUT|CM_IC_PARERR|CM_IC_ACCERR))

#endif

#ifdef vax

#define CM_OFIFO_EMPTY(cms) \
    (((cms)->cms_regs->cm_csr & (CM_HBUS_OFIFO_READY)) == 0)

#define CM_OFIFO_READY(cms) \
    ((cms)->cms_regs->cm_csr & (CM_HBUS_OFIFO_READY))

#define CM_READ_OFIFO(cms, dest) \
    (dest) = (cms)->cms_regs->cm_ucfifo; (cms)->cms_regs->cm_discard_reg = 0;

#define CM_IFIFO_MPTY(cms) \
    ((cms)->cms_regs->cm_csr & (CM_HBUS_IFIFO_MT))

#define CM_ERROR(cms) \
    (((cms)->cms_regs->cm_csr & CM_HARD_ERRORS) != CM_HARD_ERRORS)

#define FEBI_ERROR(cms) \
    (((cms)->cms_regs->cm_csr & (CM_ACC_TIMEOUT_LATCH_L|CM_CM_PAR_ERR_LATCH_L)) \
       != (CM_ACC_TIMEOUT_LATCH_L|CM_CM_PAR_ERR_LATCH_L))

#endif

/*
 * Check whether CM/Sequencer is idle. Detect this as IFIFO empty and
 * sequencer in dispatch loop.
 */

#define CM_IDLE(cms)\
    ((CM_IFIFO_MPTY(cms) && CM_UCC0_IFIFO_MPTY(cms) && CM_IN_DISPATCH(cms)) || CM_ERROR(cms))

CM_PROC *GetProcess();

int cmselectcalls = 0;

CM_PROC *cm_accounting_daemon;

CM_KACCT *cm_accounting_queue_hd;
CM_KACCT *cm_accounting_queue_tl;

/*
 * A hint that we are executing at interrupt level.  At_Interrupt_Level is
 * ALWAYS true when we ARE executing at interrupt level, and MAY BE true
 * when we AREN'T executing at interrupt level (on a multiprocessor
 * front-end, for example.
 *
 * Therefore, use this for things (such as ULTRIX's km_alloc(...KM_NOWAIT)
 * argument) that needn't be picky about not being executed when not at
 * interrupt level.
 */
int At_Interrupt_Level = 0;

#ifdef sun

/*
 * Define and initialise the driver data structure
 */

int     cmattach(), cmprobe(), cmminphys(), cmreadstrategy(), cmwritestrategy(), cmintr();



struct mb_device *cminfo[NCM];

struct mb_driver cmdriver = {
    cmprobe,		/* mdr_probe	*/
    0,			/* mdr_slave	*/
    cmattach,		/* mdr_attach	*/
    0,			/* mdr_go	*/
    0,			/* mdr_done	*/
    0,			/* mdr_intr	*/
    sizeof(CM_REGS),	/* mdr_size	*/
    "cm",		/* mdr_dname	*/
    cminfo,  		/* mdr_dinfo	*/
    0,			/* mdr_cname	*/
    0,			/* mdr_cinfo	*/
    0,			/* mdr_flags	*/
    0,			/* mdr_link 	*/
};

#endif sun

#ifdef vax

int     cmattach(), cminit(), cmminphys(), cmreadstrategy(), cmwritestrategy();

u_short cm_std[] = { 0 };
struct uba_device *cminfo[NCM];

struct uba_driver cmdriver = {
	cminit,					    /* device probe entry */
	0,					    /* no slave device */
	cmattach,				    /* device attach entry */
	0,					    /* no "fill csr/ba to start" */
	cm_std,					    /* device addresses */
	"cm-interface",				    /* device name string */
	cminfo					    /* ptr to BIBI's uba_device struct */
};

/*
 * Other useful stuff.
 * XXX The page table stuff, in particular, could use better comments.
 */
extern struct bidata bidata[];		/* BI control structure */
extern struct cm_regs cmindregbase[];	/* Base of array of register arrays */

extern struct pte cmindregmap[][CM_NUMBER_OF_REG_PAGES];

					/* Page tables for same */

extern int ignorebi;				    /* Igore BI errors if this is set */

#define ON 1
#define OFF 0

#endif vax



/*
 * Macros to extract various parts of the device number.
 * 
 * The minor device number is organised as follows:
 *
 *   Bits 7 6 5 4 3 2 1 0
 *        +-+ +---------+
 *         |       |
 *         |       +----- unit 
 *         +------------- type 
 *              
 *
 *   Where:
 *
 *     type is 0 for generic device
 *             1 for diagnostic device
 *             2 for direct device
 *
 *     unit is the number of the VEBI interface
 *     (for diagnostic and direct devices)
 *
 */

#define CM_GENERIC(dev) ((minor(dev) & 0xC0) == 0x00)
#define CM_DIAG(dev)    ((minor(dev) & 0xC0) == 0x40)
#define CM_DIRECT(dev)  ((minor(dev) & 0xC0) == 0x80)
#define CM_UNIT(dev)    ((minor(dev) & 0x3F))


static int IdleTimerIsRunning = 0;
private void IdleTimer();

void DeleteProcess();
void DisconnectProcessAndLock();
void DisconnectProcess();


/*
 * Local software structures
 */

/*
 * When a process opens a CM device, a free CM_PROC structure is linked
 * into the cm_procs list based on their position in the process
 * hierarchy, and on the state of their connection. Each proc structure is
 * linked to others in the same list via the cmp_next pointer, and the
 * root of each list is linked to the root of the next list via the
 * cmp_sibling pointer.
 *
 * Note that the cms_daemon and cms_active fields in the cm_state
 * structure point to the proc structures within the above 2D list, and do
 * not form the head of their own lists.
 *
 *			   <----- O W N E R S ----->
 *		
 *	cm_procs------+--->cmp              +---+--->cmp           
 * 		      ^      i'face->CMS[N] |   ^      i'face->CMS[M]
 *		 ^    |      cminfo->...    |   |      cminfo->... 
 *		 .    |      sibling--------+   |      sibling----->...
 *		 .    +------owner		+------owner       
 *		 .    ^      next-+		^      next-+      
 *		 P    |           |		|           |       
 *		 R    |  +--------+		|  +--------+       
 *		 O    |  |			|  |                
 *		 C    |  +->cmp			|  +->cmp           
 *		 E    |       i'face->0		|	i'face->0
 *		 S    |	      cminfo->0		|       cminfo->0
 *		 S    |       sibling->0	|       sibling->0  
 *		 |    +-------owner		+-------owner       
 *		 G    ^       next-+			 next...
 *		 R    |            |     
 *		 O    |  +---------+     
 *		 U    |  |               
 *		 P    |  +->cmp          
 *		 .    |       i'face->0
 *		 .    |	      cminfo->0 
 *		 .    |       sibling->0 
 *		 V    +-------owner      
 *		              next->0    
 *
 * 	cm_suspended_procs --- looks like cm_procs
 *
 *	cm_freeproc---->cmp	 ,-->cmp      ,---->cmp      ,...
 *			  next--'      next--'	      next--'
 *
 *
 * New process-groups get linked in between cmproc and the head of the
 * sibling-list. 
 *
 * New children get linked in at the tail of their ancestor's (owner's)
 * 	list.  Process groups are joined together by ancestry.
 *
 * cmopen delinks the head of the cm_freeproc queue and adds a CM_PROC to
 *
 *	- one of the process-group lists (if this process is opening the
 *	  generic device AND this process is a descendent of something
 *	  that has the generic device open).
 *	- as a new owner if this process is opening the generic device but
 *	  is not a descendent of some process that already has the generic
 *	  device open.
 *	- as a new owner if the process is opening the direct device.
 *
 * Generally, the head of each process group will be the cmattach process.
 *
 * Multiple process groups can access the same (shared) CM_STATE
 *
 * When a shared interface is suspended, all the process-groups that
 * 	are accessing that interface get moved to the cm_suspended_procs
 * 	list. 
 */

/*
 * Pool of CM_PROC structures. These are linked together on the free list
 * during system initialisation.
 */

CM_PROC	cm_procpool[MAXPROCS];
CM_PROC	*cm_freeproc = NULLPROC;
CM_PROC *cm_procs = NULL;	/* pointer to process lists */
CM_PROC *cm_suspended_procs = NULL; /* pointer to suspended process lists */
CM_PROC *FirstProcess();
CM_PROC *NextProcess();

#define ACTIVE_ONLY		0
#define SUSPENDED_ONLY		1
#define ACTIVE_OR_SUSPENDED	2

CM_STATE cm_state[NCM];				    /* indexed by unit (interface) */

Q_FOR_CM *attach_waiting_head = NULL;
Q_FOR_CM *attach_waiting_tail = NULL;

CM_LIMIT_LIST *cm_limit_chain;
CM_LIMIT_LIST *cm_limit_find();

#define CM_LIMIT_HASH_BUCKETS 509
static CM_LIMIT_LIST *limit_hash[CM_LIMIT_HASH_BUCKETS];

#define CM_LIMIT_HASH_INDEX(uid) (uid % CM_LIMIT_HASH_BUCKETS)

/*****************************************************************************
 *
 *  CM_ACCT
 *
 *	A wrapper for the vendor-supplied acct() routine, called when a
 *	process exits.  This way, we find out when the process exits
 *	within the process' context.  This allows us to grab the rusage
 *	structure.
 *
 *****************************************************************************/
void
cm_acct ()
{
    register CM_PROC *cmp;
    void CheckInterfaces();
    int i;

    in_cm_code++;

    /* note that we're using the acct() replacement */
    if (UsingAcctFunc == 0)
	UsingAcctFunc++;

    /*
     * If the exitting process has the nexus locked, unlock the nexus.
     */
    for(i = 0; i < NCM; i++) 
      if(cm_state[i].cms_proc_locking_nexus == u.u_procp) 
	nexus_unlock(&cm_state[i]);
    
    /*
     * The process probably isn't even a CM process...
     */
    if((cmp = GetProcess(u.u_procp->p_pid, 0, ACTIVE_OR_SUSPENDED)) != NULL) {

	if (cm_debug) printf("cm_acct(): proc %d (0x%x)\n", u.u_procp->p_pid, cmp);

	if(cm_accounting_daemon == cmp) {
	    void Acct_Queue_Free();

	    cm_accounting_daemon = NULL;
	    Acct_Queue_Free();
	}

	if(cmp->cmp_procp) {
	    DisconnectProcessAndLock(cmp, 0, u.u_uid);
	    DeleteProcess (cmp);
	}
	/*
	 * check to see whether the interface is still open.
	 */
	CheckInterfaces();
    }

    in_cm_code--;
    return;
} /* ACCT */

/*****************************************************************************
 *
 *  Acct_Free
 *
 *	Free a kernel accounting structure.
 *
 *****************************************************************************/
private void
Acct_Free (cmk)
CM_KACCT *cmk;
{
    if(cmk)
      kmfree(cmk, sizeof(CM_KACCT));
    else
      panic("Acct_Free called with NULL ptr");
} /* Acct_Free */

/*****************************************************************************
 *
 *  Acct_Get
 *
 *	returns a pointer to one of the pool of kernel accounting
 *	structures, or NULL if none are available.
 *
 *	Initialize the new accounting structure from an old one (if it
 * 	exists) or from the u-area if there is no old accounting
 * 	structure.  Then queue the old structure.
 *
 *	This dance involving the old structure is for those times when a
 * 	program changes its configuration: e.g., changes interface or
 * 	changes sequencer allocation.  The u-area may not be available (if
 * 	it is a sequencer allocation change noticed by the IdleTimer), yet
 * 	the OLD accounting structure needs to be detached before the new
 * 	one is attached.
 *
 *****************************************************************************/
private CM_KACCT *
Acct_Get (cmp)
CM_PROC *cmp;
{
    register CM_KACCT *cmk = (CM_KACCT *) kmalloc(sizeof(CM_KACCT));
    void Acct_Queue();

    if(cmk) {
	bzero(cmk, sizeof(CM_KACCT));
	
	/*
	 * Fill only those fields we can get from procp,
	 * we may be running at interrupt level so don't look at u area.
	 */
	cmk->acct.id.pid = cmp->cmp_procp->p_pid;
	cmk->acct.id.sid = P_Session(cmp->cmp_procp);

	/*
	 * If we're replacing an existing accounting record, inherit some
	 * information from the previous record, before queueing it for
	 * the accounting daemon.
	 */
	if(cmp->cmp_kacct) {
	    uniqtime(&cmp->cmp_kacct->acct.detach_time);
	    /* Structure copy */
	    cmk->acct.id = cmp->cmp_kacct->acct.id;
	    cmk->acct.interface = cmp->cmp_kacct->acct.interface;
	    cmk->acct.rusage = cmp->cmp_kacct->acct.rusage;
	    bcopy((caddr_t)cmp->cmp_kacct->acct.command,
		  (caddr_t)cmk->acct.command, 
		  CM_MAX_CMD_LENGTH);
	    
	    Acct_Queue(cmp->cmp_kacct, 0);
	}
	uniqtime(&cmk->acct.attach_time);

	if(cmp->cmp_interface)
	    cmk->acct.uccs = cmp->cmp_interface->cms_seqn;
	  
	if(cmp->cmp_udata.ud_state & US_SHARED) cmk->acct.flags |= TIMESHARED;

	cmk->acct.last_excl_time = time;

    }
    return cmk;
} /* Acct_Get */

/*
 * A macro which does the subtraction between a before and after timer
 * correctly.
 *
 * What's going on here?  Well, think of subtracting two 2-digit numbers:
 * AB - CD.
 *
 * Bascally, you do the ones by:		 	(10 + B) - D
 * then do the tens by removing the borrowed ten from A:(A - 1) - C
 *
 * If 10+B-D > 10, then undo the borrow.
 * 
 * struct timeval *result, *before, *after
 */
#define TIMER_DIFF(result, before, after) \
    (result)->tv_sec = (after)->tv_sec - 1 - (before)->tv_sec; \
    (result)->tv_usec = (after)->tv_usec + 1000000 - (before)->tv_usec;\
    if((result)->tv_usec >= 1000000) { \
	(result)->tv_sec++; \
	(result)->tv_usec -= 1000000; \
    }

/*****************************************************************************
 *
 *  Acct_Queue
 *
 *	Queue an accounting record to get read by the accounting daemon.
 *
 *****************************************************************************/
private void
Acct_Queue (cmk, flag)
CM_KACCT *cmk;
int flag;
{

    if(cmk) {
	if(cm_accounting_daemon) {
	    /*
	     * stick stuff onto the queue.
	     */
	    int s;
	    
	    /*
	     * Now calculate the changes in these times... 
	     */
	    TIMER_DIFF(&cmk->acct.rusage.ru_utime,
		       &cmk->rusage_begin.ru_utime,
		       &cmk->acct.rusage.ru_utime);

	    TIMER_DIFF(&cmk->acct.rusage.ru_stime,
		       &cmk->rusage_begin.ru_stime,
		       &cmk->acct.rusage.ru_stime);
	    
	    if(flag) uniqtime(&cmk->acct.detach_time);
	
	    /*
	     * Kludge: A sequencer-less accounting record that is less
	     * than 2 seconds old is discarded.  The base system software
	     * opens the /dev/cm at the drop of a hat --- cmattach, for
	     * example, does so to determine what kind of driver we're
	     * running.  These opens require CM_CLOSEs, which do a
	     * disconnect-from-interface....  
	     */
	    if((cmk->acct.detach_time.tv_sec - cmk->acct.attach_time.tv_sec
	       > 2)
	       || (cmk->acct.uccs != 0)) {
		s = splcm(NULL);

		AcquireAcctLock("Acct_Queue");
		cmk->prev = NULL;
		cmk->next = cm_accounting_queue_hd;
	    
		if(cm_accounting_queue_hd) cm_accounting_queue_hd->prev = cmk;
		else cm_accounting_queue_tl = cmk;
	    
		cm_accounting_queue_hd = cmk;
		ReleaseAcctLock("Acct_Queue");
		splx(s);
	    
		/*
		 * Poke the accounting daemon.
		 */
		selwakeup(cm_accounting_daemon->cmp_procp, 0);
	    }
	    else Acct_Free(cmk);
	}
	else Acct_Free(cmk);
    }
} /* Acct_Queue */

/*****************************************************************************
 *
 *  Acct_Queue_Dequeue
 *
 *	dequeue a cm kernel accounting structure from the queue of them.
 *
 *****************************************************************************/
private CM_KACCT *
Acct_Queue_Dequeue ()
{
    register int s;
    register CM_KACCT *cmk;

    s = splcm(NULL);
    AcquireAcctLock("Acct_Queue_Dequeue");

    if((cmk = cm_accounting_queue_tl) != NULL) {
	cm_accounting_queue_tl = cmk->prev;
	if(cmk->prev) cmk->prev->next = NULL;
	else cm_accounting_queue_hd = NULL;
	
    }
    ReleaseAcctLock("Acct_Queue_Dequeue");
    splx(s);
    return cmk;
} /* Acct_Queue_Dequeue */

/*****************************************************************************
 *
 *  Acct_Queue_Free
 *
 *	Free the entire contents of the accounting queue.
 *****************************************************************************/
private void
Acct_Queue_Free ()
{
    register CM_KACCT *cmk;

    while((cmk = Acct_Queue_Dequeue()) != NULL) Acct_Free(cmk);
} /* Acct_Queue_Free */

/*****************************************************************************
 *
 *  Acct_Queue_Record
 *
 *****************************************************************************/
private void
Acct_Queue_Record (cmp, reason)
CM_PROC *cmp;
int reason;
{
    if(cmp->cmp_kacct) {
	CM_LIMIT_LIST *limit;

	/*
	 * record this process's hit on our runtime limits...
	 */
	if((limit = cm_limit_find(cmp->cmp_procp->p_suid, CM_ACL_UID))
	   != NULL) {
	    limit->limit.exclusive_access_limit -=
	      limit->active_exclusive_access_time;
	}

	if((limit = cm_limit_find(cmp->cmp_procp->p_sgid, CM_ACL_GID))
	   != NULL) {
	    limit->limit.exclusive_access_limit -=
	      limit->active_exclusive_access_time;
	}

	cmp->cmp_kacct->reason = reason;
	/* Give owner a copy of accounting before queueing it to daemon */
	if (cmp->cmp_owner->cmp_childs_cmacct == (CM_ACCT *) NULL)
	  cmp->cmp_owner->cmp_childs_cmacct
	    = (CM_ACCT *) kmalloc(sizeof (CM_ACCT));
	if (cmp->cmp_owner->cmp_childs_cmacct != (CM_ACCT *) NULL)
	  *(cmp->cmp_owner->cmp_childs_cmacct) = cmp->cmp_kacct->acct;
	Acct_Queue(cmp->cmp_kacct, 1);
	cmp->cmp_kacct = NULL;
    }
} /* Acct_Queue_Record */

/*****************************************************************************
 *
 *  cm_limit_find
 *
 *	find the limit structure for a given user or group id.
 *	Returns a pointer to the limit structure, or NULL, if there isn't
 *	one. 
 *
 *****************************************************************************/
CM_LIMIT_LIST *
cm_limit_find (id, type)
uid_t id;
CM_ACL_T type;
{
    int i = CM_LIMIT_HASH_INDEX(id);
    CM_LIMIT_LIST *bucket;

    for(bucket = limit_hash[i];
	(bucket != NULL)
	&& ((bucket->limit.id.uid > id)
	    || (bucket->limit.id.uid == id
		&& bucket->limit.type != type));
	bucket = bucket->next)
    { ; }
    if((bucket != NULL)
	&& (bucket->limit.id.uid == id)
       && (bucket->limit.type == type))
      return bucket;
    else return NULL;
} /* cm_limit_find */

/*****************************************************************************
 *
 *  cm_limit_insert
 *
 *	insert a new limit structure into the hash list.  When there are
 *	hash conflicts, the items in the hash bucket are sorted by
 *	decreasing UIDs. 
 *
 *	This will overwrite an existing record for the same ID.
 *
 *****************************************************************************/
int
cm_limit_insert (new_limit)
CM_LIMIT *new_limit;
{
    CM_LIMIT_LIST *bucket;

    if((bucket = cm_limit_find(new_limit->id.uid, new_limit->type)) != NULL) 
      /*
       * is already an item for this ID, update it.
       */
      bucket->limit = *new_limit;
    else {
	bucket = (CM_LIMIT_LIST *) kmalloc(sizeof(CM_LIMIT_LIST));
	  
	if(bucket == NULL) return ENOMEM;
	else {
	    int i = CM_LIMIT_HASH_INDEX(new_limit->id.uid);

	    bucket->limit = *new_limit;
	    bucket->active_exclusive_access_time = 0;

	    if(limit_hash[i] == NULL) {
		bucket->prev = bucket->next = NULL;
		limit_hash[i] = bucket;
	    }
	    else {
		CM_LIMIT_LIST *loop_bucket;
		CM_LIMIT_LIST *prev_bucket = NULL;

		for(loop_bucket = limit_hash[i];
		    (loop_bucket != NULL)
		    && (loop_bucket->limit.id.uid > new_limit->id.uid
			|| (loop_bucket->limit.id.uid == new_limit->id.uid
			    && loop_bucket->limit.type != new_limit->type));
		    loop_bucket = loop_bucket->next) {

		    prev_bucket = loop_bucket;
		}
		
		if(loop_bucket) {
		    /*
		     * loop_bucket's id is < ours, and it is the first one
		     * for which that is true.  Link the new one in
		     * before loop_bucket.
		     */
		    bucket->next = loop_bucket;
		    bucket->prev = loop_bucket->prev;
		    if(loop_bucket->prev) loop_bucket->prev->next = bucket;
		    loop_bucket->prev = bucket;
		}
		else if(prev_bucket) {
		    prev_bucket->next = bucket;
		    bucket->prev = prev_bucket;
		    bucket->next = NULL;
		}
		else {
		    bucket->prev = NULL;
		    bucket->next = limit_hash[i];
		    if(limit_hash[i]) limit_hash[i]->prev = bucket;
		    limit_hash[i] = bucket;
		}
	    }
	}
	/*
	 * link us into the chain head of the chain.
	 */
	bucket->chain_prev = NULL;
	bucket->chain_next = cm_limit_chain;
	if(cm_limit_chain) cm_limit_chain->chain_prev = bucket;
	cm_limit_chain = bucket;

    }
    return 0;
} /* cm_limit_insert */

/*
 * When a context switch is initiated, we will need to save any data in
 * the output FIFO, and give it to the current process when it nexts
 * issues a read request. Because the read may or may not read all the
 * saved data (and could go through another context switch before the
 * saved data is emptied), need some form of queue. The following routines
 * implement this queue (loosely based on clists used by old tty drivers).
 * For associated typedefs see cm/cmsoft.h
 */

FIFODATA fdpool[FDPOOLSIZE];
FIFOQUEUE fdfree;

private
FIFODATA *
fd_get()
{
    register FIFODATA *fd;
    int s = splcm(NULL);

    AcquireFifoLock("fd_get");
    if ((fd = fdfree.fq_head) == NULL) {
	if (cm_debug) printf("out of free data elements\n");
	ReleaseFifoLock("fd_get");
	splx(s);
	return (NULL);
    }
    fdfree.fq_head = fd->fd_next;

    fd->fd_next = NULL;
    fd->fd_start = 0;
    fd->fd_end = 0;
	
    ReleaseFifoLock("fd_get");
    splx(s);
    return (fd);
}

private
fd_init()
{
    register int i;
    register FIFODATA *fd;
    int s = splcm(NULL);

    AcquireFifoLock("fd_init");
    fd = &fdpool[FDPOOLSIZE - 1];
    fdfree.fq_tail = fd;

    for (i = FDPOOLSIZE - 2; i >= 0; i--) {
	fdpool[i].fd_next = fd;
	fd = &fdpool[i];
    }

    fdfree.fq_head = fd;
    ReleaseFifoLock("fd_init");
    splx(s);
}

private 
fd_free(fd)
FIFODATA *fd;
{
    int s = splcm(NULL);
    AcquireFifoLock("fd_free");
    fd->fd_next = fdfree.fq_head;
    fdfree.fq_head = fd;
    ReleaseFifoLock("fd_free");
    splx(s);
}


private void
fq_init(fq)
FIFOQUEUE *fq;
{
    fq->fq_head = fq->fq_tail = NULL;
    fq->fq_length = 0;
}


/*
 * Inline the next three routines for performance reasons
 */ 

#define fq_empty(fq) (((fq)->fq_length == 0))

#define fq_not_empty(fq) (((fq)->fq_length != 0))

#define fq_exhausted(fq) \
    (((fq->fq_head == NULL) || (fq->fq_tail->fd_end == FDSIZE)) && (fdfree.fq_head == NULL))


private int
fq_add (fq, value)
FIFOQUEUE *fq;
long value;
{
    register FIFODATA *fd;

    if ((fq->fq_head == NULL) || (fq->fq_tail->fd_end == FDSIZE)) {
	if ((fd = fd_get()) == NULL) {
	    return (FALSE);
	}
	if (fq->fq_head == NULL) {
	    fq->fq_head = fq->fq_tail = fd;
	} else {
	    fq->fq_tail->fd_next = fd;
	    fq->fq_tail = fd;
	}
    }

    fq->fq_tail->fd_data[fq->fq_tail->fd_end++] = value;
    fq->fq_length++;
    return (TRUE);
}

private long
fq_remove(fq)
FIFOQUEUE *fq;
{
    register FIFODATA *fd;
    register long value;

    if (fq_empty(fq)) {
	panic ("remove from empty queue\n");
    }

    fd = fq->fq_head;
    value = fd->fd_data[fd->fd_start++];
    fq->fq_length--;

    /*
     * If emptied a block then remove from the head of the queue unless
     * its the only block on the queue, in which case reset the start
     * and end pointers so that can reuse for next add
     */

    if (fd->fd_start == fd->fd_end) {
	if (fd->fd_next == NULL) {
	    fd->fd_start = fd->fd_end = 0;
	} else {
	    fq->fq_head = fd->fd_next;
	    fd_free(fd);
	}
    }

    return (value);
}

/*
 * Internal routines
 */


/*
 * Only do this once. cm_freeproc is as good a once only flag as any
 * because once set up if can't go NULL again until after ALL
 * initialisation is complete.
 */

private
InitQueues()
{
    register CM_PROC	*cmp, *prevproc;
    register int		i;

    AcquireProcessLock("InitQueues");
    if (cm_freeproc == NULLPROC) {

	fd_init();

	prevproc = NULL;
	cmp = cm_procpool;

	for (i = 0; i < MAXPROCS; i++) {
	    cmp->cmp_next  = prevproc;
	    cmp->cmp_procp = (struct proc *)0;
	    fq_init (&cmp->cmp_ofifo_data);
	    prevproc = cmp++;
	}

	cm_freeproc = &cm_procpool[MAXPROCS-1];
    }
    ReleaseProcessLock("InitQueues");
}

/*
 * AddProcess.
 * Callers:
 * 	cmopen()
 * Link in a new process.
 */
private void
AddProcess (cmp, owner)
CM_PROC *cmp;
CM_PROC *owner;
{
    register CM_PROC *p;
    int s = splcm(NULL);

    if (cm_debug) printf("AddProcess %d (0x%x)\n", cmp->cmp_pid, cmp);

    AcquireProcessLock("AddProcess");
    cmp->cmp_owner = owner;
    cmp->cmp_next = NULL;

    if (owner == cmp) {
	cmp->cmp_sibling = cm_procs;
	cm_procs = cmp;
    } else {
	/*
	 * find the last process in the process group, and tack the new
	 * process onto the tail.
	 */
	for ALL_BUT_LAST_PROCESS_IN_PROCESS_GROUP(p, owner)
	{;}
	p->cmp_next = cmp;
    }

    ReleaseProcessLock("AddProcess");
    splx(s);
}

private void
drainFifoqueue(fq)
register FIFOQUEUE *fq;
{
    register FIFODATA  *fd;

    if (fq->fq_head != NULL) {
	/* Clear all the blocks */
	for (fd = fq->fq_head; fd != NULL; fd = fd->fd_next) {
	    fd->fd_start = fd->fd_end = 0;
	}

	/* and add them all to the free queue */
	AcquireFifoLock("drainFifoqueue");
	fq->fq_tail->fd_next = fdfree.fq_head;
	fdfree.fq_head       = fq->fq_head;
	ReleaseFifoLock("drainFifoqueue");

	fq->fq_head    = fq->fq_tail = NULL;
	fq->fq_length  = 0;
    }
}

/*
 * Never called with a lock held, we lock ourselves.
 * Also, always called in some valid process context, never
 * from the interrupt routine for the IdleTimer.
 * Current callers:
 * 	cm_acct()
 * 	CheckProcesses();
 * 	cm_open()
 * 	cm_close()
 *	cmioctl_helper for CM_RELAY_ATTACHMENT
 */

private void
DeleteProcess (cmp)
    CM_PROC *cmp;
{
    register CM_PROC **prev, *tmp;
    int s = splcm(NULL);
    CM_PROC *FindActive(), *DaemonOwner;
    CM_STATE *InterfaceLostDaemon = NULL;

    if (cm_debug)
	printf("DeleteProcess 0x%x (%d)\n", cmp, cmp->cmp_pid);
	       
    AcquireProcessLock("DeleteProcess");

    Acct_Queue_Record(cmp, CMKR_DELETE_PROCESS);
    
    if (cmp->cmp_owner != cmp) {

	/*
	 * We're not the head of the list, so simply remove
	 */

	for (prev = &(cmp->cmp_owner->cmp_next);
	     *prev != cmp;
	     prev = &((*prev)->cmp_next))
	{;}
	*prev = cmp->cmp_next;

    } else {

	/*
	 * We are the head of a list. If we are the only one on the list,
	 * then return all the lists resources, and chop us out. If there
	 * are others behind us, then pass the list's resources onto the
	 * next guy.
	 */

	for (prev = &cm_procs; prev && (*prev != cmp); prev = &((*prev)->cmp_sibling))
	  {;}

	if (prev == NULL)
	  for (prev = &cm_suspended_procs;
	       *prev != cmp;
	       prev = &((*prev)->cmp_sibling))
	    {;}
	if (cmp->cmp_next == NULL) {
	    if (cmp->cmp_cminfo != NULL) {
		kmfree(cmp->cmp_cminfo, CM_INFO_SIZE);
		cmp->cmp_cminfo = NULL;
	    }
	    if (cmp->cmp_childs_cmacct != NULL) {
		kmfree(cmp->cmp_childs_cmacct, sizeof (CM_ACCT));
		cmp->cmp_childs_cmacct = NULL;
	    }
	    *prev = cmp->cmp_sibling;
	} else {
	    *prev = cmp->cmp_next;
	    (*prev)->cmp_sibling   = cmp->cmp_sibling;
	    (*prev)->cmp_interface = cmp->cmp_interface;
	    (*prev)->cmp_cminfo    = cmp->cmp_cminfo;
	    (*prev)->cmp_childs_cmacct    = cmp->cmp_childs_cmacct;
	    for ALL_PROCESSES_IN_PROCESS_GROUP(tmp, *prev) 
	      tmp->cmp_owner = *prev;
	}
    }

    /*
     * From experience, I know we can't really trust
     * cmp->cmp_owner->cmp_interface to be valid at this point.
     *
     * I don't know WHY that should be so -- dm 12 Sep 91
     */
  {
      int i;
      CM_STATE *cms;

      for(i = 0; i < NCM; i++) {
	  cms = &cm_state[i];

	  if(cms->cms_daemon == cmp) {
	      cms->cms_flags &= ~CMS_SHARED;
	      cms->cms_daemon = NULL;
	      InterfaceLostDaemon = cms;
	      DaemonOwner = cmp->cmp_owner;
	  }

	  if(cms->cms_active == cmp) {
	      cms->cms_active = FindActive(cms, cmp->cmp_owner);
	  }
      }
  }
    /*
     * Throw away the saved VFIFO and timesharing context switch data.
     */
    drainFifoqueue(&cmp->cmp_ofifo_data);
    drainFifoqueue(&cmp->cmp_ififo_data);

    cmp->cmp_owner = cmp->cmp_sibling = NULL;
    cmp->cmp_procp = NULL;
    cmp->cmp_pid   = NULL;
    cmp->cmp_next  = cm_freeproc;
    cm_freeproc    = cmp;

    ReleaseProcessLock("DeleteProcess");
    splx(s);

    if (InterfaceLostDaemon) {
	/*
	 * Disconnect all clients.
	 */
	for ALL_PROCESSES_ON_INTERFACE(InterfaceLostDaemon, cmp) 
	    if (cmp != DaemonOwner) {
		DisconnectProcessAndLock(cmp, SIGURG, 1);
	    }
    }

} /* DeleteProcess */

/*
 * Given a CM_STATE structure, find the head of the next process-group
 * which is accessing that CM_STATE, beginning at a specific point (either
 * cm_proc or a member (most likely the tail) of the group we're looking
 * at now). 
 *
 * (Marches along the sibling linkage.)
 *
 * Note that cms == NULL is a legal request, looking for those cmp
 * structures that aren't attached to any interface (e.g., the accounting
 * daemon). 
 * Called by:
 * 	FirstProcess()
 * 	NextProcess()
 */
private CM_PROC *
NextProcessGroup (where, cms)
CM_PROC *where;
CM_STATE *cms;
{
    register CM_PROC *cmp;
    int s;

    s = splcm(NULL);
    AcquireProcessLock("NextProcessGroup");
    for (cmp = where;
	 ((cmp != NULL) && (cmp->cmp_interface != cms));
	 cmp = cmp->cmp_sibling)
      {;}
    ReleaseProcessLock("NextProcessGroup");
    splx(s);
    return (cmp);
}

/*
 * Given a CM_STATE structure, find the top of the list of processes that
 * are accessing that CM_STATE.
 *
 * (Marches along the sibling linkage.)
 */
private CM_PROC *
FirstProcess (cms)
    CM_STATE *cms;
{
    return NextProcessGroup(cm_procs, cms);
}

/*
 * A tool for marching through all the processes --- if you reach the end
 * of a given interface's processes, move on to the next interface.
 */
private CM_PROC *
NextProcess (last, cms)
    CM_PROC *last;
    CM_STATE *cms;
{
    if (last->cmp_next != NULL)
      return (last->cmp_next);
    else
      return NextProcessGroup(last->cmp_owner->cmp_sibling, cms);
}

private void
DisconnectProcessAndLock(cmp, sendsig, uid)
CM_PROC *cmp;
int sendsig;
int uid;
{
    int s = splcm(NULL);
    AcquireProcessLock("DisconnectProcessWithLock");
    DisconnectProcess(cmp, sendsig, uid);
    ReleaseProcessLock("DisconnectProcess");
    splx(s);
}

/*
 * Disconnect a single process from the interface it is connected to. If
 * the process is still alive and a signal is requested then send it a
 * SIGURG. If it is the active or daemon process, then update the fields
 * in the state structure appropriately.
 * 
 * This routine *MAY* be called at interrupt level, from IdleTimer, for example.
 * Current Callers:
 * 	cm_acct()
 * 	DisconnectProcessGroup()
 * 	CheckProcesses()
 * 	IdleTimer()
 * 	cm_open()
 * 	cm_close()
 * 	cm_ioctl()
 * 
 * The caller should call CheckInterfaces() after calling this,
 * but without any SMP locks (as CheckInterfaces() needs to get its own).
 * 
 * MUST BE CALLED WITH A LOCK ALREADY HELD, AT INTERRUPT LEVEL!!!
 */
private void
DisconnectProcess (cmp, sendsig, uid)
CM_PROC *cmp;
int sendsig;
int uid;
{
    register CM_STATE *cms;
    CM_PROC *FindActive();
    CM_STATE *InterfaceLostDaemon = NULL;

    ASSERT_PROCESS_LOCK_HELD();

    if ((cms = cmp->cmp_owner->cmp_interface) != NULL) {

	cmp->cmp_udata.ud_state ^= (US_CONNECTED | US_DISCONNECTED);
	cmp->cmp_udata.ud_detach_uid = uid;
	cmp->cmp_udata.ud_intf = -1;

	if (cmp == cms->cms_active) {
	    void BusyTicks();

	    BusyTicks(cmp, cms);
	    cms->cms_active = FindActive(cms, cmp->cmp_owner);
	    if (cms->cms_active && cms->cms_active->cmp_kacct)
		cms->cms_active->cmp_kacct->acct.last_excl_time = time;
	}

	Acct_Queue_Record(cmp, CMKR_DISCONNECT_PROCESS);
	
	if (sendsig)
	    psignal (cmp->cmp_procp, sendsig);

	if (cmp->cmp_procp == cms->cms_intr_proc)
	    cms->cms_intr_proc = NULL;

	/*
	 * Tell the TS daemon that something interesting happened.
	 */
	if (cms->cms_daemon)
	    psignal(cms->cms_daemon->cmp_procp, SIGURG);

	cms->cms_modtime = TIME_STAMP;

	/*
	 * Poke this process in case it was waiting for a timesharing
	 * timeslice, this will make it notice it's been disconnected.
	 */
	if (cmp->cmp_udata.ud_state & US_BLOCKED) {
	    cmp->cmp_udata.ud_state &= ~US_BLOCKED;
	    wakeup (&cmp->cmp_udata.ud_state);
	}
    }
} /* DisconnectProcess */

/*
 * Disconnect all the processes in the process group from the interface
 * they are connnected to.
 *
 * group is the root of the process group
 * Callers:
 * 	IdleTimer()
 * 	cmioctl()
 * MUST BE CALLED WITH A LOCK ALREADY HELD, AT INTERRUPT LEVEL!!!
 */
private void
DisconnectProcessGroup (group, uid)
CM_PROC  *group;
int uid;
{
    register CM_PROC  *cmp;

    ASSERT_PROCESS_LOCK_HELD();

    if (group->cmp_interface != NULL) {
	for ALL_PROCESSES_IN_PROCESS_GROUP(cmp, group)
	  DisconnectProcess (cmp, SIGURG, uid);
	group->cmp_interface = NULL;
    }
}

	
/*****************************************************************************
 *
 *  FindActive
 *
 *	Find a (new) active process for a given exclusive interface.
 *	Returns NULL on a timeshared interface because finding the active
 *	process is up to the ts-daemon.
 *
 *	     
 *	if timesharing, cms_active is the process that is currently
 *	controlling the CM.
 *     
 *	if exclusive mode, cms_active is the process that opened the CM
 *	for read/write *most recently* (this is only a heuristic ---
 *	though a pretty good one --- but it is all we can do, since
 *	there's no way to tell which of the many processes are doing
 *	the scribbling on the mapped registers).
 *     
 *	About the only way this heuristic can fail (and charge the
 *	wrong process) is when:
 *     
 *	     program A is talking to the CM
 *	     program B attaches to the CM (presumably to do some
 *		     talking).  Program A's computation on the CM will
 *		     get charged against program B.
 *     
 *	Having two programs with the CM open for read/write is not
 *	unusual --- program A could be cmattach.  However, cmattach
 *	does no CM computation to be mistakenly charged to program B,
 *	so the heuristic still works.
 * 
 * Callers:
 * 	DisconnectProcess()	(possibly from interrupt level)
 * 	
 *
 *****************************************************************************/
private CM_PROC *
FindActive (cms, cmp)
CM_STATE *cms;
CM_PROC *cmp;
{
    if ((cms->cms_flags & CMS_SHARED) == 0) {
	int s;
	/*
	 * find the last process that has the interface open for
	 * writing, and charge subsequent CM cycles against it.
	 */
	register CM_PROC *icmp;
	register CM_PROC *last_writer = NULL;
	
	/*
	 * Find the last process in the list that has the registers open for
	 * writing (there may be none --- though most likely there will be
	 * at least the cmattach subshell).
	 */
	s = splcm(NULL);

	for ALL_PROCESSES_IN_PROCESS_GROUP(icmp, cmp->cmp_owner)
	  if(PROC_STILL_EXISTS(icmp)
	     && (icmp->cmp_udata.ud_intf >= 0)
	     && (icmp->cmp_openflags & _FWRITE))
	    last_writer = icmp;
	splx(s);

	return last_writer;
    }
    else return NULL;
} /* FindActive */

/*****************************************************************************
 *
 *  BusyTicks
 *
 *	a new process is about to become active, do the appropriate
 *	shuffling of the busy_ticks data out of the CM_STATE structure
 *	into the departing process's CM_PROC structure.
 *
 *	cmp may be null because we may be initializing the structure, or
 * 	resuming a timeshared process after the ts-daemon has computed for
 * 	a while. 
 *
 *****************************************************************************/
private void
BusyTicks (cmp, cms)
CM_PROC *cmp;			/* departing process (may be null) */
CM_STATE *cms;
{
    struct timeval foo;

    /*
     * and we might not have accounting turned on, so no kacct record..
     */
    if(cmp && cmp->cmp_kacct) {
	cmp->cmp_kacct->acct.ucc_busy_ticks += cms->cms_ucc_busy_ticks;
	cmp->cmp_kacct->acct.ififo_busy_ticks += cms->cms_ififo_busy_ticks;

	TIMER_DIFF(&foo,
		   &cmp->cmp_kacct->acct.last_excl_time,
		   &time);
	cmp->cmp_kacct->acct.pcur_duration.tv_sec += foo.tv_sec;
	if ((cmp->cmp_kacct->acct.pcur_duration.tv_usec += foo.tv_usec) >= 1000000) {
	    cmp->cmp_kacct->acct.pcur_duration.tv_sec ++;
	    cmp->cmp_kacct->acct.pcur_duration.tv_usec -= 1000000;
	}
	cmp->cmp_kacct->acct.last_excl_time = time;
	
    }
    cms->cms_ucc_busy_ticks = 0;
    cms->cms_ififo_busy_ticks = 0;
} /* BusyTicks */

/*
 * Check whether the current process is a descendent of the specified
 * process. 
 */

private int
Descendent (cmp)
    CM_PROC	*cmp;
{
    register struct proc *p;

    for (p = u.u_procp; 
	 (p  && (p != p->p_pptr)); 
	 p = p->p_pptr) {
	if ((p == cmp->cmp_procp) && (p->p_pid == cmp->cmp_pid))
	    return (TRUE);
    }

    return (FALSE);
} /* Descendent */


/*
 * Scan down the list of processes using these interfaces and remove ones
 * which are no longer alive.
 * 
 * This isn't called *at all* if the system is set up properly.
 * It's only there if accounting isn't installed correcty.
 *
 * Compare the saved pid with that in the saved kernel proc table entry
 * (this could give incorrect results if the process dies and we loop back
 * to the same pid (in the same slot) between scans (needless to say this
 * is very unlikely).
 */

private void
CheckProcesses ()
{
    register int i;
    register CM_PROC *cmp;

    if (UsingAcctFunc)		/* If we see everyone exit, don't use this routine */
	return;

    /*
     * By walking through the procpool we get all the CM_PROC structures,
     * no matter what lists they have been hidden on (even the free list,
     * heaven forbid!).
     * Also: we don't need to SMP lock this.
     */
    for (i = 0; i < MAXPROCS; i++) {
	cmp = &cm_procpool[i];
	if ((cmp->cmp_procp != NULL)
	    && (cmp->cmp_procp->p_pid != cmp->cmp_pid)) {
	    DisconnectProcessAndLock (cmp, 0, 0);
	    DeleteProcess (cmp);
	}
    }

    CheckInterfaces();

} /* CheckProcesses */

/* 
 * For each available interface, examine all the processes attached to 
 * that interface, accumulating such things as:
 * 
 *	- there is at least one process connected to this interface
 *	  --> CMS_OPEN.
 *	- some process is accessing the device directly (US_DIRECT)
 *	  --> CMS_EXCL.
 *	- some process is timesharing the device (US_SHARED) 
 * 	  --> CMS_SHARED
 *	- the ts-daemon still exists and is on the active list 
 * 	  -->  CMS_SHARED. 
 * 
 * If nobody is using the interface at all, free any UCCS allocated to it.
 * 
 * Callers:
 * 	CheckProcesses()
 * 	cm_acct()
 * 	cmioct()
 */
private void
CheckInterfaces()
{
    int i;
    register CM_STATE *cms;
    register CM_PROC *cmp;
    int mode;

    for (i = 0; i < NCM; i++) {
	cms = &cm_state[i];

	if (cms->cms_flags & CMS_AVAIL) {
	    mode = cms->cms_flags & ~(CMS_OPEN | CMS_EXCL | CMS_SHARED);
	    
	    
	    for ALL_PROCESSES_ON_INTERFACE(cms, cmp) {
		int ud_state = cmp->cmp_udata.ud_state;
		if (ud_state & US_CONNECTED) {

		    mode |= CMS_OPEN;
		    if (!(ud_state & US_DIRECT)) mode |= CMS_EXCL;
		    if (ud_state & US_SHARED) mode |= CMS_SHARED;

		    /*
		     * this is done within this loop in case the ts-daemon is
		     * suspended.
		     *
		     * If the ts-daemon is suspended, the cms->cms_daemon will be
		     * non-null, but the ts-daemon won't show up in this loop,
		     * since it is on the cm_suspended list.
		     */
		    if (cms->cms_daemon != NULL && cmp == cms->cms_daemon)
			mode |= CMS_SHARED;
		}
	    }

	    if ((mode & CMS_OPEN) == 0) {
		UCCSet_Free(cms);
	    }
	    cms->cms_flags = mode;
	}
    }
} /* CheckInterfaces */

/*
 * Return the CM_PROC pointer corresponding to the specified pid, or
 * NULLPROC if not found
 *
 * which is one of {ACTIVE_ONLY, ACTIVE_OR_SUSPENDED, SUSPENDED_ONLY}
 * dev is the CM device, it may be 0, if all we have to go on is the pid. 
 * 
 * Callers:
 * 	cm_acct()
 * 	ExclusiveAccess()
 * 	cm_open()
 * 	cm_close()
 * 	cm_read()
 * 	cm_write()
 * 	cmreadstrategy()
 * 	cmwritestrategy()
 * 	cmioctl()
 * 	cmselect()
 * 	cmmmap()
 * 	cmsegmap()
 * 		None of these are at interrupt level.
 */

private CM_PROC *
GetProcess (pid, dev, which)
int	pid;
dev_t 	dev;
int 	which;
{
    register CM_PROC *parent, *cmp, *result = NULL;
    int s = splcm(NULL);
    
    AcquireProcessLock("GetProcess");

    if(which == ACTIVE_ONLY || which == ACTIVE_OR_SUSPENDED)
      parent = cm_procs;
    else parent = cm_suspended_procs;

    /*
     * March along the list(s) desired, moving to the next list once the
     * current list is exhausted.
     */
    while (parent != NULL || which == ACTIVE_OR_SUSPENDED) {
	/*
	 * march down the members of the process group...
	 */
	if(parent) {
	    for ALL_PROCESSES_IN_PROCESS_GROUP(cmp, parent)
		if ((cmp->cmp_pid == pid)
		    && ((dev == 0)
			|| (cmp->cmp_dev == dev))) {
		    result = cmp;
		    goto foundProcess;
		}
	    
	    parent = parent->cmp_sibling;
	}
	if(parent == NULL && which == ACTIVE_OR_SUSPENDED) {
	    parent = cm_suspended_procs;
	    which = SUSPENDED_ONLY;
	}
    }
  foundProcess:
    ReleaseProcessLock("GetProcess");
    splx(s);
    return (result);
}


private int
NotDaemonProcess(cms)
    CM_STATE *cms;
{
    return ((cms->cms_daemon == NULL) || !CURRENT_PROCESS(cms->cms_daemon));
}

/*
 * Connect the process list containing the specified process to the
 * interface. Return 0 if successful, appropriate error otherwise.
 * 
 * Callers:
 * 	cmioctl() (never at interrupt level)
 */
private int
ConnecttoInterface (cmp, interface, reset_p)
    CM_PROC *cmp;
    int interface;
    int reset_p;
{
    register CM_STATE *cms;
    register CM_PROC *tcmp;
    int ud_state = NULL;
    int s;

    if (interface >= NCM)
	return (ENODEV);

    cms = &cm_state[interface];

    /*
     * If this process is already connected to this interface, just return.
     */
    for ALL_PROCESSES_ON_INTERFACE(cms, tcmp) {
	if (cmp == tcmp)
	    return(0);
    }

    /*
     * If the device exists...
     */
    if (((cms->cms_flags & CMS_AVAIL) == 0)
	/*
	 * And no other process group has marked it exclusive mode...
	 */
	|| ((cms->cms_flags & (CMS_EXCL | CMS_SHARED)) == CMS_EXCL))
      return (EACCES);

    /*
     * If the diagnostic device is open...
     *
     * (can't use EBUSY for this, since EBUSY is interpreted by cmattach
     * as meaning we are already connected to an interface.
     */
    if(cms->cms_flags & CMS_DIAGNOSTIC_OPEN)
      return EAGAIN;
	

    if (cms->cms_flags & CMS_SHARED) {
	/*
	 * Connect to a timeshared interface...
	 */
	if (cmp->cmp_owner->cmp_cminfo == NULL)
	    cmp->cmp_owner->cmp_cminfo = (long *)kmalloc(CM_INFO_SIZE);

	if (cmp->cmp_owner->cmp_cminfo == NULL)
	    return (ENOMEM);

	/*
	 * Sometimes (usually when debugging) the ts-daemon vanishes
	 * without marking the interface exclusive.  In that case, reject
	 * the open attempt.
	 */
	if(cms->cms_daemon == NULL) return (EHOSTDOWN);

	bcopy (cms->cms_daemon->cmp_owner->cmp_cminfo, 
	       cmp->cmp_owner->cmp_cminfo, CM_INFO_SIZE);

	ud_state = (US_CONNECTED | US_SHARED);

    } else {
	/*
	 * An exclusive-mode interface...
	 */
	cms->cms_flags |= (CMS_OPEN | CMS_EXCL);
	if (cms->cms_active == NULL)
	    cms->cms_active = cmp;
	ud_state = US_CONNECTED;
	/* 
	 * Reset the interface to make sure the accounting
	 * code can read the NEXUS and ucc registers.
	 */
	if (reset_p) cmreset(interface);
    }

    s = splcm(NULL);
    AcquireProcessLock("ConnecttoInterface");
    for ALL_PROCESSES_IN_PROCESS_GROUP(tcmp, cmp->cmp_owner) {
	tcmp->cmp_udata.ud_intf = cms->cms_interface;
	tcmp->cmp_udata.ud_state = ud_state;
	tcmp->cmp_interface = cms;
	if(tcmp->cmp_openflags & _FWRITE) {
	    if(tcmp->cmp_kacct) 
	      tcmp->cmp_kacct->reason = CMKR_CONNECT_TO_INTERFACE;

	    tcmp->cmp_kacct = Acct_Get(tcmp);
	    tcmp->cmp_kacct->acct.interface = interface;
	}
    }
    ReleaseProcessLock("ConnecttoInterface");

    cms->cms_modtime = TIME_STAMP;
    cms->cms_touchtime = TIME_STAMP;
    cms->cms_seqn_to_zero = 0;
    cmp->cmp_udata.ud_mark = TIME_STAMP;

    splx(s);

    /*
     * Start up repetitive timer if one is not running already. Would do
     * this during initialisation but it's not needed until the first open.
     */
    if (IdleTimerIsRunning == 0) {
	if (cm_debug) printf("ConnecttoInterface: Starting CM IdleTimer\n");
	IdleTimerIsRunning = 1;
	timeout (IdleTimer, 0,  1);
    }

    return 0;
} /* ConnecttoInterface */

	    
private int
ExclusiveAccess(dev)
    dev_t dev;
{
    register CM_PROC *cmp = GetProcess(u.u_procp->p_pid, dev, ACTIVE_ONLY);
    
    return ((CM_DIAG(dev)
	     || CM_DIRECT(dev)
	     || ((cmp != NULL) 
		 && ((cmp->cmp_udata.ud_state & (US_CONNECTED | US_SHARED))
		     == US_CONNECTED))));
}


/*
 * 
 * Nexus Management
 */
/*
 * Given a copy of the hardware Nexus Status register, decode the
 * interesting fields into the NexusStatus structure.
 *
 * Note that this code knows the order of the GBUS and HBUS fields in the
 * Nexus Status Register.
 */
private void
DecodeNexusStatus(NexusReg0, NexusStatus)
    int		NexusReg0;
    NEXUS_STAT	*NexusStatus;
{
    register int i;

    for (i = 0; i < 4; i++) {
	NexusStatus->ucc_ports[i] = NexusReg0 & NEXUS_R0_UCC_FIELD_MASK;
	NexusReg0 >>= NEXUS_R0_UCC_FIELD_SIZE;
    }

    for (i = 0; i < 4; i++) {
	NexusStatus->host_ports[i] = NexusReg0 & NEXUS_R0_HOST_FIELD_MASK;
	NexusReg0 >>= NEXUS_R0_HOST_FIELD_SIZE;
    }
} /* DecodeNexusStatus */

/*****************************************************************************
 *
 *  UCCSet_Free
 *
 *	Free the UCCs on this interface.
 *****************************************************************************/
private int
UCCSet_Free (cms)
CM_STATE *cms;
{
    int nexus_bits = 0;
    int mask = 0;

    register int nexus;
    register int i;

    nexus = cm_read_nexstat(cms);

    if(NEXUS_R0_CANT_READ(nexus)) return 0;

    for(i = 0; i < 4; i++) {
	if(UCC_FIELD(i, cms->cms_host, 0) == (nexus & UCC_FIELD_MASK(i))) {
	    nexus_bits |= UCC_FIELD(i, cms->cms_host, NEXUS_R0_UCC_DISABLE);
	    mask |= UCC_FIELD_MASK(i);
	}
    }
    if (mask) 
	return (cm_write_nexstat(cms, nexus_bits, mask));

    return 0;
} /* UCCSet_Free */

/*****************************************************************************
 *
 *  UCCSet_Grab
 *
 *	Grab a collection of UCCs.
 *****************************************************************************/
private int
UCCSet_Grab (cms, wanted_set)
CM_STATE *cms;
int wanted_set;
{
    int i;
    int nexus_bits = 0;
    int mask = 0;

    for(i = 0; i < 4; i++) 
      if(wanted_set & (1<<i)) {
	  nexus_bits |= UCC_FIELD(i, cms->cms_host, 0);
	  mask |= UCC_FIELD_MASK(i);

	  nexus_bits |= HOST_FIELD(cms->cms_host, i);
	  mask |= HOST_MASK(cms->cms_host);
      }
    
    return cm_write_nexstat(cms, nexus_bits, mask);
} /* UCCSet_Grab */

/*****************************************************************************
 *
 *  UCCSet_Read
 *
 *	Read what uccs are attached to this interface; returns a map of
 *	them. 
 * 
 * Return -1 if we can't tell.
 *
 *****************************************************************************/
private int
UCCSet_Read (cms)
CM_STATE *cms;
{
    NEXUS_STAT	NexusStatus;
    register int NexusReg0;
    register int i;
    int uccs = 0;

    NexusReg0 = cm_read_nexstat(cms);
    if(NEXUS_R0_CANT_READ(NexusReg0)) return -1;

    DecodeNexusStatus(NexusReg0, &NexusStatus);
    
    for (i = 0; i < 4; i++) {
	/*
	 * If the sequencer is has our id, but it is marked as
	 * disabled, it's not talking to us.
	 */
	if (NexusStatus.ucc_ports[i] == cms->cms_host)
	  uccs |= (1 << i);
    }
    return uccs;
} /* UCCSet_Read */

/*****************************************************************************
 *
 *  Free_UCCS_on_Interface
 *
 *****************************************************************************/
int
Free_UCCS_on_Interface (cms)
CM_STATE *cms;
{
    register int j;
    register int free_uccs =  0;
    register nexus = cm_read_nexstat(cms);

    if(NEXUS_R0_CANT_READ(nexus)) return 0;

    for(j = 0; j < 4; j++) {
	if(nexus & NEXUS_R0_UCC_DISABLE) free_uccs |= (1<<j);
	nexus >>= NEXUS_R0_UCC_FIELD_SIZE;
    }
    return free_uccs;
} /* Free_UCCS_on_Interface */

/*****************************************************************************
 *
 *  CheckForResource
 *
 *	Check the combinations acceptable to the user for availability,
 *	and grab 'em if they are available
 *
 *	Returns NULL if none of the combinations can be satisfied,
 *	returns the CM_STATE for the interface that has what is necessary
 *	available.
 *
 *****************************************************************************/
CM_STATE *
CheckForResource (acms, w)
CM_STATE *acms;			/* NULL => check all interfaces */
Q_FOR_CM *w;
{
    register int i;
    CM_WAITING_USER *wuser = &w->wuser;

    /*
     * If we are checking a specific interface, set up the for-loop to
     * start at that interface and finish before it gets to the next
     * interface.
     *
     * If we are checking any interface set up for the for-loop to start
     * at 0 and end at NCM.
     */
    int start = (acms? acms->cms_interface: 0);
    int finish = (acms? acms->cms_interface + 1: NCM);

    for(i = start; i < finish; i++) 
      if(wuser->wanted.interface[i] != 0) {
	  register CM_STATE *cms = &cm_state[i];

	  if (((cms->cms_flags & (CMS_AVAIL|CMS_OPEN|CMS_EXCL)) == CMS_AVAIL)
	      && (cms->cms_host != -1)) {
	      register int j;
	      register int uccs = UCCSet_Read(cms);
	      int available_uccs;

	      if (uccs != -1) {
		  available_uccs = (Free_UCCS_on_Interface(cms) | uccs);

		  for(j = 0; j < 4; j++) {
		      int possible_subset = ((wuser->wanted.interface[i]
					      >> (j * 4))
					     & 0xf);
		      if(possible_subset != 0
			 && ((possible_subset & available_uccs)
			     == possible_subset)) {
			  
			  /*
			   * This is exactly what we want!  
			   * Try to grab the UCCS.
			   */
			  if(UCCSet_Grab(cms, possible_subset)) {
			      register CM_PROC *cmp = 
				GetProcess(wuser->pid, 0, ACTIVE_ONLY);

			      if (cmp == NULL)
				panic("CheckForResource");
			  
			      /*
			       * Got the sequencers requested.  Now connect
			       * this process list to the interface.
			       */
			      if (ConnecttoInterface(cmp,
						     cms->cms_interface, 0)
				  == 0)
				return cms;

			  }
		      }
		  }
	      }
	  }
      }
    return NULL;
} /* CheckForResource */

/*
 * Low level NEXUS accessors
 *  cm_read_nexstat(cms)  - in machine specific code.
 *  wnr0
 *  cm_write_nexstat
 */
private int
wnr0(cms, val, mask)
CM_STATE *cms;
unsigned long val;		/* the value to write into the masked bits */
unsigned long mask;		/* the bits that should change */
{
    register unsigned long new_one;
    int febi_error_occured = 0;

    WithFEBIErrorsIgnored(cms) {
	register unsigned long original;
	register unsigned long *nsr
	  = (unsigned long *) &cms->cms_regs->cm_nsrl;

	original = *nsr;

	if (! FEBI_ERROR(cms)) {
	    (*nsr) = ((original & (~(mask|NEXUS_R0_RESET_REGISTER_ACCESS)))
		      | (val & mask));
	    new_one = *nsr;
	}
	else febi_error_occured = 1;
    }
    EndFEBIErrorsIgnored;

    if(! febi_error_occured) {
	/*
	 * the value written to the host-port field is unlikely to match the
	 * value that we can read from it. 
	 */
	mask &= ~((NEXUS_R0_HOST_PORT_MASK<<NEXUS_R0_HOST_PORT_OFFSET)
		  | NEXUS_R0_CHANNEL_ERROR);

	if((new_one & mask) == (val & mask)) return 1;
	traceN(("wnr0(%d, %X, %X) failed\n", cms->cms_interface, val, mask));
    }
    return 0;
}

/*****************************************************************************
 * rnr123 --- read one of the nexus registers (one of {1, 2, 3})
 *****************************************************************************/
static unsigned long
rnr123(cms, reg, retain)
CM_STATE *cms;
int reg;			/* which reg we are interested in */
int retain;			/* leave the nexus locked */
{
#ifdef vax
    register unsigned long *nr1
      = (unsigned long *) &cms->cms_regs->cm_nexus_reg123;
#endif
#ifdef sun
    register unsigned long *nr1 = (unsigned long *) &cms->cms_regs->cm_nsrh;
#endif
    unsigned long orig_r0 = cm_read_nexstat(cms);

    /*
     * generate an R0 value to select the desired register.
     */
    unsigned long rsel = ((cms->cms_host << NEXUS_R0_RSEL_HOST_NUMBER)
			  | (reg << NEXUS_R0_RSEL)); 
    unsigned long mask = (NEXUS_R0_RSEL_HOST_NUMBER_MASK | NEXUS_R0_RSEL_MASK);
    unsigned long val = -1;
    int s;

    if(NEXUS_R0_CANT_READ(orig_r0)) return -1;

    s = splcm(cms);
    ProtectNexus(cms) {
	if(cm_write_nexstat(cms, rsel, mask)) {
	    val = *nr1;
	    /*
	     * we are retaining control of the nexus register (locking out
	     * other hosts)
	     *
	     * 
	     */
	    if(!retain)
	      cm_write_nexstat(cms, orig_r0,
			       (unsigned long) (0xffffffff
						& ~NEXUS_R0_DONT_TOUCH));
	}
    }
    RestoreNexus(cms);
    splx(s);
    
    return val;

} /* rnr123 */

/*****************************************************************************
 * wnr123 -- write one of the nexus registers, one of { 1, 2, 3 }
 *****************************************************************************/
static int
wnr123(cms, reg, val, retain)
CM_STATE *cms;
int reg;			/* the desired register */
unsigned long val;		/* the value for that register */
int retain;			/* unlock the nexus when done */
{
#ifdef vax
    register unsigned long *nr1
      = (unsigned long *) &cms->cms_regs->cm_nexus_reg123;
#endif
#ifdef sun
    register unsigned long *nr1 = (unsigned long *) &cms->cms_regs->cm_nsrh;
#endif
    unsigned long orig_r0;
    int retval = FALSE;
    int s;

    traceN(("wnr123(%d, %d, %X)\n", cms->cms_host, reg, val));

    s = splcm(cms);
    ProtectNexus(cms) {
	/*
	 * generate an R0 value to select the desired register.
	 */

	orig_r0 = cm_read_nexstat(cms);

	/*
	 * unlock NR0
	 */
	if(! retain)
	  orig_r0 &= ~(NEXUS_R0_RSEL_MASK | NEXUS_R0_RSEL_HOST_NUMBER_MASK);

	trace2("wnr123: r0 is %X\n", orig_r0);

	if(! NEXUS_R0_CANT_READ(orig_r0)) {
	    /*
	     * fill in NR0 so that *we* have it locked.  This also selects
	     * which of regs 1, 2 or 3 will be read at *nr1.
	     */
	    unsigned long rsel = ((cms->cms_host
				   << NEXUS_R0_RSEL_HOST_NUMBER)
				  | (reg << NEXUS_R0_RSEL));

	    unsigned long mask = (NEXUS_R0_RSEL_HOST_NUMBER_MASK
				  | NEXUS_R0_RSEL_MASK);
	    if(cm_write_nexstat(cms, rsel, mask)) {
		/*
		 * deposit value into NRn
		 */
		trace("wnr123: wrote nexstat\n");
		(*nr1) = val;
		/*
		 * restore NR0 (i.e., unlock it)
		 */
		retval = cm_write_nexstat(cms, orig_r0,
					  (unsigned long)
					  (0xffffffff & ~NEXUS_R0_DONT_TOUCH));
		trace2("wnr123: cm_write_nexstat: %X\n", retval);
	    }
	}
    }
    RestoreNexus(cms);
    splx(s);

    return retval;
} /* wnr123 */

/*****************************************************************************
 * cm_write_nexstat -- write nexus status-register
 * To write the Nexus status safely, since there are potentially
 * multiple hosts writing simultaneously:
 *   1. Read the status
 *   2. Write the status changing only the bits in the mask 
 *   2a. Wait a little while.
 *   3. Read the status
 *   4. If the changed bits are as desired, we are done.
 *   5. If the changed bits are as original, do a random delay and
 *      try again. (To handle simulaneous changes to different
 *      fields of the status register.) 
 *   6. If the changed bits are not as desired and not as original,
 *      we have two hosts changing the same fields simultaneously;
 *      return nil. 
 *
 *****************************************************************************/
private int
cm_write_nexstat(cms, val, mask)
CM_STATE *cms;
unsigned long val;		/* the value to write into the masked bits */
unsigned long mask;		/* the bits that should change */
{
    traceN(("write nexstat(%d, %X, %X)\n", cms->cms_interface, val, mask));
    if(wnr0(cms, val, mask)) return 1;
    else {
	/*
	 * This is close enough to random --- lbolt doesn't sleep for a
	 * full second, it sleeps until the next second-clock tick.  That
	 * is a ``random-enough'' distance away.
	 */
	trace("Can't write NR0\n");
	if (! At_Interrupt_Level) 
	    sleep(&lbolt, PZERO);
	else
	    DELAY(time.tv_usec % 10000);
	
	if(wnr0(cms, val, mask)) return 1;
	else {
	    unsigned long r0 = cm_read_nexstat(cms);
	    unsigned long my_port = cms->cms_host;

	    trace("2nd attempt at NR0 failed\n");
	    
	    trace("trying to reset nexus r0 access");
	    /*
	     * Some other host has a lock on the nexus regs, smash it.
	     */
	    if(NEXUS_R0_CANT_READ(r0)) return 0;

	    /*
	     * the !mask & NEXUS_R0_RESET_REGISTER_ACCESS makes sure we're
	     * not recursing trying to reset the register access bit on
	     * broken hardware.
	     */
	    if((!(mask & NEXUS_R0_RESET_REGISTER_ACCESS))
	       /*
	        * If r0 already has the nexus register I want and is
	        * already listening to me, there's no need to change it
	        * (actually, if I got here under those circumstances,
	        * things are moderately screwed up...)
	        */
	       && ((r0 & NEXUS_R0_RSEL_HOST_NUMBER_MASK)
		   != (my_port << NEXUS_R0_RSEL_HOST_NUMBER)))
	      return cm_write_nexstat(cms,
				      val | NEXUS_R0_RESET_REGISTER_ACCESS, 
				      mask | NEXUS_R0_RESET_REGISTER_ACCESS); 
	}
    }
    return 0;
} /* cm_write_nexstat */

/*****************************************************************************
 *
 * nexus_lock
 *
 *	See the comment in cmioctl.h explaiing CM_LOCK_NEXUS, et.al.
 *	Basically, an error means we couldn't lock the nexus --- either
 *	because some other process has it locked, or some other host...
 *     
 *	locking_hostid is the value the user read out of NR1 --- i.e., it
 *	is the CM_HOST_LOCKING_NEXUS encoding of the host-id.
 * 
 *****************************************************************************/
private int
nexus_lock (cms, locking_hostid)
CM_STATE *cms;
int locking_hostid;
{
    int r1;

    /*
     * Some other process on this machine already has the nexus locked
     * (ought not happen, since nexus lockers supposedly have the device
     * open exclusively...
     */
    if(cms->cms_proc_locking_nexus
       && cms->cms_proc_locking_nexus != u.u_procp)
      return EALREADY;

    r1 = rnr123(cms, 1, TRUE);

    /*
     * Already have it locked?
     */
    if(CM_HOST_LOCKING_NEXUS(r1) == cms->cms_host) return 0;

    /*
     * Nexus locked by no one, or by the host the user has determined that
     * they can take it away from?
     */
    if(CM_HOST_LOCKING_NEXUS(r1) == CM_NO_HOST_LOCKING_NEXUS
       || (r1 & CM_HOST_LOCKING_NEXUS_MASK)  == locking_hostid) {
	if(wnr123(cms, 1, CM_HOST_LOCKS_NEXUS(cms->cms_host), FALSE)) {
	    cms->cms_proc_locking_nexus = u.u_procp;
	    /*
	     * reset the interface so the locker doesn't get bitten by a
	     * pre-existing interface error.
	     */
	    cmreset(cms->cms_interface);
	    return 0;
	}
	/*
	 * failed to write...
	 */
	return EBUSY;
    }
    /*
     * Someone else has grabbed the nexus, you'll have to negotiate with
     * them... 
     */
    return EINPROGRESS;
} /* nexus_lock */

/*****************************************************************************
 *
 *  nexus_unlock
 *	
 *****************************************************************************/
private int
nexus_unlock (cms)
CM_STATE *cms;
{
    int r1 = rnr123(cms, 1, FALSE);

    if(CM_HOST_LOCKING_NEXUS(r1) == cms->cms_host)
      wnr123(cms, 1, (r1 & ~CM_HOST_LOCKING_NEXUS_MASK), FALSE);

    cms->cms_proc_locking_nexus = NULL;
    return 0;
} /* nexus_unlock */



/*
 * Internal event management routines:
 *
 *    CheckEvent
 *    AwaitEvent
 *    SignalEvent
 */


/*
 * Wait for one of the event to be signalled, returning the number of the
 * event that occurred. Set the sleep priority so that can't get
 * interrupted while waiting for the FIFOs
 */
private
AwaitEvent(cms, cmp, events, hertz)
    CM_STATE	*cms;
    CM_PROC	*cmp;
    long	events;
    int		hertz;
{
    long res;

    if (cm_debug_events)
	printf ("AwaitEvent %x\n", events);

    cmp->cmp_events = events;

    if (events & TIMEOUT)
	cmp->cmp_timer = hertz;

    while (1) {
	if ((res = CheckEvent(cms, events)) != 0)
	    break;
 
	if ((res = WaitForEvent(cms, cmp, events)) != 0) {
	    res = INTERRUPT;
	    break;
	}

	if ((events & TIMEOUT) && (cmp->cmp_timer-- == 0)) {
	    res = TIMEOUT;
	    break;
	}

	if ((events & XFERCOMPLETE) &&	
	    ((cmp->cmp_udata.ud_state & (US_READING|US_WRITING)) == 0)) {
	    res = XFERCOMPLETE;
	    break;
	}

	/* Who knows why the sleep returned.  Just try again */
    }

    cmp->cmp_events = 0;
    return(res);
}

private int
WaitForEvent (cms, cmp, events)
    CM_STATE	*cms;
    CM_PROC     *cmp;
    long	events;
{
    int s, r;
    long pri =
	(events & (IFIFO_READY | OFIFO_READY)) ? PZERO 
	    : (events & INTERRUPT) ? (PCATCH | CMPRI)
		: CMPRI;

    s = splcm(cms);
    EnableEventInterrupt(cms, events);
    r = sleep ((&cmp->cmp_events), pri);
    splx(s);

    return (r);
}

/*
 * Signal an event occuring on an interface.
 * Callers:
 * 	IdleTimer()
 * 	cmread()
 * 	cmwrite()
 * 	cmintr()
 */	      
private void
SignalEvent (cms, event)
    CM_STATE	*cms;
    int		event;
{
    register CM_PROC *cmp;
    if (cm_debug_events && ((event != TIMEOUT) || cm_debug_timeouts))
	printf ("SignalEvent %x\n", event);

    for ALL_PROCESSES_ON_INTERFACE(cms, cmp) {
	if (cmp->cmp_events & event) {
	    if (cmp->cmp_events & SELWAIT) {
		cmp->cmp_events &= ~SELWAIT;
		selwakeup(cmp->cmp_procp, 0);
	    } else { 
		wakeup (&(cmp->cmp_events));
	    }
	}
    }
}

/*
 * Fast idle timer, used when suspending a timesharing process.
 */
/*ARGSUSED*/
private void
FastCMIdleTimer(foo)
{
    wakeup(FastCMIdleTimer);
}

/*
 * Look through the list of processes waiting for a CM resource.
 * Wake up the first who's resource has become available.
 */
void
CheckWaitQueue(cms)
register CM_STATE *cms;
{
    int s = splcm(NULL);

    if (attach_waiting_head != NULL
       && (cms->cms_flags & (CMS_EXCL|CMS_OPEN)) == 0) {

	register Q_FOR_CM *w;

	for(w = attach_waiting_head; w ; w = w->next) {
	    if (CheckForResource(cms, w) == cms) {
		/*
		 * Got what we wanted!  Remove this guy from the wait queue.
		 * 
		 * We *must* remove him from the queue here, in case he's waiting for
		 * multiple interfaces.  If we don't, the next idletimer may
		 * come along and reserve a *different* interface for him.  
		 */
		if(w->prev) w->prev->next = w->next;
		else attach_waiting_head = w->next;
		if(w->next) w->next->prev = w->prev;
		else attach_waiting_tail = w->prev;
		
		w->prev = NULL;
		w->next = NULL;

		wakeup(w);
		break;
	    }
	}
    }
    splx(s);
}

/*
 * 128/100 second.
 */
#define SLOWTIMER	((IdleCount & 0x7f) == 0)   
static int IdleCount;

/*
 * Wakeup any processes waiting for timeouts, 
 * and update idle times.  Also deal with waiters.
 */
/* ARGSUSED */
private void
IdleTimer(foo)
int foo;
{
    register CM_PROC *cmp;
    register CM_STATE *cms;
    int s;
    int restart_timer = 0;

    s = splhigh();
    At_Interrupt_Level++;
    splx(s);

    for (cms = &cm_state[0]; cms < &cm_state[NCM]; cms++) {
	/*
	 * If the interface doesn't exist, or the driver has been unloaded
	 * and the unloader is waiting for us to shut down, don't restart
	 * the timer.
	 */
	if ((cms->cms_flags & CMS_AVAIL) == 0)
	    continue;

	/*
	 * If the interface is being diagnosed, don't run the idletimer
	 */
	if (cms->cms_flags & CMS_DIAGNOSTIC_OPEN)
	  continue;

	/*
	 * If this interface is not connected to a working CM, don't
	 * do *any* of this stuff.
	 */
	if (cms->cms_host == -1)
	    continue;

	/*
	 * First do things which happen often (every 1/100th of a second)
	 */
	s = splcm(cms);
	if (cms->cms_regs && cm_regs_dirty(cms)) {
	    cms->cms_ififo_busy_ticks++;
	    cm_reset_dirty(cms);
	    cms->cms_touchtime = TIME_STAMP;
	}
	splx(s);
		
	if(cm_accounting_daemon) {

	    /*
	     * This is a kludge to make sure the rusage info in the
	     * accounting record is up-to-date without being able to
	     * access the process's u-area at the time the accounting
	     * record gets written out.
	     */
#ifdef vax
	    if (! CURRENT_CPUDATA->cpu_noproc) 
#endif vax	    
		if(cms->cms_active) {
		    BusyTicks(cms->cms_active, cms);
		    if(u.u_procp == cms->cms_active->cmp_procp) {
			CM_KACCT *cmk = cms->cms_active->cmp_kacct;
			if(cmk) cmk->acct.rusage = u.u_ru;
		    }
		}

	    /*
	     * the data CM_IN_DISPATCH uses is seriously invalid if we aren't
	     * attached to any sequencers.  Worse yet, it may cause an
	     * interface error which will screw up other software using
	     * the interface (attach, etc.)  So we're careful to make sure
	     * it's reasonable to look at the ucc status registers.
	     *
	     * We won't do this *at all* on VAXes, since we can't do the
	     * equivalent of WithFEBIErrorsIgnored, and we can't guarantee
	     * that we wno't cause an error here.
	     *
	     * The test on cms->cms_seqn is an optimization --- if we don't
	     * THINK we have any sequencers, assume we think right and skip
	     * the test --- we'll find out for sure in a second.
	     */

#	    ifndef vax
	    if(cms->cms_seqn != 0) {
		s = splcm(cms);
		WithFEBIErrorsIgnored(cms) {
		    register int uccs = UCCSet_Read(cms);
		    if(uccs != 0)
		      if(!CM_IN_DISPATCH(cms)) cms->cms_ucc_busy_ticks++;
		}
		EndFEBIErrorsIgnored;
		splx(s);
	    }
#	    endif /* not vax */
	}

	/*
	 * every 128 hundredths of a second (approx 1 second) do a few things.
	 */
	if (SLOWTIMER) {
	    int uccs = 0;
	    int idle;
	    
	    /*
	     * signal timeout event for readers or writers
	     * (virtual FIFO users)
	     */
	    SignalEvent (cms, TIMEOUT);

	    /* 
	     * Give the interface to anyone who's waiting 
	     */
	    CheckWaitQueue(cms);

	    /*
	     * Adjust idle time for active process, his owner,
	     * and the TS daemon (if there is one)
	     */
	    s = splcm(cms);
	    AcquireProcessLock("Idletimer cms-touchtime");
	    if (cms->cms_active) {
		if (cms->cms_active->cmp_owner != NULL) {
		    cms->cms_active->cmp_udata.ud_mark = 
		      cms->cms_active->cmp_owner->cmp_udata.ud_mark =
			cms->cms_touchtime;
		}
	    }

	    if (cms->cms_daemon) {
		if (cms->cms_daemon->cmp_owner != NULL) {
		    cms->cms_daemon->cmp_udata.ud_mark =
		      cms->cms_daemon->cmp_owner->cmp_udata.ud_mark =
			cms->cms_touchtime;
		}
	    }

	    ReleaseProcessLock("Idletimer cms-touchtime");
	    splx(s);

#	    ifdef IDLEDETACH
	    if((cm_idletime > 0)
	       /*
		* Timeshared interfaces don't get automatically detached.
		*/
	       && !(cms->cms_flags & CMS_SHARED)
	       /*
		* touchtime is when the FEBI was last written, but we
		* only detach processes that have a ud_mark that shows
		* them older than the cm_idletime.  The reason for using
		* the process-associated time is to avoid instantly
		* detaching a cmattach that has only just attached, but
		* which has not yet touched the interface (via
		* cmcoldboot). 
		*/
	       && ((idle=(TIME_STAMP - cms->cms_touchtime)) > cm_idletime)) {
		/*
		 * automatic detach of idlers.
		 */
		int detached_someone = FALSE;

		s = splcm(NULL);
		AcquireProcessLock("IdleTimer");
		for ALL_PROCESS_GROUPS(cm_procs, cmp)
		    if ((cmp->cmp_interface == cms)
			&& ((TIME_STAMP - cmp->cmp_udata.ud_mark)
			    > cm_idletime)) {
			printf("CM driver: Detached uid %d, pid %d from i/f %d; idle %d minutes.\n",
			       cmp->cmp_procp->p_uid, cmp->cmp_procp->p_pid,
			       cms->cms_interface,
			       idle/60);
			/*
			 * TODO for 6.2: stash u.u_ttyp in the CM proc struct somewhere
			 * so we can give this message to the guy who got detached (via tprintf)
			 */
			DisconnectProcessGroup(cmp, 0);
			detached_someone = TRUE;
		    }
		ReleaseProcessLock("IdleTimer");
		splx(s);
		if (detached_someone == TRUE) CheckInterfaces();
	    }
#	    endif IDLEDETACH

	    uccs = UCCSet_Read(cms);
	    /*
	     * The UCC set has changed...
	     */
	    if((uccs != -1) && (uccs != cms->cms_seqn)) {
		/*
		 * note a transition to zero --- after a while we will
		 * detach these processes, if they haven't reclaimed any
		 * sequencers. 
		 */
		if(uccs == 0) cms->cms_seqn_to_zero = TIME_STAMP;
		else cms->cms_seqn_to_zero = 0;

		/*
		 * We've changed the sequencer set, so send an accounting log
		 * for the old set, and start a new accounting log.
		 *
		 * The hack with the age of the accounting record less
		 * than 15 seconds is to overlook transitory phases like:
		 *
		 * when you attach, you have no sequencers, then you get
		 * some, and
		 *
		 * while you're cold-booting, you do a ``do-for-each-ucc''.
		 *
		 * programs that don't live as long as 15 seconds will
		 * still get charged when they exit.
		 */
		for ALL_PROCESSES_ON_INTERFACE(cms, cmp) {
		    /*
		     * Acct_Get queues the old one and gets a new one.
		     */
		    if((TIME_STAMP - cms->cms_modtime) > 15) {
			cms->cms_modtime = TIME_STAMP;
			if(cmp->cmp_kacct) {
			    cmp->cmp_kacct->reason = CMKR_IT_UCC_CHANGE;
			    cmp->cmp_kacct = Acct_Get(cmp);
			}
		    }
		    if(cmp->cmp_kacct) {
			cmp->cmp_kacct->acct.uccs = uccs;
			cmp->cmp_kacct->acct.interface = cms->cms_interface;
		    }
		}
		cms->cms_seqn = uccs;
	    }
	    else if((uccs == 0)
		    /*
		     * if cms->cms_seqn_to_zero is zero, we may not yet
		     * have grabbed any sequencers in this attach.
		     */
		    && (cms->cms_seqn_to_zero != 0)
		    && ((TIME_STAMP - cms->cms_seqn_to_zero)
			> cm_no_uccs_time)) {
		int detached_someone = FALSE;
		s = splcm(NULL);
		AcquireProcessLock("IdleTimer 2");
		for ALL_PROCESS_GROUPS(cm_procs, cmp)
		    if (cmp->cmp_interface == cms) {
			printf("CM driver: uid %d pid %d on i/f %d was detached by another front-end\n",
			       cmp->cmp_procp->p_uid, cmp->cmp_procp->p_pid,
			       cms->cms_interface);
			/*
			 * TODO for 6.2: stash u.u_ttyp in the CM proc struct somewhere
			 * so we can give this message to the guy who got detached (via tprintf)
			 */
			DisconnectProcessGroup(cmp, 0);
			detached_someone = TRUE;
		    }
		ReleaseProcessLock("IdleTimer 2");
		splx(s);
		if (detached_someone == TRUE) CheckInterfaces();
	    }
	}
    }	/* for all interfaces */

    if (SLOWTIMER) {
	/*
	 * If the accounting daemon is on and someone has a runtime limit
	 * set for them, check up on the runtime limits.
	 */
	if(cm_accounting_daemon && cm_limit_chain != NULL) {
	    /*
	     * reset the active runtime accumulators.
	     */
	    CM_LIMIT_LIST *limit;
	    for(limit = cm_limit_chain; limit; limit = limit->chain_next) {
		limit->active_exclusive_access_time = 0;
	    }
	    
	    s = splcm(NULL);
	    AcquireProcessLock("IdleTimer taximeter");
	    /*
	     * figure out how much time has been used by all the existing
	     * processes.
	     *
	     * The factor of 100 in the busy-ticks calculations comes from
	     * the fact that busy-ticks are measured in 100ths of a second,
	     * while the busy_seconds are measured in seconds.
	     */
	    for ALL_PROCESS_GROUPS(cm_procs, cmp) {
		CM_PROC *icmp;
		for ALL_PROCESSES_IN_PROCESS_GROUP(icmp, cmp) {
		    CM_LIMIT_LIST *limit
		      = cm_limit_find(icmp->cmp_procp->p_suid, CM_ACL_UID);
			   
		    if(limit && icmp->cmp_kacct) {
			
			limit->active_exclusive_access_time
			  += icmp->cmp_kacct->acct.pcur_duration.tv_sec;
		    }

		    limit = cm_limit_find(icmp->cmp_procp->p_sgid, CM_ACL_GID);
		    if(limit && icmp->cmp_kacct) {
			limit->active_exclusive_access_time
			  += icmp->cmp_kacct->acct.pcur_duration.tv_sec;
		    }
		}
	    }
	    /*
	     * disconnect people and groups who have used up their quotas.
	     *
	     * the ``* 100'' in dealing with ucc_busy_ticks and
	     * ucc_busy_seconds is there to translate ticks into seconds.
	     */
	    for ALL_PROCESS_GROUPS(cm_procs, cmp) {
		CM_PROC *icmp;
		for ALL_PROCESSES_IN_PROCESS_GROUP(icmp, cmp) {
		    CM_LIMIT_LIST *limit
		      = cm_limit_find(icmp->cmp_procp->p_suid, CM_ACL_UID);
		    if(limit) {
			if((limit->limit.exclusive_access_limit
			    - limit->active_exclusive_access_time) < 0)
			  /*
			   * disconnect the wastrel.
			   */
			  DisconnectProcess(icmp, SIGXCPU, 0);

		    }
		    limit = cm_limit_find(icmp->cmp_procp->p_sgid, CM_ACL_GID);
		    if(limit) {
			if((limit->limit.exclusive_access_limit
			    - limit->active_exclusive_access_time) < 0)
			  /*
			   * disconnect the wastrel.
			   */
			  DisconnectProcess(icmp, SIGXCPU, 0);

		    }
		}
	    }

	    ReleaseProcessLock("Idletimer taximeter");
	    splx(s);
	}
	    
	/*
	 * Consider shutting down the idletimer.
	 * CMS_OPEN is turned off when the last process to have the interface
	 * open disconnects (or when all the processes that have the interface
	 * open mysteriously disappear).
	 *
	 * If attach_waiting_head is non-null, one of those processes might be
	 * interested in this interface, even though it is not yet open.
	 */
	restart_timer = 0;

	if (attach_waiting_head)
	    restart_timer++;

	for (cms = &cm_state[0]; cms < &cm_state[NCM]; cms++) 
	    if (cms->cms_flags & CMS_OPEN)
		restart_timer++;

    } else {
	/*
	 * Wait until next SLOWTIMER until we decide on shutting off
	 * the idletimer.
	 */
	restart_timer = 1;
    }


    if (restart_timer) {
	IdleCount++;
	timeout (IdleTimer, 0, 1);
	IdleTimerIsRunning = 1;
    } else {
	IdleCount = 0;
	IdleTimerIsRunning = 0;
	if (cm_debug) printf("IdleTimer: Stopped.\n");
    }

    s = splhigh();
    At_Interrupt_Level--;
    splx(s);
}

/*
 * Drain the output FIFO saving the data in the read queue associated with 
 * the active process.
 */

private int
DrainOutputFifo(cms, cmp)
    CM_STATE *cms;
    CM_PROC  *cmp;
{
    register FIFOQUEUE *fq = &(cmp->cmp_ofifo_data);
    register long d;

    while (CM_OFIFO_READY(cms)) {
	if (fq_exhausted(fq))
	    return (FALSE);

	CM_READ_OFIFO(cms, d);
	fq_add(fq, d);
    }

    return (TRUE);
}

private int
DrainInputFifo(cms, cmp)
    CM_STATE *cms;
    CM_PROC  *cmp;
{
    register FIFOQUEUE *fq = &(cmp->cmp_ififo_data);
    register long d;

    while (CM_OFIFO_READY(cms)) {
	if (fq_exhausted(fq))
	    return (FALSE);

	CM_READ_OFIFO(cms, d);
	fq_add(fq, d);
    }

    return (TRUE);
}

/*
 * Routines called from the cdevsw table
 */

/*
 * CMOPEN
 */
cmopen(dev, flags)
dev_t dev;
int flags;
{
    register int retval;

    in_cm_code++;
    retval = cmopen_helper(dev, flags);
    in_cm_code--;
    return retval;
}

int DoCMAccounting = 1;

cmopen_helper(dev, flags)
dev_t dev;
int   flags;
{
    register CM_STATE *cms;
    register CM_PROC *newp, *cmp, *owner;
    int s;
    int i;

    if((flags & _FWRITE) && !suser()) {
	int access_ok = ((acl_gids_size !=0 || acl_uids_size != 0)
			 ? FALSE
			 : TRUE);
	/*
	 * calculate the OR of the group and user membership predicates...
	 */
	/*
	 * user in user access list?
	 */
	for(i = 0; i < acl_uids_size && access_ok == FALSE; i++)
	    if(acl_uids[i] == u.u_uid) access_ok = TRUE;
	
	/*
	 * process belong to one of the right groups?
	 */
	for(i = 0; i < acl_gids_size && access_ok == FALSE; i++) {
#	    ifndef ACL_ANY_GROUP
	    if(acl_gids[i] == u.u_gid) access_ok = TRUE;
#	    endif /* ACL_ANY_GROUP */
#	    ifdef ACL_ANY_GROUP
	    int j;	    
	    for(j = 0; j < NGROUPS && u.u_groups[j] && access_ok == FALSE; j++)
		if(acl_gids[i] == u.u_groups[j]) access_ok = TRUE;
#	    endif /* ACL_ANY_GROUP */
	}
	/*
	 * user in an access-denied list?
	 *
	 * The access-denied lists take precedence over the access-granted
	 * lists.
	 */
	for(i = 0; i < acl_denied_uids_size && access_ok == TRUE; i++)
	  if(acl_denied_uids[i] == u.u_uid) return EACCES;

	for(i = 0; i < acl_denied_gids_size && access_ok == TRUE; i++)
	  if(acl_denied_gids[i] == u.u_gid) return EACCES;

	if(((acl_gids_size != 0) || (acl_uids_size != 0))
	   && (access_ok == FALSE))
	    return EACCES;
    }

    /*
     * Arrange for our accounting function to be called.
     */
    if (DoCMAccounting)
	if (AuxAcctFunc == NULL)
	    AuxAcctFunc = cm_acct;

    CheckProcesses();

    /*
     * Access to the diagnostic device is allowed when:
     *
     * suser()
     * !suser() AND no one is connected to this interface
     *
     * The reason for these restrictions is twofold:
     * a) diagnostics may screw up someone trying to use the interface, 
     * b) a diagnostic like vbutil muck with the sequencer (e.g., the
     *    walking-1s test), while the idletimer loop ALSO pokes at the
     *    sequencer), similarly, they muck about with the various control
     *    words of the interface which the Idletimer is likely to mess up,
     *    too.
     *
     * Therefore, we let the root turn off accounting on this interface,
     * if they MUST, and we let others turn off accounting only if there
     * is nothing to account for.
     */

    if (CM_DIAG(dev)) {
	int unit = CM_UNIT(dev);
	if(unit > NCM) return ENODEV;
	
	cms = &cm_state[unit];
	/*
	 * If there are any processes hanging on the generic interface,
	 * disallow access.
	 */
	if(!suser())
	  if(FirstProcess(cms)) return EBUSY;

	cms->cms_flags |= CMS_DIAGNOSTIC_OPEN;
	return (0);
    }
    
    /*
     * If process already has this device open, destroy the old structure
     */

    if ((newp = GetProcess(u.u_procp->p_pid, dev, ACTIVE_OR_SUSPENDED))
	!= NULL) {
	DisconnectProcessAndLock (newp, 0, u.u_uid);
	DeleteProcess (newp);
	CheckInterfaces();
    }

    /*
     * Get and initialise a new process structure
     */

    if ((newp = cm_freeproc) == NULLPROC) {
	return (EAGAIN);	/* No spare process slots */
    }
    /* No SMP lock needed here */
    cm_freeproc = newp->cmp_next;

    newp->cmp_next           = NULL;
    newp->cmp_sibling        = NULL;
    newp->cmp_owner          = NULL;
    newp->cmp_interface      = NULL;
    newp->cmp_cminfo         = NULL;
    newp->cmp_events         = 0;
    newp->cmp_dev            = dev;

    newp->cmp_procp          = u.u_procp;
    newp->cmp_pid            = u.u_procp->p_pid;

    newp->cmp_sdp 	     = NULL;
    newp->cmp_nseg	     = 0;

    newp->cmp_udata.ud_intf  = -1;
    newp->cmp_udata.ud_state = 0;
    newp->cmp_udata.ud_uid   = u.u_ruid;
    newp->cmp_udata.ud_mark  = TIME_STAMP;
    newp->cmp_openflags	     = flags;
    newp->cmp_kacct 	     = NULL;
    newp->cmp_childs_cmacct  = NULL;

    bcopy((caddr_t)u.u_comm, (caddr_t)newp->cmp_udata.ud_command,
	  CM_MAX_CMD_LENGTH);

    /*
     * Get an accounting record for this process.
     */
    if(newp->cmp_openflags & _FWRITE)  {
	extern int hostnamelen;
	register CM_KACCT *cmk;
	cmk = newp->cmp_kacct = Acct_Get(newp);

	cmk->acct.id.pid = u.u_procp->p_pid;
	cmk->acct.id.ruid = u.u_ruid;
	cmk->acct.id.rgid = u.u_rgid;
	cmk->acct.id.euid = u.u_uid;
	cmk->acct.id.egid = u.u_gid;
	cmk->acct.id.time = u.u_start.tv_sec;
	cmk->acct.rusage = u.u_ru;
	bcopy((caddr_t)u.u_comm, (caddr_t)cmk->acct.command,
	      CM_MAX_CMD_LENGTH);
	bcopy((caddr_t)hostname, (caddr_t)cmk->acct.id.host_name, 
	      hostnamelen);
    }

    /* 
     * A direct device open always gets a new group, and doesn't check
     * access, except to avoid stepping on diagnostic toes.
     */

    if (CM_DIRECT(dev)) {
	cms = &(cm_state[CM_UNIT(dev)]);
	if ((cms->cms_flags & CMS_AVAIL)
	    && !((cms->cms_flags & CMS_DIAGNOSTIC_OPEN)
		 && (flags & _FWRITE))) {
	    newp->cmp_udata.ud_intf  = CM_UNIT(dev);
	    newp->cmp_interface      = cms;
	    newp->cmp_udata.ud_state |= (US_CONNECTED | US_DIRECT);
	    fq_init(&newp->cmp_ififo_data);
	    fq_init (&newp->cmp_ofifo_data);
	    AddProcess (newp, newp);
	    /*
	     * The CONNECT_TO_INTERFACE is implicit in the choice of
	     * devices. 
	     */
	    if(newp->cmp_kacct) {
		newp->cmp_kacct->acct.interface = cms->cms_interface;
		newp->cmp_kacct->acct.uccs = cms->cms_seqn;
	    }
	    return (0);
	} else {
	    newp->cmp_procp = NULL;
	    newp->cmp_next = cm_freeproc;
	    cm_freeproc = newp;
	    return (EACCES);
	}	
	/*NOT REACHED*/
    }

    /*
     * If opening a generic device, see if this process has an ancestor that
     * already 'owns' the device. 
     */

    owner = NULL;
    s = splcm(NULL);
    AcquireProcessLock("cmopen");
    for ALL_PROCESS_GROUPS(cm_procs, cmp) {
	if (Descendent(cmp)) {
	    owner = cmp;
	    break;
	}
    }
    ReleaseProcessLock("cmopen");
    splx(s);

    /*
     * If no ancestor found, then let the process open the device, and
     * form the base of a new process list. If the interface isn't
     * available, then we will reject his attempts to attach later on.
     * Also need to get an area to keep the CMINFO data in.
     */

    if (owner == NULL) {
	fq_init(&newp->cmp_ififo_data);
	fq_init (&newp->cmp_ofifo_data);
	AddProcess (newp, newp);
	return (0);
    }
    
    /*
     * Scan the appropriate process list (owner points to the head) to see
     * if any process has EXCLUSIVE rights to the device.
     */

    s = splcm(NULL);
    AcquireProcessLock("cmopen 2");
    for ALL_BUT_LAST_PROCESS_IN_PROCESS_GROUP(cmp, owner) {
	if (cmp->cmp_udata.ud_state & US_EXCLUSIVE) {
	    newp->cmp_procp = NULL;
	    newp->cmp_next = cm_freeproc;
	    cm_freeproc = newp;
	    ReleaseProcessLock("cmopen 2");
	    splx(s);
	    return (EACCES);
	}
    }
    ReleaseProcessLock("cmopen 2");
    splx(s);

    /*
     * At this point, owner points to the 'owner' of the device, and cmp
     * points to the last process structure in the list.
     */

    if ((cms = owner->cmp_interface) == NULL) {
	/*
	 * Not currently attached to any interface.  Just add the
	 * process and return.
	 */
	fq_init(&newp->cmp_ififo_data);
	fq_init (&newp->cmp_ofifo_data);
	AddProcess (newp, owner);
	return (0);
    }

    /*
     * We have an interface.
     * Update accounting record with info about it, and
     * any attached sequencers.
     */
    if(newp->cmp_kacct) {
	newp->cmp_kacct->acct.interface = cms->cms_interface;
	newp->cmp_kacct->acct.uccs = cms->cms_seqn;
    }

    /*
     * If the device is currently in shared mode, we are allowed to open it 
     * if we don't explicitly want exclusive access.
     */

    if (owner->cmp_udata.ud_state & US_SHARED) {
	if (flags & O_EXCL) {
	    newp->cmp_procp = NULL;
	    s = splcm(NULL);
	    AcquireProcessLock("cmopen 3");
	    newp->cmp_next = cm_freeproc;
	    cm_freeproc = newp;
	    ReleaseProcessLock("cmopen 3");
	    splx(s);
	    return (EACCES);
	}
	newp->cmp_udata.ud_state |= US_SHARED;
	if(newp->cmp_kacct) {
	    newp->cmp_kacct->acct.flags |= TIMESHARED;
	}
    }
    
    /*
     * Everything OK, link the new process onto the end of the process list
     */

    newp->cmp_udata.ud_state |= US_CONNECTED;
    newp->cmp_udata.ud_intf = cms->cms_interface;
    fq_init(&newp->cmp_ififo_data);
    fq_init (&newp->cmp_ofifo_data);
    AddProcess(newp, owner);

    /*
     * The interface isn't shared, and this process is writing the device.
     * Since it is the newest, it is called the ``active process'' on the
     * interface (it's the one that gets billed for CM usage).
     */
    if(newp->cmp_openflags & _FWRITE) {
	if (!(owner->cmp_udata.ud_state & US_SHARED)) {
	    if (owner->cmp_interface) {
		BusyTicks(owner->cmp_interface->cms_active,
			  owner->cmp_interface);
		owner->cmp_interface->cms_active = newp;
	    }
	}
    }

    return (0);

}				/* cmopen_helper */

/*
 * CMCLOSE
 *
 *   Note that this routine only gets called by the upper levels of the
 *   kernel on the last close for this device. For shared access this may
 *   not necessarily be the timesharing daemon.
 */

/*ARGSUSED*/
cmclose(dev, flags)
    dev_t dev;
    int   flags;
{
    register CM_PROC *cmp;

    in_cm_code++;
    if (CM_DIAG(dev)) {
	int unit = CM_UNIT(dev);
	cm_state[unit].cms_flags &= ~CMS_DIAGNOSTIC_OPEN;
    }
    else {
	if ((cmp = GetProcess (u.u_procp->p_pid, dev, ACTIVE_OR_SUSPENDED))
	    != NULL) {
	    DisconnectProcessAndLock (cmp, 0, u.u_uid);
	    DeleteProcess (cmp);
	    CheckInterfaces();
	}
    }

    in_cm_code--;
    return (0);
}

cmread(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    register int retval;
    in_cm_code++;
    retval = cmread_helper(dev, uio);
    in_cm_code--;
    return retval;
}

cmread_helper(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    register CM_PROC *cmp;
    register int ret;
    register int before = uio->uio_resid;

    if (((cmp = GetProcess(u.u_procp->p_pid, dev, ACTIVE_ONLY)) == NULL)
	|| (cmp->cmp_udata.ud_state & US_DISCONNECTED))
      return (EPERM);

#ifdef sun
    if (cmp->cmp_sdp)
	return (ENXIO);
#endif
    /*
     * If an error was detected when we were suspended last time,
     * tell the user about it now.
     */

    if (cmp->cmp_udata.ud_state & US_CM_ERROR) {
	cmp->cmp_udata.ud_state &= ~US_CM_ERROR;
	return (EIO);
    }

    bzero(&cmp->cmp_buf, sizeof (struct buf));
    ret = physio(cmreadstrategy, &cmp->cmp_buf, dev, B_READ, minphys, uio);

    if(cmp->cmp_kacct) {
	cmp->cmp_kacct->vfifo_data.vfifo_reads++;
	cmp->cmp_kacct->vfifo_data.vfifo_bytes_read +=
	  (before - uio->uio_resid);
    }
    return ret;
}

cmwrite(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    register int retval;

    in_cm_code++;
    retval = cmwrite_helper(dev, uio);
    in_cm_code--;
    return retval;
}

cmwrite_helper(dev, uio)
    dev_t dev;
    struct uio *uio;
{
    register CM_STATE *cms;
    register CM_PROC *cmp;
    register int ret;
    int before = uio->uio_resid;

    if (((cmp = GetProcess(u.u_procp->p_pid, dev, ACTIVE_ONLY)) == NULL)
	|| (cmp->cmp_udata.ud_state & US_DISCONNECTED)) 
      return (EPERM);

#ifdef sun
    if (cmp->cmp_sdp)
	return (ENXIO);
#endif

    cms = &(cm_state[cmp->cmp_udata.ud_intf]);

    if(cmp->cmp_kacct) {
	cmp->cmp_kacct->vfifo_data.vfifo_writes++;
	cmp->cmp_kacct->vfifo_data.vfifo_bytes_written += u.u_arg[2];
    }
    
    /*
     * Wait for us to become the active process.
     *
     * We MUST do this outside physio in case the transfer is broken up by
     * physio into smaller chunks.  We must send all the data requested by
     * the user to the CM in order to guarentee that we are sending whole
     * instructions to the sequencer!
     */ 

    if (!ExclusiveAccess(dev)) {
	while (cms->cms_active != cmp) {
	    if (cms->cms_daemon == NULL)
		return(ENOTCONN);
	    
	    /* Tell the TS daemon he has work to do */
	    if ((cmp->cmp_udata.ud_state & US_BLOCKED) == 0) {
		cmp->cmp_udata.ud_state |= US_BLOCKED;
		selwakeup(cms->cms_daemon->cmp_procp, 0);
	    }

	    if (sleep (&cmp->cmp_udata.ud_state, (PCATCH | CMPRI)) != 0) {
		cmp->cmp_udata.ud_state &= ~US_BLOCKED;
		return(EINTR);
	    }
	}
    }
    cmp->cmp_udata.ud_state &= ~US_BLOCKED;

    cmp->cmp_udata.ud_state |= US_WRITING;
    bzero(&cmp->cmp_buf, sizeof (struct buf));
    ret = physio(cmwritestrategy, &cmp->cmp_buf, dev, B_WRITE, minphys, uio);
    cmp->cmp_udata.ud_state          &= ~US_WRITING;
    SignalEvent (cms, XFERCOMPLETE);

    cmp->cmp_udata.ud_mark            = TIME_STAMP;
    cmp->cmp_owner->cmp_udata.ud_mark = TIME_STAMP;

    if(cmp->cmp_kacct) {
	cmp->cmp_kacct->vfifo_data.vfifo_writes++;
	cmp->cmp_kacct->vfifo_data.vfifo_bytes_written +=
	  (before - uio->uio_resid);
    }

    return (ret);
}

cmreadstrategy(bp)
struct buf *bp;
{
    register int retval;
    in_cm_code++;
    retval = cmreadstrategy_helper(bp);
    in_cm_code--;
    return retval;
} /* cmreadstrategy */

cmreadstrategy_helper (bp)
    struct buf *bp;
{
    register CM_STATE *cms;
    register CM_PROC *cmp;
    register FIFOQUEUE *fq;
    long *p;
    int length, n;
    int ret;

    if ((cmp = GetProcess(u.u_procp->p_pid, bp->b_dev, ACTIVE_ONLY))
	== NULLPROC) {
	bp->b_flags |= B_ERROR;
	bp->b_error = EPERM;
	iodone (bp);
	return;
    }

    cms = &(cm_state[cmp->cmp_udata.ud_intf]);

    lock_buffer(bp);

    length = (bp->b_bcount >> 2);		    /* convert to words */
    p = (long *)bp->b_un.b_addr;

    cms->cms_stats.reads++;
    cms->cms_stats.readlength += bp->b_bcount;

    /*
     * See if can satisfy the read from any queued output data
     */

    fq = &cmp->cmp_ofifo_data;

    while ((length > 0) && (!fq_empty(fq))) {
	*p++ = (long)fq_remove(fq);
	length--;
    }

    if (length == 0) {
	goto xfer_complete;
    }

    /*
     * Wait for us to become the active process
     */

    if (!ExclusiveAccess(bp->b_dev)) {
	while (cms->cms_active != cmp) {
	    if (cms->cms_daemon == NULL) {
		cmp->cmp_udata.ud_state &= ~US_BLOCKED;
		bp->b_flags |= B_ERROR;
		bp->b_error = EINTR;
		goto xfer_complete;
	    }

	    /* Tell the TS daemon he has work to do */
	    if ((cmp->cmp_udata.ud_state & US_BLOCKED) == 0) {
		cmp->cmp_udata.ud_state |= US_BLOCKED;
		selwakeup(cms->cms_daemon->cmp_procp, 0);
	    }

	    if (sleep (&cmp->cmp_udata.ud_state, (PCATCH | CMPRI)) != 0) {
		cmp->cmp_udata.ud_state &= ~US_BLOCKED;
		bp->b_flags |= B_ERROR;
		bp->b_error = EINTR;
		goto xfer_complete;
	    }
	}
    }

    cmp->cmp_udata.ud_state &= ~US_BLOCKED;

    /*
     * Have to check again to see if a SUSPEND saved any
     * ofifo data for us.
     */

    while ((length > 0) && (!fq_empty(fq))) {
	*p++ = (long)fq_remove(fq);
	length--;
    }

    if (length == 0) {
	goto xfer_complete;
    }


    cmp->cmp_udata.ud_state |= US_READING;
    ProtectNexus(cms) {

	if (CM_OFIFO_EMPTY(cms)) {
	    ret = AwaitEvent (cms, cmp, (TIMEOUT | EXCEPTION | OFIFO_READY),
			      CM_VFIFO_READ_TIMEOUT);

	    if (ret & TIMEOUT) {
		bp->b_flags |= B_ERROR;
		bp->b_error = ETIMEDOUT;
		goto out;
	    }
	    if (ret & EXCEPTION) {
		bp->b_flags |= B_ERROR;
		bp->b_error = EIO;
		goto out;
	    }

	    ReprotectNexus(cms);
	}

	while (length > 0) {
	    switch ((n = length & 0x0F)) {
	      case  0: CM_READ_OFIFO(cms, *p++); n = 16; 
	      case 15: CM_READ_OFIFO(cms, *p++);
	      case 14: CM_READ_OFIFO(cms, *p++);
	      case 13: CM_READ_OFIFO(cms, *p++);
	      case 12: CM_READ_OFIFO(cms, *p++);
	      case 11: CM_READ_OFIFO(cms, *p++);
	      case 10: CM_READ_OFIFO(cms, *p++);
	      case  9: CM_READ_OFIFO(cms, *p++);
	      case  8: CM_READ_OFIFO(cms, *p++);
	      case  7: CM_READ_OFIFO(cms, *p++);
	      case  6: CM_READ_OFIFO(cms, *p++);
	      case  5: CM_READ_OFIFO(cms, *p++);
	      case  4: CM_READ_OFIFO(cms, *p++);
	      case  3: CM_READ_OFIFO(cms, *p++);
	      case  2: CM_READ_OFIFO(cms, *p++);
	      case  1: CM_READ_OFIFO(cms, *p++);
	    }
	    length -= n;
	}
	
	if (CM_ERROR(cms)) {
	    bp->b_flags |= B_ERROR;
	    bp->b_error = EIO;
	}
	
      out:
	;
    }
    RestoreNexus(cms);

  xfer_complete:

    unlock_buffer(bp);
    cmp->cmp_udata.ud_state          &= ~US_READING;
    cmp->cmp_udata.ud_mark            = TIME_STAMP;
    cmp->cmp_owner->cmp_udata.ud_mark = TIME_STAMP;

    SignalEvent (cms, XFERCOMPLETE);
    iodone (bp);

    return;


}/* cmreadstrategy_helper */

cmwritestrategy (bp)
register struct buf *bp;
{
    register int retval;
    in_cm_code++;
    retval = cmwritestrategy_helper(bp);
    in_cm_code--;
    return retval;
}

cmwritestrategy_helper (bp)
    struct buf *bp;
{
    register CM_STATE *cms;
    register CM_PROC *cmp;
    register long *ptr, *fifo;
    int count;

    if ((cmp = GetProcess(u.u_procp->p_pid, bp->b_dev, ACTIVE_ONLY))
	== NULLPROC) {
	bp->b_flags |= B_ERROR;
	bp->b_error = EPERM;
	iodone (bp);
	return;
    }

    cms = &(cm_state[cmp->cmp_udata.ud_intf]);
    cms->cms_stats.writes++;
    cms->cms_stats.writelength += bp->b_bcount;

    lock_buffer(bp);

    count = (bp->b_bcount >> 2);		    /* convert to words */
    ptr   = (long *)bp->b_un.b_addr;
    fifo  = &(cms->cms_regs->cm_ucfifo);

    ProtectNexus(cms) {
	
	while (count > 0) {
	    register int length, n;
	    
	    /*
	     * Wait for IFIFO ready, checking for timeouts or other errors
	     */
	    
	    if (AwaitEvent (cms, cmp, (TIMEOUT | EXCEPTION | IFIFO_READY),
			    CM_VFIFO_WRITE_TIMEOUT) & TIMEOUT) {
		bp->b_flags |= B_ERROR;
		bp->b_error = ETIMEDOUT;
		break;
	    }
	    
	    if (CM_ERROR(cms)) {
		bp->b_flags |= B_ERROR;
		bp->b_error = EIO;
		break;
	    }

	    ReprotectNexus(cms);

	    /*
	     * Loop on minimum of xfer length left or the number of words in
	     * the FIFO. 
	     */
	    
	    length = (cms->cms_iwords < count) ? cms->cms_iwords : count;
	    cms->cms_iwords -= length;
	    count -= length;
	    
	    while (length > 0) {
		switch ((n = length & 0x0F)) {
		  case  0: *fifo = *ptr++; n = 16; 
		  case 15: *fifo = *ptr++;
		  case 14: *fifo = *ptr++;
		  case 13: *fifo = *ptr++;
		  case 12: *fifo = *ptr++;
		  case 11: *fifo = *ptr++;
		  case 10: *fifo = *ptr++;
		  case  9: *fifo = *ptr++;
		  case  8: *fifo = *ptr++;
		  case  7: *fifo = *ptr++;
		  case  6: *fifo = *ptr++;
		  case  5: *fifo = *ptr++;
		  case  4: *fifo = *ptr++;
		  case  3: *fifo = *ptr++;
		  case  2: *fifo = *ptr++;
		  case  1: *fifo = *ptr++;
		}
		length -= n;
	    }
	    
	}
    }
    RestoreNexus(cms);
    unlock_buffer(bp);
    iodone (bp);
    return;

}/* cmwritestrategy  */

cmioctl(dev, cmd, data, flag)
dev_t   dev;
int     cmd;
caddr_t data;
int     flag;
{
    register int retval;
    /*
     * There are too many returns in cmioctl_helper to stick an
     * in_cm_code--; in front of every one...
     */
    in_cm_code++;
    retval = cmioctl_helper(dev, cmd, data, flag);
    in_cm_code--;
    return retval;
}

int max_if_len, max_of_len;

/*ARGSUSED*/
private
cmioctl_helper(dev, cmd, data, flag)
dev_t   dev;
int     cmd;
caddr_t data;
int     flag;
{
    register CM_STATE *cms;
    register CM_PROC *cmp;
    int unit, s;
    int wait_p = 0;

    CheckProcesses ();

    cmp = GetProcess(u.u_procp->p_pid, dev, ACTIVE_OR_SUSPENDED);

    if (CM_DIAG(dev)) unit = CM_UNIT(dev);
    else if (cmp != NULL) unit = cmp->cmp_udata.ud_intf;
    else unit = -1;

    cms = (unit == -1) ? NULL : &(cm_state[unit]);

    switch (cmd) {
	/*
	 * These cases are in alphabetical order, simply because there are
	 * so many of them.
	 *
	 * Unfortunately, this separates the SET/GET and SET/CLEAR pairs,
	 * but you're editing with gmacs so bring them up in separate
	 * windows... 
	 */

      case CM_ACCOUNTING_ON:
	if(cm_accounting_daemon
	   /*
	    * does the process still exist?
	    */
	   && PROC_STILL_EXISTS(cm_accounting_daemon)
	   && cm_accounting_daemon != cmp) {
	    return EBUSY;
	}
	else cm_accounting_daemon = cmp;

	return 0;

      case CM_ATTACH_WAIT:
	wait_p = 1;
	/* FALL THROUGH ... */
      case CM_ATTACH:
      {
	  Q_FOR_CM *new = (Q_FOR_CM *)kmalloc(sizeof(Q_FOR_CM));
	  CM_STATE *cms;
	  int s;
	  int r = 0;

	  if(cmp == NULL) return ENOTCONN;	/* dm 24/9/91 */

	  if(new == NULL) return ENOMEM;

	  new->wuser.uid = u.u_uid;
	  new->wuser.pid = u.u_procp->p_pid;
	  new->proc = u.u_procp;
	  new->wuser.began_waiting = TIME_STAMP;
	  new->wuser.wanted = *((CM_WANTED_UCC_SET *) data);
	  new->next = NULL;
	  new->prev = NULL;

	  /*
	   * start the idletimer, if necessary
	   */
	  if (IdleTimerIsRunning == 0) {
	      IdleTimerIsRunning = 1;
	      timeout (IdleTimer, 0,  1);
	      if (cm_debug) printf("cmioctl CM_ATTACH{_WAIT}: Starting CM IdleTimer\n");
	  }

	  /*
	   * Wait for the resources to become available...
	   */
	  if ((cms = CheckForResource(NULL, new))
		 == (CM_STATE *)NULL) {
	      /*
	       * Make sure we're not holding onto 
	       * resources ourself while we're waiting...
	       */
	      if ((cms = cmp->cmp_owner->cmp_interface) != NULL) {
		  register CM_PROC *icmp;
		  /*
		   * We already have an interface but it's not what we want.
		   * Disconnect before we wait.
		   */
		  if (cms->cms_flags & CMS_SHARED) {
		      /*
		       * Disconnect just our process group from the shared interface.
		       */
		      s = splcm(NULL);
		      AcquireProcessLock("CM_ATTACH");
		      for ALL_PROCESSES_IN_PROCESS_GROUP(icmp, cmp->cmp_owner)
			  DisconnectProcess(icmp, 0, u.u_uid);
		      ReleaseProcessLock("CM_ATTACH");
		      splx(s);
		  } else {
		      /*
		       * Disconnect all processes from our currently attached
		       *  interface.
		       * (I believe that this *should* be just our process group!)
		       */
		      for ALL_PROCESSES_ON_INTERFACE(cms, icmp) 
			  DisconnectProcessAndLock(icmp, 0, u.u_uid);
		      cms->cms_flags &= ~(CMS_OPEN | CMS_EXCL);
		  }
		  cmp->cmp_owner->cmp_interface = NULL;
		  CheckInterfaces();
	      }

	      if (!wait_p) {
		  kmfree(new, sizeof(Q_FOR_CM));
		  return (EWOULDBLOCK);
	      }
	      /*
	       * Resources are not available now, wait for them to become available.
	       * 
	       * Stick us onto the queue...
	       */
	      s = splcm(NULL);
	      new->prev = attach_waiting_tail;
	      if(attach_waiting_tail) 
		  attach_waiting_tail->next = new;
	      else 
		  attach_waiting_head = new;
	      /*
	       * Always update tail!
	       */
	      attach_waiting_tail = new;
	      splx(s);

	      /*
	       * Now wait until we get what we asked for or interrupt.
	       */
	      r = 0;
	      while (((cms = cmp->cmp_owner->cmp_interface) == NULL)
		     && (r == 0)) {
		  r = sleep(new, PCATCH | (PZERO+1));
	      }

	      if (r) {
		  register Q_FOR_CM *w;
		  /*
		   * Process was interrupted while waiting.  
		   * Remove it from the queue.
		   */
		  s = splcm(NULL);
		  for(w = attach_waiting_head; w ; w = w->next) 
		      if (w == new) {
			  if(new->prev)  new->prev->next = new->next;
			  else  attach_waiting_head = new->next;
			  if(new->next)  new->next->prev = new->prev;
			  else  attach_waiting_tail = new->prev;
			  break;
		      }
		  splx(s);
		  kmfree(new, sizeof (Q_FOR_CM));

		  if (cms) {
		      register CM_PROC *icmp;
		      /*
		       * We actually got the resource before we were interrupted!
		       * (this is pretty unlikely).  Disconnect before
		       * returning.
		       */
		      for ALL_PROCESSES_ON_INTERFACE(cms, icmp) 
			  DisconnectProcessAndLock(icmp, 0, u.u_uid);
		      cms->cms_flags &= ~(CMS_OPEN | CMS_EXCL);
		      cmp->cmp_owner->cmp_interface = NULL;
		  }
		  CheckInterfaces();

		  return EINTR;
	      }

	      kmfree(new, sizeof (Q_FOR_CM));
	      
	      /*
	       * We've already been connected by CheckForResource().
	       */
	  }

	  break;
      }

      case CM_CLEAR_DIAG_MODE:
	{
	    if (cms == NULL) {
		return (ENOTCONN);
	    }

	    if (!ExclusiveAccess(dev)) {
		return (EOPNOTSUPP);
	    }

	    cms->cms_intr_proc = NULL;
	    cms->cms_modtime = TIME_STAMP;
	    break;
	}

      case CM_CLEAR_INTR_PID:
	return (0);

      case CM_CLOSE:
	/*
	 * Unix doesn't pass all closes down, so we have to find another way
	 */
	{
	    cmclose (dev, 0);
	    break;
	}

      case CM_CONNECT_TO_INTERFACE_SET:
	/*
	 * Connect this process list to any one of the specified interfaces.
	 * Let any waiters get at it first!
	 */
	{
	    int interface, interface_mask;

	    if (cms) 
		CheckWaitQueue(cms);

	    interface_mask = *(int *)data;

	    if (cmp == NULL) return ENOTCONN;

	    if (cmp->cmp_owner->cmp_interface != NULL) return EBUSY;

	    for (interface = 0; interface < 4; interface++) {
		if (interface_mask & (1 << interface)) {
		    if (ConnecttoInterface(cmp, interface, 1) == 0) {
			*(int *)data = interface;
			return (0);
		    }
		}
	    }
	    return EBUSY;
	}
      case CM_DISCONNECT_FROM_INTERFACE:
	/*
	 * Disconnect all (non-diag) users from the specified interface.
	 */
      case CM_PREEMPT_INTERFACE:
	/*
	 * ...and steal the interface for ourselves.
	 */
	{
	    int	interface;
	    CM_PROC *cmp;

	    if ((interface = *(int *)data) != -1 && interface < NCM)
		cms = &cm_state[interface];

	    if(cms == NULL) return ENOTCONN;
	      
	    if ((cms->cms_flags & CMS_AVAIL) == 0) 
	      return ENXIO;

	    s = splcm(NULL);
	    AcquireProcessLock("ioctl PREEMPT INTERFACE");
	    for ALL_PROCESS_GROUPS(cm_procs, cmp)
	      if (cmp->cmp_interface == cms)
		DisconnectProcessGroup(cmp, u.u_uid);
	    ReleaseProcessLock("ioctl PREEMPT INTERFACE");
	    splx(s);
	    CheckInterfaces();

	}
	if (cmd == CM_DISCONNECT_FROM_INTERFACE) break;
	/*
	 * NOTE: the CM_PREEMPT_INTERFACE function falls through to
	 * connect to the interface, too --- in order to make this action
	 * reasonably atomic.
	 */

      case CM_CONNECT_TO_INTERFACE:
	/*
	 * Connect this process list to a CM interface;
	 * let any waiters get it first!
	 */
	{
	    int interface = *(int *)data;
	    int retval;

	    if (cmp == NULL) return ENOTCONN;

	    /*
	     * Already connected to this interface?
	     */
	    if (cmp->cmp_owner->cmp_interface &&
		cmp->cmp_owner->cmp_interface->cms_interface == interface)
		return 0;

	    /*
	     * Already connected to some other interface?
	     */
	    if (cmp->cmp_owner->cmp_interface) 
		return EBUSY;

	    if (cms && (cmd != CM_PREEMPT_INTERFACE))
		CheckWaitQueue(cms);

	    retval = ConnecttoInterface (cmp, interface, 1);
	    return retval;
	}
      case CM_DISCONNECT:
	/*
	 * Disconnect a tree of processes given the pid of any process in
	 * the tree. (0 means my tree)
	 */
	{
	    CM_PROC *cmp;
	    int pid = *(int *)data;
	    int s;

	    if (pid == 0) pid = u.u_procp->p_pid;

	    if ((cmp = GetProcess (pid, dev, ACTIVE_OR_SUSPENDED)) == NULL) {
		return (ESRCH);
	    }

	    s = splcm(NULL);
	    AcquireProcessLock("ioctl CM_DISCONNECT");
	    DisconnectProcessGroup (cmp->cmp_owner, u.u_uid);
	    ReleaseProcessLock("ioctl CM_DISCONNECT");
	    splx(s);
	    CheckInterfaces();
	    break;
	}

      case CM_GET_ACL:
        {
	    int err = 0;
	    CM_ACL acl;

	    acl = *(CM_ACL *)data;

	    if(acl.len > 0) 
	      err = copyout((caddr_t) (acl.type == CM_ACL_UID
				       ? acl_uids
				       : acl_gids),
			    acl.ids, sizeof(uid_t) * acl.len);
	    if(err == 0)
	      ((CM_ACL *)data)->len = (acl.type == CM_ACL_UID
				       ? acl_uids_size
				       : acl_gids_size);
	    return err;
	}

      case CM_GET_ACL_DENIED:
        {
	    int err = 0;
	    CM_ACL acl;

	    acl = *(CM_ACL *)data;

	    if(acl.len > 0) 
	      err = copyout((caddr_t) (acl.type == CM_ACL_UID
				       ? acl_denied_uids
				       : acl_denied_gids),
			    acl.ids, sizeof(uid_t) * acl.len);
	    if(err == 0)
	      ((CM_ACL *)data)->len = (acl.type == CM_ACL_UID
				       ? acl_denied_uids_size
				       : acl_denied_gids_size);
	    return err;
	}

      case CM_GET_CHILD_ACCT_INFO:
	{
	    CM_ACCT *cma = *(CM_ACCT **)data;

	    if (cmp == NULL) 
		return ENOTCONN;
	    if (cmp->cmp_owner->cmp_childs_cmacct == NULL)
		return (ESRCH);
	    /*
	     * If there's no accounting daemon running, we arn't
	     * gathering any interesting information, so return an error.
	     */
	    if (cm_accounting_daemon == NULL)
		return (ENETDOWN);	/* XXX */

	    return copyout(cmp->cmp_owner->cmp_childs_cmacct, 
			   (caddr_t) cma, sizeof (CM_ACCT));

	}

      case CM_GET_CMINFO:
	{
	    CM_INFO info;
	    long *cminfo;

	    if (cmp == NULL) return ENOTCONN;

	    info = *(CM_INFO *)data;
	    if ((cminfo = cmp->cmp_owner->cmp_cminfo) == NULL) {
		return (ENOTCONN);
	    }

	    if (info.cminfo_size > CM_INFO_SIZE)
	      info.cminfo_size = CM_INFO_SIZE;
	    return  copyout((caddr_t)cminfo, (caddr_t)info.cminfo_addr,
			    info.cminfo_size);
	}

      case CM_GET_HOST:
	/*
	 * return the host ID of the port we are connected to
	 */
	{
	    if (cms == NULL) {
		return (ENOTCONN);
	    }

	    *(int *)data = cms->cms_host;
	    break;
	}

      case CM_GET_IDLETIMEOUT:
	/*
	 * return the value of cm_idletime.
	 */	 
	*(int *)data = cm_idletime;
	break;

      case CM_GET_MODE:
	/*
	 * Return the current mode. Diagnostic devices return the mode of
	 * the interface, all others return their individual mode.
	 */
	{
	    if(cms == NULL) return ENOTCONN;

	    if (CM_DIAG(dev)) {
		*(int *)data = ((cms->cms_flags & CMS_SHARED)
				? CM_SHARE
				: ((cms->cms_flags & CMS_EXCL)
				   ? CM_EXCLUSIVE
				   : (-1)));
	    } else {
		if (cmp == NULLPROC) {
		    return (ESRCH);
		}

		*(int *)data = ((cmp->cmp_udata.ud_state & US_SHARED)
				? CM_SHARE
				: ((cms->cms_flags & CMS_EXCL)
				   ? CM_EXCLUSIVE
				   : (-1)));
	    }
	    break;
	}

      case CM_GET_MY_INFO:
	{
	    CM_PROC *cmp;

	    if (CM_DIAG(dev)) {
		return (EOPNOTSUPP);
	    }

	    if ((cmp = GetProcess (u.u_procp->p_pid, dev,
				   ACTIVE_OR_SUSPENDED)) == NULLPROC) {
		return (ESRCH);
	    }

	    *(struct cm_user_data *)data = cmp->cmp_udata;
	    break;
	}

      case CM_OLD_GET_NSTAT:
      case CM_GET_NSTAT:
	/*
	 * return the nexus status
	 */
	{
	    int nstat;
	    int reg;

	    if (cms == NULL) {
		return (ENOTCONN);
	    }

	    /*
	     * allow for back-compatibility with older software that
	     * didn't use the r0 to select which register...
	     */
	    
	    if(cmd == CM_OLD_GET_NSTAT) reg = 0;
	    else reg = *(int *)data;

	    /*
	     * XXX --- to read regs other than 0 is a little dangerous,
	     * since it has to write R0 to get access to the other regs.
	     * If there is someone else using the interface at this point,
	     * we may trash them.
	     *
	     * Regs other than 0 are ONLY examined in two places:
	     * debugging tools that examine the regs (we assume you know
	     * what you are doing when you run these), and when locking
	     * the nexus (which means you're attaching, which means you've
	     * got exclusive access to the CM...)
	     */
#	    ifdef vax
	    if(reg == 0) {
		int i = 0;

		/*
		 * this EBUSY state is pretty normal, but usually temporary.
		 * Try a few times to spare the poor cmfinger maintainer from
		 * doing so...
		 */
		do {
		    nstat = cm_read_nexstat(cms);
		    if (nstat == -2) sleep(&lbolt, PZERO);
		} while ((nstat == -2) && (i++ < 5));

		if (nstat == -2)
		  return EBUSY;
	    }
	    else nstat = rnr123(cms, reg, FALSE);
#	    endif /* vax */

#	    ifdef sun
	    if(reg == 0) 
	      nstat = cm_read_nexstat(cms);
	    else 
	      nstat = rnr123(cms, reg, FALSE);
#	    endif /* sun */

	    if (NEXUS_R0_CANT_READ(nstat)) return EIO;

	    *(int *)data = nstat;	    
	    
	    break;
	}

      case CM_GET_PROCS:
	/*
	 * User passes us an CM_PTABy structure that contains a pointer to
	 * an array of CM_PINFO structures, and the number of elements in
	 * that array. We fill in the CM_PINFO array with the CM_PROC data
	 * and overwrite the length field of the CM_PTAB structure with
	 * the number of elements that were filled in.
	 */
	{
	    CM_PTAB ptab;
	    CM_PINFO pinfo, *ptr;
	    CM_PROC *cmp;
	    int i, err;

	    if (cms == NULL) {
		return (ENOTCONN);
	    }

	    ptab  = *(CM_PTAB *)data;
	    ptr   = ptab.pt_pinfo;

	    for (i = 0, cmp = FirstProcess(cms);
		 ((i < ptab.pt_size) && (cmp != NULLPROC));
		 i++, cmp = NextProcess(cmp, cms)) {

		pinfo.p_pid    = cmp->cmp_pid;
		pinfo.p_flags  = cmp->cmp_udata.ud_state;
		pinfo.p_uid    = cmp->cmp_udata.ud_uid;
		err = copyout((caddr_t)&pinfo, (caddr_t)ptr++,
			      sizeof(CM_PINFO));
		if (err) {
		    return (err);
		}
	    }

	    ((CM_PTAB *)data)->pt_size = i;
	    break;
	}

#	ifdef vax
      case CM_GET_REG_ADDR:
	/*
	 * Get a pointer to the interface hardware registers. Only allowed in
	 * Diagnostic or exclusive mode. 
	 * Access to the registers was set up at VAX boot time.
	 */
	{
	    if (!ExclusiveAccess(dev)) {
		return (EOPNOTSUPP);
	    }

	    *(CM_REGS **)data = (CM_REGS *) (&cmindregbase[unit]);
	    break;
	}
#	endif /* vax */

      case CM_GET_RUNTIME_LIMIT:
        {
	    int err = 0;
	    int output = 0;
	    int nrecords = 0;
	    CM_LIMIT_ARRAY la;
	    CM_LIMIT_LIST *limit;

	    la = *(CM_LIMIT_ARRAY *)data;

	    for(limit = cm_limit_chain;
		(limit 
		 && err == 0);
		limit = limit->chain_next, nrecords++) {
		if(output < la.nelements) {
		    err = copyout((caddr_t) &limit->limit, 
				  (caddr_t) (la.limit++), 
				  sizeof(CM_LIMIT));
		    output++;
		}
	    }
	    ((CM_LIMIT_ARRAY *)data)->nelements = output;
	    ((CM_LIMIT_ARRAY *)data)->limit_chain_len = nrecords;

	    return err;
	}
	
      case CM_GET_STATS:
	{
	    if (cms == NULL) 
		return (ENOTCONN);

	    *(CM_STAT *)data = cms->cms_stats;
	    break;
	}

      case CM_GET_TS_PROCS:
	/*
	 * User passes us an CM_PTAB structure that contains a pointer to
	 * an array of CM_PINFO structures, and the number of elements in
	 * that array. We fill in the CM_PINFO array with the CM_PROC data
	 * and overwrite the length field of the CM_PTAB structure with
	 * the number of elements that were filled in.
	 *
	 * Only processes connected in a timeshared mode are returned.
	 */
	{
	    CM_PTAB ptab;
	    CM_PINFO pinfo, *ptr;
	    CM_PROC *cmp;
	    int i, err;

	    if (cms == NULL) 
		return (ENOTCONN);

	    ptab  = *(CM_PTAB *)data;
	    cmp   = FirstProcess(cms);
	    ptr   = ptab.pt_pinfo;

	    i = 0; 
	    
	    while ((i < ptab.pt_size) && (cmp != NULLPROC)) {
		if (cmp->cmp_udata.ud_state & US_SHARED) {
		    pinfo.p_pid    = cmp->cmp_pid;
		    pinfo.p_flags  = cmp->cmp_udata.ud_state;
		    pinfo.p_uid    = cmp->cmp_udata.ud_uid;
		    err = copyout((caddr_t)&pinfo, (caddr_t)ptr++, sizeof(CM_PINFO));
		    if (err) return (err);
		    i++;
		}
		cmp = NextProcess(cmp, cms);
	    }

	    ((CM_PTAB *)data)->pt_size = i;
	    break;
	}
      case CM_GET_TS_PROCSX:
	/*
	 * Like above, but more goodies.
	 */
	{
	    CM_PTABX ptab;
	    CM_PINFOX pinfo, *ptr;
	    CM_PROC *cmp;
	    int i, err;

	    if (cms == NULL) 
		return (ENOTCONN);

	    ptab  = *(CM_PTABX *)data;
	    cmp   = FirstProcess(cms);
	    ptr   = ptab.pt_pinfo;

	    i = 0; 
	    
	    while ((i < ptab.pt_size) && (cmp != NULLPROC)) {
		if (cmp->cmp_udata.ud_state & US_SHARED) {
		    pinfo.p_pid    = cmp->cmp_pid;
		    pinfo.p_flags  = cmp->cmp_udata.ud_state;
		    pinfo.p_uid    = cmp->cmp_udata.ud_uid;
		    pinfo.p_ud_mark    = cmp->cmp_udata.ud_mark;
		    pinfo.p_wchan = cmp->cmp_procp->p_wchan;
		    err = copyout((caddr_t)&pinfo, (caddr_t)ptr++, sizeof(CM_PINFO));
		    if (err) return (err);
		    i++;
		}
		cmp = NextProcess(cmp, cms);
	    }

	    ((CM_PTABX *)data)->pt_size = i;
	    i = splcm(cms);
	    WithFEBIErrorsIgnored(cms) {
		((CM_PTABX *)data)->pt_cmstate = 
#		  ifndef vax
		  ((CM_IDLE(cms)) ? PT_CM_IDLE : 0) |
#		  endif /* not vax */
		    ((CM_ERROR(cms)) ? PT_CM_ERROR : 0);
	    }
	    EndFEBIErrorsIgnored;
	    splx(i);
	    break;
	}

      case CM_GET_UCC0:
	/*
	 * Get Microcontroller status register 0
	 */
	{
	    if (cms == NULL) 
		return (ENOTCONN);

	    ProtectNexus(cms) {
		*(long *)data = cms->cms_regs->cm_ucsr0;
	    }
	    RestoreNexus(cms);
	    break;
	}

      case CM_GET_UCCS:
	/*
	 * return the sequencers currently attached to our host. Have to
	 * look down the UCC ports in case host has multiple sequencers
	 * (can only encode one sequencer in the host port associated with
	 * us).
	 */
	if (cms == NULL) 
	  return (ENOTCONN);

	*(int *)data = cms->cms_seqn = UCCSet_Read(cms);
	break;

      case CM_GET_UCCTIMEOUT:
	/*
	 * return the value of cm_idletime.
	 */	 
	*(int *)data = cm_no_uccs_time;
	break;

      case CM_GET_USER_INFO:
	/*
	 * Return an array whose elements consist of a structure which
	 * represents the non-private data for each open device. Arguments
	 * are a structure containing the max number of devices to report
	 * and a pointer into the user process space array to receive the
	 * data
	 */
	{
	    struct cmioc_user_info pblk;
	    struct cm_user_data *ptr;
	    CM_PROC *cmp;
	    int i, err;

	    pblk  = *(struct cmioc_user_info *)data;
	    ptr   = pblk.ui_array;
	    cmp   = cm_procs;

	    for (i = 0; i < pblk.ui_array_size; i++) {
		if (cmp == NULLPROC) {
		    struct cm_user_data ud;
		    bzero ((caddr_t)&ud, sizeof(ud));
		    err = copyout((caddr_t)&ud, (caddr_t)ptr,
				  sizeof(*ptr));
		    if (err) return (err);
		} else {
		    err = copyout((caddr_t)&cmp->cmp_udata, (caddr_t)ptr,
				  sizeof(*ptr));
		    if (err) return (err);
		    cmp = ((cmp->cmp_next != NULL)
			   ? cmp->cmp_next
			   : cmp->cmp_owner->cmp_sibling);
		}
		ptr++;
	    }
	    break;
	}

      case CM_GET_INDIVIDUAL_RUNTIME_LIMIT:
        {
	    CM_LIMIT_LIST *olimit;

	    olimit = cm_limit_find(((CM_LIMIT *)data)->id.uid,
				   ((CM_LIMIT *)data)->type);

	    if(olimit == NULL) return ESRCH;
	    else *(CM_LIMIT *)data = olimit->limit;

	    break;
	}
	
      case CM_GET_WAITQUEUE:
	/*
	 * return an array of processes waiting for a CM interface.
	 */
      {
	  int q_count;
	  Q_FOR_CM *p;
	  CM_WAITING_USER *pWu;
	  CM_WAITQUEUE cmq;
	  int err = 0;

	  cmq = *(CM_WAITQUEUE *)data;
	  pWu = cmq.waiting;

	  /*
	   * count the length of queue, PLUS, as long as you can, copy out
	   * the items on the queue.
	   */
	  for(q_count = 0, p = attach_waiting_head;
	      p != NULL;
	      p = p->next) {
	      if(err == 0 && q_count < cmq.count)
		err = copyout((caddr_t) &p->wuser,
			      (caddr_t) pWu++,
			      sizeof(CM_WAITING_USER));
	      q_count++;
	  }
	  ((CM_WAITQUEUE *)data)->count
	    = q_count < cmq.count? q_count: cmq.count;

	  ((CM_WAITQUEUE *)data)->total_count = q_count;
	  return err;
      }
	/*NOTREACHED*/
	break;

      case CM_NEXUS_LOCK:
      {
	  int locking_host = *(int *) data;

	  if(cms == NULL) return ENOTCONN;
	  return nexus_lock(cms, locking_host);
      }
	
      case CM_NEXUS_UNLOCK:
	if(cms == NULL) return ENOTCONN;
	else return nexus_unlock(cms);
	  
      case CM_READ_ACCT_RECORD:
        {
	    /*
	     * The user passes in a CM_ACCT_IOCTL structure (because the
	     * idiot ioctl interface can't handle structures > 128
	     * bytes).
	     */
	    CM_KACCT *cmk = Acct_Queue_Dequeue();
	    CM_ACCT_IOCTL ai;
	    int err = 0;

	    ai = *(CM_ACCT_IOCTL *)data;

	    if(cmk == NULL) return EWOULDBLOCK;
	    
	    /*
	     * would be bad form to leave these lying around...
	     */
	    cmk->next = cmk->prev = 0;
	    
	    if(ai.length == sizeof(CM_ACCT))
	      err = copyout((caddr_t) &cmk->acct,
			    (caddr_t) ai.acctu.acct,
			    sizeof(CM_ACCT));
	    else if(ai.length == sizeof(CM_KACCT))
	      err = copyout((caddr_t) cmk,
			    (caddr_t)ai.acctu.kacct,
			    sizeof(CM_KACCT));
	    else {
		/*
		 * stick it back on the queue...
		 */
		cmk->reason = cmk->reason + CMKR_REPEAT;
		Acct_Queue(cmk, 0);
		return EINVAL;
	    }
	    Acct_Free(cmk);
	    return err;
	}  
	/*NOTREACHED*/
	break;

#	ifdef vax
      case CM_READ_NEXSTAT:
	/*
	 * Read the real nexus status (if can't, return -1). Only allowed in
	 * Diagnostic or exclusive mode. 
	 */
	{
	    if (cms == NULL) 
		return (ENOTCONN);

	    if (!ExclusiveAccess(dev))
		return (EOPNOTSUPP);

	    *(long *)data = cm_read_nexstat(cms);
	    break;
	}
#	endif /* vax */

	/*
	 * takes an argument: the timeout in seconds.
	 *
	 * used for a process like the NQS scheduler to allocate CM
	 * resources, then start up the program that will use them.  The
	 * NQS scheduler then moves on to work on the next request,
	 * unburdened by an attachment to the CM.
	 *
	 * 
	 */
      case CM_RELAY_ATTACHMENT:
      {
	  int timeout = *(int *)data;

	  if(cmp == NULL) return EBADF;
	  if(cms == NULL) return ENOTCONN;

	  /*
	   * Do we have a child, yet?
	   *
	   * Note the spaghetti involving the process locks --- don't want
	   * cmp->cmp_next getting changed out from under us.
	   */
	  while(cmp->cmp_next == NULL && timeout-- > 0) 
	    sleep(&lbolt, PZERO);

	  /*
	   * Priority still splcm, process-lock still held.
	   */
	  if(timeout <= 0) return ETIMEDOUT;
	  else {
	      DeleteProcess(cmp);
	      return 0;
	  }
      }

      case CM_RESET:
	{
	    if ((ExclusiveAccess(dev)) && (unit != -1)) {
		cmreset (unit);
	    }
	    if (cmp) {
		cmp->cmp_udata.ud_state &= ~US_CM_ERROR;
		drainFifoqueue(&cmp->cmp_ofifo_data);
		drainFifoqueue(&cmp->cmp_ififo_data);
		cm_unmap(cmp);	/* remap *real* reg pages */
	    }

	    break;
	}

      case CM_RESUME:
	/*
	 * Resume a blocked process. Caller must be the daemon process,
	 * and there can't be a currently active process.
	 */
	{
	    CM_PROC *cmp;
	    int pid = *(int *)data;

	    if (cms == NULL) 
		return (ENOTCONN);

	    if (NotDaemonProcess(cms))
		return (EPERM);

	    if (cms->cms_active && (cms->cms_active != cms->cms_daemon))
		return (EBUSY);

	    cmp = NULL;
	    for ALL_PROCESSES_ON_INTERFACE(cms, cmp) {
		if ((cmp->cmp_procp != NULL) && (cmp->cmp_pid == pid)) 
		    break;
	    }
	    if (cmp == NULL)
		return (ESRCH);
	    
	    /*
	     * resume process "cmp"
	     */
	    BusyTicks(cms->cms_active, cms);
#ifdef sun
	    /*
	     * If this process has the fifo mapped in SHARED mode,
	     * restore this guy's OFIFO data and IFIFO data before
	     * resuming.  No need to wait for room;
	     * we're guarenteed it will fit!
	     */
	    if ((cms->cms_tsinfo.ucode_version >= 6100) && cmp->cmp_sdp) {
		FIFOQUEUE *fq;
		register long *fifo  = &(cms->cms_regs->cm_ucfifo);
		register int room;

		if (cm_debug) printf("RESUME (%d) mapped\n",
				     pid);

		if (CM_ERROR(cms)) {
		    if (cm_verbose) {
			printf("RESUME (%d) CM error: %b\n",
			       pid, cms->cms_regs->cm_csr, CM_CSR_BITS);
			printf("       hstat %b\n", 
			       cms->cms_regs->cm_hstat, CM_HSTAT_BITS);
			printf("       ucsr0 %b\n",
			       cms->cms_regs->cm_ucsr0, UC_REG0_BITS_WITH_FLAGS);
		    }
		    return EIO;
		}

		if (CheckEvent(cms, IFIFO_READY) == 0) {
		    if (cm_verbose) 
			printf("RESUME (%d): IFIFO not ready, hstat %b\n",
			       pid, cms->cms_regs->cm_hstat, CM_HSTAT_BITS);
		    return EIO;
		}

		ProtectNexus(cms);
		fq = &cmp->cmp_ofifo_data;
		if (cm_debug && fq_not_empty(fq)) 
		    printf("Restoring %d words to OFIFO\n",
			   fq->fq_length);
		
		room = (CM_IFIFO_MPTY(cms)) ? 500 : 
		    (CM_IFIFO_RDY(cms) ? 240 : 0);
		while (fq_not_empty(fq)) {
		    if ((room -= 2) <= 0) {
			if (AwaitEvent(cms, cms->cms_daemon, 
				       (TIMEOUT | EXCEPTION | IFIFO_READY),
				       hz) & (TIMEOUT|EXCEPTION))
			    return EIO;
			room = (CM_IFIFO_MPTY(cms)) ? 500 : 
			    (CM_IFIFO_RDY(cms) ? 240 : 0);
		    }
		    IF_TO_OF_SINGLE(cms, fifo, fq_remove(fq));
		}

		fq = &cmp->cmp_ififo_data;
		if (cm_debug && fq_not_empty(fq)) 
		    printf("Restoring %d words to IFIFO\n",
			   fq->fq_length);
		while (fq_not_empty(fq)) {
		    if (--room <= 0) {
			if (AwaitEvent(cms, cms->cms_daemon, 
				       (TIMEOUT | EXCEPTION | IFIFO_READY),
				       hz) & (TIMEOUT|EXCEPTION))
			    return EIO;
			room = (CM_IFIFO_MPTY(cms)) ? 500 : 
			    (CM_IFIFO_RDY(cms) ? 240 : 0);
		    }
		    *fifo = fq_remove(fq);
		}

		RestoreNexus(cms);
		/* 
		 * Committed to resume now, don't
		 * check for error here.
		 */
	    } else {
		if (cm_debug)
		    printf("RESUME (%d) vfifo\n", pid);
	    }
#endif sun
	    cms->cms_active  = cmp;
	    cmp->cmp_udata.ud_state &= ~US_BLOCKED;

	    wakeup (&cmp->cmp_udata.ud_state);
	    /*
	     * Note that we've given the interface to this guy now.
	     */
	    if (cmp->cmp_kacct)
		cmp->cmp_kacct->acct.last_excl_time = time;

	    return (0);	
	}

      case CM_RESUME_TIMESHARING:
      {
	  CM_STATE *cms;
	  int s;
	  CM_PROC *prev;
	  CM_PROC *next;

	  if (cmp == NULL) return ENOTCONN;

	  cms = cmp->cmp_owner->cmp_interface;

	  if(cms == NULL 
	     || (cms->cms_daemon == NULL)
	     || (cms->cms_daemon->cmp_pid != u.u_procp->p_pid))
	    return (EPERM);

	  /*
	   * Make sure the interface is available!
	   */
	  if (((cms->cms_flags & CMS_AVAIL) == 0) ||
	      (cms->cms_flags & CMS_EXCL))
	      return (EBUSY);

	  /*
	   * The interrupt handler uses this chain to find processes that
	   * need to be woken up, therefore, prevent interrupts from
	   * finding the chain in an inconsistent state.
	   */
	  s = splcm(cms);
	  
	  /*
	   * We are going to delink every process that is attached to our
	   * interface. 
	   */
	  AcquireProcessLock("ioctl RESUME TIMESHARING");
	  for(cmp = cm_suspended_procs, prev = NULL;
	      cmp != NULL;
	      cmp = next) {

	      next = cmp->cmp_sibling;

	      if(cmp->cmp_interface != NULL && cmp->cmp_interface == cms) {
		  /*
		   * Need we delink the first one?
		   */
		  if(cm_suspended_procs == cmp)
		    cm_suspended_procs = cmp->cmp_sibling;
		  else {
		      /*
		       * Find the predecessor for the fellow to be delinked.
		       */
		      for(prev = cm_procs;
			  prev != NULL && prev->cmp_sibling != cmp;
			  prev = prev->cmp_sibling)
			{;}
		      
		      if(prev == NULL || prev->cmp_sibling != cmp){
			  splx(s);
			  return ESRCH;
		      }
		      
		      prev->cmp_sibling = cmp->cmp_owner->cmp_sibling;
		  }
		  cmp->cmp_sibling = cm_procs;
		  cm_procs = cmp;
	      }
	      else prev = cmp;
	  }
	  ReleaseProcessLock("ioctl RESUME TIMESHARING");
	  /*
	   * the interface is shared again, and also is open.
	   */
	  cms->cms_flags |= (CMS_SHARED|CMS_OPEN);
	  cms->cms_seqn_to_zero = TIME_STAMP;	/* Give us 15 seconds to get UCCS again */
	  /*
	   * Has the idletimer gone away due to interface inactivity?
	   * restart it.
	   */
	  if (IdleTimerIsRunning == 0) {
	      IdleTimerIsRunning = 1;
	      timeout (IdleTimer, 0,  1);
	      if (cm_debug) printf("cmioctl RESUME_TIMESHARING: Starting CM IdleTimer\n");
	  }

	  splx(s);
	  break;
      }

      case CM_SET_ACL:
        {
	    CM_ACL acl;
	    uid_t **aclp;
	    uid_t *newp;
	    int *sizep;

	    if(!suser()) return EPERM;

	    acl = *(CM_ACL *)data;
	    if (cm_debug) {
		int i;
		printf("ACL: type %x; len: %d; ", acl.type, acl.len);
		for(i = 0; i < acl.len; i++)
		    printf("id[%d]: %d; ", i, acl.ids[i]);
		printf("\n");
	    }
	    if(acl.type == CM_ACL_UID) {
		aclp = &acl_uids;
		sizep = &acl_uids_size;
	    }
	    else if(acl.type == CM_ACL_GID) {
		aclp = &acl_gids;
		sizep = &acl_gids_size;
	    }
	    else return EINVAL;

	    if(acl.len > 0) {
		if((newp = (uid_t *)kmalloc(sizeof(uid_t) * acl.len))
		   == (uid_t *) NULL)
		  return ENOMEM;
	    }
	    else if(acl.len == 0) newp = NULL;
	    else return EINVAL;

	    kmfree(*aclp, sizeof(uid_t) * (*sizep));
	    *aclp = newp;
	    *sizep = acl.len;
	     
	    return (acl.len
		    ? copyin(acl.ids, (caddr_t) *aclp,
			     sizeof(uid_t) * acl.len)
		    : 0);
	}

      case CM_SET_ACL_DENIED:
        {
	    CM_ACL acl;
	    uid_t **aclp;
	    uid_t *newp;
	    int *sizep;

	    if(!suser()) return EPERM;

	    acl = *(CM_ACL *)data;
	    if (cm_debug) {
		int i;
		printf("ACL: type %x; len: %d; ", acl.type, acl.len);
		for(i = 0; i < acl.len; i++)
		    printf("id[%d]: %d; ", i, acl.ids[i]);
		printf("\n");
	    }
	    if(acl.type == CM_ACL_UID) {
		aclp = &acl_denied_uids;
		sizep = &acl_denied_uids_size;
	    }
	    else if(acl.type == CM_ACL_GID) {
		aclp = &acl_denied_gids;
		sizep = &acl_denied_gids_size;
	    }
	    else return EINVAL;

	    if(acl.len > 0) {
		if((newp = (uid_t *)kmalloc(sizeof(uid_t) * acl.len))
		   == (uid_t *) NULL)
		  return ENOMEM;
	    }
	    else if(acl.len == 0) newp = NULL;
	    else return EINVAL;

	    kmfree(*aclp, sizeof(uid_t) * (*sizep));
	    *aclp = newp;
	    *sizep = acl.len;
	     
	    return (acl.len
		    ? copyin(acl.ids, (caddr_t) *aclp,
			     sizeof(uid_t) * acl.len)
		    : 0);
	}

      case CM_SET_CMINFO:
	{
	    CM_INFO info;
	    long *cminfo;
	    if (cmp == NULL) return ENOTCONN;

	    info = *(CM_INFO *)data;

	    if ((cminfo = cmp->cmp_owner->cmp_cminfo) == NULL)
		cminfo = cmp->cmp_owner->cmp_cminfo
		  = (long *)kmalloc(CM_INFO_SIZE);

	    if ((cminfo = cmp->cmp_owner->cmp_cminfo) == NULL)
		return (ENOMEM);

	    if (info.cminfo_size > CM_INFO_SIZE)
	      info.cminfo_size = CM_INFO_SIZE;

	    return copyin((caddr_t)info.cminfo_addr, (caddr_t)cminfo,
			  info.cminfo_size);
	}

      case CM_SET_DIAG_MODE:
	{
	    if (cms == NULL) return ENOTCONN;

	    if (!ExclusiveAccess(dev))
		return (EOPNOTSUPP);

	    cms->cms_intr_proc = u.u_procp;
	    cms->cms_modtime = TIME_STAMP;
    
	    break;
	}

      case CM_SET_EXCLUSIVE:
	{
	    if (CM_DIAG(dev) || (cmp == NULL))
		return (EPERM);

	    cmp->cmp_udata.ud_state |= US_EXCLUSIVE;
	    break;
	}

      case CM_SET_IDLETIMEOUT:
	/*
	 * return the value of cm_idletime.
	 */	 
	if(!suser()) return(EPERM);
	cm_idletime = *(int *)data;
	break;

      case CM_SET_UCCTIMEOUT:
	/*
	 * return the value of cm_idletime.
	 */	 
	if(!suser()) return(EPERM);
	cm_no_uccs_time = *(int *)data;
	break;

      case CM_SET_INTR_PID:
	return (0);

      case CM_SET_MODE:
	/*
	 * Set the mode of the interface (CM_SHARE or CM_EXCLUSIVE).
	 *
	 * If set to SHARE, then must be one EXCL user who now becomes the
	 * timesharing daemon.
	 *
	 * If set to EXCL, then must be getting back from SHARED, and the
	 * caller must be the process who switched into SHARED mode. All
	 * other users are DISCONNECTED.
	 */
	{
	    if (cms == NULL) 
		return (ENOTCONN);

	    switch (*(int *)data) {
	      case CM_SHARE:
		/*
		 * Someone has already marked it exclusive.
		 */
		if (!(cms->cms_flags & CMS_EXCL)) {
		    return (EPERM);
		}

		/*
		 * The ts-daemon may be suspended.
		 */
		if(cms->cms_daemon != NULL) return EBUSY;

		cms->cms_daemon = GetProcess(u.u_procp->p_pid, dev,
					     ACTIVE_ONLY); 
		cms->cms_flags |= CMS_SHARED;
		cms->cms_modtime = TIME_STAMP;
		bzero (&cms->cms_tsinfo, sizeof (CM_TSINFO));
		
		break;

	      case CM_EXCLUSIVE:
		if (!(cms->cms_flags & CMS_SHARED) || (NotDaemonProcess(cms)))
			return (EPERM);

		for ALL_PROCESSES_ON_INTERFACE(cms, cmp) {

		    if (cmp != cms->cms_daemon) {
			cmp->cmp_udata.ud_state ^= (US_CONNECTED
						    | US_DISCONNECTED);
			cmp->cmp_udata.ud_detach_uid = u.u_uid;
			psignal (cmp->cmp_procp, SIGURG);
		    }
		}
		cms->cms_daemon = NULL;
		cms->cms_flags &= ~CMS_SHARED;
		cms->cms_modtime = TIME_STAMP;
		break;

	      default:
		return (EINVAL);
	    }

	    break;
	}

      case CM_SET_NON_EXCLUSIVE:
	{
	    if (CM_DIAG(dev) || (cmp == NULL))
		return (EPERM);

	    cmp->cmp_udata.ud_state &= ~US_EXCLUSIVE;
	    break;
	}

      case CM_SET_NSTAT:
	/*
	 * Set the Nexus (should make this a privileged operation)
	 */
	{
	    if (cms == NULL) 
		return (ENOTCONN);

	    cms->cms_regs->cm_nsrl = *(int *)data;
	    cms->cms_modtime = TIME_STAMP;
	    break;
	}

#	ifdef notdef
    case CM_SET_ACCOUNT_ID:
	{
	    if(cmp == NULL) return ENOTCONN;

	    if(cmp->cmp_kacct) {
		bcopy((caddr_t)data, (caddr_t)cmp->cmp_kacct->acct.id.acct,
		      CM_ID_STRING_LENGTH);
		cmp->cmp_kacct->acct.id.acct[CM_ID_STRING_LENGTH] = '\0';
	    }
	    else
	      return ENOTCONN;

	    break;
	}
#	endif /* notdef */

    case CM_SET_COMMAND_NAME:
	/*
	 * SET COMMAND NAME
	 *
	 * Allows the user to customize the "command name" field in the
	 * user data.  This field is automatically initialised to the
	 * command name when the device is device opened.
	 */
	if (cmp == NULL) return ENOTCONN;

	bcopy((caddr_t)data, (caddr_t)cmp->cmp_udata.ud_command,
	      CM_MAX_CMD_LENGTH);
	cmp->cmp_udata.ud_command[CM_MAX_CMD_LENGTH] = '\0';
	if(cmp->cmp_kacct) {
	    bcopy((caddr_t)data, (caddr_t)cmp->cmp_kacct->acct.command,
		  CM_MAX_CMD_LENGTH);
	    cmp->cmp_kacct->acct.command[CM_MAX_CMD_LENGTH] = '\0';
	}
	break;

#	ifdef notdef
      case CM_SET_JOB_ID:
	if (cmp == NULL) return ENOTCONN;

	if(cmp->cmp_kacct) {
	    bcopy((caddr_t)data, (caddr_t)cmp->cmp_kacct->acct.id.job,
		  CM_ID_STRING_LENGTH);
	    cmp->cmp_kacct->acct.id.job[CM_ID_STRING_LENGTH] = '\0';
	}
	else
	  return ENOTCONN;
	
	break;
#	endif /* notdef */

      case CM_SET_RUNTIME_LIMIT:
      {
	  int err = 0;
	  int i;
	  int input = 0;
	  CM_LIMIT_ARRAY la;
	  
	  la = *(CM_LIMIT_ARRAY *)data;
	  
	  for(i = 0;
	      (i < CM_LIMIT_HASH_BUCKETS
	       && input < la.nelements
	       && err == 0);
	      i++) {
	      CM_LIMIT limit;
	      
	      if((err = copyin((caddr_t)(la.limit++), (caddr_t)&limit,
			       sizeof(CM_LIMIT))) == 0) {
		  CM_LIMIT_LIST *users_limit
		    = cm_limit_find((limit.type == CM_ACL_UID
				     ? limit.id.uid
				     : limit.id.gid),
				    limit.type);
		  input++;
		  /*
		   * the superuser can set anyone's access limit.
		   * users can only decrease their own, if one exists, or
		   * establish their own, if none exists.
		   */
		  if(suser()
		     /*
		      * user is adjusting their own runtime limit:
		      */
		     || ((limit.type == CM_ACL_UID && limit.id.uid == u.u_uid)
			 /*
			  * ...and there is no pre-existing runtime limit
			  */
			 && ((users_limit == NULL)
			     /*
			      * ...or the user is reducing a pre-existing
			      * runtime limit.
			      */
			     || ((users_limit->limit.exclusive_access_limit
				     > limit.exclusive_access_limit))))) {

		      err = cm_limit_insert(&limit);
		  }
		      
		  else err = EACCES;
	      }
	  }
	  return err;
      }

      case CM_SUSPEND:
	/*
	 * Suspend the current process. Caller must be the daemon process.
	 */
	{
	    CM_PROC *cmp;
	    int SuspendTimeout, InitialSuspendTimeout;

	    if (cms == NULL) 
		return (ENOTCONN);

	    if (NotDaemonProcess(cms))
		return (EPERM);

	    InitialSuspendTimeout = SuspendTimeout = *(int *)data;

	    /*
	     * If there's no current process, then there's nothing to do,
	     * but report this fact to the daemon.
	     */

	    if ((cmp = cms->cms_active) == NULL)
		return (ESRCH);

#ifdef sun
	    if ((cms->cms_tsinfo.ucode_version >= 6100) && cmp->cmp_sdp) {
		register long *ucsr0 = &cms->cms_regs->cm_ucsr0;
		register long *uccsa = &cms->cms_regs->cm_uccsa;
		register long *hs = &cms->cms_regs->cm_hstat;
		register long ucstatus;
		register long ucc_pc;
		int i, hstat;
		int switched = 0;
		int nseq;

#ifdef CM_DEBUG
		int trace_pcs[10];
		int trace_ucsr0[10];
		char *names[10];
		int npcs = 0;
#define TRACEPC(cms, place) \
		if (npcs < 10) {\
				    trace_pcs[npcs] = *uccsa & 0x3ffff;\
					trace_ucsr0[npcs] = *ucsr0;\
					    names[npcs++] = (place);}

#define DUMPPCS() {int j; for (j = 0; j < npcs; j++) printf("[%s] upc=0x%x ucsr0=0x%x\n",\
							    names[j], trace_pcs[j],\
							    trace_ucsr0[j]);}
#else CM_DEBUG
#define TRACEPC(cms, place)
#define DUMPPCS()		
#endif CM_DEBUG

		/*
		 * New context switch mechanism, for processes not using 
		 * the VFIFO.
		 * 
		 * Set Host-UCC bits to 1 to tell the UCC we want to
		 *  context switch.  Note that the active process has 
		 * *NOT* yet been suspended.
		 * 
		 */

		nseq = 0;
		for (i = 0; i < 4; i++)
		    if (cms->cms_seqn & (1<<i))
			nseq++;

		if (cm_debug) 
		    printf("SUSPEND %d (mapped), timeout %d\n",
			   cmp->cmp_pid, SuspendTimeout);

		ProtectNexus(cms);
		TRACEPC(cms, "Entry");

		/*
		 * Tell the UCC to switch this guy when it gets the chance.
		 * Also, let the current process continue until the UCC does go idle
		 */
		if (CM_ERROR(cms)) {
		    if (cm_verbose || cm_debug) {
			printf("SUSPEND (%d) CM error: %b\n",
			       cmp->cmp_pid, cms->cms_regs->cm_csr, CM_CSR_BITS);
			printf("       hstat %b\n", 
			       cms->cms_regs->cm_hstat, CM_HSTAT_BITS);
			printf("       ucsr0 %b\n",
			       cms->cms_regs->cm_ucsr0, UC_REG0_BITS_WITH_FLAGS);
			DUMPPCS();
		    }
		    cmp->cmp_udata.ud_state |= US_CM_ERROR;
		    cm_unmap(cmp);
		    cms->cms_active = NULL; /* Successful SUSPEND */
		    wakeup (&cmp->cmp_udata.ud_state);
		    return(EIO); /* Let TS daemon deal with error */
		} 

		
		/*
		 * Tell the Sequencer to continue, but stop when
		 * it gets to the dispatch loop the next time around.
		 */
		*ucsr0 =  CM_UCC0_RUN | CM_UCC0_TS_SUSPEND;
		TRACEPC(cms, "After setting suspend");

		/*
		 * Now we wait to see the UCC respond with a '2' in UCC reg0
		 * indicating that the context switch request has been
		 * acknowledged.
		 * We wait for up to "SuspendTimeout" seconds before giving up.
		 */
		SuspendTimeout = InitialSuspendTimeout * hz;
		while (SuspendTimeout > 0 ) {

		    /*
		     * Check UCSR0 timesharing bit to see if 
		     * suspend has been acknowledged.  Check twice
		     * as this bit is constantly changing.
		     */
		    ucstatus = *ucsr0;
		    switched = (((ucstatus & CM_UCC0_TS_UC_TO_HOST_MASK)
				 == CM_UCC0_TS_SUSPENDING) &&
				(ucstatus == *ucsr0) &&
				((ucc_pc = *uccsa & 0x3ffff)
				 <= cms->cms_tsinfo.high_cx_pc) &&
				(ucc_pc >= cms->cms_tsinfo.low_cx_pc));
		    if (switched) {
			/*
			 * Looks like the UCC is cooperating.
			 * Just to make sure, stop it and check.
			 */
			*ucsr0 = CM_UCC0_TS_SUSPEND|CM_UCC0_WCS_REG_CNTL;
			/* Wait for it to stop */
			CDELAY(((*ucsr0 & CM_UCC0_RUN) == 0), SuspendTimeout);
			if (*ucsr0 & CM_UCC0_RUN) {
			    /* UCC never halted.  Error */
			    SuspendTimeout = 0;
			    break;
			}
			/*
			 * UCC has stopped.  Read ucstatus and upc
			 */
			ucstatus = *ucsr0;
			ucc_pc = *uccsa & 0x3ffff;
			/*
			 * Continue the UCC.
			 */
			*ucsr0 =  CM_UCC0_RUN | CM_UCC0_TS_SUSPEND;
		    
			/*
			 * We wait until the UCC has reached DRAIN state.
			 */ 
			switched = ((ucc_pc <= cms->cms_tsinfo.high_cx_pc) &&
				    (ucc_pc >= cms->cms_tsinfo.low_cx_pc) &&
				    ((ucstatus & CM_UCC0_TS_UC_TO_HOST_MASK)
				     == CM_UCC0_TS_SUSPENDING));
			if (!switched) {
			    printf("cm: false switched indication: ucsr0 0x%x, upc 0x%x\n",
				   ucstatus, ucc_pc);
			}
		    }

		    if (CM_ERROR(cms)) {
			if (cm_verbose || cm_debug) {
			    printf("suspend: error caused by context switch\n");
			    printf(" upc=0x%x; ucstatus = %b\n", 
				   ucc_pc, ucstatus, UC_REG0_BITS_WITH_FLAGS);
			}
			cmp->cmp_udata.ud_state |= US_CM_ERROR;
			break;
		    } 

		    if (switched)
			break;

		    if (cm_debug && ((SuspendTimeout % hz) == 0))
			printf("SUSPEND: waiting, ucsr0 = 0x%x, upc = 0x%x\n", 
			       ucstatus, ucc_pc);

		    SuspendTimeout -= 10;
		    timeout(FastCMIdleTimer, 0, 10);
		    sleep(FastCMIdleTimer, CMPRI);
		    if (cmp != cms->cms_active)
			/* 
			 * The guy we're trying to suspend must have died
			 * and been disconnected.  Tell the ts-daemon so.
			 */
			return (ESRCH);

		    if (CM_ERROR(cms)) {
			if (cm_verbose || cm_debug)
			    printf("suspend: error caused by process\n");
			cmp->cmp_udata.ud_state |= US_CM_ERROR;
			break;
		    } 
		    ReprotectNexus(cms);
		}

		TRACEPC(cms, "Suspended");
		if (SuspendTimeout <= 0) {
		    /* 
		     * Current process won't cooperate.
		     * Inform the ts-daemon, and nuke the
		     * guy so the TS can move on to the next process.
		     */
		    if (cm_verbose) {
			printf("SUSPEND (proc %d, %d): timed out.\n",
			       cmp->cmp_pid, InitialSuspendTimeout);
			printf("       ucsr0 %b\n",
			       cms->cms_regs->cm_ucsr0, UC_REG0_BITS_WITH_FLAGS);
			DUMPPCS();
		    }
		    cms->cms_active = NULL;
		    cmp->cmp_udata.ud_state |= US_CM_ERROR;
		    cm_unmap(cmp);
		    wakeup (&cmp->cmp_udata.ud_state);
		    if (cmp->cmp_events & SELWAIT) {
			cmp->cmp_events &= ~SELWAIT;
			selwakeup(cmp->cmp_procp, 0);
		    }
		    return (ETIMEDOUT);	/* Fatal error */
		}

		/*
		 * UCC has started context switch. 
		 * 
		 * Now we stop the current process.
		 * It will block in the pagefault handler the
		 * next time it trys to touch the CM.
		 */
		cms->cms_active = NULL;
		cm_unmap(cmp);
		

		if (cmp->cmp_udata.ud_state & US_CM_ERROR) {
		    if (cm_verbose || cm_debug) {
			printf("SUSPEND (%d) error flagged: %b\n",
			       cmp->cmp_pid, cms->cms_regs->cm_csr, CM_CSR_BITS);
			printf("       hstat %b\n", 
			       cms->cms_regs->cm_hstat, CM_HSTAT_BITS);
			printf("       ucsr0 %b\n",
			       cms->cms_regs->cm_ucsr0, UC_REG0_BITS_WITH_FLAGS);
			DUMPPCS();
		    }
		    cmp->cmp_udata.ud_state |= US_CM_ERROR;
		    drainFifoqueue(&cmp->cmp_ofifo_data);
		    drainFifoqueue(&cmp->cmp_ififo_data);
		    wakeup (&cmp->cmp_udata.ud_state);
		    return(EIO); /* Let TS daemon deal with error */
		}

		/*
		 * Here is the interesting part.  We save the IFIFO and OFIFO
		 * data for when we restart, doing a complex dance with the
		 * sequencer in order to do so.
		 * Make sure we don't have any stale FIFO crud left around.
		 */
		drainFifoqueue(&cmp->cmp_ofifo_data);
		drainFifoqueue(&cmp->cmp_ififo_data);

		/*
		 * UCC has stopped to allow us to suck out OFIFO data. 
		 * Save the processes OFIFO data, we'll stuff it back in
		 * on restart.
		 */
		switched = 0;
		for (i = 0; !switched && (i < 1000); i++) {
		    if ( DrainOutputFifo(cms, cmp) == FALSE)
			panic("CM Output fifoqueue exhausted");
		    switched = ((*hs & HS_OF_RDY) == 0);
		}

		TRACEPC(cms, "After drain OFIFO");
		if (!switched) {
		    printf("CM SUSPEND: proc %d context switch error 0\n\tUCSR0=%b\n",
			   cmp->cmp_pid, ucstatus, UC_REG0_BITS_WITH_FLAGS);
		    printf("\tofifo saved = %d\n",
			   cmp->cmp_ofifo_data.fq_length);
		    DUMPPCS();
		    cmp->cmp_udata.ud_state |= US_CM_ERROR;
		    wakeup (&cmp->cmp_udata.ud_state);
		    return(EBUSY);
		}

		if (cm_debug && (cmp->cmp_ofifo_data.fq_length > 0))
		    printf("SUSPEND: Saved %d words from ofifo\n", 
			   cmp->cmp_ofifo_data.fq_length);

		/*
		 * Tell the UCC to go to the next step.  
		 */
		*ucsr0 = CM_UCC0_RUN | CM_UCC0_TS_FIFO_LOOP;
		DELAY(10);

		/*
		 * Now wait for the UCC to move on,
		 * sucking out any OFIFO stuff as we go.
		 */
		switched = 0;
		for (i = 0; !switched && (i < 1000); i++) {
		    if ( DrainInputFifo(cms, cmp) == FALSE)
			panic("CM input fifoqueue exhausted");
		    hstat = *hs;
		    switched = (((*ucsr0 & CM_UCC0_TS_UC_TO_HOST_MASK)
				 == CM_UCC0_TS_LOOPING) &&
				((hstat & HS_OFOR) == 0) &&
				(hstat & HS_IFMT));
		}
		TRACEPC(cms, "After drain IFIFO");
		if (!switched) {
		    printf("CM SUSPEND: proc %d cxsw error 1\n\tUCSR0=%b\n\tHSTAT=%b\n",
			   cmp->cmp_pid, 
			   *ucsr0, UC_REG0_BITS_WITH_FLAGS,
			   *hs, CM_HSTAT_BITS);
		    printf("\tofifo saved = %d, ififo saved = %d\n",
			   cmp->cmp_ofifo_data.fq_length,
			   cmp->cmp_ififo_data.fq_length);
		    DUMPPCS();
		    cmp->cmp_udata.ud_state |= US_CM_ERROR;
		    wakeup (&cmp->cmp_udata.ud_state);
		    return(EBUSY);
		}

		if (cm_debug && (cmp->cmp_ififo_data.fq_length > 0))
		    printf("SUSPEND: Saved %d words from ififo\n", 
			   cmp->cmp_ififo_data.fq_length);

		/* 
		 * Once all data is drained, tell the UCC to go on to the dispatch loop.
		 * Wait around a bit to make sure it does so.
		 */
		*ucsr0 = CM_UCC0_RUN;
		switched = 0;
		for (i = 0; !switched && (i < 100); i++) {
		    ucstatus = *ucsr0;
		    switched = ((ucstatus & CM_UCC0_TS_UC_TO_HOST_MASK)
				== CM_UCC0_TS_IDLE);
		}

		TRACEPC(cms, "End");
		if (!switched) {
		    printf("CM SUSPEND: proc %d cxsw error 2\n\tUCSR0=%b\n\tHSTAT=%b\n",
			   cmp->cmp_pid, 
			   ucstatus, UC_REG0_BITS_WITH_FLAGS,
			   *hs, CM_HSTAT_BITS);
		    printf("\tififo saved = %d, ofifo saved = %d\n",
			   cmp->cmp_ififo_data.fq_length,
			   cmp->cmp_ofifo_data.fq_length);
		    DUMPPCS();
		    cmp->cmp_udata.ud_state |= US_CM_ERROR;
		    wakeup (&cmp->cmp_udata.ud_state);
		    return (EBUSY); /* XXX something is hosed! */
		}

		if (cm_debug) {
		    printf("proc %d suspended.\n", cmp->cmp_pid);
		    DUMPPCS();
		}

		RestoreNexus(cms);
		if (cmp->cmp_ififo_data.fq_length > max_if_len)
		    max_if_len = cmp->cmp_ififo_data.fq_length;
		if (cmp->cmp_ofifo_data.fq_length > max_of_len)
		    max_of_len = cmp->cmp_ofifo_data.fq_length;
		
	    } else
#endif sun
		{
		    int i, idle, empty;

		    /*
		     * Original context switch mechanism, for processes 
		     * using the VFIFO.
		     * 
		     * Stop the current process from starting any more
		     * transfers (by setting active to NULL), and wait for
		     * any transfer in progress to complete
		     */

		    if (cm_debug) 
			printf("SUSPEND %d (vfifo), timeout %d\n",
			       cmp->cmp_pid, SuspendTimeout);

		    cms->cms_active = NULL;

		    while (cmp->cmp_udata.ud_state & (US_READING|US_WRITING)) {
			if (AwaitEvent(cms, cms->cms_daemon,  
				       XFERCOMPLETE|TIMEOUT, SuspendTimeout)
			    == TIMEOUT)
			    return ETIMEDOUT;
		    }
		    /*
		     * Empty OFIFO and wait for the sequencer to be IDLE (i.e.
		     * DISPATCH bit on) 
		     */

		    for (idle = FALSE;
			 ((SuspendTimeout > 0) && (!idle));
			 SuspendTimeout--) {

			ProtectNexus(cms) {
			    /*
			     * Note the use of CM_IDLE.
			     * 
			     * This reads the CM UCC status register.
			     * This is in general OK here since we know
			     * that it will be readable, since
			     *	(a), we're attached 
			     *  (b), the sequencer is basically happy,
			     *  and
			     *  (c), we're between PARIS instructions, so
			     *       the UCC chip select will be OK.
			     */

			    empty = DrainOutputFifo(cms, cmp);
			    ReprotectNexus(cms);
			    for (i = 0;
				 (i < 1000) && !(idle = CM_IDLE(cms));
				 i++)
			    {;}
			    /*
			     * avoid the following race condition:
			     *
			     * DrainOutputFifo empties the output fifo
			     * and returns.  The CM puts more stuff on
			     * the output fifo, then goes idle.  The test
			     * CM_IDLE succeeds.
			     *
			     * This makes it look like the process left
			     * junk in the OFIFO (a fifo protocol
			     * violation), when in fact the process was
			     * perfectly well-behaved. 
			     */
			    if(idle) empty = DrainOutputFifo(cms, cmp);
			}
			RestoreNexus(cms);

			/*
			 * If there's not enough room to store all the
			 * OFIFO, try restarting the client process and
			 * hope that he issues another read. Return to the
			 * timesharing daemon (with EWOULDBLOCK) so that
			 * he can field any direct requests from the
			 * client process (e.g. memory allocation). 
			 */

			if (!empty) {
			    cms->cms_active = cmp;
			    wakeup (&cmp->cmp_udata.ud_state);
			    return (EWOULDBLOCK);
			}

			if (!idle)
			    AwaitEvent (cms, cms->cms_daemon, TIMEOUT, 1);

			if (cmp->cmp_procp == NULL
			    || (cmp->cmp_procp->p_pid != cmp->cmp_pid))
			    /* 
			     * The guy we're trying to suspend must have died
			     * and been disconnected.  Tell the ts-daemon so.
			     */
			    return (ESRCH);
		    } 

		    if (cmp && CM_ERROR(cms))
			cmp->cmp_udata.ud_state |= US_CM_ERROR;

		    if (SuspendTimeout == 0) 
			return (ETIMEDOUT);

		    if (cm_debug)
			printf("SUSPENDED %d\n", cmp->cmp_pid);
		}

	    cmp->cmp_kacct->acct.suspends++;
	    /*
	     * whew, process suspended.  Charge it for time used.
	     */
	    BusyTicks(cmp, cms);
	    break;
	}

      case CM_SUSPEND_TIMESHARING:
      {
	  CM_STATE *cms;
	  int s;
	  CM_PROC *prev;
	  CM_PROC *next;

	  if(cmp == NULL) return ENOTCONN;

	  cms = cmp->cmp_owner->cmp_interface;

	  if(cms == NULL
	     || (cms->cms_daemon == NULL)
	     || (cms->cms_daemon->cmp_pid != u.u_procp->p_pid))
	    return (EPERM);

	  /*
	   * The interrupt handler uses this chain to find processes that
	   * need to be woken up, therefore, prevent interrupts from
	   * finding the chain in an inconsistent state.
	   */
	  s = splcm(cms);
	  
	  /*
	   * We are going to delink every process that is attached to our
	   * interface. 
	   */
	  AcquireProcessLock("ioctl CM_SUSPEND_TIMESHARING");
	  for(cmp = cm_procs, prev = NULL;
	      cmp != NULL;
	      cmp = next) {
	      
	      next = cmp->cmp_sibling;

	      if(cmp->cmp_interface != NULL && cmp->cmp_interface == cms) {
		  /*
		   * Need we delink the first one?
		   */
		  if(cm_procs == cmp)
		    cm_procs = cmp->cmp_sibling;
		  else {
		      /*
		       * Find the predecessor for the fellow to be delinked.
		       */
		      for(prev = cm_procs;
			  prev != NULL && prev->cmp_sibling != cmp;
			  prev = prev->cmp_sibling)
		      {;}
		      
		      if(prev == NULL || prev->cmp_sibling != cmp){
			  splx(s);
			  return ESRCH;
		      }
		      
		      prev->cmp_sibling = cmp->cmp_owner->cmp_sibling;
		  }
		  /*
		   * Now link the suspended process into the suspended
		   * process list.
		   */
		  cmp->cmp_sibling = cm_suspended_procs;
		  cm_suspended_procs = cmp;
	      }
	      else prev = cmp;
	  }
	  ReleaseProcessLock("ioctl CM_SUSPEND_TIMESHARING");

	  splx(s);
	  cms->cms_flags &= ~CMS_SHARED;
	  CheckInterfaces();
	  break;
      }

      case CM_GET_TSINFO:
	if (cms == NULL) 
	  return (ENOTCONN);
	
	*(CM_TSINFO *)data = cms->cms_tsinfo;
	break;

      case CM_SET_TSINFO:
	if (cms == NULL) 
	  return (ENOTCONN);
	
	cms->cms_tsinfo = *(CM_TSINFO *)data;
	break;
	
      case CM_WAIT_FOR_CM:
	/*
	 * Wait to become the active process
	 */
	if (!ExclusiveAccess(dev) && (cmp != cms->cms_daemon)) {
	    while (cms->cms_active != cmp) {
		/*o
		 * Error pending?
		 */
		if (cmp->cmp_udata.ud_state & US_CM_ERROR) {
		    cmp->cmp_udata.ud_state &= ~US_BLOCKED;
		    return (EIO);
		}
		/*
		 * Disconnected?
		 */
		if (cmp->cmp_udata.ud_state & US_DISCONNECTED) {
		    cmp->cmp_udata.ud_state &= ~US_BLOCKED;
		    return (ENOTCONN);
		}

		/* Tell the TS daemon he has work to do */
		if ((cmp->cmp_udata.ud_state & US_BLOCKED) == 0) {
		    cmp->cmp_udata.ud_state |= US_BLOCKED;
		    selwakeup(cms->cms_daemon->cmp_procp, 0);
		}

		if (sleep (&cmp->cmp_udata.ud_state, (PCATCH | CMPRI)) != 0) {
		    cmp->cmp_udata.ud_state &= ~US_BLOCKED;
		    return(EINTR);
		}
	    }
	    cmp->cmp_udata.ud_state &= ~US_BLOCKED;
	}
	break;

      default:
	return (EOPNOTSUPP);
    }

    return (0);
}/* cmioctl_helper */

/*
 * select can't return errors (just returns a boolean!)
 * If there's an error, it must set u.u_error and return
 */
int
cmselect(dev, rw)
    dev_t dev;
    int   rw;
{
    register int retval;
    in_cm_code++;
    retval = cmselect_helper(dev, rw);
    in_cm_code--;
    return retval;
}

int
cmselect_helper(dev, rw)
    dev_t dev;
    int   rw;
{
    register CM_STATE *cms;
    register CM_PROC  *cmp;
    int event;
    int unit;

    if ((cmp = GetProcess(u.u_procp->p_pid, dev, ACTIVE_OR_SUSPENDED))
	 == NULL) {
	u.u_error = EPERM;
	return (0);
    }

    /*
     * Select by accounting daemon simply tests availability of 
     * accounting data.
     */
    if (cmp == cm_accounting_daemon) {
	if (cm_accounting_queue_hd != NULL) 
	    return 1;
	return (0);
    }

    if (CM_DIAG(dev)) 
	unit = CM_UNIT(dev);
    else 
	unit = cmp->cmp_udata.ud_intf;
    cms = (unit == -1) ? NULL : &(cm_state[unit]);

    if (cms == NULL) {
	/*printf("cm driver: proc %d has no cms in select??\n", cmp->cmp_pid);*/
	u.u_error = EIO;
	return (0);
    }

    if (cmp->cmp_udata.ud_state & US_DISCONNECTED) {
	u.u_error = ENOTCONN;
	return (0);
    }

    if ((cmp == cms->cms_daemon) &&
	(cms->cms_tsinfo.ucode_version >= 6102)) {
	/*
	 * Different semantics for select by ts-daemon.
	 * Select for write means check if someone is blocked
	 * waiting for the CM.
	 */

	if (rw == FWRITE) {
	    CM_PROC *p;
	    for ALL_PROCESSES_ON_INTERFACE(cms, p) {
		if (p->cmp_udata.ud_state & US_BLOCKED)
		    return(1);
	    }
	    return(0);
	}
    }

    if (!ExclusiveAccess(dev) && (cmp != cms->cms_daemon)) {
	/*
	 * Timesharing client. 
	 * First check for pending error.
	 */
	if (cmp->cmp_udata.ud_state & US_CM_ERROR) {
	    if (rw != FREAD && rw != FWRITE) {
		return (1);
	    } 
	    u.u_error = EIO;
	    return (0);
	}
	if (cms->cms_active != cmp) {
	    /* 
	     * Timesharing client not the active process.  
	     * Tell them to wait before calling this.
	     * We can't do the wait here since he may have a timer running.
	     */
	    u.u_error = EBUSY;
	    return (0);
	}
	/*
	 * Fall through only for active timesharing process 
	 * with no error pending.
	 */
    }

    cmselectcalls++;

    switch (rw) {
      case FREAD:
	if(cmp->cmp_kacct)
	  cmp->cmp_kacct->acct.read_selects++;
	event = OFIFO_READY;
	break;
      case FWRITE:
	if(cmp->cmp_kacct)
	  cmp->cmp_kacct->acct.write_selects++;
	event = IFIFO_READY;
	break;
      default:
	if(cmp->cmp_kacct)
	  cmp->cmp_kacct->acct.exception_selects++;
	event = EXCEPTION;
	break;
    }

    if (CheckEvent(cms, event)) {
	/* Event already occurred, no need to wait for it */
	cmp->cmp_events &= ~event;
	return (1);
    } else {
	/* Event hasn't occurred, need to wait */
	cmp->cmp_events |= (event | SELWAIT);
	EnableEventInterrupt(cms, event);
	return (0);
    }
}/* cmselect */

/*
 * Reset any nexus error on this interface.
 */
static void
reset_nexus(cms)
CM_STATE *cms;
{
    unsigned long r3;
    
    r3 = rnr123(cms, 3, TRUE);
    
    r3 &= (DIS_HBUS_0_EXCP|DIS_HBUS_1_EXCP|DIS_HBUS_2_EXCP|DIS_HBUS_2_EXCP) |
	CLOCK_CTRL_MASK;

    switch (cms->cms_host) {
      case 0:
	r3 |= RST_HBUS_0_PERR;
	break;
      case 1:
	r3 |= RST_HBUS_1_PERR;
	break;
      case 2:
	r3 |= RST_HBUS_2_PERR;
	break;
      case 3:
	r3 |= RST_HBUS_3_PERR;
	break;
    }
    wnr123(cms, 3, r3, FALSE);
}

/*
 * Machine dependent routines. Specific versions for the Sun and Vax
 * machines. 
 */

#ifdef sun

/*
 * Read the nexus status register.
 * Returns -1 if we get an HBUS timeout doing so.
 * *WARNING*: side effect may alter IC bits.
 */
private long
cm_read_nexstat(cms) 
    CM_STATE *cms;
{
    register long nexstat;
    register int *csr = &cms->cms_regs->cm_csr;
    int old_csr = *csr;	/* Save old interrupt enables */
    int s = splcm(cms);


    *csr = CM_CSR_INIT | CM_IC_BITS;
    nexstat = ((cms)->cms_regs->cm_nsrl);

    if (FEBI_ERROR(cms)) {
	nexstat = -1;
	if (cm_debug)
	    printf("cm%d: febi error, CSR %X; old %X\n", 
		   cms->cms_interface, cms->cms_regs->cm_csr, old_csr);
    }
    
    *csr = old_csr;

    if (nexstat != -1) cms->cms_host = NEXUS_R0_HOST_ID(nexstat);

    splx(s);
    return (nexstat);
}


/*
 * CMPROBE
 *   "Probe" routine. Called once for each interface. 
 *    Determine if the device is really there.
 */

/*ARGSUSED*/
cmprobe(regs, ctlr)
     register CM_REGS *regs;
     register int ctlr;
{
	int result;
    return ((peekl(regs,&result) == -1) ? 0 : sizeof(CM_REGS));
}


/*
 * CMATTACH
 * Called once for each unit.
 * 
 */
cmattach(md)
    struct mb_device *md;
{
    int		unit    = md->md_unit;
    CM_REGS	*cmregs = (CM_REGS *)md->md_addr;
    CM_STATE	*cms;

    InitQueues();

    cms = &(cm_state[unit]);

    cms->cms_flags   = CMS_AVAIL;
    cms->cms_regs    = cmregs;
    cms->cms_intpri  = md->md_intpri;

    cms->cms_daemon  = NULL;
    cms->cms_active  = NULL;
    BusyTicks(NULL, cms);
    cms->cms_intr_proc = NULL;
    cms->cms_interface = unit;
    cms->cms_proc_locking_nexus = NULL;

    cmreset(unit);

    UCCSet_Free(cms);
} /* cmattach */


/*ARGSUSED*/
cmmmap(dev, off, protection)
    dev_t dev;
    off_t off;
    int   protection;
{
    CM_PROC *cmp;
    int unit = -1;

    in_cm_code++;
    cmp = GetProcess(u.u_procp->p_pid, dev, ACTIVE_ONLY);
    if (CM_DIAG(dev))
	unit = CM_UNIT(dev);
    else if (cmp != NULL)
	unit = cmp->cmp_udata.ud_intf;

    if (unit == -1 || unit > NCM) {
	in_cm_code--;
	return (-1);
    }

    if (ExclusiveAccess(dev) && (off < sizeof(CM_REGS))) {
	in_cm_code--;
	return (hat_getkpfnum(cminfo[unit]->md_addr + off));
    }
    in_cm_code--;
    return (-1);

};

/*
 * reset the VMEFEBI card
 */

cmreset(unit)
    int unit;
{
    register struct mb_device *md;
    int nstat;
    int result;

    CM_STATE *cms = &cm_state[unit];
    register CM_REGS *cm;
    int pri;

    md = cminfo[unit];
    cm = (CM_REGS *)md->md_addr;

    pri = splcm(&cm_state[unit]);
	
    if (peekl(&cm->cm_csr, &result) == -1) {
	printf("cmreset cm%d board went away!\n", unit);
	(void) splx(pri);
	return;
    }

    cm->cm_csr = 0;		/* Disable board */
    cm->cm_csr = CM_BRESET;
    cm->cm_csr = cm->cm_csr;	/* reset error bits */
    cm->cm_vec = md->md_intr->v_vec; /* set up interrupt vector */

    cm->cm_data = 0;		/* clear hbus data latch */

    cm->cm_csr = CM_CSR_INIT;

    /*
     * cms->cms_host is our NEXUS host port. 
     * ONLY update it here.  If the CM is powered off or our host
     * port is changed, someone must do a cmreset() to get the
     * new host port ID.
     */
    nstat = cm_read_nexstat(cms);
    if (NEXUS_R0_CANT_READ(nstat)) {
	printf("cm%d: CM powered off or disconnected?\n", unit);
	cms->cms_host = -1;
    } else {
	cms->cms_host = NEXUS_R0_HOST_ID(nstat);
	if (nstat & NEXUS_R0_CHANNEL_ERROR)
	    reset_nexus(cms);
    }

    (void) splx(pri);
    return;
}

/*
 * Interrupt Handler.
 */
int
cmintr(unit)
{
    register CM_STATE *cms;
    register int csr, hstat;
    int s;

    s = splhigh();
    At_Interrupt_Level++;
    splx(s);

    cms = &cm_state[unit];

    csr   = cms->cms_regs->cm_csr;
    hstat = cms->cms_regs->cm_hstat;

    if (cms->cms_intr_proc != NULL) {
	cms->cms_regs->cm_csr = csr & ~(CM_IC_BITS | CM_IE);
	psignal(cms->cms_intr_proc, SIGUSR1);

    } else {
	if ((hstat & (HS_CMEX|HS_HERROR)) ||
	    (csr & (CM_IC_CMEX | CM_IC_PARERR))) {
	    SignalEvent (cms, EXCEPTION);
	    csr &= ~(CM_IE_CMEX | CM_IE_PARERR);
	}

	if (hstat & HS_OFOR) {
	    SignalEvent (cms, OFIFO_READY);
	    csr &= ~CM_IE_OFOR;
	}

	if (hstat & HS_IFIR) {
	    SignalEvent (cms, IFIFO_READY);
	    csr &= ~(CM_IE_IFIR | CM_IE_IFMT);
	}

	if (hstat & HS_IF_RDY) {
	    cms->cms_iwords = (hstat & HS_IFMT) ? 510 : 250;
	}

	/* Clear the interrupt. */
	cms->cms_regs->cm_csr = csr;
    }

    s = splhigh();
    At_Interrupt_Level--;
    splx(s);
}

int cm_busyloop = 50;


/*
 * return value indicates whether need to wait for the event
 *
 *   0 - need to wait for event, otherwise the event that has already
 *       occurred.
 *   
 */

int
CheckEvent (cms, events)
    CM_STATE	*cms;
    long	events;
{
    register CM_REGS *regs   = cms->cms_regs;
    int i;

    if (events & IFIFO_READY)
	for (i = 0; i < cm_busyloop; i++)
	    if (regs->cm_hstat & HS_IFIR) {
		if (regs->cm_hstat & HS_IF_RDY)
		    cms->cms_iwords = (regs->cm_hstat & HS_IFMT) ? 510 : 250;
		return (IFIFO_READY);
	    }

    if (events & OFIFO_READY)
	for (i = 0; i < cm_busyloop; i++)
	    if (CM_OFIFO_READY(cms))
		return (OFIFO_READY);

    if (events & EXCEPTION)
	if (regs->cm_hstat & HS_CMEX)
	    return (EXCEPTION);	

    return (0);
}

EnableEventInterrupt (cms, events)
    CM_STATE	*cms;
    long	events;
{
    register CM_REGS *regs   = cms->cms_regs;
    long csr1 = 0;
    long csr2 = 0;

    if (events & IFIFO_READY) {
	csr1 |= (CM_IC_IFIR);
	csr2 |= (CM_IE_IFIR | CM_IE);
    }

    if (events & OFIFO_READY) {
	csr1 |= (CM_IC_OFOR);
	csr2 |= (CM_IE_OFOR | CM_IE);
    }

    if (events & EXCEPTION) {
	csr1 |= (CM_IC_CMEX | CM_IC_PARERR);
	csr2 |= (CM_IE_CMEX | CM_IE_PARERR | CM_IE);
    }

    regs->cm_csr |= csr1;
    regs->cm_csr |= csr2;

}


/*
 * CM MMAP routines
 * In exclusive mode, or for the diagnostic device, the real registers 
 * can be mapped.
 * 
 * In timeshared mode, only the FIFO can be mapped read/write, the
 * other registers are read only.
 * 
 * We keep a struct seg pointer around for each interface, which is the guy
 * who currently has the interface mapped.  When we invalidate is segment,
 * our own fault handler will be called on next page access.
 */ 

#define UCFIFO_OFFSET ((u_int)&((CM_REGS *)0)->cm_ucfifo)
#define UCFIFO(unit) (cmstate[unit]->cms_regs + UCFIFO_OFFSET)


/*
 * Called from SUSPEND ioctl to unmap the fifo from a process being
 * suspended. 
 */
int
cm_unmap(cmp)
CM_PROC *cmp;
{
    register struct segcm_data *sdp;
    register struct seg *seg;
    struct ctx *ctxsav;

    if (cmp->cmp_sdp == NULL)
	return -1;

    /*
     * hat_unload() will set the current context to that of the
     * guy we're unmapping, (via hat_setup()), and not put it back.  
     * We need to save the current context and restore it when we're done.
     */
    ctxsav = mmu_getctx();
    for (sdp = cmp->cmp_sdp; sdp ; sdp = sdp->next) {
	seg = sdp->seg;
	if (cm_debug)
	    printf("cm_unmap: proc %d (0x%x,0x%x)\n",
		   cmp->cmp_pid, seg->s_base, seg->s_size);
	hat_unload(seg, seg->s_base, seg->s_size);
    }
    mmu_setctx(ctxsav);

    return (0);
}



int segcm_create();

/*
 * This routine is called when the CM device is mmap'ed
 * maxprot is maximum allowable protection, from filesystem and
 * user identity.  prot is what the user asked for in the mmap() call.
 */
int
cmsegmap(dev, off, as, addrp, len, prot, maxprot, flags, cred)
	dev_t dev;
	u_int off;
	struct as *as;
	addr_t *addrp;
	u_int len;
	u_int prot, maxprot;
	u_int flags;
	struct ucred *cred;
{
    struct segcm_crargs dev_a;
    CM_PROC *cmp = GetProcess(u.u_procp->p_pid, dev, ACTIVE_ONLY);
    int Exclusive = ExclusiveAccess(dev);
    int unit, ret;
    CM_STATE *cms;

    /*
     * MAP_SHARED is the old style stuff.
     * Just use the old mmap() interface.
     */

    if ((flags & MAP_TYPE) == MAP_SHARED) {
	if (Exclusive)
	    return (spec_segmap(dev, off, as, addrp, 
				len, prot, maxprot, flags, cred));	
	else
	    return(EPERM);	/* No shared mapping in timeshared mode */
    }
    
    if (cm_debug){
	printf("cmsegmap dev=%x off=%x as=0x%x *addrp=0x%x\n",
	       dev, off, as, *addrp);
	printf("         len=%x prot=%x maxprot=%x flags=%x cred=0x%x\n",
	       len, prot, maxprot, flags, cred);
    }

    /*
     * Must be MAP_PRIVATE.
     */
    if ((flags & MAP_TYPE) != MAP_PRIVATE) 
	return(EINVAL);

    /* Must have a process! */
    if (cmp == NULLPROC)
	return(ESRCH);

    /* Must be connected */
    unit = cmp->cmp_udata.ud_intf;
    if (unit < 0)
	return(ENOTCONN);

    cms = &cm_state[unit];

    /* Must be running right microcode */
    if (cms->cms_tsinfo.ucode_version < 6100)
	return (EOPNOTSUPP);

    /* Can't go off the end */
    if (off + len > sizeof (CM_REGS))
	return(EINVAL);

    /* If shared, can only map FIFO page read/write, others must be r/o */
    if (!Exclusive) {
	if ((prot & PROT_WRITE) && (off < UCFIFO_OFFSET))
	    return(EPERM);
    }

    if ((flags & MAP_FIXED) == 0) {
	/*
	 * Pick an address w/o worrying about
	 * any vac alignment contraints.
	 */
	map_addr(addrp, len, (off_t)off, 0);
	if (*addrp == NULL)
	    return (ENOMEM);
    } else {
	/*
	 * User specified address -
	 * Blow away any previous mappings.
	 */
	(void) as_unmap(as, *addrp, len);
    }

    dev_a.dev = dev;
    dev_a.cmproc = cmp;
    dev_a.off = off;
    dev_a.len = len;
    dev_a.prot = prot;

    ret = as_map(as, *addrp, len, segcm_create, (caddr_t)&dev_a);

    return (ret);
	
}

/*
 * CM interface Page Management
 */

static	int segcm_dup(/* seg, newsegp */);
static	int segcm_unmap(/* seg, addr, len */);
static	int segcm_free(/* seg */);
static	faultcode_t segcm_fault(/* seg, addr, len, type, rw */);
static	int segcm_checkprot(/* seg, addr, size, prot */);
static	int segcm_badop();
static  int segcm_incore();

struct	seg_ops segcm_ops =  {
	segcm_dup,	/* dup */
	segcm_unmap,	/* unmap */
	segcm_free,	/* free */
	segcm_fault,	/* fault */
	segcm_badop,	/* faulta */
	segcm_badop,	/* unload */
	segcm_badop,	/* setprot */
	segcm_checkprot, /* checkprot */
	segcm_badop,	/* kluster */
	(u_int (*)()) NULL,	/* swapout */
	segcm_badop,	/* sync */
	segcm_incore	/* incore */
};



/*
 * Create a segment.
 */
static
segcm_create(seg, argsp)
	struct seg *seg;
	caddr_t argsp;
{
	register struct segcm_data *dp;

	dp = (struct segcm_data *)
		new_kmem_zalloc(sizeof (struct segcm_data), KMEM_SLEEP);
	*dp = *((struct segcm_crargs *)argsp);

	seg->s_ops = &segcm_ops;
	seg->s_data = (char *)dp;

	dp->seg = seg;

	if (dp->cmproc) {
	    /*
	     * Keep track of the segments mapping the FEBI we've allocated.
	     */
	    dp->prev = NULL;
	    dp->next = dp->cmproc->cmp_sdp;
	    if (dp->cmproc->cmp_sdp)
		dp->cmproc->cmp_sdp->prev = dp;
	    dp->cmproc->cmp_sdp = dp; 
	    dp->cmproc->cmp_nseg++;
	    if (cm_debug)
		printf("segcm_create: proc %d, seg %d; base 0x%x, len 0x%x\n",
		       dp->cmproc->cmp_pid, dp->cmproc->cmp_nseg,
		       dp->seg->s_base, dp->seg->s_size);
	}

	return (0);
}

/*
 * Duplicate seg and return new segment in newsegp.
 * Called from fork() in context of PARENT, we have no idea who the
 * child will be.  
 * 
 * We don't allow the child process to get at the registers.  Period.
 */
static
segcm_dup(seg, newseg)
	struct seg *seg, *newseg;
{
	struct segcm_data sd;

	sd = *(struct segcm_data *)seg->s_data; /* Copy */

	/* Create a new segment with no mapping */
	sd.cmproc = NULLPROC;
	sd.off = 0;
	sd.len = 0;

	(void) segcm_create(newseg, (caddr_t)&sd);

	return (0);
}

/*
 * Allow unmapping of whole segment only.
 * We can probably use this information to tell that someone doesn't want
 * to use the CM anymore.
 */
static
segcm_unmap(seg, addr, len)
	register struct seg *seg;
	register addr_t addr;
	u_int len;
{
	/*
	 * Check for entire segment
	 */
	if (addr != seg->s_base || len != seg->s_size) {
		return (-1);
	}
	seg_free(seg);
	return (0);
}

/*
 * free a cm segment.  This means that this guy doesn't want to use the CM
 * anymore, we may be able to use this fact elsewhere (but not presently)
 */
static
segcm_free(seg)
    struct seg *seg;
{
    register struct segcm_data *sdp = (struct segcm_data *)seg->s_data;

    if (sdp->cmproc) {
	register struct segcm_data *dp;
	for (dp = sdp->cmproc->cmp_sdp; dp && dp != sdp; dp = dp->next)
	{;}
	if (dp == NULL) {
	    if(cm_debug) {
		printf("segcm_free: Segment not attached to CM proc structure!\n");
		printf("            seg: %X; sdp: %X; sdp->cmproc: %X; nseg: %d\n",
		       seg, sdp, sdp->cmproc, sdp->cmproc->cmp_nseg);
		for(dp = sdp->cmproc->cmp_sdp; dp && dp != sdp; dp = dp->next)
		  printf("            dp: %X\n", dp);
	    }

	    /* panic("Segment not attached to CM proc structure!"); */
	}
	else {
	    if (dp == sdp->cmproc->cmp_sdp)
	      sdp->cmproc->cmp_sdp = dp->next;

	    if (dp->next)
	      dp->next->prev = dp->prev;
	    if (dp->prev)
	      dp->prev->next = dp->next;
	    
	    sdp->cmproc->cmp_nseg--;
	}

	if (cm_debug)
	    printf("segcm_free: CM process (%d) seg 0x%x deleted, %d left \n",
		   sdp->cmproc->cmp_pid, seg, sdp->cmproc->cmp_nseg);
    }

    kmfree((char *)sdp, sizeof (*sdp));
}

/*
 * Handle a fault on the FEBI registers.
 * Only one valid mapping at a time is allowed.  If we're not the current
 * process for this interface, block until we are before servicing the fault.
 */

static char  error_page[PAGESIZE];
static char  blankpage[PAGESIZE];

/*ARGSUSED*/
static
segcm_fault(seg, addr, len, type, rw)
    register struct seg *seg;
    addr_t addr;
    u_int len;
    enum fault_type type;
    enum seg_rw rw;
{
    register struct segcm_data *sdp = (struct segcm_data *)seg->s_data;
    register CM_PROC *cmp = sdp->cmproc;
    register addr_t adr;
    int pf;

    if (cmp == NULLPROC) {
	/* Not your device! -- only happens after a fork. */
	printf("segcm_fault: cmp == NULL: pid %d type %x, rw %x at offset %d, len %d\n",
	       u.u_procp->p_pid, type, rw, (addr - seg->s_base), len);
	return (FC_MAKE_ERR(EBUSY));
    }
    if ((cmp->cmp_udata.ud_intf < 0)
	|| (cmp->cmp_udata.ud_state & US_DISCONNECTED)) {
	printf("segcm_fault: pid %d not connected\n", cmp->cmp_pid);
	return(FC_MAKE_ERR(ENOTCONN));
    }

    /*
     * Block here until we're the active process for this interface.
     */
    if (!ExclusiveAccess(cmp->cmp_dev)) {
	CM_STATE *cms = &cm_state[cmp->cmp_udata.ud_intf];

	while (cms->cms_active != cmp) {
	    if ((cmp->cmp_udata.ud_state & US_DISCONNECTED)
		|| (cmp->cmp_udata.ud_intf < 0)	
		|| (cms->cms_daemon == NULL)) {
		if (cm_debug)
		    printf("segcm_fault: pid %d not connected or no daemon\n", 
			   cmp->cmp_pid);
		return(FC_MAKE_ERR(ENOTCONN));
	    }

	    /*
	     * Have to deal with errors for timeshared processes.
	     * If an error is pending, give them a blank page.
	     */
	    if (cmp->cmp_udata.ud_state & US_CM_ERROR) {
		CM_REGS *r = (CM_REGS *)error_page;
		r->cm_csr = CM_IC_CMEX;
		r->cm_hstat = HS_CMEX;
		
		for (adr = addr; adr < (addr + len); adr += PAGESIZE) {
		    if (sdp->off + (adr - seg->s_base))
			pf = hat_getkpfnum(blankpage);
		    else
			pf = hat_getkpfnum(error_page);

		    hat_devload(seg, adr, pf, sdp->prot, 0);
		}
		if (cm_debug) 
		    printf("segcm_fault: pid %d blankpage\n",
			   cmp->cmp_pid);
		return (0);
	    }

	    if (cm_debug)
		printf("segcm_fault: pid %d waits to become current proc\n",
		       cmp->cmp_pid);

	    /* Tell the TS daemon he has work to do */
	    if ((cmp->cmp_udata.ud_state & US_BLOCKED) == 0) {
		cmp->cmp_udata.ud_state |= US_BLOCKED;
		selwakeup(cms->cms_daemon->cmp_procp, 0);
	    }

	    /*
	     * We'd like to sleep interruptably here, but lots of things
	     * croak if they get EINTR Bus errors!  (Lisp in particular dies
	     * a horrible death).
	     * 
	    if (sleep (&cmp->cmp_udata.ud_state, (PCATCH | CMPRI)) != 0) {
		cmp->cmp_udata.ud_state &= ~US_BLOCKED;
		return(FC_MAKE_ERR(EINTR));
	    }
	     * 
	     */
	    (void) sleep(&cmp->cmp_udata.ud_state, PZERO-1);
	}
	cmp->cmp_udata.ud_state &= ~US_BLOCKED;


    }

    if (cm_debug)
	printf("segcm_fault: pid %d type %x, rw %x at offset %d, len %d\n",
	       cmp->cmp_pid, type, rw, (addr - seg->s_base), len);


    /*
     * Either exclusive or active process now, allow access to the registers
     */

    for (adr = addr; adr < (addr + len); adr += PAGESIZE) {
	pf = hat_getkpfnum(cminfo[cmp->cmp_udata.ud_intf]->md_addr +
			   sdp->off + 
			   (adr - seg->s_base));
	hat_devload(seg, adr, pf, sdp->prot, 0);
    }
    return (0);
}



/*ARGSUSED*/
static
segcm_checkprot(seg, addr, len, prot)
	struct seg *seg;
	addr_t addr;
	u_int len, prot;
{
	return (PROT_READ|PROT_WRITE);
}


/*
 * segdev pages are always "in core".
 */
/*ARGSUSED*/
static 
segcm_incore(seg, addr, len, vec)
        struct seg *seg;
        addr_t addr;
        register u_int len;
        register char *vec;
{
        u_int v = 0;

        for (len = (len + PAGEOFFSET) & PAGEMASK; len; len -= PAGESIZE,
            v += PAGESIZE)
                *vec++ = 1;
        return (v);
}


static
segcm_badop()
{
	/*
	 * silently fail.
	 */
	return (0);
}


#ifdef LOADABLE_DRIVER
/*
 * Loadable module support
 */

#ifndef lint
extern int 
    cmopen(), cmclose(), cmread(), cmwrite(), 
    cmioctl(), cmmmap(), cmsegmap(), cmselect();

extern int nodev();

struct cdevsw cm_cdevsw = {
        cmopen,         cmclose,        cmread,         cmwrite,     
        cmioctl,        nodev,          cmselect,       cmmmap,
        0,              cmsegmap  };

struct mb_device cmdevice[] = {
    {&cmdriver, 0, 0, 0, (caddr_t) 0x00000000, 0, 0, 0x0, 0, 0x0},
};

struct vdldrv cmdrv = {
	VDMAGIC_DRV,				/* Drv_magic 		*/
	"cm.c $Revision: 61.33 $",		/* *Drv_name 		*/
#ifndef sun4c
	NULL,					/* *Drv_mb_ctlr 	*/
	&cmdriver,				/* *Drv_mb_driver	*/
	cmdevice,				/* *Drv_mb_device	*/
	0,					/* *Drv_numctlrs	*/
	NCM,					/* *Drv_numdevs		*/
#else   sun4c
	&cm_dev_ops,				/* *Drv_dev_ops		*/
#endif
	NULL,					/* *Drv_bdevsw		*/
	&cm_cdevsw,				/* *Drv_cdevsw */
	0,					/* Drv_blockmajor */
	0					/* Drv_charmajor */
};
#endif !lint

/*
 * For loadable driver support
 */
/*ARGSUSED*/
cm_load(code, vdp, vdi, vds)
unsigned int code;
struct vddrv *vdp;
addr_t vdi;
struct vdstat *vds;
{
    switch(code) {
      case VDLOAD:
	vdp->vdd_vdtab = (struct vdlinkage *)&cmdrv;
	break;
      case VDUNLOAD:
	{
	    CM_STATE *cms;
	    int unit;
	    
	    CheckProcesses();
	    
	    if (cm_procs) {
		return(EBUSY);
	    }
	    /*
	     * Now shut down the timer to avoid crashing next time it goes off!
	     */
	    for (unit = 0; unit < NCM; unit++) {
		cms = &cm_state[unit];
		cms->cms_flags &= ~CMS_AVAIL;
		while (IdleTimerIsRunning) {
		    if (sleep(&lbolt, (CMPRI|PCATCH))) {
			return(EINTR);
		    }
		}
	    }
	    AuxAcctFunc = NULL;
	    break;
	}
      case VDSTAT:
	return(0);
    }
    return(0);
}
#endif LOADABLE_DRIVER
#endif sun

#ifdef vax

/*
 * CMPROBE
 * "Probe" routine. Called once for each interface. Initialises the node
 * and interrupt vectors.
 */

/*ARGSUSED*/
cminit (nxv, nxp, binumber, binode, ui)
    caddr_t nxv;		/* virt addr of device */
    caddr_t nxp;		/* phys addr of device */
    int binumber;		/* this bi number on the system */
    int binode;			/* the node number on this bi */
    struct uba_device *ui;	/* Our device descriptor in ioconf */
{
    register unit = ui->ui_unit;

    /*
     * Save away bus location
     */
    cm_state[unit].cms_binumber = binumber;
    cm_state[unit].cms_binode = binode;

    /*
     * Set up interrupt vectors for BIBI.  Theoretically it
     * has two, but since the board doesn't set the vector
     * itself, I just have them both come in at level 15 to
     * cmintr(), below (see also the conf file).
     */
    bidev_vec(binumber, binode, LEVEL17, ui);

    return (1);			/* Always indicate success */
}

/*
 * CMATTACH
 * Called once for each unit.
 */
cmattach(ui)
    struct uba_device *ui;
{

    CM_REGS *regs = (CM_REGS *)(ui->ui_addr);
    int unit = ui->ui_unit;
    register struct pte *ptep;
    register CM_STATE *cms = &cm_state[unit];
    int nstat;

    /*
     * Find the page table entries for the BIBI registers in
     * the system page table.
     */
    ptep = ((struct pte *) Nexmap) + btop(((int)regs) - ((int)nexus));
    cms->cms_ptep = &cmindregmap[unit][0];
    cms->cms_regs = regs;

    /*
     * Give users access to the bibi regs (this will go away
     * when we figure out how to map the regs into each process
     * address space).	XXX
     *
     */

			
    cm_reg_access(ptep, ON);
    cm_copy_bibi_ptes (cms->cms_ptep, ptep);
    cm_reg_access(cms->cms_ptep, ON);

    /*
     * Initialize the BIBI.
     */

    cmhardreset(unit);

    cms->cms_bibi_rev = (regs->cm_biic.biic_typ) >> 16;
	
    if (cms->cms_bibi_rev < 4) {
	printf("********************************************\n");
	printf("*** THIS VERSION OF THE CM SOFTWARE         \n");
	printf("*** REQUIRES THAT THIS BIBI BE UPGRADED     \n");
	printf("*** CONTACT THINKING MACHINES CUSTOMER SUPPORT\n");
	printf("*** FOR AN UPGRADE\n");
	printf("********************************************\n");
    }

    printf("cm%d rev %d BI %d node %d BIIC rev %d\n",
	   unit, 
	   cms->cms_bibi_rev,
	   cms->cms_binumber,
	   cms->cms_binode,
	   ((regs)->cm_biic.biic_ctrl&BICTRL_BIICREV) >> 24);


    InitQueues();

    cms->cms_flags   = CMS_AVAIL;

    nstat = cm_read_nexstat(cms);
    if (NEXUS_R0_CANT_READ(nstat)) {
	printf("cm%d: CM powered off or disconnected?\n", unit);
	cms->cms_host = -1;
    } else
	cms->cms_host = NEXUS_R0_HOST_ID(nstat);


    cms->cms_daemon  = NULL;
    cms->cms_active  = NULL;
    BusyTicks(NULL, cms);
    cms->cms_intr_proc = NULL;
    cms->cms_interface = unit;
    cms->cms_proc_locking_nexus = NULL;

    lockinit(&CMProcessLock, &lock_device15_d);
    lockinit(&CMFifoLock, &lock_device15_d);
    lockinit(&CMAcctLock, &lock_device15_d);

    UCCSet_Free(cms);
} /* cmattach */

cmbireset()
{
}

/*
 * CMHARDRESET
 * Perform "node reset" operation on BIBI,
 * then re-initialize BIIC registers.
 */

int cmstdelay = 100000; /* 100 millisec. */
int cmsttries = 10;     /* 1 sec. total */
int cmstmin = 10;       /* The min number of times we tried */
int cmstmax = 0;        /* The max number of times we tried */

cmhardreset(unit)
{
    CM_STATE *cms = &cm_state[unit];
    CM_REGS *regs = cm_state[unit].cms_regs;
    int binumber  = cm_state[unit].cms_binumber;
    int node      = cm_state[unit].cms_binode;
    int save_flag;
    register i;
    int s;

    s = splcm(cms);

    /*
     * Turn off access to BIBI registers in case someone on
     * another CPU is trying to frob things.
     */

    cm_reg_access(cms->cms_ptep, OFF);

    /*
     * Perform a BIBI Node Reset.
     * [This code sort of copied from the assembly
     * language routine _bisst in locore.s, which
     * I can't use because it has a 10 SECOND timeout!]
     * Instead we wake up at 1 msec intervals to check
     * if testing is complete, giving up after 100 msecs.
     */

    save_flag = ignorebi;
    ignorebi = 1;
    
    regs->cm_biic.biic_ctrl = BICTRL_STS | BICTRL_SST; 

    for (i = 100; i < 0; i--);			    /* do nothing */;

    for (i = 0; i < cmsttries; ++i) {
	DELAY(cmstdelay);
	if (regs->cm_biic.biic_ctrl & BICTRL_STS)
	    break;
    }

    ignorebi = save_flag;
    if (i > cmstmax)
	cmstmax = i;
    if (i < cmstmin)
	cmstmin = i;

    /*
     * Set BI interrupt dest to be cpu, clear the error
     * register "just in case" and reinitialize the error
     * interrupt control and biic control registers.
     * [This code lifted from biinit.c]
     */

    regs->cm_biic.biic_int_dst = bidata[binumber].biintr_dst;
    regs->cm_biic.biic_err     = regs->cm_biic.biic_err; 
    regs->cm_biic.biic_err_int = (regs->cm_biic.biic_err_int &
				  ~(BIEINT_VECTOR | BIEINT_LEVEL | BIEINT_FORCE))
	| (BIEINT_5LEVEL | (SCB_BI_OFFSET(binumber))+BIEINT_BIVEC);

    regs->cm_biic.biic_ctrl = (BICTRL_HEIE) | 
	(regs->cm_biic.biic_ctrl&~(BICTRL_BROKE));

    /*
     * This code was NOT in biinit.c, I got it from bda.c .
     * The BIBI always uses level 7, so we need to use the LEVEL17 vector.
     * I believe it forces all interrupts from the hardware
     * to be routed to the level 17 vector reserved for this
     * device. 
     */
    regs->cm_biic.biic_int_ctrl = SCB_BI_LWOFFSET(node, LEVEL17);
	
    /*
     * Set up the BCI ctrl register as spec'ed.
     */
    regs->cm_biic.biic_bci_ctrl =	BCI_UCSREN | BCI_RTOEVEN;

    /*
     * Now set the CSR, carefully clearing interrupts.
     */
    ignorebi++;
    regs->cm_csr = CM_HARD_INT_CLEAR | CM_SOFT_INT_CLEAR;
    regs->cm_csr = 0;
    --ignorebi;

    /*
     * Restore user-level access.
     */
    cm_reg_access(cms->cms_ptep, ON);

    (void) splx(s);
}

int
cmreset(unit)
    int unit;
{
    CM_STATE *cms = &cm_state[unit];
    CM_REGS *regs = cm_state[unit].cms_regs;
    int nstat;
    int s;

    s = splcm(cms);

    /*
     * Put the BIBI back in "idle" state, and reset interrupt conditions
     */
    
    regs->cm_discard_reg = 0;
    regs->cm_csr = CM_HARD_INT_CLEAR | CM_SOFT_INT_CLEAR;
    regs->cm_csr = 0;

    nstat = cm_read_nexstat(cms);
    if (NEXUS_R0_CANT_READ(nstat)) {
	/*
	 * Couldn't read the NEXUS.
	 */
	printf("cm%d: CM powered off or disconnected?\n", unit);
	cms->cms_host = -1;
	/*
	 * Reset the BIBI again, as we caused an error
	 */
	regs->cm_discard_reg = 0;
	regs->cm_csr = CM_HARD_INT_CLEAR | CM_SOFT_INT_CLEAR;
	regs->cm_csr = 0;
    } else {
	cms->cms_host = NEXUS_R0_HOST_ID(nstat);
	if (nstat & NEXUS_R0_CHANNEL_ERROR)
	    reset_nexus(cms);
    }

    splx(s);

}

/*
 * INTERRUPT HANDLER.
 * Translate the interrupt to a signal and relay it to the "owner" process.
 */
cmintr(unit)
{
    register CM_STATE *cms;
    register CM_REGS *regs;
    long csr;

    cms = &cm_state[unit];
    regs = cms->cms_regs;
    csr = regs->cm_csr;

    if (cms->cms_intr_proc != NULL)
	psignal(cms->cms_intr_proc, SIGURG);

    /*
     * Hard interrupt? Do exception select processing and look out
     * for nasty BIBI register access errors.
     */
    if ((csr & CM_HARD_ERRORS) != CM_HARD_ERRORS) {
	if ((csr & (CM_CM_EXCPT_LATCH_L | CM_CM_PAR_ERR_LATCH_L)) != (CM_CM_EXCPT_LATCH_L | CM_CM_PAR_ERR_LATCH_L)) {
	    SignalEvent (cms, EXCEPTION);
	    csr &= ~CM_CM_ERR_IE;
	}

	/*
	 * Clear the interrupt by toggling the clear line.
	 */
	regs->cm_csr = (csr | CM_HARD_INT_CLEAR);
	regs->cm_csr = csr;
    }

    /*
     * Soft interrupt processing
     */
    

    if ((csr & (CM_DATA_AVAIL_IE|CM_HBUS_OFIFO_READY)) == (CM_DATA_AVAIL_IE|CM_HBUS_OFIFO_READY)) {
	SignalEvent (cms, OFIFO_READY);
	csr &= ~(CM_DATA_AVAIL_IE | CM_FIFO_NHF_IE);
    }

    if ((csr & (CM_FIFO_NHF_IE|CM_HBUS_IFIFO_NHF)) == (CM_FIFO_NHF_IE|CM_HBUS_IFIFO_NHF)) {
	SignalEvent (cms, IFIFO_READY);
	csr &= ~(CM_DATA_AVAIL_IE | CM_FIFO_NHF_IE);
    }

    /*
     * These should never be on...
     */

    csr &= ~(CM_FIFO_MT_IE);
    csr |= CM_SOFT_INT_L;	/* set soft int bit (active low) */
    
    /*
     * Clear interrupt.
     */
    regs->cm_csr = (csr | CM_SOFT_INT_CLEAR);
    regs->cm_csr = csr;
}

/*
 * Returns 0 if need to wait for event, otherwise the event that has
 * already occurred.  Busy wait a short while for FIFO events in an
 * attempt to eliminate waiting for an interrupt.
 */

#define CM_CSR_HSTAT (CM_HBUS_CM_EXCPT|CM_HBUS_IFIFO_NHF|CM_HBUS_IFIFO_MT|CM_HBUS_OFIFO_READY)

int cm_busyloop = 500;

int
CheckEvent (cms, events)
    CM_STATE	*cms;
    long	events;
{
    register CM_REGS *regs   = cms->cms_regs;
    long csr, hstat;
    int i;

    /*
     * Mask out bits we don't care about
     */
    csr   = regs->cm_csr;
    hstat = csr & CM_CSR_HSTAT;
    csr   = csr & (CM_CM_ERR_IE|CM_FIFO_NHF_IE|CM_DATA_AVAIL_IE);

    if (events & IFIFO_READY) {

	for (i = 0; i < cm_busyloop; i++) {
	    if (hstat & CM_HBUS_IFIFO_NHF) {
		cms->cms_iwords = (hstat & CM_HBUS_IFIFO_MT) ? 500 : 250;
		return (IFIFO_READY);
	    }
	    hstat = regs->cm_csr & CM_CSR_HSTAT;
	}

    }

    if (events & OFIFO_READY) {

	for (i = 0; i < cm_busyloop; i++) {
	    if (hstat & CM_HBUS_OFIFO_READY)
		return (OFIFO_READY);
	    hstat = regs->cm_csr & CM_CSR_HSTAT;
	}

    }

    if (events & EXCEPTION)
	if (hstat & CM_HBUS_CM_EXCPT)
	    return (EXCEPTION);

    return (0);
}

EnableEventInterrupt (cms, events)
    CM_STATE	*cms;
    long	events;
{
    register CM_REGS *regs   = cms->cms_regs;
    long csr;

    /*
     * Mask out bits we don't care about
     */

    csr = regs->cm_csr & (CM_CM_ERR_IE | CM_FIFO_NHF_IE | CM_DATA_AVAIL_IE);

    if (events & IFIFO_READY) {

	if (cms->cms_bibi_rev >= 4) {
	    regs->cm_csr = CM_SOFT_INT_CLEAR;
	}

	csr &= ~CM_DATA_AVAIL_IE;
	csr |= CM_FIFO_NHF_IE;
    }

    if (events & OFIFO_READY) {

	if (cms->cms_bibi_rev >= 4) {
	    regs->cm_csr = CM_SOFT_INT_CLEAR;
	}

	csr &= ~CM_FIFO_NHF_IE;
	csr |= CM_DATA_AVAIL_IE;
    }

    if (events & EXCEPTION) {

	if (cms->cms_bibi_rev >= 4) {
	    regs->cm_csr = CM_HARD_INT_CLEAR;
	}
	
	csr |= CM_CM_ERR_IE;
    }

    regs->cm_csr = csr;
}


/*
 * INIT INDIRECT PTES
 * Copy the real BIBI reg page table to an indirect set.
 */
cm_copy_bibi_ptes(dest, src)
    struct pte *dest;
    struct pte *src;
{
    register i;

    for (i = 0; i < CM_NUMBER_OF_REG_PAGES; ++i)
	dest[i] = src[i];

    /*
     * Initialize access to OFF.
     */
    cm_reg_access(dest, OFF);
}

/*
 * CM REG ACCESS
 * Turn on/off user program access to the bibi regs given a pointer to a
 * valid page table for the register space.
 * Note that we don't give write access to the BIIC registers (users
 * should never touch these).
 */

cm_reg_access(ptep, turn_on)
    struct pte *ptep;
    int turn_on;
{
    register i;
    register int *iptep = (int *)ptep;


    for (i = 0; i < CM_NUMBER_OF_REG_PAGES; i++, iptep++) {
	if (turn_on) {
	    /*
	     * First two pages (BIIC regs) are user read-only.
	     * Also the BIBI CSR, to avoid machine checks.
	     * Page 13 is unused so not accessible. The rest are
	     * user read/writeable.
	     */

	    switch (i) {	/* XXX make these reg numbers symbolic */
	      case 13:
		*iptep = (*iptep & ~PG_PROT) | PG_KW | PG_V;
		break;

	      case 0:
	      case 1:
		*iptep = (*iptep & ~PG_PROT) | (PG_URKW | PG_V);
		break;

	      default:
		*iptep = (*iptep & ~(PG_PROT | PG_M)) | PG_UW | PG_V;
		break;
	    }
	} else {
	    /* turn off */
	    *iptep = (*iptep & ~PG_PROT) | PG_KW | PG_V;
	}
    }

}

/*
 * A routine to read the nexus status register as safely as possible.
 * Returns -1 if we can't read it.
 */

long
cm_read_nexstat(cms)
    CM_STATE *cms;
{
    register CM_REGS *regs;
    register long original_csr;
    register long csr;
    long nexstat;
    int s;

    regs = cms->cms_regs;
    s = splcm(cms);
    
    if (cm_debug & 2)
	printf("cm_read_nexstat(0x%x)\n", cms);

    original_csr =  regs->cm_csr;

    /* 
     * Disable interrupts 
     */
    regs->cm_csr = 0;	
    /*
     * Read the nexus
     */
    nexstat = regs->cm_nexus_lo_sreg;
    /*
     * Did it work?
     */
    csr = regs->cm_csr;
    if (((csr & CM_ACC_TIMEOUT_LATCH_L) != CM_ACC_TIMEOUT_LATCH_L) 
	|| ((nexstat & 0xffff) == 0xc055)) {
	/*
	 * We got an ACCESS TIMEOUT reading the nexus, or
	 * B7+ BIBI is in READ_WAIT state.  
	 * 
	 * If no one has the interface open, go ahead and
	 * reset it and try again.  Otherwise just give up
	 * right away.
	 */
	if ((cms->cms_flags & CMS_OPEN) == 0) {
	    regs->cm_discard_reg = 0;
	    regs->cm_csr = CM_HARD_INT_CLEAR | CM_SOFT_INT_CLEAR;
	    regs->cm_csr = 0;
	    nexstat = regs->cm_nexus_lo_sreg;
	    csr = regs->cm_csr;

	    if ((csr & CM_ACC_TIMEOUT_LATCH_L) != CM_ACC_TIMEOUT_LATCH_L)
	      nexstat = -1;
	    if((nexstat & 0xffff) == 0xc055)
	      nexstat = -2;

	} else {
	    if ((nexstat & 0xffff) == 0xc055) 
	      nexstat = -2;
	    else
	      nexstat = -1;
	}
    }

    regs->cm_csr = original_csr;

    if (cm_debug & 2)
	printf("cm_read_nexstat(0x%x) returns 0x%x\n", cms, nexstat);

    if (nexstat != -1)
	cms->cms_host = NEXUS_R0_HOST_ID(nexstat);

    splx(s);
    return (nexstat);
}

/* ARGSUSED */
cm_unmap(cmp)
CM_PROC *cmp;
{
    return (0);
}

#endif vax

#endif NCM > 0
